{: test that assigning to a set outside its bounds causes a fatal error
   here we test various values where sets overlap on the upper bound,
   highest value of src set
}

{ this is ageneric test, many versions of this test will be built with
  cpp -D ARG1=ARG -D ARG2=(ARG+ADJ)
  for all combinatiopns of ARG & ADJ

ARG   -8 -7 -1 0 1 2 7 8 9 15 16 17 23 24 25 31 32 33
ADJ    1 2 7 8 9 15 16 17

}

{$d+}
program d200( output );

#if !defined ARG1 || ! defined ARG2
#error "ARG2 or ARG1 not defined"
#endif
#if ARG2 <= ARG1
#error "ARG2 must be greater than ARG1"
#endif

const
   hi  = ARG1;
   hi1 = ARG2;
var
   i  : integer;
   s  : set of -20..hi;   {dst}
   s1 : set of -10..hi1;  {src}

begin {d200}

   s1 := [hi];
   s := s1; {this should be OK}

   writeln( 'INFO: s is [-20..', hi:1, '], s1 is [-10..', hi1:1, '], test bit ', hi1:1 );

   s1 := [hi1];
   s := s1; {!!! assign beyond upper bound}

   writeln('failed to detect set assign error');

end. { d200 }

