{: test that sqr(x) causes a fatal error if it overflows, x is real & negative }

{$d+}
program d029( output );

var
   k, x : real;

function side : real;
begin
   side := k;
   k := k+1;
end;
begin {d029}

   k := -1;
   x := sqr(side);
   if x <> 1 then
      writeln( 'unexpected value of sqr(1) is ', x );

   if k <> 0 then
      writeln( 'side effect error evaluating sqr' );

   write( 'checking for sqr(x) underflow ... ' );
   k := -1;
   repeat
      k := k/2;
      x := sqr(k);
   until x = 0;
   writeln( 'underflows when x is ', k );


   write( 'checking for sqr(x) overflow, expect runtime error ... ' );
   k := -1;
   repeat
      k := k*2;
      x := sqr(k);
   until abs(sqrt(x) + k) > -k/4;
   writeln( 'sqr overflow not detected' );

end. { d029 }

