// Copyright (c) 2010-2018 Trevor Blight ////
//
// system header file for p5x generated code
//

#ifndef __P5X_H__
#define __P5X_H__ 100

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <inttypes.h>
#include <stdbool.h>
#include <math.h>
#include <time.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <unistd.h>

// translate pascal names to equivalent c name
static inline double arctan( double x ) { return atan(x); }
static inline double ln( double x ) { return log(x); }

static inline int bitor(int a, int b)   { return a|b; }
static inline int bitand(int a, int b)  { return a&b; }
static inline int bitxor(int a, int b)  { return a^b; }
static inline int bitnot(int a)         { return ~a; }
// should test that b is not too big
static inline int rshiftu(int a, int b) { return b>=0 ? ((unsigned)a >> b):
                                                        ((unsigned)a << -b); }
static inline int rshift(int a, int b)  { return b>=0? (a >> b):
                                                       (a << -b); }

#if __GNUC__ <= 3
static inline double __attribute__ ((pure))
__builtin_powi(double x, int i)
{
  int u = i<0? -i: i;
  double r = 1;
  double px = x;
  while(u > 0) {
    if(u&1) r*=px;
    u>>=1; px*=px;
  }
  return i<0? 1/r: r;
}
#endif

// file handling
typedef struct {
    FILE *f;
    char *name;
    int flags;
    unsigned char buffer;
} text;

//     timestamp record, fit into an integer for the year,
//     and exactly another 32 bits for the other fields.
//     overlay datevalid & timevalid, both likely on sign bit
struct __attribute__ ((__packed__)) timestamp_0 {
   int year_0;
   union {
      struct {
         unsigned isdst_0 : 1;
           unsigned dstValid_0 : 1;
           unsigned day_of_week_0 : 3;
           unsigned second_0 : 6;
           unsigned minute_0 : 6;
           unsigned hour_0 : 5;
           unsigned day_0 : 5;
           unsigned month_0 : 4;
           unsigned timevalid_0 : 1;
      };
      struct {
           unsigned dummy : 31;
           unsigned datevalid_0 : 1;
      };
   };//union
}; // timestamp


struct _PcleanupInf {
     int level;
     void (*cuFunc)(void);
     struct _PcleanupInf *link;
};
extern struct _PcleanupInf *_Phead;

static void  __attribute__ ((__noreturn__))
_Pfatal( char *const s, const int l )
{
fprintf( stderr, "fatal error at line %d: %s\n", l, s);
exit(EXIT_FAILURE);
} // _Pfatal()

#endif //__P5X_H__
