#!/bin/sh
#
#    regression test of p5x version of algorithms from
#
#        Compact Numerical Methods for Computers
#               J C Nash
#        Adam Hilger Ltd.      Bristol    1990
#   Copyright (C)  J C Nash  1990
#

if [ -z $P5CDIR ] ; then
   echo "\$P5CDIR is not set, bailing out"
   exit 1;
fi

rm -f out*

rm -f dr0102 dr0102.exe
$P5CDIR/r -cpp dr0102 <dr0102x
mv out0102. out0102.p5x
if [ $? -ne 0 ] ; then
        read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -A1 "Singular values" out0102.p5x | \
      grep -c "3\.3658407[0-9]\+e[+-]0\+  1\.0812763[0-9]\+e[+-]0\+  6\.7431328[0-9]\+e-0\+1  5\.3627598[0-9]\+e-0\+1"` -ne 2 ] ; then
   echo "test dr0102 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr03 dr03.exe
$P5CDIR/r -cpp dr03 <dr03x
mv out03. out03.p5x
if [ $? -ne 0 ] ; then
        read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -A1 "^Q$" out03.p5x | \
      grep -c "0\.83812   -0\.44721   -0\.25555   -0\.17960"` -ne 1 ] ; then
   echo "test dr03 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr03 dr03.exe
$P5CDIR/r -cpp -DROWS dr03 <dr03ax
mv out03a. out03a.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -A1 "^Q$" out03a.p5x | \
      grep -c "0\.83812   -0\.44721   -0\.25555   -0\.17960"` -ne 1 ] ; then
   echo "test dr03a failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr04 dr04.exe
$P5CDIR/r -cpp dr04 <dr04x
mv out04. out04.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -c "Solution component \[5\]=  4\.33366[0-9]\+e-0\+3" out04.p5x` -ne 1 ] ; then
   echo "test dr04 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr0506 dr0506.exe
$P5CDIR/r -cpp dr0506 <dr0506x
mv out0506. out0506.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -A2 "alg06.pas" out0506.p5x | \
      grep -c "0\.00000    0\.00000    0\.00000    0\.00000    0\.00000    1\.00000"` -ne 1 ] ; then
   echo "test dr0506 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

./dr0506 <dr0506sx
mv out0506s. out0506s.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -c "Matrix computationally singular" out0506s.p5x` -ne 1 ] ; then
   echo "test dr0506s failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr0708 dr0708.exe
$P5CDIR/r -cpp dr0708 <dr0708x
mv out0708. out0708.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -A1 "Solution" out0708.p5x | \
      grep -c "171\.00000"` -ne 1 ] ; then
   echo "test dr0708 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr09 dr09.exe
$P5CDIR/r -cpp dr09 <dr09x
mv out09. out09.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -A4 "Computed inverse" out09.p5x | \
      grep -c "0\.00000    0\.00000   -1\.00000    1\.00000"` -ne 1 ] ; then
   echo "test dr09 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr10 dr10.exe
$P5CDIR/r -cpp dr10 <dr10x
mv out10. out10.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -A1 "Eigenvector" out10.p5x | \
      grep -c "1\.00000    0\.74619    0\.30300    0\.08590    0\.01881    0\.00336    0\.00051"` -ne 1 ] ; then
   echo "test dr10 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr13 dr13.exe
$P5CDIR/r -cpp dr13 <dr13x
#mv out13a. out13a.p5x
mv out13. out13.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -A1 "Eigenvalue 10 = -1\.546983[0-9]*e-0\+1" out13.p5x | \
      grep -c "\-0\.6123736 -0\.3061868 -0\.1530934 -0\.0765467 -0\.0382734 -0\.0191367 -0\.0095683"` -ne 1 ] ; then
   echo "test dr13 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr14 dr14.exe
$P5CDIR/r -cpp dr14 <dr14x
#mv out14a. out14a.p5x
mv out14. out14.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -A1 "Eigenvalue 10 = -1\.546983[0-9]*e-0\+1" out14.p5x | \
      grep -c "\-0\.6123736 -0\.3061868 -0\.1530934 -0\.0765467 -0\.0382734 -0\.0191367 -0\.0095683"` -ne 1 ] ; then
   echo "test dr14 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr15 dr15.exe
$P5CDIR/r -cpp dr15 <dr15x
#mv out15a. out15a.p5x
mv out15. out15.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -A1 "Eigenvalue 5 =  1\.06[0-9]*e-0\+5" out15.p5x | \
      grep -c "0\.0109[0-9]* -0\.2090[0-9]*  0\.9104[0-9]* -1\.3834[0-9]*  0\.6796[0-9]*"` -ne 1 ] ; then
   echo "test dr15 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr1617 dr1617.exe
$P5CDIR/r -cpp dr1617 <dr1617x
mv out1617. out1617.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -c "Apparent minimum is f( 8\.1649[0-9]\+e-0\+1)=-6\.0886[0-9]\+e[+-]0\+" out1617.p5x` -ne 1 ] ; then
   echo "test dr1617 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr1618 dr1618.exe
$P5CDIR/r -cpp dr1618 <dr1618x
mv out1618. out1618.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -c "root is at  2\.97267[0-9]\+e-0\+1" out1618.p5x` -ne 1 ] ; then
   echo "test dr1618 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr1920 dr1920.exe
$P5CDIR/r -cpp dr1920 <dr19x
mv out19. out19.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -c "B\[[12]\]= 1\.00000[0-9]\+e[+-]0\+" out19.p5x` -ne 2 ] ; then
   echo "test dr19 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

./dr1920 <dr1920rx
mv out1920r. out1920r.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -c "B\[[12]\]= 1\.00000[0-9]\+e[+-]0\+" out1920r.p5x` -ne 2 ] ; then
   echo "test dr1920r failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr1920 dr1920.exe
$P5CDIR/r -cpp -DJJACF dr1920 <dr19jx
mv out1920j. out1920j.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -c "B\[1\]= 1\.1204[0-9]\+e+0\+" out1920j.p5x` -ne 2 \
   -o  `grep -c "B\[2\]=-4\.037[0-9]\+e-0\+1" out1920j.p5x` -ne 2 \
] ; then
   echo "test dr1920j failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr21 dr21.exe
$P5CDIR/r -cpp dr21 <dr21x
mv out21. out21.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -c "Bvec\[[12]\]= 1\.00000[0-9]\+e[+-]0\+" out21.p5x` -ne 2 ] ; then
   echo "test dr21 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr22 dr22.exe
$P5CDIR/r -cpp dr22 <dr22x
mv out22. out22.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -c "Bvec\[[12]\]= 1\.00000[0-9]\+e[+-]0\+" out22.p5x` -ne 2 ] ; then
   echo "test dr22 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr23 dr23.exe
$P5CDIR/r -cpp dr23 <dr23x
mv out23. out23.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -c "Bvec\[[12]\]= 1\.00000[0-9]\+e[+-]0\+" out23.p5x` -ne 2 ] ; then
   echo "test dr23 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr23 dr23.exe
$P5CDIR/r -cpp -DLOGISTIC dr23 <dr23ax
mv out23a. out23a.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -A2 "Minimum function value found = 2\.58727[0-9]*e[+-]0\+" out23a.p5x | \
      grep -c "Bvec\[[1]\]= 1\.96186[0-9]*e[+-]0\+"` -ne 1 ] ; then
   echo "test dr23a failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr24ii dr24ii.exe
$P5CDIR/r -cpp dr24ii <dr24iix
mv out24ii. out24ii.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -A2 "Eigensolution for eigenvalue = 8\.5828[0-9]*e-0\+6" out24ii.p5x | \
      grep -c "1\.0000000  0\.5000021  0\.2500064  0\.1250145  0\.0625300  0\.0313108  0\.0157469"` -ne 1 ] ; then
   echo "test dr24ii failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr24le dr24le.exe
$P5CDIR/r -cpp dr24le <dr24lex
mv out24le. out24le.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -A1 "Solution after [0-9]\+ iterations" out24le.p5x | \
      grep -c "1\.00000   [ -]0\.00000   [ -]0\.00000   [ -]0\.00000   [ -]0\.00000   [ -]0\.00000   [ -]0\.00000"` -ne 1 ] ; then
   echo "test dr24le failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr24ls dr24ls.exe
$P5CDIR/r -cpp dr24ls <dr24lsx
mv out24ls. out24ls.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -A1 "Solution after [0-9]\+ iterations" out24ls.p5x | \
      grep -c "1\.00000   [ -]0\.00000   [ -]0\.00000"` -ne 1 ] ; then
   echo "test dr24ls failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr25 dr25.exe
$P5CDIR/r -cpp dr25 <dr25x
mv out25. out25.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -A1 "Solution after [0-9]\+ products. Est. eigenvalue = 8\.58280[0-9]*e-0\+6" out25.p5x | \
      grep -c "0\.8660151  0\.4330094  0\.2165093  0\.1082644  0\.0541520  0\.0271156  0\.0136371"` -ne 1 ] ; then
   echo "test dr25 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr26 dr26.exe
$P5CDIR/r -cpp dr26 <dr26x
mv out26. out26.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -A2 "EIGENVALUE 5=( 2\.79943[0-9]*e-0\+1, 2\.27493[0-9]*e[+-]0\+)" out26.p5x | \
      grep -c "( 2\.57760[0-9]*e-0\+1, 1\.17868[0-9]*e-0\+1)"` -ne 1 ] ; then
   echo "test dr26 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr27 dr27.exe
$P5CDIR/r -cpp dr27 <dr27x
mv out27r. out27r.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -c "B\[[12]\]= 1\.00000[0-9]\+e[+-]0\+" out27r.p5x` -ne 2 ] ; then
   echo "test dr27 failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi

rm -f dr27 dr27.exe
$P5CDIR/r -cpp -DJJACF dr27 <dr27jx
mv out27j. out27j.p5x
if [ $? -ne 0 ] ; then
    read -rsp $'Press any key to continue...\n' -n1 key
elif [ `grep -c "B\[1\]= 1\.110[0-9]\+e+0\+" out27j.p5x` -ne 1 \
   -o  `grep -c "B\[2\]=-3\.87[0-9]\+e-0\+1" out27j.p5x` -ne 1 \
] ; then

   echo "test dr27j failed"
   read -rsp $'Press any key to continue...\n' -n1 key
fi


echo
echo "cnm tests done"

#
# the following code assumes tp5 and freepascal output files exist in ./orig
# remove or modify this code as necessary
#
echo
if [ -d orig ] ; then
    read -rsp $'Press c to compare, any other key to skip ... ' -n1 key
    if [[ $key = [Cc] ]]; then
        echo
        echo -n comparing ...
        for i in `basename -s .p5x out*.p5x` ; do
            echo -n " $i"
            kdiff3 $i.p5x orig/$i.{fpc,tp5}
        done
    fi
fi


$P5CDIR/pan -cpp -2 dr1920 > dr1920.rpt

if which svn > /dev/null 2> /dev/null  && \
   svn ls dr1920.rpt &> /dev/null; then

  if [ `svn diff --diff-cmd diff --extensions "-I dr1920.pas" dr1920.rpt | \
         wc -l ` -ne  2 ] ; then
      svn diff dr1920.rpt
  else
      svn revert -q dr1920.rpt
      echo "pan test OK"
  fi
else
    grep unused dr1920.rpt
fi


echo "------- cnm tests Done --------"
read -rsp $'Press any key to continue...\n' -n1 key
