program dr27(input,output);
{dr27.pas == driver for Hooke and Jeeves method

  This program is designed to minimise functions of n parameters.

  Present example uses the problem file ROSEN.PAS, which must be
  replaced with similar code for the user's problem.

          Copyright 1988 J.C.Nash
}
const
   banner = 'dr27.pas -- driver for Hooke & Jeeves minimisation';

#include "common.inc.pas"  // constants, types & procedures
#include "calceps.pas"

#if !defined JJACF
#include "rosen.pas"
#else
   (* use the JJACF.PAS test with EX27R.CNM *)
#include "jjacf.pas"
#endif

#include "alg27.pas"     

       {main program}
var
  n          : integer; {the order of the problem}
  B          : rvector; {current set of parameters}
  X          : rvector; {"best" set of parameters}
  Workdata   : probdata; { the problem data type from CONSTYPE.DEF}
  i          : integer;
  Fmin       : real;   {for the minimal function value found}
  fail       : boolean; {set TRUE if the method fails in some way}
  mytol      : real; {to store a convergence tolerance}

begin
  startup;
  fminset(n,B,Workdata); {sets up problem and defines starting
                  values of B}
  mytol:=-1.0; {Note: set the tolerance negative to indicate that procedure
            must obtain an appropriate value.}
  hjmin(n,B,X,Fmin,Workdata,fail,mytol); {minimise the function}
  writeln;
  writeln(confile);
  writeln(' Minimum function value found =',Fmin);
  writeln(confile,' Minimum function value found =',Fmin);
  writeln(' At parameters');
  writeln(confile,' At parameters');
  for i:=1 to n do
  begin
    writeln(' B[',i,']=',X[i]);
    writeln(confile,' B[',i,']=',X[i]);
  end; {loop to write out parameters}
    {local files auto closed when procedure ends}
end. {dr27.pas -- Hooke & Jeeves driver}
