// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  26 junio 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// PEUS PalaExcavadoraUsoSuelo
// El archivo dibuja una pala corriente. 
// Ofrece una macro para cambiar las caracteristicas principales y texturas.   
// Es compatible con POVRay 3.1.
//
// La macro principal carece de parametros
// #macro PEUS_Pala()
//
// La siguiente versin de la macro, permite un mayor control de las caracteristicas.
// #macro PEUS_PalaExcavadoraUsoSuelo( BocaPala, AnguloPala,
//                LargoPala, LargoSoporte, DiametroMadera,
//                FraccionUnion, FraccionAgarre,
//                TexturaPala, TexturaSoporteMetal,
//                TexturaUnionMetalMadera, TexturaMadera,
//                TexturaAgarre, TexturaAgarre2 )
//      BocaPala                : Vector para describir las dimensiones de la
//              boca de pala, a partir de un objeto unitario. 
//              Default es <150,218, 43>*L.
//      AnguloPala              : Inclinacion de la boca de pala, respecto al soporte.
//              Default es 22.5 grados.
//      LargoPala               : Referencia para el largo total de la pala.
//              Default es 744*L.
//      LargoSoporte            : Referencia para el largo del soporte de la pala.
//              Default es 494*L.
//      DiametroMadera          : Diametro de la madera cilindrica de soporte.
//              Default es 27*L.
//      FraccionUnion           : Fraccion propia relativa del tamano de la
//              union soporte-pala, respecto al largo del soporte.
//              Default es 0.1.
//      FraccionAgarre          : Referencia como fraccion propia relativa del
//              tamano del mango respecto al largo del soporte.
//              Default es 0.175.
//      TexturaPala             : Textura de la boca de pala.
//              Default es PEUS_TexturaPala.
//      TexturaSoporteMetal     : Textura de soporte directo de boca de pala.    
//              Default es PEUS_TexturaSoporteMetal.
//      TexturaUnionMetalMadera : Textura de la union metal-madera del soporte.
//              Default es PEUS_TexturaUnionMetalMadera.
//      TexturaMadera           : Textura de la madera del brazo de la pala.
//              Default es PEUS_TexturaMadera.
//      TexturaAgarre           : Textura del mango.  Default es PEUS_TexturaAgarre. 
//      TexturaAgarre2          : Textura del mango en contacto con la mano.
//              Default es PEUS_TexturaAgarre2.
//
// El aparato por defecto tiene las siguientes dimensiones:      
//      Alto                            =  760*L
//      Frente en X                     =  150*L
//      Profundidad en Z                = -110*L.. 35*L
// Se dibuja semicentrado sobre el plano XZ.  El eje de la pala en Y, con boca
// hacia Z-, gravedad Y-.  
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare PEUS_DefaultTexturaPala             
//      Textura de la boca de pala.
// #declare PEUS_DefaultTexturaSoporteMetal     
//      Textura de soporte directo de boca de pala.    
// #declare PEUS_DefaultTexturaUnionMetalMadera 
//      Textura de la union metal-madera del soporte.
// #declare PEUS_DefaultTexturaMadera           
//      Textura de la madera del brazo de la pala.
// #declare PEUS_DefaultTexturaAgarre           
//      Textura del mango.  
// #declare PEUS_DefaultTexturaAgarre2          
//      Textura del mango en contacto con la mano.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default) 
// #declare PEUS_FF                     = 3
//      Controla el grado de subdivision para la aproximacion del
//      relieve de la pala.  Casi siempre un valor unitario funcionara bien.
//      Tomar en cuenta que cada unidad multiplica por cuatro el detalle.
//      Esta variable requiere declararse antes del #include. 
// #declare PEUS_TexturaPala             
//      Textura de la boca de pala.
// #declare PEUS_TexturaSoporteMetal     
//      Textura de soporte directo de boca de pala.    
// #declare PEUS_TexturaUnionMetalMadera 
//      Textura de la union metal-madera del soporte.
// #declare PEUS_TexturaMadera           
//      Textura de la madera del brazo de la pala.
// #declare PEUS_TexturaAgarre           
//      Textura del mango.  
// #declare PEUS_TexturaAgarre2          
//      Textura del mango en contacto con la mano.
// #declare PEUS_POV3_1                                 = off;
//      Valor "on" activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo simplemente
// #include "PEUS.inc"
// object        { PEUS_Pala() }
//
// Otro ejemplo con la macro detallada:
// #include "PEUS.inc"   
// object                       { 
//   PEUS_PalaExcavadoraUsoSuelo( <0.15,0.218,0.043>, 
//      22.5, 0.744, 0.494, 0.027, 0.1, 0.175,
//      PEUS_TexturaPala, PEUS_TexturaSoporteMetal,
//      PEUS_TexturaUnionMetalMadera,
//      PEUS_TexturaMadera, PEUS_TexturaAgarre, PEUS_TexturaAgarre2 )
// }                   
//
// O bien con modificadores:
// #include "PEUS.inc"                         
// #include "textures.inc"
// #declare PEUS_TexturaPala  = PinkAlabaster
// object                       {
//   PEUS_Pala()
// }
//
#include "colors.inc"

#declare OjoAbsoluto            = 256;
#declare VecesCentroAbsoluto    = 10;     
#declare L                      = 0.001;
camera {
        location  <   0,  0, -( VecesCentroAbsoluto+1 )*OjoAbsoluto >*L
        direction z
        sky       y
        angle     38.74
//        look_at  <   0,  0, -VecesCentroAbsoluto*OjoAbsoluto >*L
} 
light_source    {
         < 500  , 500   , -3000 >*L
         White
}
background      {
         Gray50
}                                     

#include "PEUS.inc"

#declare FactorAcercamiento             = 2.25;

object          {
  PEUS_Pala()                               
  translate     -0.375*y                     
  rotate        90*z
  translate       -( VecesCentroAbsoluto+1 )
         *( FactorAcercamiento-1 )/( FactorAcercamiento )*OjoAbsoluto*L*z           
}


                