// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  26 junio 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// PEUS PalaExcavadoraUsoSuelo
// El archivo dibuja una pala corriente. 
// Ofrece una macro para cambiar las caracteristicas principales y texturas.   
// Es compatible con POVRay 3.1.
//
// La macro principal carece de parametros
// #macro PEUS_Pala()
//
// La siguiente versin de la macro, permite un mayor control de las caracteristicas.
// #macro PEUS_PalaExcavadoraUsoSuelo( BocaPala, AnguloPala,
//                LargoPala, LargoSoporte, DiametroMadera,
//                FraccionUnion, FraccionAgarre,
//                TexturaPala, TexturaSoporteMetal,
//                TexturaUnionMetalMadera, TexturaMadera,
//                TexturaAgarre, TexturaAgarre2 )
//      BocaPala                : Vector para describir las dimensiones de la
//              boca de pala, a partir de un objeto unitario. 
//              Default es <150,218, 43>*L.
//      AnguloPala              : Inclinacion de la boca de pala, respecto al soporte.
//              Default es 22.5 grados.
//      LargoPala               : Referencia para el largo total de la pala.
//              Default es 744*L.
//      LargoSoporte            : Referencia para el largo del soporte de la pala.
//              Default es 494*L.
//      DiametroMadera          : Diametro de la madera cilindrica de soporte.
//              Default es 27*L.
//      FraccionUnion           : Fraccion propia relativa del tamano de la
//              union soporte-pala, respecto al largo del soporte.
//              Default es 0.1.
//      FraccionAgarre          : Referencia como fraccion propia relativa del
//              tamano del mango respecto al largo del soporte.
//              Default es 0.175.
//      TexturaPala             : Textura de la boca de pala.
//              Default es PEUS_TexturaPala.
//      TexturaSoporteMetal     : Textura de soporte directo de boca de pala.    
//              Default es PEUS_TexturaSoporteMetal.
//      TexturaUnionMetalMadera : Textura de la union metal-madera del soporte.
//              Default es PEUS_TexturaUnionMetalMadera.
//      TexturaMadera           : Textura de la madera del brazo de la pala.
//              Default es PEUS_TexturaMadera.
//      TexturaAgarre           : Textura del mango.  Default es PEUS_TexturaAgarre. 
//      TexturaAgarre2          : Textura del mango en contacto con la mano.
//              Default es PEUS_TexturaAgarre2.
//
// El aparato por defecto tiene las siguientes dimensiones:      
//      Alto                            =  760*L
//      Frente en X                     =  150*L
//      Profundidad en Z                = -110*L.. 35*L
// Se dibuja semicentrado sobre el plano XZ.  El eje de la pala en Y, con boca
// hacia Z-, gravedad Y-.  
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare PEUS_DefaultTexturaPala             
//      Textura de la boca de pala.
// #declare PEUS_DefaultTexturaSoporteMetal     
//      Textura de soporte directo de boca de pala.    
// #declare PEUS_DefaultTexturaUnionMetalMadera 
//      Textura de la union metal-madera del soporte.
// #declare PEUS_DefaultTexturaMadera           
//      Textura de la madera del brazo de la pala.
// #declare PEUS_DefaultTexturaAgarre           
//      Textura del mango.  
// #declare PEUS_DefaultTexturaAgarre2          
//      Textura del mango en contacto con la mano.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default) 
// #declare PEUS_FF                     = 3
//      Controla el grado de subdivision para la aproximacion del
//      relieve de la pala.  Casi siempre un valor unitario funcionara bien.
//      Tomar en cuenta que cada unidad multiplica por cuatro el detalle.
//      Esta variable requiere declararse antes del #include. 
// #declare PEUS_TexturaPala             
//      Textura de la boca de pala.
// #declare PEUS_TexturaSoporteMetal     
//      Textura de soporte directo de boca de pala.    
// #declare PEUS_TexturaUnionMetalMadera 
//      Textura de la union metal-madera del soporte.
// #declare PEUS_TexturaMadera           
//      Textura de la madera del brazo de la pala.
// #declare PEUS_TexturaAgarre           
//      Textura del mango.  
// #declare PEUS_TexturaAgarre2          
//      Textura del mango en contacto con la mano.
// #declare PEUS_POV3_1                                 = off;
//      Valor "on" activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo simplemente
// #include "PEUS.inc"
// object        { PEUS_Pala() }
//
// Otro ejemplo con la macro detallada:
// #include "PEUS.inc"   
// object                       { 
//   PEUS_PalaExcavadoraUsoSuelo( <0.15,0.218,0.043>, 
//      22.5, 0.744, 0.494, 0.027, 0.1, 0.175,
//      PEUS_TexturaPala, PEUS_TexturaSoporteMetal,
//      PEUS_TexturaUnionMetalMadera,
//      PEUS_TexturaMadera, PEUS_TexturaAgarre, PEUS_TexturaAgarre2 )
// }                   
//
// O bien con modificadores:
// #include "PEUS.inc"                         
// #include "textures.inc"
// #declare PEUS_TexturaPala  = PinkAlabaster
// object                       {
//   PEUS_Pala()
// }
//
#include "colors.inc"
#include "woods.inc"
#include "PEUS_AU1.inc"
#include "PEUS_AU2.inc"

#declare PEUS_L         = 0.001;

#ifndef ( PEUS_FF ) 
  #declare PEUS_FF              = 3;
#end  // #ifndef ( PEUS_FF )

#declare PEUS_DefaultTexturaPala        =
  texture                       {
    pigment                     {
      Gray50
    }
    normal                      {
      granite
      turbulence                2
      scale                     PEUS_L
    }
  }

#ifndef ( PEUS_TexturaPala )
  #declare PEUS_TexturaPala             = PEUS_DefaultTexturaPala
#end  // #ifndef ( PEUS_TexturaPala )

#declare PEUS_DefaultTexturaSoporteMetal        =
  texture                       {
    pigment                     {
      Gray25
    }
    normal                      {
      granite
      scale                     10*PEUS_L
    }
    finish                      {
      metallic
    }
  }

#ifndef ( PEUS_TexturaSoporteMetal )
  #declare PEUS_TexturaSoporteMetal     = PEUS_DefaultTexturaSoporteMetal
#end  // #ifndef ( PEUS_TexturaSoporteMetal )

#declare PEUS_DefaultTexturaUnionMetalMadera    =
  texture                       {
    pigment                     {
      Red
    }
    normal                      {
      bumps
      scale                     10*PEUS_L
    }
  }

#ifndef ( PEUS_TexturaUnionMetalMadera )
  #declare PEUS_TexturaUnionMetalMadera  =
                PEUS_DefaultTexturaUnionMetalMadera
#end  // #ifndef ( PEUS_TexturaUnionMetalMadera )

#declare PEUS_DefaultTexturaMadera      = T_Wood10

#ifndef ( PEUS_TexturaMadera )
  #declare PEUS_TexturaMadera   = PEUS_DefaultTexturaMadera
#end  // #ifndef ( PEUS_TexturaMadera )

#declare PEUS_DefaultTexturaAgarre      = PEUS_DefaultTexturaSoporteMetal

#ifndef ( PEUS_TexturaAgarre )
  #declare PEUS_TexturaAgarre   = PEUS_DefaultTexturaAgarre
#end  // #ifndef ( PEUS_TexturaMadera )

#declare PEUS_DefaultTexturaAgarre2     = PEUS_DefaultTexturaUnionMetalMadera

#ifndef ( PEUS_TexturaAgarre2 )
  #declare PEUS_TexturaAgarre2   = PEUS_DefaultTexturaAgarre2
#end  // #ifndef ( PEUS_TexturaAgarre2 )

#declare PEUS_RedPala  = array [5][7][4]
  { { {
<-0.500, 0.030, 0.030>,< 0.300, 1.000, 0.000>,<on ,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<-0.250, 0.030, 0.130>,< 0.000, 1.000, 0.000>,<on ,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<-0.100,-0.095, 0.030>,<-0.500, 1.000, 0.000>,<on ,off,PEUS_FF>,<-1,-3.75,0.005>
      },{
< 0.000,-0.120,-0.020>,< 0.000, 1.000, 0.000>,<on ,off,PEUS_FF>,<-1,-3.75,0.005>
      },{
<+0.100,-0.095, 0.030>,< 0.500, 1.000, 0.000>,<on ,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<+0.250, 0.030, 0.130>,< 0.000, 1.000, 0.000>,<on ,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<+0.500, 0.030, 0.030>,<-0.300, 1.000, 0.000>,<off,off,PEUS_FF>,<-1,+3.75,0.005>
      }
    },
    { {
<-0.500, 0.000, 0.000>,< 0.300, 0.000,-1.000>,<on ,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<-0.250, 0.000, 0.100>,< 0.000, 0.000,-1.000>,<on ,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<-0.100,-0.125, 0.000>,<-0.500, 0.000,-1.000>,<on ,off,PEUS_FF>,<-1,-3.75,0.005>
      },{
< 0.000,-0.150,-0.050>,< 0.000, 0.000,-1.000>,<on ,off,PEUS_FF>,<-1,-3.75,0.005>
      },{
<+0.100,-0.125, 0.000>,< 0.500, 0.000,-1.000>,<on ,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<+0.250, 0.000, 0.100>,< 0.000, 0.000,-1.000>,<on ,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<+0.500, 0.000, 0.000>,<-0.300, 0.000,-1.000>,<off,off,PEUS_FF>,<-1,+3.75,0.005>
      }
    },
    { {
<-0.500,-0.200, 0.000>,< 0.300, 0.000,-1.000>,<on ,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<-0.250,-0.200, 0.125>,< 0.000, 0.000,-1.000>,<on ,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<-0.050,-0.250, 0.060>,<-0.500,-0.200,-1.000>,<on ,off,PEUS_FF>,<-1,-3.75,0.005>
      },{
< 0.000,-0.250,-0.010>,< 0.000,-0.300,-1.000>,<on ,off,PEUS_FF>,<-1,-3.75,0.005>
      },{
<+0.050,-0.250, 0.060>,< 0.500,-0.200,-1.000>,<on ,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<+0.250,-0.200, 0.125>,< 0.000, 0.000,-1.000>,<on ,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<+0.500,-0.200, 0.000>,<-0.300, 0.000,-1.000>,<off,off,PEUS_FF>,<-1,+3.75,0.005>
      }
    },
    { {
<-0.500,-0.400, 0.000>,< 0.300, 0.000,-1.000>,<on ,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<-0.250,-0.500, 0.100>,< 0.000, 0.000,-1.000>,<on ,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<-0.050,-0.575, 0.075>,<-0.500,-0.300,-1.000>,<on ,off,PEUS_FF>,<-1,-3.75,0.005>
      },{
< 0.000,-0.600, 0.050>,< 0.000,-0.300,-1.000>,<on ,off,PEUS_FF>,<-1,-3.75,0.005>
      },{
<+0.050,-0.575, 0.075>,< 0.500,-0.300,-1.000>,<on ,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<+0.250,-0.500, 0.100>,< 0.000, 0.000,-1.000>,<on ,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<+0.500,-0.400, 0.000>,<-0.300, 0.000,-1.000>,<off,off,PEUS_FF>,<-1,+3.75,0.005>
      }
    },
    { {
<-0.475,-0.600, 0.000>,< 0.300, 0.300,-1.000>,<off,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<-0.250,-0.850, 0.010>,< 0.000, 0.300,-1.000>,<off,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<-0.050,-0.975, 0.022>,< 0.000, 0.300,-1.000>,<off,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
< 0.000,-1.000, 0.025>,< 0.000, 0.300,-1.000>,<off,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<+0.050,-0.975, 0.022>,< 0.000, 0.300,-1.000>,<off,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<+0.250,-0.850, 0.000>,< 0.000, 0.300,-1.000>,<off,off,PEUS_FF>,<-1,+3.75,0.005>
      },{
<+0.475,-0.600, 0.010>,<-0.300, 0.300,-1.000>,<off,off,PEUS_FF>,<-1,+3.75,0.005>
      }
    }
  }


#macro PEUS_PalaExcavadoraUsoSuelo( BocaPala, AnguloPala,
                LargoPala, LargoSoporte, DiametroMadera,
                FraccionUnion, FraccionAgarre,
                TexturaPala, TexturaSoporteMetal,
                TexturaUnionMetalMadera, TexturaMadera,
                TexturaAgarre, TexturaAgarre2 )
  union                         {
    #local FraccionAnchoUnion   = 0.025;

    object                      {
      PEUS_Red( PEUS_RedPala, "", off, -1 )
      texture                   {
        TexturaPala
      }
      scale                     BocaPala/<1,1,0.1>
      translate                 BocaPala.y*y
      rotate                    AnguloPala*x
      translate                 -( LargoPala-LargoSoporte )*y
      translate                 -DiametroMadera/2*z
      #local PuntoUnion         = BocaPala*<0,0.9,0>;
      #local PuntoUnion         = vaxis_rotate( PuntoUnion, x, AnguloPala );
      #local PuntoUnion         = PuntoUnion
                        -( LargoPala-LargoSoporte )*y
                        -DiametroMadera/2*z;
    }
    #local PivoteReal           = vlength( PuntoUnion );
    #local PivoteRadio          = PivoteReal*PivoteReal/( 2*abs( PuntoUnion.z ) );
    #local NuevoPunto           = PuntoUnion/2-PivoteRadio*z;
    #local NuevoPunto           =
             PivoteRadio*vnormalize( NuevoPunto )+PivoteRadio*z;
    union                       {
      object                    {
        PEUS_SweepTriplePunto( <0,0,0>, NuevoPunto, PuntoUnion,
                        DiametroMadera/2, false )
      }
      cylinder                  {
        0, LargoSoporte*( FraccionUnion-FraccionAnchoUnion/2 )*y,
        DiametroMadera/2
      }
      texture                   {
        TexturaSoporteMetal
      }
    }
    cylinder                    {
      0, FraccionAnchoUnion*LargoSoporte*y, 1.2*DiametroMadera/2
      translate                 ( FraccionUnion-FraccionAnchoUnion/2 )*
                                        LargoSoporte*y
      texture                   {
        TexturaUnionMetalMadera
      }
    }
    cylinder                    {
      FraccionUnion*LargoSoporte*y,
      LargoSoporte*( 1-FraccionAgarre )*y,
      DiametroMadera/2
      texture                   {
        TexturaMadera
      }
    }
    union                       {
      cone                      {
        0, 1.1*DiametroMadera/2
        LargoSoporte*0.15*FraccionAgarre*y, 1.25*DiametroMadera/2
        translate               LargoSoporte*y*(1-FraccionAgarre)
      }
      object                            {
        PEUS_BlobMango( TexturaAgarre, TexturaAgarre2 )
        translate               0.4*y
        rotate                  -25*x
        translate               -0.4*y
        translate               -0.9*cos( 25*pi/180 )*y
        scale                   <1.50*DiametroMadera,
                                 FraccionAgarre*LargoSoporte/2,
                                 1.25*DiametroMadera>
        translate               LargoSoporte*y
      }
      texture                           {
        TexturaAgarre
      }
    }    
    translate                   ( LargoPala-LargoSoporte )*y
  }
#end  // PEUS_PalaExcavadoraUsoSuelo

#macro PEUS_Pala()
  object                        {
    #local L                    = PEUS_L;
    #local BocaPala             = <150,218,43>*L;
    #local AnguloPala           = 22.5;
    #local DiametroMadera       = 27*L;
    #local LargoPala            = 744*L;
    #local LargoSoporte         = 494*L;
    #local FraccionUnion        = 0.1;
    #local FraccionAgarre       = 0.175;
    PEUS_PalaExcavadoraUsoSuelo( BocaPala, AnguloPala,
      LargoPala, LargoSoporte, DiametroMadera,
      FraccionUnion, FraccionAgarre,
      PEUS_TexturaPala, PEUS_TexturaSoporteMetal,
      PEUS_TexturaUnionMetalMadera,
      PEUS_TexturaMadera, PEUS_TexturaAgarre, PEUS_TexturaAgarre2 )
  }
#end  // #macro PEUS_Pala
