// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho... 30 septiembre 2013
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas
// definido como 0.001 para POVRAY
//
// BCSE_TDEP TiraderaDEPuerta
// El archivo dibuja tiraderas de puerta y/o gaveta simples.
// Las macros son muy poco flexibles, pero permiten cambiar la textura.
// Es compatible con POVRay 3.1.
// Para el diseno de los cinco objetos se utilizo inicialmente el programa
// Epspline.exe para Windows.  
//
// El paquete incluye cinco macros, con parametro de textura.  Se ofrecen
// texturas recomendadas.  
// La macro para la base de tiraderas.
// #macro BCSE_TDEP_BaseTirador( TexturaAplicar ) 
//      TexturaAplicar          : Textura a aplicar al objeto.
//              Sugerencia : BCSE_TDEP_TexturaBaseTirador.
//
// La macro para la tiradera circular con decorado abierto interior.                                         
// #macro BCSE_TDEP_TiraderaCircularAbierta
//   ( TexturaCirculoExterno, TexturaDecorado, TexturaCilindro )
//      TexturaCirculoExterno   : Textura para el diametro mayor.
//              Sugerencia : BCSE_TDEP_TexturaTiraderaCircularAbiertaA.
//      TexturaDecorado         : Textura para el decorado central.
//              Sugerencia : BCSE_TDEP_TexturaTiraderaCircularAbiertaB.
//      TexturaCilindro         : Textura para el cilindro soporte.
//              Sugerencia : BCSE_TDEP_TexturaTiraderaCircularAbiertaC.
// 
// La macro para la tiradera larga con estructura estilo lathe.                                                                 
// #macro BCSE_TDEP_TiraderaLathe( TexturaAplicar )                
//      TexuraAplicar           : Textura para aplicar al objeto.
//              Sugerencia : BCSE_TDEP_TexturaTiraderaLathe.
//   
// Para crear una tiradera circular corriente.
// #macro BCSE_TDEP_TiraderaBasica( TexturaAplicar )
//      TexturaAplicar          : Textura de la estructura.
//              Sugerencia : BCSE_TDEP_TexturaTiraderaBasica.
// 
// Para crear una tiradera alargada simple con poco relieve.
// #macro BCSE_TDEP_TiraderaLargaBasica( TexturaAplicar )
//      TexturaAplicar          : Textura para aplicar a la estructura.
//              Sugerencia : BCSE_TDEP_TexturaTiraderaLargaBasica.
//   
// Las dimensiones de los objetos son :
// BaseTiradera
//      Largo                   :  71.5*L
//      Frente                  :  21.5*L
//      Profundidad             :   0.7*L
// TiraderaCircularAbierta
//      DiametroMayor           :  33.6*L
//      Profundidad             :  15.5*L
//      ProfundidadAgarre       :  14.0*L
//      DiametroAgarre          :   5.0*L 
// Tiradera Lathe
//      Largo                   :  80.0*L
//      Ancho                   :   7.0*L
//      Profundidad             :  12.0*L
//      Profundidad Base        :   8.0*L
// Tiradera Basica
//      DiametroAgarre          :  33.0*L
//      AltoAgarre              :  14.5*L   
// Tiradera Larga Basica
//      Larga                   :  86.0*L
//      Ancho                   :  13.0*L
//      Profundidad             :  17.0*L
// Todos los objetos anteriores descansan sobre el plano XZ, centrados en el origen.
// Y sobresalen hacia Z-.  La dimensin larga, si existe, en el eje Y. 
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse.
// #declare BCSE_TDEP_TexturaBaseTirador
//      Textura sugerida para la macro BCSE_TDEP_BaseTirador.
// #declare BCSE_TDEP_TexturaTiraderaCircularAbiertaA      
//      Textura sugerida para el primer parametro macro BCSE_TDEP_TiraderaCircularAbierta.
// #declare BCSE_TDEP_TexturaTiraderaCircularAbiertaB 
//      Textura sugerida para el segundo parametro macro BCSE_TDEP_TiraderaCircularAbierta.
// #declare BCSE_TDEP_TexturaTiraderaCircularAbiertaC                         
//      Textura sugerida para el tercer parametro macro BCSE_TDEP_TiraderaCircularAbierta.
// #declare LSLE_TexturaTiraderaLathe
//      Textura sugerida para la macro BCSE_TDEP_TiraderaLathe.
// #declare LSLE_TexturaTiraderaBasica
//      Textura sugerida para la macro BCSE_TDEP_TiraderaBasica.
// #declare LSLE_TexturaTiraderaLargaBasica
//      Textura sugerida para la macro BCSE_TDEP_TiraderaLargaBasica.
//   
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default)
// #declare TDEO_POV3_1                                 = off;
//      Valor on activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente.
//      En esta version no cumple ninguna funcion.
//
// Para colocarlo simplemente
//
// #include "BCSE_AU3.inc"
//  object                  {
//    BCSE_TDEP_BaseTirador( BCSE_TDEP_TexturaBaseTirador ) 
//  }
//
//  o bien... 
//  #include "BCSE_AU3.inc"
//  object                  {
//    BCSE_TDEP_TiraderaCircularAbierta( 
//      BCSE_TDEP_TexturaTiraderaCircularAbiertaA,
//      BCSE_TDEP_TexturaTiraderaCircularAbiertaB,
//      BCSE_TDEP_TexturaTiraderaCircularAbiertaC )
//  }
//
//  o bien... 
//  #include "BCSE_AU3.inc"
//  object                  {
//    BCSE_TDEP_TiraderaLathe( BCSE_TDEP_TexturaTiraderaLathe )  
//  }
//
//  o bien... 
//  #include "BCSE_AU3.inc"
//  object                  {
//    BCSE_TDEP_TiraderaBasica( BCSE_TDEP_TexturaTiraderaBasica )
//  }
//
//  o bien... 
//  #include "BCSE_AU3.inc"
//  object                          {
//    BCSE_TDEP_TiraderaLargaBasica( BCSE_TDEP_TexturaTiraderaLargaBasica )
//  }
//

#declare BCSE_TDEP_L                 = 0.001;

#include "BCSE_AU4.inc"
#include "BCSE_AU5.inc"
#include "BCSE_AU6.inc"
#include "BCSE_AU7.inc"
#include "BCSE_AU8.inc"
#include "metals.inc"  
#include "stones.inc"  

#declare BCSE_TDEP_Textura1                          =
  texture                                       {  
    T_Copper_5C
    normal                              {  
      bumps
      scale             20*BCSE_TDEP_L
    }
  }

#declare BCSE_TDEP_Textura2                          =
  texture                                       {  
    T_Copper_5A
    normal                              {  
      bumps
      scale             20*BCSE_TDEP_L
    }
  }

#declare BCSE_TDEP_TexturaBaseTirador        =
  texture                               {  
    bumps                                  
      scale             40*BCSE_TDEP_L
      texture_map                       {   
        [ 0 BCSE_TDEP_Textura1 ]
        [ 1 BCSE_TDEP_Textura2 ]
      }
    
  }  
  
#declare BCSE_TDEP_TexturaTiraderaCircularAbiertaA   =
  texture                               { 
    T_Brass_2A             
    normal                              {  
      ripples                              
      turbulence                        0.2
      scale             10*BCSE_TDEP_L
    }
  }  

#declare BCSE_TDEP_TexturaTiraderaCircularAbiertaB   =
  texture                               { 
    T_Chrome_1A    
    normal                              { 
      granite
      
    }
  }  

#declare BCSE_TDEP_TexturaTiraderaCircularAbiertaC   =
  texture                               { 
    T_Chrome_1A 
    normal                              { 
      granite
    }
  }  
                       
#declare BCSE_TDEP_Textura3                          =                       
  texture                               {   
    T_Chrome_2C
    normal                              {
      dents                              
      turbulence                        1
      scale                             5*BCSE_TDEP_L
    }
  }    
  
#declare BCSE_TDEP_Textura4                          =                       
  texture                               {   
    T_Silver_1B 
    normal                              {   
      wood
      turbulence                        0.5
      rotate            100
      scale                             50*BCSE_TDEP_L
    }
  }
                       
#declare BCSE_TDEP_TexturaTiraderaLathe              =
  texture                               {   
    onion                                         
    triangle_wave
    turbulence                          0.1       
    scale                               10*BCSE_TDEP_L                        
    texture_map                         { 
      [ 0 BCSE_TDEP_Textura3 ]
      [ 1 BCSE_TDEP_Textura4 ]
    }     
  }  
                          
#declare BCSE_TDEP_Textura5                  =
  texture                               { 
    BCSE_TDEP_TexturaTiraderaCircularAbiertaA
  }
  
#declare BCSE_TDEP_Textura6                  =
  texture                               {
    BCSE_TDEP_TexturaTiraderaCircularAbiertaB
  }                            
                          
#declare BCSE_TDEP_TexturaTiraderaBasica     =
  texture                               {   
    gradient z  
    scale               z
    texture_map                         { 
      [ 0.0 BCSE_TDEP_Textura5 ]
      [ 0.5 BCSE_TDEP_Textura5 ]
      [ 0.5 BCSE_TDEP_Textura6 ]
      [ 1.0 BCSE_TDEP_Textura6 ]
    }
  }  
  
#declare BCSE_TDEP_TexturaTiraderaLargaBasica        =
  texture                                       {
    T_Stone35
  }  

#macro BCSE_TDEP_BaseTirador( TexturaAplicar )
  union                         {
    #local L                    = BCSE_TDEP_L;
    difference                  {
      union                     {
      #local C                  = 0;
      #while ( C < 4 )
        object                  {
          BCSE_TDEP_Base
          translate             -136.1*x-494.1*z-y
          rotate                90*x
          #if ( div( C,2 )=1 )
            scale                  -y
          #end
          #if ( mod( C,2) = 1 )
            scale                  -x
          #end
        }
        #local C                = C+1;
      #end
        scale                   <1/59,1/200,1>*<21.45*L,71.5*L,1.4*L>/2
      }
      cylinder                  {
        -z,z,1.8*L
      }
      cylinder                  {
        -z,z,0.7*L
        translate               31.45*L*y
      }
      cylinder                  {
        -z,z,0.7*L
        translate               -31.45*L*y
      }
    }
    texture                     {
      TexturaAplicar
    }
  }
#end  //  #macro BCSE_TDEP_BaseTirador

#macro BCSE_TDEP_TiraderaCircularAbierta
  ( TexturaCirculoExterno, TexturaDecorado, TexturaCilindro )
  union                         {
    #local L                    = BCSE_TDEP_L;
    #local AltoCilindro         = 14*L;
    #local DiametroCilindro     = 5*L;
    #local DiametroMayor        = 33.6*L;
    #local DiametroMenor        = 20.7*L;
    #local AltoCircular         = 1.5*L;
    union                       {
      #local C                  = 0;
      #while ( C < 6 )
        difference              {
          object                {
            BCSE_TDEP_BaseCExterior
          }
          object                {
            BCSE_TDEP_BaseCInterior
          }
          translate             -360*x-374*z+y
          rotate                -90*x
          scale                 <1/390,1/390,1/2>
          scale                 <DiametroMenor/2,DiametroMenor/2,AltoCircular>
          #if ( div( C, 3 ) = 1 )
            scale               -y
          #end
          rotate                mod(C,3)*120*z
        }
        #local C                = C+1;
      #end
      #local C                  = 0;
      #while ( C < 20 )
        difference              {
          object                {
            BCSE_TDEP_BaseFlor
          }
          object                {
            BCSE_TDEP_BaseFlorInterior
          }
          plane                 {
            z,374
          }
          translate             -360*x-374*z+y
          rotate                -90*x
          scale                 <1/390,1/390,1/2>
          scale                 <DiametroMenor/2,DiametroMenor/2,AltoCircular>
          #if ( div( C, 10 ) = 1 )
            scale               -y
          #end
          rotate                mod(C,10)*36*z
        }
        #local C                = C+1;
      #end
      translate                 -AltoCilindro*z
      texture                   {
        TexturaDecorado
      }
    }
    cylinder                    {
      0, -AltoCilindro*z, DiametroCilindro/2
      texture                   {
        TexturaCilindro
      }
    }
    difference                  {
      torus                     {
        DiametroMenor/2, ( DiametroMayor-DiametroMenor )/2
        rotate                  90*x
      }
      plane                     {
        -z,0
      }
      cylinder                  {
        -DiametroMayor*z, DiametroMayor*z, DiametroMenor/2
      }
      scale                     2*AltoCircular*z/
                                ( DiametroMayor-DiametroMenor )
      translate                 -AltoCilindro*z
      texture                   {
        TexturaCirculoExterno
      }
    }
  }
#end  //  #macro BCSE_TDEP_TiraderaCircularAbierta

#macro BCSE_TDEP_TiraderaLathe( TexturaAplicar )
  union                         {
    #local L                    = BCSE_TDEP_L;
    #local Alto                 = 78.6*L;
    #local SeparacionPatas      = 54*L;
    #local DiametroPatas        = 4.3*L;
    #local AltoPatas            = 8.6*L;
    #local C                    = 0;
    #while ( C < 2 )
      difference                  {
        object                    {
          BCSE_TDEP_Lathe
          translate               -902*y
          scale                   0.5*Alto/793
        }
        plane                     {
          -z, 0
        }
        translate               +0*Alto*y
        #if ( C = 0 )
          scale -y
        #end
        translate               -AltoPatas*z
      }
      #local C                  = C+1;
    #end
    cylinder                    {
      0, -AltoPatas*z, DiametroPatas/2
      translate                 +SeparacionPatas/2*y
    }
    cylinder                    {
      0, -AltoPatas*z, DiametroPatas/2
      translate                 -SeparacionPatas/2*y
    }
    texture                     {
      TexturaAplicar
    }
  }
#end

#macro BCSE_TDEP_TiraderaBasica( TexturaAplicar )
  union                         {
    #local L                    = BCSE_TDEP_L;
    #local DiametroPrincipal    = 28.5*L;
    #local DiametroPatas        = 5*L;
    #local AltoPatas            = 11.5*L;
    object                      {
      BCSE_TDEP_TiraderaEsferoidal
      translate                 -300*y
      scale                     -0.5*DiametroPrincipal/284
      rotate                    -90*x
      translate                 -AltoPatas*z
    }
    cylinder                    {
      0, -AltoPatas*z, DiametroPatas/2
    }
    texture                     {
      TexturaAplicar
      scale                     AltoPatas*2.225
      translate                 -AltoPatas*z*0.0
    }
  }
#end

#macro BCSE_TDEP_TiraderaLargaBasica( TexturaAplicar )
  union                         {
    #local L                    = BCSE_TDEP_L;
    #local LargoPrincipal       = 85.8*L;
    #local SeparacionPatas      = 72.9*L;
    #local DiametroPatas        = 12.9*L;
    #local ProfundidadPatas     = 3*L;
    #local AgujeritoPatas       = 3*L;
    difference                          {
    intersection                       {

      union                     {
        object                    {
          BCSE_TDEP_Prisma1
          translate               -103*x-511*z
          scale                   0.5*LargoPrincipal/1090*<1,0,1>+0.02*y
          rotate                  -90*z
          translate               0.975*LargoPrincipal/2*y
        }
        object                    {
          BCSE_TDEP_Prisma1
          translate               -103*x-511*z
          scale                   0.5*LargoPrincipal/1090*<1,0,1>+0.02*y
          rotate                  -90*z
          translate               0.975*LargoPrincipal/2*y
          scale                 -y
        }
      }

      union                     {
        object                    {
          BCSE_TDEP_Prisma2
          translate               -105*x-376*z
          scale                   0.5*LargoPrincipal/1090*<1,0,1>+0.02*y
          rotate                  -90*z
          translate               0.975*LargoPrincipal/2*y
        }
        object                    {
          BCSE_TDEP_Prisma2
          translate               -105*x-376*z
          scale                   0.5*LargoPrincipal/1090*<1,0,1>+0.02*y
          rotate                  -90*z
          translate               0.975*LargoPrincipal/2*y
          scale                 -y
        }
        object                    {
          BCSE_TDEP_Prisma2
          translate               -105*x-376*z
          scale                   0.5*LargoPrincipal/1090*<1,0,1>+0.02*y
          rotate                  -90*z
          translate               0.975*LargoPrincipal/2*y
          scale                 -z
        }
        object                    {
          BCSE_TDEP_Prisma2
          translate               -105*x-376*z
          scale                   0.5*LargoPrincipal/1090*<1,0,1>+0.02*y
          rotate                  -90*z
          translate               0.975*LargoPrincipal/2*y
          scale                 -y
          scale                 -z
        }
        rotate                  90*y
      }

      union                     {
        object                    {
          BCSE_TDEP_Prisma3
          translate               -1587*x-375*z
          scale                   0.5*LargoPrincipal/1090*<1,0,1>+0.05*y
          rotate                  -90*z
          translate               -0.400*LargoPrincipal/2*y
        }
        object                    {
          BCSE_TDEP_Prisma3
          translate               -1587*x-375*z
          scale                   0.5*LargoPrincipal/1090*<1,0,1>+0.05*y
          rotate                  -90*z
          translate               -0.400*LargoPrincipal/2*y
          scale                 -z
        }
        rotate                  90*y
        rotate                  90*x
      }
    }
        cone                    {
          +0.1*ProfundidadPatas*z, AgujeritoPatas/2,
          -1.1*ProfundidadPatas*z, 2*AgujeritoPatas/2
          translate             +SeparacionPatas/2*y
        }
        cone                    {
          +0.1*ProfundidadPatas*z, AgujeritoPatas/2,
          -1.1*ProfundidadPatas*z, 2*AgujeritoPatas/2
          translate             -SeparacionPatas/2*y
        }
    }
    #local C                    = 0;
    #while ( C < 2 )
      difference                  {
        cone                    {
          0, DiametroPatas/2,
          -ProfundidadPatas*z, 0.90*DiametroPatas/2
        }
        cone                    {
          +0.1*ProfundidadPatas*z, AgujeritoPatas/2,
          -1.1*ProfundidadPatas*z, 2*AgujeritoPatas/2
        }
        translate                       +SeparacionPatas/2*y
        #if ( C = 1 )
          scale                 -y
        #end
      }
      #local C                  = C+1;
    #end
    texture                     {
      TexturaAplicar
    }
  }
#end  // #macro BCSE_TDEP_TiraderaLargaBasica
