// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho... 4 noviembre 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas
// definido como 0.001 para POVRAY
//
// BCSE BaseCamaSinExtras
// El archivo dibuja el respaldo y la base inferior para una cama individual.
// Se incluye macro para modificar caracteristicas principales.
// Es compatible con POVRay 3.1.
// Algunos elementos prismaticos fueron disenados con Epspline.exe.
//           
// La macro fundamental, tiene un parametro.
// #macro BCSE_BaseCama( AnguloGaveta )
//      AnguloGaveta            : Angulo a partir de cero para abrir la gaveta.
//
// La siguiente macro permite mucho mayor control sobre las caracteristicas.
// #macro BCSE_BaseCamaSinExtras( AnguloGaveta,
//              FrenteCama, FrenteMesa, AlturaMesa, ProfundidadMesa,
//              ExcesoBase, GruesoMedio, GruesoCuerda,
//              AltoPatas, GruesoPata, AltoCama, LargoCama,
//              TexturaPrincipal, TexturaGaveta, TexturaInteriorGaveta,
//              TexturaBordeGaveta, TexturaPatas, 
//              TexturaPatasCama, TexturaColchon )
//      AnguloGaveta            : Angulo a partir de cero para abrir la gaveta.
//      FrenteCama              : Referencia para el frente de cama, sin la mesita.
//              Default es 765*L.
//      FrenteMesa              : Referencia para el frente de la mesita de noche.  
//              Default es 308*L.
//      AlturaMesa              : Altura sobre el suelo de la superficie de la mesa.
//              Default es 390*L.
//      ProfundidadMesa         : Referencia para la profundidad Z de la mesa.
//              Default es 240*L.
//      ExcesoBase              : Referencia para el alto en exceso del respaldo
//              de cama respecto a la AlturaMesa.  Default es 200*L.
//      GruesoMedio             : Grueso de la madera.  Default es 12*L.
//      GruesoCuerda            : Grueso para la cuerda de la base del colchon.  
//              Default es 2*L.
//      AltoPatas               : Alto de las patas.  Default es 230*L.
//      GruesoPata              : Grueso de las patas.  Default es 50*L.
//      AltoCama                : Alto de la cama.  Default es 220*L.
//      LargoCama               : Largo de cama.  Default es 1325*L.
//      TexturaPrincipal        : Textura principal del respaldo.
//              Default es BCSE_TexturaPrincipal.
//      TexturaGaveta           : Textura principal de la gaveta.
//              Default es BCSE_TexturaGaveta.
//      TexturaInteriorGaveta   : Textura del interior de la gaveta.
//              Default es BCSE_TexturaInteriorGaveta.  
//      TexturaBordeGaveta      : Textura para el decorado del respaldo, y supuesto
//              relleno decorativo de la tabla superior de la mesa.
//              Default es BCSE_TexturaBordeGaveta.
//      TexturaPatas            : Textura para las patas.  
//              Default es BCSE_TexturaPatas.
//      TexturaPatasCama        : Textura para las patas de cama.
//              Default es BCSE_TexturaPatasCama.
//      TexturaColchon          : Textura de la base del colchon.
//              Default es BCSE_TexturaColchon.
//   
// Las dimensiones del objeto default :  
//      Altura en Y             :   640*L
//      Frente en X             : - 325*L..+750*L
//      Profundidad en Z        : -1325*L 
//      Profundidad mesita      : - 290*L   
// Descansa sobre el plano XZ, con gravedad Y-.  El respaldo descansa 
// sobre el plano XY con frente hacia Z-.  El plano XZ divide en dos
// zonas el dibujo:  la mesita en X- y la base del colchon en X+.
//     
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse.
// BCSE_DefaultTexturaPrincipal        
//      Textura principal del respaldo.
// BCSE_DefaultTexturaGaveta           
//      Textura principal de la gaveta.
// BCSE_DefaultTexturaInteriorGaveta   
//      Textura del interior de la gaveta.
// BCSE_DefaultTexturaBordeGaveta      
//      Textura para el decorado del respaldo, y supuesto
//      relleno decorativo de la tabla superior de la mesa.
// BCSE_DefaultTexturaPatas            
//      Textura para las patas.  
// BCSE_DefaultTexturaPatasCama       
//      Textura para las patas de cama.
// BCSE_DefaultTexturaColchon          
//      Textura de la base del colchon.
// BCSE_DefaultTexturaHilo             
//      Textura para la cuerda del colchon.
// BCSE_DefaultTexturaTiradera         
//      Textura para la tiradera.
//   
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default)
// #declare BCSE_TexturaPrincipal                       = texture  { ... }        
//      Textura principal del respaldo.
// #declare BCSE_TexturaGaveta                          = texture  { ... }         
//      Textura principal de la gaveta.
// #declare BCSE_TexturaInteriorGaveta                  = texture  { ... } 
//      Textura del interior de la gaveta.
// #declare BCSE_TexturaBordeGaveta                     = texture  { ... }      
//      Textura para el decorado del respaldo, y supuesto
//      relleno decorativo de la tabla superior de la mesa.
// #declare BCSE_TexturaPatas                           = texture  { ... }           
//      Textura para las patas.  
// #declare BCSE_TexturaPatasCama                       = texture  { ... }       
//      Textura para las patas de cama.
// #declare BCSE_TexturaColchon                         = texture  { ... }         
//      Textura de la base del colchon.
// #declare BCSE_TexturaHilo                            = texture  { ... }             
//      Textura para la cuerda del colchon.
// #declare BCSE_TexturaTiradera                        = texture  { ... }         
//      Textura para la tiradera.
// #declare BCSE_BanderaHilo                            = on;
//      Valor on dibuja la cuerda del colchon.  Valor off no la dibuja. 
// #declare BCSE_BanderaCama                            = on;
//      Valor on dibuja la cama.  Valor off no la dibuja.
// #declare BCSE_POV3_1                                 = off;
//      Valor on activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente.
//      En esta version no cumple ninguna funcion.
//
// Para colocarlo simplemente
//  #include "BCSE.inc"
//  object                  {
//    BCSE_BaseCama( 0 )  
//  }
//
//  o bien la macro detallada 
//  #include "BCSE.inc"
//  object                  {
//    BCSE_BaseCamaSinExtras( 0, 0.765, 0.308, 0.390, 0.240,
//              0.200, 0.012, 0.002, 0.230, 0.050, 0.220, 1.325,
//              BCSE_TexturaPrincipal, BCSE_TexturaGaveta, BCSE_TexturaInteriorGaveta,
//              BCSE_TexturaBordeGaveta, BCSE_TexturaPatas, 
//              BCSE_TexturaPatasCama, BCSE_TexturaColchon )
//  }
//
//  o bien con modificadores 
//  #include "BCSE.inc"                                
//  #include "textures.inc"
//  #declare BCSE_TexturaPrincipal              =
//      texture                         { 
//        average
//        average_map                   {   
//          [ 0.5 BCSE_DefaultTexturaPrincipal ]
//          [ 0.5 Rust                         ]
//        }            
//      }
//  object                          {
//    BCSE_BaseCama( 0 )
//  }
//


#include "colors.inc"

#declare OjoAbsoluto            = 256;
#declare VecesCentroAbsoluto    = 10;     
#declare L                      = 0.001;  
camera {
        location  <   0,  0, -( VecesCentroAbsoluto+1 )*OjoAbsoluto >*L
        direction z
        sky       y
        angle     38.74
//        look_at  <   0,  0, -VecesCentroAbsoluto*OjoAbsoluto >*L
}
light_source    {
         < 500  , 500   , -3000 >*L
         White
}
background      {
         Gray50
}    

#include "BCSE.inc"


object                  {
  BCSE_BaseCama( 0 )
  translate     -0.250*y-0.300*x
}





