// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho... 4 noviembre 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas
// definido como 0.001 para POVRAY
//
// BCSE BaseCamaSinExtras
// El archivo dibuja el respaldo y la base inferior para una cama individual.
// Se incluye macro para modificar caracteristicas principales.
// Es compatible con POVRay 3.1.
// Algunos elementos prismaticos fueron disenados con Epspline.exe.
//           
// La macro fundamental, tiene un parametro.
// #macro BCSE_BaseCama( AnguloGaveta )
//      AnguloGaveta            : Angulo a partir de cero para abrir la gaveta.
//
// La siguiente macro permite mucho mayor control sobre las caracteristicas.
// #macro BCSE_BaseCamaSinExtras( AnguloGaveta,
//              FrenteCama, FrenteMesa, AlturaMesa, ProfundidadMesa,
//              ExcesoBase, GruesoMedio, GruesoCuerda,
//              AltoPatas, GruesoPata, AltoCama, LargoCama,
//              TexturaPrincipal, TexturaGaveta, TexturaInteriorGaveta,
//              TexturaBordeGaveta, TexturaPatas, 
//              TexturaPatasCama, TexturaColchon )
//      AnguloGaveta            : Angulo a partir de cero para abrir la gaveta.
//      FrenteCama              : Referencia para el frente de cama, sin la mesita.
//              Default es 765*L.
//      FrenteMesa              : Referencia para el frente de la mesita de noche.  
//              Default es 308*L.
//      AlturaMesa              : Altura sobre el suelo de la superficie de la mesa.
//              Default es 390*L.
//      ProfundidadMesa         : Referencia para la profundidad Z de la mesa.
//              Default es 240*L.
//      ExcesoBase              : Referencia para el alto en exceso del respaldo
//              de cama respecto a la AlturaMesa.  Default es 200*L.
//      GruesoMedio             : Grueso de la madera.  Default es 12*L.
//      GruesoCuerda            : Grueso para la cuerda de la base del colchon.  
//              Default es 2*L.
//      AltoPatas               : Alto de las patas.  Default es 230*L.
//      GruesoPata              : Grueso de las patas.  Default es 50*L.
//      AltoCama                : Alto de la cama.  Default es 220*L.
//      LargoCama               : Largo de cama.  Default es 1325*L.
//      TexturaPrincipal        : Textura principal del respaldo.
//              Default es BCSE_TexturaPrincipal.
//      TexturaGaveta           : Textura principal de la gaveta.
//              Default es BCSE_TexturaGaveta.
//      TexturaInteriorGaveta   : Textura del interior de la gaveta.
//              Default es BCSE_TexturaInteriorGaveta.  
//      TexturaBordeGaveta      : Textura para el decorado del respaldo, y supuesto
//              relleno decorativo de la tabla superior de la mesa.
//              Default es BCSE_TexturaBordeGaveta.
//      TexturaPatas            : Textura para las patas.  
//              Default es BCSE_TexturaPatas.
//      TexturaPatasCama        : Textura para las patas de cama.
//              Default es BCSE_TexturaPatasCama.
//      TexturaColchon          : Textura de la base del colchon.
//              Default es BCSE_TexturaColchon.
//   
// Las dimensiones del objeto default :  
//      Altura en Y             :   640*L
//      Frente en X             : - 325*L..+750*L
//      Profundidad en Z        : -1325*L 
//      Profundidad mesita      : - 290*L   
// Descansa sobre el plano XZ, con gravedad Y-.  El respaldo descansa 
// sobre el plano XY con frente hacia Z-.  El plano XZ divide en dos
// zonas el dibujo:  la mesita en X- y la base del colchon en X+.
//     
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse.
// BCSE_DefaultTexturaPrincipal        
//      Textura principal del respaldo.
// BCSE_DefaultTexturaGaveta           
//      Textura principal de la gaveta.
// BCSE_DefaultTexturaInteriorGaveta   
//      Textura del interior de la gaveta.
// BCSE_DefaultTexturaBordeGaveta      
//      Textura para el decorado del respaldo, y supuesto
//      relleno decorativo de la tabla superior de la mesa.
// BCSE_DefaultTexturaPatas            
//      Textura para las patas.  
// BCSE_DefaultTexturaPatasCama       
//      Textura para las patas de cama.
// BCSE_DefaultTexturaColchon          
//      Textura de la base del colchon.
// BCSE_DefaultTexturaHilo             
//      Textura para la cuerda del colchon.
// BCSE_DefaultTexturaTiradera         
//      Textura para la tiradera.
//   
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default)
// #declare BCSE_TexturaPrincipal                       = texture  { ... }        
//      Textura principal del respaldo.
// #declare BCSE_TexturaGaveta                          = texture  { ... }         
//      Textura principal de la gaveta.
// #declare BCSE_TexturaInteriorGaveta                  = texture  { ... } 
//      Textura del interior de la gaveta.
// #declare BCSE_TexturaBordeGaveta                     = texture  { ... }      
//      Textura para el decorado del respaldo, y supuesto
//      relleno decorativo de la tabla superior de la mesa.
// #declare BCSE_TexturaPatas                           = texture  { ... }           
//      Textura para las patas.  
// #declare BCSE_TexturaPatasCama                       = texture  { ... }       
//      Textura para las patas de cama.
// #declare BCSE_TexturaColchon                         = texture  { ... }         
//      Textura de la base del colchon.
// #declare BCSE_TexturaHilo                            = texture  { ... }             
//      Textura para la cuerda del colchon.
// #declare BCSE_TexturaTiradera                        = texture  { ... }         
//      Textura para la tiradera.
// #declare BCSE_BanderaHilo                            = on;
//      Valor on dibuja la cuerda del colchon.  Valor off no la dibuja. 
// #declare BCSE_BanderaCama                            = on;
//      Valor on dibuja la cama.  Valor off no la dibuja.
// #declare BCSE_POV3_1                                 = off;
//      Valor on activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente.
//      En esta version no cumple ninguna funcion.
//
// Para colocarlo simplemente
//  #include "BCSE.inc"
//  object                  {
//    BCSE_BaseCama( 0 )  
//  }
//
//  o bien la macro detallada 
//  #include "BCSE.inc"
//  object                  {
//    BCSE_BaseCamaSinExtras( 0, 0.765, 0.308, 0.390, 0.240,
//              0.200, 0.012, 0.002, 0.230, 0.050, 0.220, 1.325,
//              BCSE_TexturaPrincipal, BCSE_TexturaGaveta, BCSE_TexturaInteriorGaveta,
//              BCSE_TexturaBordeGaveta, BCSE_TexturaPatas, 
//              BCSE_TexturaPatasCama, BCSE_TexturaColchon )
//  }
//
//  o bien con modificadores 
//  #include "BCSE.inc"                                
//  #include "textures.inc"
//  #declare BCSE_TexturaPrincipal              =
//      texture                         { 
//        average
//        average_map                   {   
//          [ 0.5 BCSE_DefaultTexturaPrincipal ]
//          [ 0.5 Rust                         ]
//        }            
//      }
//  object                          {
//    BCSE_BaseCama( 0 )
//  }
//

#include "colors.inc"
#include "woods.inc"
#include "BCSE_AU2.inc"  
#include "BCSE_AU3.inc"


#declare BCSE_L                 = 0.001;
#declare BCSE_BanderaHilo       = on;  
#declare BCSE_BanderaCama       = on;

#declare BCSE_DefaultTexturaPrincipal   =
  texture                       {
    T_Grnt20
    normal                      {  
      granite
    }
    scale                       0.5
  }

#ifndef ( BCSE_TexturaPrincipal )
  #declare BCSE_TexturaPrincipal        = BCSE_DefaultTexturaPrincipal
#end  // #ifndef ( BCSE_TexturaPrincipal )

#declare BCSE_DefaultTexturaGaveta   =
  texture                       {
    T_Grnt20
    scale                       0.25
  }

#ifndef ( BCSE_TexturaGaveta )
  #declare BCSE_TexturaGaveta        = BCSE_DefaultTexturaGaveta
#end  // #ifndef ( BCSE_TexturaGaveta )

#declare BCSE_DefaultTexturaInteriorGaveta   =
  texture                       {     
    T_Wood1
    rotate                      45
  }            

#ifndef ( BCSE_TexturaInteriorGaveta )
  #declare BCSE_TexturaInteriorGaveta        = BCSE_DefaultTexturaInteriorGaveta
#end  // #ifndef ( BCSE_TexturaInteriorGaveta )

#declare BCSE_DefaultTexturaPatas   =
  texture                       {
    T_Wood1                         
    rotate                      45
    scale                       0.1
  }      
  texture                       {  
    pigment { White transmit 0.10 }
    normal  { wood scale 0.01 rotate 45 }
  }

#ifndef ( BCSE_TexturaPatas )
  #declare BCSE_TexturaPatas        = BCSE_DefaultTexturaPatas
#end  // #ifndef ( BCSE_TexturaPatas )

#declare BCSE_DefaultTexturaPatasCama   =
  texture                       {
    T_Wood18                        
    rotate                      45
    scale                       0.1
  }      

#ifndef ( BCSE_TexturaPatasCama )
  #declare BCSE_TexturaPatasCama        = BCSE_DefaultTexturaPatasCama
#end  // #ifndef ( BCSE_TexturaPatasCama )

#declare BCSE_DefaultTexturaColchon   =
  texture                       {
    T_Stone34       
    normal                      {   
      quilted  0.1              
      control0 0.9
      control1 0.9 
      scale             0.5
    }
    scale               0.25
  } 

#ifndef ( BCSE_TexturaColchon )
  #declare BCSE_TexturaColchon        = BCSE_DefaultTexturaColchon
#end  // #ifndef ( BCSE_TexturaColchon )

#declare BCSE_DefaultTexturaHilo   =
  texture                       {
    T_Stone17
    scale               0.01
  }

#ifndef ( BCSE_TexturaHilo )
  #declare BCSE_TexturaHilo        = BCSE_DefaultTexturaHilo
#end  // #ifndef ( BCSE_TexturaHilo )

#declare BCSE_DefaultTexturaBordeGaveta   =
  texture                       {
    T_Grnt20                           
    scale                       0.25   
  }                                    
  texture                       {   
    pigment                     { 
      Gray50 transmit 0.5
    }
    normal                      {    
      spiral2           10
    }                       
    scale                       0.01
  }

#ifndef ( BCSE_TexturaBordeGaveta )
  #declare BCSE_TexturaBordeGaveta        = BCSE_DefaultTexturaBordeGaveta
#end  // #ifndef ( BCSE_TexturaBordeGaveta ) 

#declare BCSE_DefaultTexturaTiradera      = BCSE_TDEP_TexturaTiraderaLathe

#ifndef ( BCSE_TexturaTiradera )        
  #declare BCSE_TexturaTiradera           = BCSE_DefaultTexturaTiradera
#end  // #ifndef ( BCSE_TexturaTiradera )
                

#macro BCSE_Pata( AltoPata, GruesoPata )
  lathe                                 {
    #local Base                 = < GruesoPata/2, -AltoPata, GruesoPata/2 >;
    cubic_spline
    11,
    <1,-1>,
    <1, 0>,
    <0.7,0.1>,
    <1,0.2>
    <0.8,0.4>,
    <1,0.5>,
    <0.8,0.7>,
    <1,0.8>,
    <0.7,0.9>,
    <1, 1>,
    <1, 2>
    scale Base
  }
#end  // #declare BCSE_Pata

#macro BCSE_BaseCamaSinExtras( AnguloGaveta,
      FrenteCama, FrenteMesa, AlturaMesa, ProfundidadMesa,
      ExcesoBase, GruesoMedio, GruesoCuerda,
      AltoPatas, GruesoPata, AltoCama, LargoCama,
      TexturaPrincipal, TexturaGaveta, TexturaInteriorGaveta,
      TexturaBordeGaveta, TexturaPatas, TexturaPatasCama, TexturaColchon )
  union                         {  
    #local BanderaCama          = BCSE_BanderaCama; 
    #local TexturaHilo          = BCSE_TexturaHilo
    #local TexturaTiradera      = BCSE_TexturaTiradera
    #local Fondo                =
      object                    {
        BCSE_SplineObject4
        translate             -600*x-150*z
        scale                 1/<600,1,300>
        scale                 < FrenteCama+FrenteMesa, GruesoMedio/2,
                                ExcesoBase+AlturaMesa-AltoPatas >
        rotate                  90*x
        translate               -GruesoMedio/2*z
        translate               ( ExcesoBase+AlturaMesa-AltoPatas )*y
        translate               -FrenteMesa*x
      }
    object                      {
      Fondo
      texture                   {
        TexturaPrincipal
      }
    }
    // Decorado Central
    #local DecoradoCentral    =
       difference               {
        object                  {
          BCSE_SplineObject3
          translate               -150*x-75*z
        }
        object                  {
          BCSE_SplineObject2
          translate             -150*x-75*z
          scale                 <1,1.1,1>
        }
        object                  {
          BCSE_SplineObject1
          translate             -150*x-75*z
          scale                 <1,1.1,1>
        }
        object                  {
          BCSE_SplineObject0
          translate             -150*x-75*z
          scale                 <1,1.1,1>
        }
        scale                 1/<150,1,150>
        scale                 <0.2*FrenteCama,GruesoMedio/8,0.5*ExcesoBase>
        rotate                  90*x
        translate               -GruesoMedio/8*z
        translate               -GruesoMedio*z
        rotate                  150*z
      }
    union                       {
      object                    {
        DecoradoCentral
      }
      object                    {
        DecoradoCentral
        scale                   <-1,1,1>
      }
      translate                 FrenteCama/2*x-0*GruesoMedio*z
      translate                 ( AlturaMesa-AltoPatas+0.75*ExcesoBase )*y
      texture                   {
        TexturaBordeGaveta
      }
    }
    // Gaveta
    union                       {
      #local MedioMesa          =
        object                  {
          BCSE_SplineObject5
          translate             -300*x-150*z
          scale                 1/<300,1,150>
          scale                 < FrenteMesa, GruesoMedio/2, -ProfundidadMesa >
          translate               -GruesoMedio/2*y
        }
      #local SobreMesa          =
        union                   {
          object                {
            MedioMesa
          }
          object                {
            MedioMesa
            scale               <-1,1,1>
          }
        }
      object                    {
        SobreMesa
        translate               ( AlturaMesa-AltoPatas )*y
        translate               -FrenteMesa*x/2
        texture                 {
          TexturaBordeGaveta
        }
      }
      object                    {
        SobreMesa
        translate               +GruesoMedio/2*y
        scale                   <0.975,1.01,0.975>
        translate               -GruesoMedio/2*y
        translate               ( AlturaMesa-AltoPatas )*y
        translate               -FrenteMesa*x/2
      }
      object                    {
        difference              {
          object                {
            SobreMesa
          }
          plane                 {
            -z, ProfundidadMesa-2*GruesoMedio
          }
          translate             ProfundidadMesa*z
        }
        scale                   < FrenteMesa-4.5*GruesoMedio, 1, 1 >/
                                < FrenteMesa, 1, 1 >
        rotate                  -90*x
        translate               -FrenteMesa/2*x
        translate               -( ProfundidadMesa-2.2499*GruesoMedio )*z
      }
      difference                {
        box                     {
          < -FrenteMesa/2+1.25*GruesoMedio,
                                         0, 0 >,
          < +FrenteMesa/2-1.25*GruesoMedio,
          AlturaMesa-AltoPatas-GruesoMedio,
          -ProfundidadMesa+2.25*GruesoMedio >
        }
        box                     {
          < -FrenteMesa/2+2.25*GruesoMedio, 2*GruesoMedio, -GruesoMedio >,
          < +FrenteMesa/2-2.25*GruesoMedio, AlturaMesa,
            -ProfundidadMesa >
          texture               {
            TexturaInteriorGaveta
          }
        }
        translate               -FrenteMesa/2*x
      }    
      // Puerta de Gaveta   
      union                     {
        box                       {     
          GruesoMedio*y,
          < FrenteMesa-3.3*GruesoMedio, 
          AlturaMesa-AltoPatas-GruesoMedio, -GruesoMedio > 
        } 
        object                          {
          BCSE_TDEP_TiraderaLathe( TexturaTiradera )   
          translate             < 0.9*FrenteMesa-3.3*GruesoMedio, 
                                AlturaMesa/2-AltoPatas/2, -GruesoMedio >
        }
        rotate                  AnguloGaveta*y
        translate               ( -FrenteMesa+1.75*GruesoMedio )*x
                               +( -ProfundidadMesa+1.5*GruesoMedio )*z    
      }
      translate                 -GruesoMedio*z
      texture                   {
        TexturaGaveta
      }
    }
    // patas
    union                       {
      object                    {
        BCSE_Pata( AltoPatas, GruesoPata )
        translate               ( FrenteMesa/2-1.25*GruesoMedio-GruesoPata )*x
        texture                 {
          TexturaPatas
        }
      }
      object                    {
        BCSE_Pata( AltoPatas, GruesoPata )
        translate               -( FrenteMesa/2-1.25*GruesoMedio-GruesoPata )*x
        texture                 {
          TexturaPatas
        }
      }
      translate  -FrenteMesa/2*x
                 -( ProfundidadMesa-2.25*GruesoMedio-GruesoPata )*z
    }
    // Patas traseras
    union                       {
      box                       {
        <-GruesoPata/2,AlturaMesa-AltoPatas,0>,
        <+GruesoPata/2,-AltoPatas,GruesoPata/4>
        translate               -FrenteMesa/2*x
      }
      box                       {
        <-GruesoPata/2,AlturaMesa-AltoPatas,0>,
        <+GruesoPata/2,-AltoPatas,GruesoPata/4>
        translate               0.75*FrenteCama*x
      }
      texture                   {
        TexturaPatas
      }
    }
    #if ( BanderaCama )
      union                     {
        #local AltoPataCama     = AltoCama*115/220;
        #local RadioCurva       = 1.5*GruesoPata;
        #local C                = 0;
        #while ( C < 4 )
          union                {
            object              {
              BCSE_Pata( AltoPataCama, GruesoPata )
              translate           ( FrenteCama/2-GruesoPata )*x
              translate           ( LargoCama/2-GruesoPata )*z
              translate           AltoPataCama*y
            }
            #if ( BCSE_BanderaHilo )
            union               {
            cylinder            {
              0, ( LargoCama/2-RadioCurva )*z, GruesoCuerda/2
              translate         ( FrenteCama/2-GruesoCuerda/2 )*x
              translate         (AltoCama-GruesoCuerda/2 )*y
            }
            difference          {
              torus               {
                RadioCurva, GruesoCuerda/2
              }
              plane { x, 0 }
              plane { z, 0 }
              translate         <FrenteCama/2-RadioCurva,AltoCama,
                                        LargoCama/2-RadioCurva>-GruesoCuerda/2
            }
            cylinder            {
              0, ( FrenteCama/2-RadioCurva )*x, GruesoCuerda/2
              translate         ( LargoCama/2-GruesoCuerda/2 )*z
              translate         (AltoCama-GruesoCuerda/2 )*y
            }
              scale             0.99
              texture           {
                TexturaHilo
              }
            }
            #end  // #if ( BanderaHilo )
            #switch( C )
              #case ( 0 )
                scale           <+1,+1,+1>
              #break  // #case ( 0 )
              #case ( 1 )
                scale           <+1,+1,-1>
              #break  // #case ( 1 )
              #case ( 2 )
                scale           <-1,+1,+1>
              #break  // #case ( 2 )
              #case ( 3 )
                scale           <-1,+1,-1>
              #break  // #case ( 3 )
            #end  // #switch( C )
            texture             {
              TexturaPatasCama
            }
          }
          #local C              = C+1;
        #end  // #while ( C < 4 )
        superellipsoid          {
          <0.1,0.1>
          scale         < FrenteCama/2,( AltoCama-AltoPataCama)/2, LargoCama/2 >
          translate     ( AltoCama/2+AltoPataCama/2 )*y
          texture               {
            TexturaColchon
          }
        }
        translate               FrenteCama/2*x
        translate               -( LargoCama/2-GruesoMedio )*z
        translate               -AltoPatas*y
      }
    #end  // #if ( BanderaCama )
    translate                   -GruesoPata/4*x
    translate                   AltoPatas*y    
    translate                   -GruesoMedio*z
  }
#end  // #macro BCSE_BaseCamaSinExtras()

#macro BCSE_BaseCama( AnguloGaveta)
  union                         {
    #local L                    = BCSE_L;
    #local FrenteCama           = 765*L;
    #local AltoCama             = 220*L;
    #local LargoCama            = 1325*L;
    #local FrenteMesa           = 308*L;
    #local AlturaMesa           = 390*L;
    #local ProfundidadMesa      = 240*L;
    #local ExcesoBase           = 200*L;
    #local GruesoMedio          =  12*L;
    #local GruesoCuerda         =   2*L;
    #local AltoPatas            = 230*L;
    #local GruesoPata           =  50*L;
    BCSE_BaseCamaSinExtras( AnguloGaveta,
      FrenteCama, FrenteMesa, AlturaMesa, ProfundidadMesa,
      ExcesoBase, GruesoMedio, GruesoCuerda,
      AltoPatas, GruesoPata, AltoCama, LargoCama,
      BCSE_TexturaPrincipal, BCSE_TexturaGaveta, BCSE_TexturaInteriorGaveta,
      BCSE_TexturaBordeGaveta, BCSE_TexturaPatas, 
      BCSE_TexturaPatasCama, BCSE_TexturaColchon )
  }
#end  // #macro BCSE_BaseCama()
