// This file is licensed under the terms of the CC-LGPL.

#macro SBCC_AuxiliarBezier( PuntoA, PuntoB, ArregloBezier, I ) 
  #local Origen         = < PuntoA.x, PuntoA.y >;
  #local Final          = < PuntoB.x, PuntoB.y >;
  #local Recorre        = Final-Origen;
  #if ( I > 0 )        
    #local ArregloBezier[ I-1 ]         = Origen+vdot( PuntoA, z )*Recorre/3;
  #end  // #if ( I < 0 )
  #local ArregloBezier[ I ]             = Origen+Recorre*vdot( PuntoA, z )/3;
  #local ArregloBezier[ I+1 ]           = ( Origen+Final )/2;
  #local ArregloBezier[ I+2 ]           = ArregloBezier[ I+1 ];
  #local ArregloBezier[ I+3 ]           = Final-vdot( PuntoB, z )*Recorre/3;
  #local ArregloBezier[ I+4 ]           = ArregloBezier[ I+3 ];
  #local ArregloBezier[ I+5 ]           = Final;
  #local ArregloBezier[ I+6 ]           = Final; 
#end  // #macro SBCC_AuxiliarBezier     

#macro SBCC_AuxiliarBezierMedio( PuntoA, PuntoB, ArregloBezier, I ) 
  #if ( I > 0 )        
    #local ArregloBezier[ I-1 ]         = ( PuntoA+PuntoB )/2;
  #end  // #if ( I < 0 )
  #local ArregloBezier[ I ]             = ( PuntoA+PuntoB )/2;
  #local ArregloBezier[ I+1 ]           = PuntoB;
  #local ArregloBezier[ I+2 ]           = PuntoB;
#end  // #macro SBCC_AuxiliarBezierMedio

#macro SBCC_RellenarArregloBezier( ArregloPrevio, ArregloBezier )
  #local TotalPuntos                    = dimension_size( ArregloPrevio, 1 );
  #local C                              = 0;
  #while ( C < TotalPuntos )        
    #local PuntoA                       = ArregloPrevio[ C ];
    #if ( C = ( TotalPuntos-1 ) )         
      #local PuntoB                     = ArregloPrevio[ 0 ];
    #else  // #else ( C = ( TotalPuntos-1 ) )                
      #local PuntoB                     = ArregloPrevio[ C+1 ];
    #end   // #else ( C = ( TotalPuntos-1 ) )              
    SBCC_AuxiliarBezier( PuntoA, PuntoB, ArregloBezier, 8*C )
    #local C                            = C+1;
  #end  // #while ( C < TotalPuntos )                       
  #local ArregloBezier[ 8*C-1 ]         = ArregloBezier[ 0 ];
#end  // #macro SBCC_RellenarArregloBezier         

#macro SBCC_RellenarArregloBezierMedio( ArregloPrevio, ArregloBezier )
  #local TotalPuntos                    = dimension_size( ArregloPrevio, 1 );
  #local C                              = 0;
  #while ( C < TotalPuntos )        
    #local PuntoA                       = ArregloPrevio[ C ];
    #if ( C = ( TotalPuntos-1 ) )         
      #local PuntoB                     = ArregloPrevio[ 0 ];
    #else  // #else ( C = ( TotalPuntos-1 ) )                
      #local PuntoB                     = ArregloPrevio[ C+1 ];
    #end   // #else ( C = ( TotalPuntos-1 ) )              
    SBCC_AuxiliarBezierMedio( PuntoA, PuntoB, ArregloBezier, 4*C )
    #local C                            = C+1;
  #end  // #while ( C < TotalPuntos )                       
  #local ArregloBezier[ 4*C-1 ]         = ArregloBezier[ 0 ];
#end  // #macro SBCC_RellenarArregloBezierMedio 

#macro SBCC_PrismaBezier( ArregloPrevio, BanderaSweep, Y0, Y1 ) 
  prism                                 {    
    #local TotalPuntos                  = dimension_size( ArregloPrevio, 1 ); 
    #local TotalBezier                  = 8*TotalPuntos; 
    #declare SBCC_ArregloBezier         = array [ TotalBezier ]
    SBCC_RellenarArregloBezier( ArregloPrevio, SBCC_ArregloBezier )
    #if ( BanderaSweep )   
      conic_sweep
    #else  // #else ( BanderaSweep )
      linear_sweep
    #end   // #else ( BanderaSweep ) 
    bezier_spline 
    Y0, Y1, TotalBezier,
    #local C                            = 0;
    #while ( C < TotalBezier )        
      SBCC_ArregloBezier[ C ]
      #local C                          = C+1;
    #end  // #while ( C < TotalBezier )   
  }  // prism
#end  // #macro SBCC_PrismaBezier   

#macro SBCC_PrismaBezierMedio( ArregloPrevio, BanderaSweep, Y0, Y1 ) 
  prism                                 {    
    #local TotalPuntos                  = dimension_size( ArregloPrevio, 1 ); 
    #local TotalBezier                  = 4*TotalPuntos; 
    #declare SBCC_ArregloBezier         = array [ TotalBezier ]
    SBCC_RellenarArregloBezierMedio( ArregloPrevio, SBCC_ArregloBezier )
    #if ( BanderaSweep )   
      conic_sweep
    #else  // #else ( BanderaSweep )
      linear_sweep
    #end   // #else ( BanderaSweep ) 
    bezier_spline 
    Y0, Y1, TotalBezier,
    #local C                            = 0;
    #while ( C < TotalBezier )        
      SBCC_ArregloBezier[ C ]
      #local C                          = C+1;
    #end  // #while ( C < TotalBezier )   
  }  // prism
#end  // #macro SBCC_PrismaBezierMedio