// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho... 17 febrero 2015
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// SBCC SelladorBolsasCalorCaliente
// El archivo dibuja un sellador de bolsas plasticas
// con impulso de calor.
// Ofrece una macro para cambiar algunas caracteristicas.   
// Lamentablemente no es compatible con POVRay 3.1.
//
// La macro principal tiene dos parametros
// #macro SBCC_SelladorBolsas( FraccionAbrir, FraccionEmpuje )
//      FraccionAbrir           : Fraccion entre 0.0 (cerrado) y 1.0 (abierto)
//              para abrir la boca del sellador.
//      FraccionEmpuje          : Fraccion entre 0.0 (bajo) y 1.0 (alto)
//              para levantar el hule superior del sellador.
//              Cuando se sellan bolsas el hule superior
//              es empujado hacia arriba por el grosor de las mismas.
//
// La siguiente versin de la macro, permite un mayor control 
// de las caracteristicas.
// #macro SBCC_SelladorBolsasCalorCaliente( FraccionAbrir, FraccionEmpuje,
//                LargoFundamental, AnchoFundamental, AltoFundamental, 
//                LargoSoporte, AnchoSoporte, AltoSoporte, CizallaSoporte,  
//                DiametroTornillo, TexturaPrincipal, TexturaMetal, 
//                TexturaMetalBase, TexturaBlanda, TexturaPlastico, 
//                TexturaEscala, TexturaPlaca )
//      FraccionAbrir           : Fraccion entre 0.0 (cerrado) y 1.0 (abierto)
//              para abrir la boca del sellador.
//      FraccionEmpuje          : Fraccion entre 0.0 (bajo) y 1.0 (alto)
//              para levantar el hule superior del sellador.
//              Cuando se sellan bolsas el hule superior
//              es empujado hacia arriba por el grosor de las mismas.
//      LargoFundamental        : Referencia para el largo frontal 
//              en X del sellador. Valor por defecto es 282*L.
//      AnchoFundamental        : Referencia para el ancho Z del sellador.
//              Valor por defecto es 50*L.
//      AltoFundamental         : Referencia para el alto Y del sellador.
//              Valor por defecto es 41*L.
//      LargoSoporte            : Referencia para el largo frontal
//              en X del soporte de la boca del sellador.
//              Valor por defecto es 35*L.           
//      AnchoSoporte            : Referencia para el ancho Z
//              del soporte de la boca del sellador.
//              Valor por defecto es 28*L.           
//      AltoSoporte             : Referencia para el alto Y
//              del soporte de la boca del sellador.
//              Valor por defecto es 18*L.     
//      CizallaSoporte          : Fraccion de cizalla para 
//              inclinar los soportes laterales.     
//              Valor por defecto es 0.2.
//      DiametroTornillo        : Diametro para dibujar los tornillos.
//              Valor por defecto es 5*L.
//      TexturaPrincipal        : Textura principal de la estructura.
//              Valor por defecto SBCC_TexturaPrincipal.
//      TexturaMetal            : Textura para zonas metalicas.
//              Valor por defecto SBCC_TexturaMetal.
//      TexturaMetalBase        : Textura para base caliente de metal.
//              Valor por defecto SBCC_TexturaMetalBase.
//      TexturaBlanda           : Textura para banda de hule.
//              Valor por defecto SBCC_TexturaBlanda.
//      TexturaPlastico         : Textura de accesorios en plastico.
//              Valor por defecto SBCC_TexturaPlastico.
//      TexturaEscala           : Textura para la escala de control.
//              Valor por defecto SBCC_TexturaEscala.
//      TexturaPlaca            : Textura para la placa de presentacion.
//              Valor por defecto sBCC_TexturaPlaca.
//
// El aparato por defecto tiene las siguientes dimensiones: 
//      Alto (abierto)                  =  208*L
//      Alto (cerrado)                  =  100*L
//      Largo X                         = -157*L..150*L
//      Ancho Z                         = - 30*L.. 30*L
// La base del aparato se encuentra casi centrado sobre el origen
// del plano XZ. Gravedad Y-, la boca abre hacia X-.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.
// #declare SBCC_DefaultTexturaPrincipal        
//      Textura principal de la estructura.
// #declare SBCC_DefaultTexturaMetal            
//      Textura para zonas metalicas.
// #declare SBCC_DefaultTexturaMetalBase        
//      Textura para base caliente de metal.
// #declare SBCC_DefaultTexturaBlanda           
//      Textura para banda de hule.
// #declare SBCC_DefaultTexturaPlastico         
//      Textura de accesorios en plastico.
// #declare SBCC_DefaultTexturaEscala           
//      Textura para la escala de control.
// #declare SBCC_DefaultTexturaPlaca            
//      Textura para la placa de presentacion.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default) 
// #declare SBCC_TexturaPrincipal               = texture  { ... }        
//      Textura principal de la estructura.
// #declare SBCC_TexturaMetal                   = texture  { ... }
//      Textura para zonas metalicas.
// #declare SBCC_TexturaMetalBase               = texture  { ... }
//      Textura para base caliente de metal.
// #declare SBCC_TexturaBlanda                  = texture  { ... }
//      Textura para banda de hule.
// #declare SBCC_TexturaPlastico                = texture  { ... }
//      Textura de accesorios en plastico.
// #declare SBCC_TexturaEscala                  = texture  { ... } 
//      Textura para la escala de control.
// #declare SBCC_TexturaPlaca                   = texture  { ... } 
//      Textura para la placa de presentacion.
//
// Para colocarlo simplemente
// #include "SBCC.inc"
// object        { SBCC_SelladorBolsas(1,0) }
//
// Otro ejemplo con la macro detallada:
// #include "SBCC.inc"   
// object                       { 
//   SBCC_SelladorBolsasCalorCaliente( 1, 0, 
//        0.282, 0.050, 0.041, 0.035, 0.028, 0.018, 0.2, 0.005,
//        SBCC_TexturaPrincipal, SBCC_TexturaMetal, 
//        SBCC_TexturaMetalBase, SBCC_TexturaBlanda, 
//        SBCC_TexturaPlastico, SBCC_TexturaEscala, SBCC_TexturaPlaca )
// }                   
//
// O bien con modificadores:
// #include "SBCC.inc"                         
// #include "textures.inc" 
// #declare SBCC_TexturaPrincipal               = PinkAlabaster
// object        { SBCC_SelladorBolsas(1,0) }
//
#include "colors.inc"

#declare EjeMejorado            = true;
#declare OjoAbsoluto            = 256;
#declare VecesCentroAbsoluto    = 10;     
#declare L                      = 0.001;
camera {
        location  <   0,  0, -( VecesCentroAbsoluto+1 )*OjoAbsoluto >*L
        direction z
        sky       y
        angle     38.74
//        look_at  <   0,  0, -VecesCentroAbsoluto*OjoAbsoluto >*L
}         
light_source    {
         < 500  , 500   , -3000 >*L
         White
}
background      {
         Gray50
}    

#include "SBCC.inc"
                              
#local FactorAcercamiento               = 6;                              

object                          { 
  SBCC_SelladorBolsas( 1.0, 0.0 )   
  translate             -0.1*y      
  translate       -( VecesCentroAbsoluto+1 )*( FactorAcercamiento-1 )
                        /( FactorAcercamiento )*OjoAbsoluto*L*z
} 
