// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho... 17 febrero 2015
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// SBCC SelladorBolsasCalorCaliente
// El archivo dibuja un sellador de bolsas plasticas
// con impulso de calor.
// Ofrece una macro para cambiar algunas caracteristicas.   
// Lamentablemente no es compatible con POVRay 3.1.
//
// La macro principal tiene dos parametros
// #macro SBCC_SelladorBolsas( FraccionAbrir, FraccionEmpuje )
//      FraccionAbrir           : Fraccion entre 0.0 (cerrado) y 1.0 (abierto)
//              para abrir la boca del sellador.
//      FraccionEmpuje          : Fraccion entre 0.0 (bajo) y 1.0 (alto)
//              para levantar el hule superior del sellador.
//              Cuando se sellan bolsas el hule superior
//              es empujado hacia arriba por el grosor de las mismas.
//
// La siguiente versin de la macro, permite un mayor control 
// de las caracteristicas.
// #macro SBCC_SelladorBolsasCalorCaliente( FraccionAbrir, FraccionEmpuje,
//                LargoFundamental, AnchoFundamental, AltoFundamental, 
//                LargoSoporte, AnchoSoporte, AltoSoporte, CizallaSoporte,  
//                DiametroTornillo, TexturaPrincipal, TexturaMetal, 
//                TexturaMetalBase, TexturaBlanda, TexturaPlastico, 
//                TexturaEscala, TexturaPlaca )
//      FraccionAbrir           : Fraccion entre 0.0 (cerrado) y 1.0 (abierto)
//              para abrir la boca del sellador.
//      FraccionEmpuje          : Fraccion entre 0.0 (bajo) y 1.0 (alto)
//              para levantar el hule superior del sellador.
//              Cuando se sellan bolsas el hule superior
//              es empujado hacia arriba por el grosor de las mismas.
//      LargoFundamental        : Referencia para el largo frontal 
//              en X del sellador. Valor por defecto es 282*L.
//      AnchoFundamental        : Referencia para el ancho Z del sellador.
//              Valor por defecto es 50*L.
//      AltoFundamental         : Referencia para el alto Y del sellador.
//              Valor por defecto es 41*L.
//      LargoSoporte            : Referencia para el largo frontal
//              en X del soporte de la boca del sellador.
//              Valor por defecto es 35*L.           
//      AnchoSoporte            : Referencia para el ancho Z
//              del soporte de la boca del sellador.
//              Valor por defecto es 28*L.           
//      AltoSoporte             : Referencia para el alto Y
//              del soporte de la boca del sellador.
//              Valor por defecto es 18*L.     
//      CizallaSoporte          : Fraccion de cizalla para 
//              inclinar los soportes laterales.     
//              Valor por defecto es 0.2.
//      DiametroTornillo        : Diametro para dibujar los tornillos.
//              Valor por defecto es 5*L.
//      TexturaPrincipal        : Textura principal de la estructura.
//              Valor por defecto SBCC_TexturaPrincipal.
//      TexturaMetal            : Textura para zonas metalicas.
//              Valor por defecto SBCC_TexturaMetal.
//      TexturaMetalBase        : Textura para base caliente de metal.
//              Valor por defecto SBCC_TexturaMetalBase.
//      TexturaBlanda           : Textura para banda de hule.
//              Valor por defecto SBCC_TexturaBlanda.
//      TexturaPlastico         : Textura de accesorios en plastico.
//              Valor por defecto SBCC_TexturaPlastico.
//      TexturaEscala           : Textura para la escala de control.
//              Valor por defecto SBCC_TexturaEscala.
//      TexturaPlaca            : Textura para la placa de presentacion.
//              Valor por defecto sBCC_TexturaPlaca.
//
// El aparato por defecto tiene las siguientes dimensiones: 
//      Alto (abierto)                  =  208*L
//      Alto (cerrado)                  =  100*L
//      Largo X                         = -157*L..150*L
//      Ancho Z                         = - 30*L.. 30*L
// La base del aparato se encuentra casi centrado sobre el origen
// del plano XZ. Gravedad Y-, la boca abre hacia X-.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.
// #declare SBCC_DefaultTexturaPrincipal        
//      Textura principal de la estructura.
// #declare SBCC_DefaultTexturaMetal            
//      Textura para zonas metalicas.
// #declare SBCC_DefaultTexturaMetalBase        
//      Textura para base caliente de metal.
// #declare SBCC_DefaultTexturaBlanda           
//      Textura para banda de hule.
// #declare SBCC_DefaultTexturaPlastico         
//      Textura de accesorios en plastico.
// #declare SBCC_DefaultTexturaEscala           
//      Textura para la escala de control.
// #declare SBCC_DefaultTexturaPlaca            
//      Textura para la placa de presentacion.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default) 
// #declare SBCC_TexturaPrincipal               = texture  { ... }        
//      Textura principal de la estructura.
// #declare SBCC_TexturaMetal                   = texture  { ... }
//      Textura para zonas metalicas.
// #declare SBCC_TexturaMetalBase               = texture  { ... }
//      Textura para base caliente de metal.
// #declare SBCC_TexturaBlanda                  = texture  { ... }
//      Textura para banda de hule.
// #declare SBCC_TexturaPlastico                = texture  { ... }
//      Textura de accesorios en plastico.
// #declare SBCC_TexturaEscala                  = texture  { ... } 
//      Textura para la escala de control.
// #declare SBCC_TexturaPlaca                   = texture  { ... } 
//      Textura para la placa de presentacion.
//
// Para colocarlo simplemente
// #include "SBCC.inc"
// object        { SBCC_SelladorBolsas(1,0) }
//
// Otro ejemplo con la macro detallada:
// #include "SBCC.inc"   
// object                       { 
//   SBCC_SelladorBolsasCalorCaliente( 1, 0, 
//        0.282, 0.050, 0.041, 0.035, 0.028, 0.018, 0.2, 0.005,
//        SBCC_TexturaPrincipal, SBCC_TexturaMetal, 
//        SBCC_TexturaMetalBase, SBCC_TexturaBlanda, 
//        SBCC_TexturaPlastico, SBCC_TexturaEscala, SBCC_TexturaPlaca )
// }                   
//
// O bien con modificadores:
// #include "SBCC.inc"                         
// #include "textures.inc" 
// #declare SBCC_TexturaPrincipal               = PinkAlabaster
// object        { SBCC_SelladorBolsas(1,0) }
//

#include "SBCC_AU1.inc"                                                     
#include "colors.inc"
#include "textures.inc"

#declare SBCC_L                 = 0.001;

#if ( version < 3.2 )
  #ifndef( SBCC_POV3_1 )
    #declare SBCC_POV3_1        = on;
  #end
#else
  #ifndef( SBCC_POV3_1 )
    #declare SBCC_POV3_1        = off;
  #end
#end

#declare SBCC_DefaultTexturaPrincipal           =
  texture                               { 
    pigment { Cyan }
    normal      {   
      granite
    }
  }

#ifndef ( SBCC_TexturaPrincipal )
  #declare SBCC_TexturaPrincipal                = SBCC_DefaultTexturaPrincipal
#end // #ifndef ( SBCC_TexturaPrincipal )

#declare SBCC_DefaultTexturaMetal               =
  texture                               { 
    pigment { Silver }
    normal      {   
      agate
    }
  }

#ifndef ( SBCC_TexturaMetal )
  #declare SBCC_TexturaMetal                    = SBCC_DefaultTexturaMetal
#end // #ifndef ( SBCC_TexturaMetal )
 
#declare SBCC_DefaultTexturaMetalBase           =
  texture                               { 
    pigment                             {
      #if ( SBCC_POV3_1 )
        bumps
      #else  // #if ( SBCC_POV3_1 )
        cells
        turbulence      1
        scale           0.1
      #end   // #if ( SBCC_POV3_1 )
      pigment_map                       { 
        [ 0.0 Silver ]
        [ 1.0 Blue*0.5+Gray30   ]
      }
    }
    normal      {   
      agate
    }
  }

#ifndef ( SBCC_TexturaMetalBase )
  #declare SBCC_TexturaMetalBase                = SBCC_DefaultTexturaMetalBase
#end // #ifndef ( SBCC_TexturaMetalBase )
 
#declare SBCC_DefaultTexturaBlanda              =
  texture                               { 
    Cork
  }
  texture                               {
    pigment { White transmit 0.5 }
    normal      {   
      agate
    }
  }

#ifndef ( SBCC_TexturaBlanda )
  #declare SBCC_TexturaBlanda                   = SBCC_DefaultTexturaBlanda
#end // #ifndef ( SBCC_TexturaBlanda )

#declare SBCC_DefaultTexturaPlastico            =
  texture                               { 
    Cork
  }
  texture                               {
    pigment { Black transmit 0.125 }
    normal      {   
      agate
    }
  }

#ifndef ( SBCC_TexturaPlastico )
  #declare SBCC_TexturaPlastico                 = SBCC_DefaultTexturaPlastico
#end // #ifndef ( SBCC_TexturaPlastico )
 
#declare SBCC_DefaultTexturaEscala              =                          
  texture                               { 
    pigment                             {
      image_map                         {
        gif "SBCC_IM1.gif"
      }                
      translate                 -0.5-0.3*y
    }    
  }

#ifndef ( SBCC_TexturaEscala )
  #declare SBCC_TexturaEscala                   = SBCC_DefaultTexturaEscala
#end // #ifndef ( SBCC_TexturaEscala )
 
#declare SBCC_DefaultTexturaPlaca               =
  texture                               { 
    pigment             { 
      image_map         {  
        gif "SBCC_IM2.gif"
      }
      translate                 -0.5 
    }
    normal      {   
      agate     
      scale     0.01
    }
  }

#ifndef ( SBCC_TexturaPlaca )
  #declare SBCC_TexturaPlaca                    = SBCC_DefaultTexturaPlaca
#end // #ifndef ( SBCC_TexturaPlaca )
 
                                
                                  
#macro SBCC_SelladorBolsasCalorCaliente( FraccionAbrir, FraccionEmpuje,
                LargoFundamental, AnchoFundamental, AltoFundamental, 
                LargoSoporte, AnchoSoporte, AltoSoporte, CizallaSoporte,  
                DiametroTornillo,
                TexturaPrincipal, TexturaMetal, TexturaMetalBase,
                TexturaBlanda, TexturaPlastico, TexturaEscala, TexturaPlaca )       
  union                         {    
    #local AnguloMaximoApertura = 26;                            
    #local FraccionBase         = 291/282;  
    #local CizallaBase          = 
        0.5*( FraccionBase-1 )*LargoFundamental/AltoFundamental;                                  
    #local FraccionSoporte      = AnchoSoporte/AnchoFundamental;   
    #local AnchoSellador        = 20*AnchoSoporte/28;
    #local LargoSellador        = 232*LargoFundamental/282;
    #local AltoSellador         = 23*LargoSoporte/35;
    #local AltoCaliente         = 10*LargoSoporte/35;
    #local AltoGiro             = 14*LargoSoporte/35;
    #local PosXGiro             = 14*LargoSoporte/35;
    #local ArregloCentral       = array [ 4 ]
        { <-1/2,-1/2,0.25>,  
          <+1/2,-1/2,0.25>, 
          <+1/2,+1/2,0.25>, 
          <-1/2,+1/2,0.25> }        
    #local ArregloTriangularMedio       = array [ 3 ] 
       { <-1/2, 0, 0.25 >, <0, 1, 1.25 >, <+1/2, 0, 0.25 > }
              
    union                       {
      object                    { 
        SBCC_PrismaBezier( ArregloCentral, true, 1, FraccionBase ) 
        translate               -y
        scale                   < LargoFundamental, 
                -AltoFundamental/( FraccionBase-1 ), AnchoFundamental > 
        matrix                  < 1, 0, 0, 
                                  0, 1, 0.070, 
                                  0, 0, 1,
                                  0, 0, 0 >        
      }                          
      object                    { 
        SBCC_PrismaBezier( ArregloCentral, true, 1, FraccionBase ) 
        translate               -y
        scale                   < LargoFundamental, 
                -AltoFundamental/( FraccionBase-1 ), AnchoFundamental > 
        matrix                  < 1, 0, 0, 
                                  0, 1,-0.070, 
                                  0, 0, 1,
                                  0, 0, 0 >        
      }  
      object                    {
        SBCC_PrismaBezier( ArregloCentral, false, 0, AltoFundamental/10 ) 
        scale                   < LargoFundamental*FraccionBase, 
                  1.0, AnchoFundamental*1.17 >*1.01
        translate               -AltoFundamental*y 
      } 
      object                    { 
        SBCC_PrismaBezier( ArregloCentral, true, 1, FraccionSoporte )
        translate               -y
        scale                   < LargoSoporte, 
                       -AltoSoporte/( 1-FraccionSoporte ), AnchoFundamental > 
        matrix                  < 1, 0, 0,
                                  -CizallaSoporte, 1, 0,
                                  0, 0, 1,
                                  0, 0, 0 >  
        translate               ( LargoFundamental/2-LargoSoporte/2 )*x                          
      }                       
      object                    { 
        SBCC_PrismaBezier( ArregloCentral, true, 1, FraccionSoporte )
        translate               -y
        scale                   < 0.8*LargoSoporte, 
                       -AltoSoporte/( 1-FraccionSoporte ), AnchoFundamental > 
        matrix                  < 1, 0, 0,
                                  -CizallaSoporte, 1, 0,
                                  0, 0, 1,
                                  0, 0, 0 >  
        translate               -( LargoFundamental/2-0.8*LargoSoporte/2 )*x                          
      }    
      object                    {
        SBCC_PrismaBezier( ArregloTriangularMedio, false, -0.5, 0.5 ) 
        rotate                  -90*x         
        rotate                  90*y 
        scale                   < LargoFundamental-LargoSoporte,
                                  AltoSoporte, AnchoFundamental >
      }                                                            
      difference                {
        object                    {
          SBCC_PrismaBezier( ArregloTriangularMedio, false, -0.5, 0.5 ) 
          rotate                  -90*x         
          rotate                  90*y 
          scale                   < LargoFundamental-2*LargoSoporte,
                                  AltoSoporte, AnchoFundamental >
        } 
        box                     {   
          <-LargoFundamental,0,-AnchoFundamental>,
          <+LargoFundamental,0.25*AltoSoporte,+AnchoFundamental>
        }                                    
        translate               0.05*AltoSoporte*y
        texture                 {
          TexturaMetalBase
        }                       
      }  
      cylinder                          {  
        ( -LargoFundamental/2+LargoSoporte )*x,
        ( +LargoFundamental/2-LargoSoporte )*x, DiametroTornillo/2 
        translate               ( AltoSoporte-DiametroTornillo/2 )*y
        texture                 {
          TexturaBlanda
        }
      }
      texture                   { 
        TexturaPrincipal
      }
    }
    // PivotePlastico
    union                       {  
      cylinder                  {  
        0, AltoCaliente*0.90*y, AnchoSoporte/4
      }
      box                       { 
        <0,0,-AnchoSoporte/4>,
        <0.8*3*AnchoSoporte/4,0.9*AltoCaliente,+AnchoSoporte/4>
      } 
      translate                 AltoSoporte*y
      translate                 -( LargoFundamental/2-AnchoSoporte/4 )*x 
      texture                   {
        TexturaPlastico
      }
    } 
    // Eje Soporte
    union                       {
      union                     {
        cylinder                  {
          -0.925*AnchoSoporte/2*z, -0.9*AnchoSoporte/2*z, 0.5*PosXGiro
        }
        box                       {  
          < -PosXGiro/2, 0, -0.925*AnchoSoporte/2 >,
          < +PosXGiro/2,-AltoSoporte-2*AltoGiro, -0.9*AnchoSoporte/2 >
        } 
        box                       {  
          < -PosXGiro/2, 0, -0.925*AnchoSoporte/2 >,
          < +PosXGiro/2,-AltoSoporte-2*AltoGiro, -0.9*AnchoSoporte/2 >  
          rotate                15*z
        } 
      }
      union                     {
        cylinder                  {
          -0.925*AnchoSoporte/2*z, -0.9*AnchoSoporte/2*z, 0.5*PosXGiro
        }
        box                       {  
          < -PosXGiro/2, 0, -0.925*AnchoSoporte/2 >,
          < +PosXGiro/2,-AltoSoporte-2*AltoGiro, -0.9*AnchoSoporte/2 >
        } 
        box                       {  
          < -PosXGiro/2, 0, -0.925*AnchoSoporte/2 >,
          < +PosXGiro/2,-AltoSoporte-2*AltoGiro, -0.9*AnchoSoporte/2 >
          rotate                  15*z
        } 
        scale                   <1,1,-1> 
      }
      translate             ( -LargoFundamental/2+PosXGiro )*x
                                +( AltoSoporte+AltoGiro )*y
      scale             <-1,1,1>
      translate         -PosXGiro/2*x                            
      texture                   {
        TexturaPrincipal
      }
    }                  
    // Brazo Superior
    union                       {
      union                     { 
        cylinder                { 
          -AnchoSoporte*z/2, AnchoSoporte*z/2, DiametroTornillo/2
          texture               {
            TexturaMetal
          }            
        }
        translate             ( -LargoFundamental/2+PosXGiro )*x
                                +( AltoSoporte+AltoGiro )*y  
      }  
      difference                { 
        intersection            {           
          union                 {       
            box                 {
              < -0.9*PosXGiro, -AltoGiro, -AnchoSellador/2 >
              < LargoSellador, AltoSellador+AltoCaliente-AltoGiro, +AnchoSellador/2 >  
            } 
            cylinder            {     
              -AltoGiro*y, ( AltoSellador+AltoCaliente-AltoGiro )*y, AnchoSellador/2
              translate         LargoSellador*x
            }
          }  
          object                {        
            #local ArregloSellador      = array [ 6 ]
              { < -0.8*PosXGiro, 0, 1 >,           
                < 0, AltoCaliente+0.9*AltoSellador-AltoGiro, 1 >,
                < 0.5*LargoSellador, AltoCaliente+AltoSellador-AltoGiro, 1 >,
                <  LargoSellador+AnchoSellador/2, AltoCaliente+0.9*AltoSellador-AltoGiro, 0.1 >,
                <  LargoSellador+AnchoSellador/2, -AltoGiro, 0.1 >,
                < -PosXGiro, -AltoGiro, 0.1 > }
            SBCC_PrismaBezier( ArregloSellador, false,
                -AnchoSellador, +AnchoSellador ) 
            rotate                      -90*x       
          }                   
          translate             ( -LargoFundamental/2+PosXGiro )*x
          translate             AltoGiro*y
        }
        box                     {
          <-LargoFundamental/2+PosXGiro,-AltoCaliente,-AnchoFundamental/2>
          <+LargoFundamental/2,AltoCaliente,+AnchoFundamental/2>
        }
        translate               AltoSoporte*y
      }
      union                     {
        box                       {
          <-LargoFundamental/2+LargoSoporte,AltoSoporte+0.2*AltoCaliente,
                        -0.0125*AnchoSellador >, 
          <+LargoFundamental/2-LargoSoporte,AltoSoporte+2*AltoCaliente,
                        +0.0125*AnchoSellador > 
        }
        box                       {
          <-LargoFundamental/2+LargoSoporte,AltoSoporte+0.2*AltoCaliente,
                        -0.1*AnchoSellador >, 
          <+LargoFundamental/2-LargoSoporte,AltoSoporte+0.5*AltoCaliente,
                        +0.1*AnchoSellador > 
        }
        box                       {
          <-LargoFundamental/2+LargoSoporte,AltoSoporte+0.0*AltoCaliente,
                        -0.07*AnchoSellador >, 
          <+LargoFundamental/2-LargoSoporte,AltoSoporte+0.3*AltoCaliente,
                        +0.07*AnchoSellador >  
          texture                       { 
            TexturaBlanda
          }
        }
        box                       {
          <-LargoFundamental/2+LargoSoporte,AltoSoporte+0.0*AltoCaliente,
                        -0.125*AnchoSellador >, 
          <+LargoFundamental/2-LargoSoporte,AltoSoporte+0.1*AltoCaliente,
                        +0.125*AnchoSellador >  
          texture                       { 
            TexturaBlanda
          }
        }
        translate               +FraccionEmpuje*AltoCaliente/2*y                
        texture                 {
            TexturaMetal
        }
      }
      union                   {                                                       
        cylinder              {
              ( 1.2*AltoSellador+AltoCaliente-AltoGiro )*y, ( 0.65*AltoSellador+AltoCaliente-AltoGiro )*y,
              1.25*AnchoSellador/2               
              translate         LargoSellador*x
        }         
        box                     {              
          <0,0.65*AltoSellador+AltoCaliente-AltoGiro,1.25*AnchoSellador/2>,
          <-0.15*LargoSellador,1.2*AltoSellador+AltoCaliente-AltoGiro,-1.25*AnchoSellador/2>
          translate             LargoSellador*x 
        }                      
        cylinder              {
              ( 1.2*AltoSellador+AltoCaliente-AltoGiro )*y, ( 1.10*AltoSellador+AltoCaliente-AltoGiro )*y,
              2.0*AnchoSellador/2               
              translate         LargoSellador*x
        }         
        box                     {              
          <0,1.10*AltoSellador+AltoCaliente-AltoGiro,2.0*AnchoSellador/2>,
          <-0.15*LargoSellador,1.2*AltoSellador+AltoCaliente-AltoGiro,-2.0*AnchoSellador/2>
          translate             LargoSellador*x 
        }                      
        translate               ( AltoSoporte+AltoGiro )*y 
                        +( -LargoFundamental/2+PosXGiro )*x
        texture               {
            TexturaPlastico
        }                    
      }
      texture                   {
        TexturaPrincipal
      }
      translate            -( -LargoFundamental/2+PosXGiro )*x
                                -( AltoSoporte+AltoGiro )*y
      rotate                    FraccionAbrir*AnguloMaximoApertura*z  
      translate             ( -LargoFundamental/2+PosXGiro )*x
                                +( AltoSoporte+AltoGiro )*y 
      scale                     <-1,1,1> 
      translate         -PosXGiro/2*x                            
    }  // BrazoSuperior 
    // Accesorios
    union                       {
      // Control de impulso
      union                     {
        #local ArregloImpulso   = array [ 6 ]
                { <-3*AnchoFundamental/8,0,0.2>,
                  <-AnchoSoporte/4,3*AltoSoporte/4,0.2>,
                  <+AnchoSoporte/4,3*AltoSoporte/4,0.2>,
                  <+3*AnchoFundamental/8,0,0.2>,
                  <+3*AnchoFundamental/8,-0.75*AltoFundamental,0.2>,
                  <-3*AnchoFundamental/8,-0.75*AltoFundamental,0.2> }
        #local FormaControl     =   
           object               {
             SBCC_PrismaBezier( ArregloImpulso, false, -0.025*LargoSoporte, +0.025*LargoSoporte )
             rotate             -90*x
             rotate             +90*y
           }  
             
        union                   {   
          object                { 
            FormaControl
          }             
          difference            {  
            object              {    
              FormaControl
              scale             <3,1,1>
            }                          
            object              { 
              FormaControl      
              scale             <4,0.8,0.9>
            }
          }
          #local C                = 0;
          #while ( C < 10 )             
            box                   {
              <-LargoSoporte/3,-AnchoFundamental/100,-AnchoFundamental/10>,
              <+LargoSoporte/3,+AnchoFundamental/100,+AnchoFundamental/10> 
              rotate              C*180*x/10    
              translate           -1.425*AltoFundamental/4*y   
              texture             {      
                TexturaMetal
              }
            }
            #local C              = C+1;
          #end  // #while ( C < 10 )
          matrix                  <1,0,0,
                                   +CizallaBase,1,0,
                                   0,0,1,
                                   0,0,0>
        }  
        translate               -LargoFundamental/2*x
        texture                 { 
          TexturaEscala
          scale                 3*AnchoFundamental/4
          rotate                90*y
        }                    
      }  // Control de impulso  
      // Tornillos
      #local Tornillo           =
        difference              {
          union                 {
            cylinder              { 
              0, -DiametroTornillo*x, 0.25*DiametroTornillo
            }                    
            difference            {      
              sphere                {
                0, DiametroTornillo/2
                scale               <0.5,1,1>
              }
              plane             {  
                x, 0
              } 
            }                     
          }        
          box                   {
            <0.1,-0.1,-1>,
            <1,+0.1,+1>
            scale               DiametroTornillo 
            texture             {
              TexturaMetalBase
            }
          } 
          box                   {
            <0.1,-0.1,-1>,
            <1,+0.1,+1>
            scale               DiametroTornillo    
            rotate              90*x
            texture             {
              TexturaMetalBase
            }
          } 
          texture               { 
            TexturaMetal
          }    
        } // Tornillo
      object                    {       
        Tornillo        
        rotate                  15*x
        translate               1.0*LargoFundamental/2*x
        translate               ( -0.2*AltoFundamental )*
                                ( y-CizallaBase*x )
      } 
      #local AnguloTriangulo    =
         degrees( atan2( AltoSoporte, 0.5*AnchoFundamental ) );
      object                    {
        Tornillo
        rotate                  15*x
        rotate                  90*y                 
        rotate                  +AnguloTriangulo*x
        translate               -AnchoFundamental*z/4
                                +1.1*AltoSoporte*y/2
      } 
      object                    {
        Tornillo
        rotate                  315*x
        rotate                  90*y                 
        rotate                  +AnguloTriangulo*x
        translate               -AnchoFundamental*z/4
                                +1.1*AltoSoporte*y/2   
        translate               +LargoFundamental/3*x
      } 
      object                    {
        Tornillo
        rotate                  215*x
        rotate                  90*y                 
        rotate                  +AnguloTriangulo*x
        translate               -AnchoFundamental*z/4
                                +1.1*AltoSoporte*y/2 
        translate               -LargoFundamental/3*x
      } 
      object                    {
        Tornillo
        rotate                  15*x
        rotate                  90*y                 
        rotate                  +AnguloTriangulo*x
        translate               -AnchoFundamental*z/4
                                +1.1*AltoSoporte*y/2     
        scale                   <1,1,-1>
      } 
      object                    {
        Tornillo
        rotate                  125*x
        rotate                  90*y                 
        rotate                  +AnguloTriangulo*x
        translate               -AnchoFundamental*z/4
                                +1.1*AltoSoporte*y/2   
        translate               +LargoFundamental/3*x
        scale                   <1,1,-1>
      } 
      object                    {
        Tornillo
        rotate                  75*x
        rotate                  90*y                 
        rotate                  +AnguloTriangulo*x
        translate               -AnchoFundamental*z/4
                                +1.1*AltoSoporte*y/2 
        translate               -LargoFundamental/3*x
        scale                   <1,1,-1>
      } 
    }  // Accesorios                             
    // Patitas
    union                       {    
      cylinder                  {  
        -AltoFundamental*y, -1.05*AltoFundamental*y, DiametroTornillo
        translate               +( +LargoFundamental/2-LargoSoporte/2 )*x
                                +( +AnchoFundamental/2-LargoSoporte/8 )*z
      }
      cylinder                  {  
        -AltoFundamental*y, -1.05*AltoFundamental*y, DiametroTornillo
        translate               -( +LargoFundamental/2-LargoSoporte/2 )*x
                                +( +AnchoFundamental/2-LargoSoporte/8 )*z
      }
      cylinder                  {  
        -AltoFundamental*y, -1.05*AltoFundamental*y, DiametroTornillo
        translate               +( +LargoFundamental/2-LargoSoporte/2 )*x
                                -( +AnchoFundamental/2-LargoSoporte/8 )*z
      }
      cylinder                  {  
        -AltoFundamental*y, -1.05*AltoFundamental*y, DiametroTornillo
        translate               -( +LargoFundamental/2-LargoSoporte/2 )*x
                                -( +AnchoFundamental/2-LargoSoporte/8 )*z
      }
      texture                   { 
        TexturaPlastico
      }
    }  // Patitas 
    // Plaquilla
    union                       {
      box                       { 
        <-4*LargoFundamental/15,-1*AltoFundamental/8,-0.001*LargoSoporte>,
        <+4*LargoFundamental/15,-3*AltoFundamental/4,+0.001*LargoSoporte>
        texture                   {
          TexturaPlaca
          scale           <LargoFundamental*8/15,AltoFundamental*5/8,LargoSoporte>
          translate       -AltoFundamental*3.5/8*y
        }  
        matrix                  <1,0,0,
                                 0,1,(CizallaBase+0.07)/2,
                                 0,0,1,
                                 0,0,0>  
        translate               -AnchoFundamental/2*z
      } 
      box                       { 
        <-4*LargoFundamental/15,-1*AltoFundamental/8,-0.001*LargoSoporte>,
        <+4*LargoFundamental/15,-3*AltoFundamental/4,+0.001*LargoSoporte>
        texture                   {
          TexturaPlaca
          scale           <-LargoFundamental*8/15,AltoFundamental*5/8,LargoSoporte>
          translate       -AltoFundamental*3.5/8*y
        }  
        matrix                  <1,0,0,
                                 0,1,(CizallaBase+0.07)/2,
                                 0,0,1,
                                 0,0,0>  
        translate               -AnchoFundamental/2*z 
        scale                   <1,1,-1>
      } 
      rotate                    0.05*z
    } // Plaquilla
    translate                   1.05*AltoFundamental*y  
  }
#end  // #macro SBCC_SelladorBolsasCalorCaliente                                  

#macro SBCC_SelladorBolsas( FraccionAbrir, FraccionEmpuje )       
  object                        {       
    #local L                    = SBCC_L;
    #local LargoFundamental     = 282*L;
    #local AnchoFundamental     = 50*L;
    #local AltoFundamental      = 41*L; 
    #local LargoSoporte         = 35*L;  
    #local AnchoSoporte         = 28*L;  
    #local AltoSoporte          = 18*L; 
    #local DiametroTornillo     = 5*L;                        
    #local CizallaSoporte       = 0.2;
    SBCC_SelladorBolsasCalorCaliente( FraccionAbrir, FraccionEmpuje,
        LargoFundamental, AnchoFundamental, AltoFundamental,
        LargoSoporte, AnchoSoporte, AltoSoporte, CizallaSoporte,
        DiametroTornillo,
        SBCC_TexturaPrincipal, SBCC_TexturaMetal, 
        SBCC_TexturaMetalBase, SBCC_TexturaBlanda, 
        SBCC_TexturaPlastico, SBCC_TexturaEscala, SBCC_TexturaPlaca )
  }
#end  // #macro SBCC_SelladorBolsas