// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com
// Apdo. 964-1250 Escaz, San Jos, Costa Rica
// dedicado a Jess y Mara...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho... 15 febrero 2011
//                
// Mis dibujos estn en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY 
//
// PAUV_Aux.pov es un archivo experimental en desarrollo
// Se recomienda no utilizarlo directamente en sus propias
// animaciones, y esperar futuras versiones.
// Se incluye aqu como auxiliar
// para la graficacion del objeto PAUV_Silla
//
// #macro PAUV_Determinante ( Det, A11, A12, A21, A22 )
//      Calcula el determinante de una matriz 2*2
//                     A11   A12   = A11*A12-A12*A21
//                     A21   A22  
//      Det     : OUTPUT resultado float del determinante
//      A11     : casilla A11 de la matriz
//      A12     : casilla A12 de la matriz
//      A21     : casilla A21 de la matriz
//      A22     : casilla A22 de la matriz
//
// #macro PAUV_SistemaDoble ( Solucion, A, B, C, D, E, F )
//      Resuelve el sistema de ecuaciones lineales 2*2
//              Ax+By   = C     Solucion = < x,y,Determinante  >
//              Dx+Ey   = F
//      Solucion        : OUTPUT devuelve la solucion como <x,y,Determinante>
//              O podria ser vector nulo si Determinante = 0
//      A               : constante multiplica x en ecuacion primera
//      B               : constante multiplica y en ecuacion primera
//      C               : constante resultado en ecuacion primera
//      D               : constante multiplica x en ecuacion segunda
//      E               : constante multiplica y en ecuacion segunda
//      F               : constante resultado en ecuacion segunda
//
// #macro PAUV_CentroTriplePunto( Centro, C, P, Q )
//      Calculo Centro de un circulo que pase por los vectores C, P y Q
//      o vector nulo si fracaso
//      PAUV_BanderaCentro      = true  si exito
//                                false si fracaso
//      Centro          : OUTPUT devuelve el centro solicitado o vector
//              nulo si fracaso
//      C               : Punto del crculo
//              Se recomienda (innecesario) colocarlo en medio de P y Q.
//      P               : Otro punto del crculo
//      Q               : Otro punto del crculo
//
// #macro PAUV_CentroEsfericoTriplePunto
//        ( CentroEsferico, CentroTriangulo, C, P, Q, RadioEsfera )
//      Calculo Centro de un circulo y esfera
//      que pase por los vectores C, P y Q
//      o vector nulo si fracaso, la esfera tiene radio RadioEsfera
//      PAUV_BanderaCentro      = true  si exito en triangulo
//                                false si fracaso en triangulo
//      PAUV_BanderaEsfera      = true  si exito en esfera
//                                false si fracaso en esfera ( vector nulo )
//      Nota: es posible exito en Centro de Triangulo y fracaso en Esfera
//              por ejemplo si RadioEsfera es muy pequeno
//      CentroEsferico  : OUTPUT devuelve el centro esfera solicitado o vector
//              nulo si fracaso
//      CentroTriangulo : OUTPUT devuelve el centro plano de triangulo
//              solicitado o vector nulo si fracaso
//      C               : Punto del crculo inscrito a esfera
//      P               : Otro punto del crculo inscrito a esfera
//      Q               : Otro punto del crculo inscrito a esfera
//      RadioEsfera     : Radio solicitado de esfera
//
// #macro PAUV_SweepTriplePunto( P, C, Q, Radio, BanderaEsfera )
//      Genera Torus que pase por los vectores P, C y Q
//      C en medio de P y Q, el torus de grueso Radio.
//      BanderaEsfera true agrega esferas en los extremos
//      En la versin actual el ngulo debera ser menor o igual a 180.
//              Si alineados genera cilindro.
//      P               : punto inicial del recorrido del torus
//      C               : punto central del recorrido del torus
//      Q               : punto final del recorrido del torus
//      Radio           : radio interno del torus
//      BanderaEsfera   : si true coloca esferas en los extremos
//                        si false se ignora
//
// #macro PAUV_AnilloTriplePunto( P, C, Q, GruesoR, GruesoZ, BanderaFinal )
//      Similar a PAUV_SweepTriplePunto (arriba), pero el torus
//      es de base interna cuadrangular. Es decir se genera
//      por diferencia de anillos cilindricos.
//      Genera Anillo Cilidrico que pase por los vectores P, C y Q
//      C en medio de P y Q.
//      GruesoR es el "grueso" del anillo cilindrico y GruesoZ es el
//      grueso perpendicular al recorrido sweep.
//      Los puntos se colocan centrados al recorrido.
//      BanderaEsfera true agrega cilindros en los extremos
//      En la versin actual el ngulo debera ser menor o igual a 180.
//              ADVERTENCIA: Si alineados genera cilindro.
//              Disculpas por los problemas que esto podria causar
//              Podria remediarlo induciendo un pequeo defecto
//              en el recorrido.
//      P               : punto inicial del recorrido del anillo cilidrico
//      C               : punto central del recorrido del anillo cilindro
//      Q               : punto final del recorrido del anillo cilindrico
//      GruesoR         : grueso radial del anillo
//      GruesoZ         : grueso perpendicular al radio del anillo
//      BanderaFinal    : si true coloca cilindros en los extremos
//                        si false se ignora
//
// #macro PAUV_SegmentoTriplePunto( P, C, Q,
//                        GruesoZ, SegmentoSector, BanderaFinal )
//      Similar a PAUV_SweepTriplePunto (arriba), pero se genera
//      un Segmento o un SectorCircular segun bandera SegmentoSector
//      el borde es plano o toroidal segun BanderaFinal
//      Genera Segmento o Sector Circular que pase por la curva P, C y Q
//      C en medio de P y Q.
//      GruesoZ es el "grueso"
//      grueso perpendicular al recorrido sweep.
//      Los puntos se colocan centrados al recorrido.
//      BanderaEsfera true redondea con toroides y cilindros
//      los bordes para que queden curvos
//      En la versin actual el ngulo debera ser menor o igual a 180.
//              ADVERTENCIA: Si alineados genera cilindro.
//              Disculpas por los problemas que esto podria causar
//              Podria remediarlo induciendo un pequeo defecto
//              en el recorrido.
//      P               : punto inicial del arco circular
//      C               : punto central del arco circular curva
//      Q               : punto final de la curva del arco circular
//      GruesoZ         : grueso perpendicular al radio del anillo
//      SegmentoSector  : si true se trata de Segmento Circular
//                              relleno hasta cuerda interior
//                        si false se trata de Sector Circular
//                              relleno hasta centro del circulo
//      BanderaFinal    : si false son bordes planos
//                        si true los bordes son curvos con toriodes, etc
//                        si false se ignora
//
// #macro PAUV_InterpolacionTriplePunto( Resultado, C, P, Q, FraccionU )
//      Calculo Interpolacion de un arco de circulo que pasa
//      por los vectores C, P y Q.  C en el centro de curva
//      o vector nulo si fracaso
//      PAUV_BanderaCentro      = true  si exito
//                                false si fracaso
//      El resultado es algo asi a P+FraccionU*(Q-P), pero en la "curva"
//      Resultado       : OUTPUT devuelve el vector interpolado solicitado o
//              nulo si fracaso
//      C               : Punto del crculo
//              Se deberia colocar en medio de P y Q.
//      P               : Otro punto del crculo
//      Q               : Otro punto del crculo
//      FraccionU       : Recorre de 0 a 1.  0 es P y 1 es Q.
//
// #macro PAUV_SegmentoEsfericoTriplePunto
//                        ( C, P, Q, RadioEsfera, BanderaSector )
//      Dibuja un segmento esferico, es decir
//      la zona entre un plano y una esfera.  Si BanderaSector es true
//      entonces el dibujo agrega un plano a la figura.
//      C               : Punto del crculo
//      P               : Otro punto del crculo
//      Q               : Otro punto del crculo
//      RadioEsfera     : es el radio de la esfera,
//              si falla dibuja un disco
//      BanderaSector   : si TRUE agrega un cono, si FALSE solo el segmento
//
// #macro PAUV_CascaronEsfericoTriplePunto
//               ( C, P, Q, RadioEsfera, GruesoCascaron, BanderaTorus )
//      Dibuja un cascaron esferico, es decir
//      la zona entre dos esferas.  BanderaTorus agrega un torus decorativo.
//      C               : Punto del circulo guia
//      P               : Otro punto del circulo guia
//      Q               : Otro punto del circulo guia
//      RadioEsfera     : Radio medio cascaron, con respecto a los puntos
//      GruesoCascaron  : Grueso del cascaron
//      BanderaTorus    : Si TRUE agrega torus decorativo al final
//
// #macro PAUV_TrianguloEsfericoTriplePunto
//              ( C, P, Q, RadioEsfera, GruesoCascaron, BanderaTorus )
//      Dibuja un triangulo esferico
//      ( un triangulo en la superficie de una esfera )
//      a manera de cascara de grueso GruesoCascaron
//      C               : Punto del circulo guia
//      P               : Otro punto del circulo guia
//      Q               : Otro punto del circulo guia
//      RadioEsfera     : Radio medio cascaron, con respecto a los puntos
//      GruesoCascaron  : Grueso del cascaron
//      BanderaTorus    : Si TRUE agrega torus y esferas decorativas
//              a los extremos del triangulo esferico
//
// #macro PAUV_TrianguloEsfericoTriplePuntoLiso
//              ( C, P, Q, RadioEsfera, GruesoCascaron )
//      Dibuja un triangulo esferico
//      ( un triangulo en la superficie de una esfera )
//      a manera de cascara de grueso GruesoCascaron
//      C               : Punto del circulo guia
//      P               : Otro punto del circulo guia
//      Q               : Otro punto del circulo guia
//      RadioEsfera     : Radio medio cascaron, con respecto a los puntos
//      GruesoCascaron  : Grueso del cascaron
//
// #macro PAUV_PuenteTrianguloEsfericoTriplePunto
//                ( C, P, Q, R, RadioEsfera, GruesoCascaron, BanderaTorus )
//      Suelen producirse "huecos" al unir dos Triangulos Esfericos
//      Esta macro intenta rellenar el hueco
//      La idea es rellenar con dos Triangulos Esfericos la union
//      Entre el TrianguloEsferico ( C, P, Q ) y el ( Q, P, R )
//      La zona PQ de ambos triangulos que no calzaron bien.
//      Utilice un RadioEsfera promedio o a su propio criterio.
//      BanderaTorus true agrega Torus a los bordes para mejorar la calza.
//      C               : Punto del circulo guia 1
//      P               : Otro punto guia comun a ambos TriangulosEsfericos
//      Q               : Otro punto guia comun a ambos TriangulosEsfericos
//      R               : Punto del circulo guia 2
//      RadioEsfera     : Radio medio cascaron, con respecto a los puntos
//        Se recomienda un promedio de los radios en los TriangulosEsfericos
//      GruesoCascaron  : Grueso del cascaron
//      BanderaTorus    : Si TRUE agrega torus y esferas para mejorar la calza
//
// #macro PAUV_SegmentoTrianguloEsfericoTriplePunto
//                ( C, P, Q, RadioEsfera, GruesoCascaron,
//                        BanderaCP, BanderaPQ, BanderaQC, BanderaTorus )
//      Se puede considerar una figura intermedia entre
//      PAUV_CascaronEsfericoTriplePunto y PAUV_TrianguloEsfericoTriplePunto
//      La idea es crear un segmento esferico, y recortarle a voluntad
//      de las banderas BanderaCP, BanderaPQ y Bandera QC, los lados
//      que se requieran de un supuesto triangulo esferico
//      inscrito en la superficie de una esfera.
//      C               : Punto del circulo guia
//      P               : Otro punto del circulo guia
//      Q               : Otro punto del circulo guia
//      RadioEsfera     : Radio medio cascaron, con respecto a los puntos
//      GruesoCascaron  : Grueso del cascaron
//      BanderaCP       : TRUE-> Recorta en el lado CP del triangulo esferico
//      BanderaPQ       : TRUE-> Recorta en el lado PQ del triangulo esferico
//      BanderaQC       : TRUE-> Recorta en el lado QC del triangulo esferico
//      BanderaTorus    : Si TRUE agrega torus y esferas decorativas
//              a los extremos del cascaron-triangulo esferico
//
// #macro PAUV_InterpolacionEsfericoTriplePuntoMedio
//                        ( Resultado, C, P, Q, RadioEsfera )
//      Calculo Interpolacion de un arco de esfera que pasa
//      por los vectores P y Q siguiente un arco de esfera.
//      C es otro punto del casco esferico de RadioEsfera.
//      Se obtiene el PuntoMedio de dicho arco.
//      PAUV_BanderaEsfera      = true  si exito
//                                false si fracaso
//      PAUV_BanderaCentro      = true exito parcial como circulo
//                                false se interpreto como linea de P a Q
//      El resultado es algo asi a (P+Q)/2, pero en el "arco esferico".
//      Resultado       : OUTPUT devuelve el vector interpolado
//      C               : Punto guia de la esfera
//      P               : Otro punto base de la interpolacion
//      Q               : Otro punto base de la interpolacion
//      RadioEsfera     : Radio de la esfera interpolada.
//              Si error se tratara de interpretar como circulo.
//
// #macro PAUV_InterpolacionEsfericoTriplePunto
//                        ( Resultado, C, P, Q, RadioEsfera, FraccionU )
//      Calculo Interpolacion de un arco de esfera que pasa
//      por los vectores P y Q siguiente un arco de esfera.
//      C es otro punto del casco esferico de RadioEsfera.
//      Se obtiene interpolacion de 0 a 1 segun FraccionU de dicho arco.
//      PAUV_BanderaEsfera      = true  si exito
//                                false si fracaso
//      PAUV_BanderaCentro      = true exito parcial como circulo
//                                false se interpreto como linea de P a Q
//      El resultado es algo asi a P+FraccionU*(Q-P), pero en "arco esferico".
//      Resultado       : OUTPUT devuelve el vector interpolado
//      C               : Punto guia de la esfera
//      P               : Otro punto base de la interpolacion
//      Q               : Otro punto base de la interpolacion
//      RadioEsfera     : Radio de la esfera interpolada.
//              Si error se tratara de interpretar como circulo.
//      FraccionU       : Recorre de 0 a 1.  0 es P y 1 es Q.
//
// #macro PAUV_PlanoTriplePunto( PuntoA, PuntoB, PuntoC )
//      Crea un plano infinito que pasa por los tres puntos.
//      La normal se orienta segun PuntoB-PuntoA x PuntoC-PuntoA.
//      Se considera util en diferencias y similares, para biselar.
//      PuntoA          : Uno de los puntos que sirve de vertice
//              en el producto cruz.
//      PuntoB          : Otro punto del plano
//      PuntoC          : Otro punto del plano
//



#if ( version < 3.2 )
  #ifndef( PAUV_POV3_1 )
    #declare PAUV_POV3_1        = on;
  #end
#else
  #ifndef( PAUV_POV3_1 )
    #declare PAUV_POV3_1        = off;
  #end
#end

#if ( PAUV_POV3_1 )
// Las macros PAUV_Reorient_Trans y PAUV_Axis_Rotate_Trans
// se transcribe casi identica a la original
// en "transforms.inc" Reorient_Trans y Axis_Rotate_Trans
// se copia por compatibilidad con POVRay 3.1.
// La macro PAUV_VPerp_To_Vector
// se tomo de "math.inc" VPerp_To_Vector
// por compatibilidad con POVRay 3.1.


// Returns a vector perpendicular to V
// Author: Tor Olav Kristensen
#macro PAUV_VPerp_To_Vector(v0)
   #if (vlength(v0) = 0)
      #local vN = <0, 0, 0>;
   #else
      #local Dm = min(abs(v0.x), abs(v0.y));
      #local Dm = min(abs(v0.z),Dm);
      #if (abs(v0.z) = Dm)
         #local vN = vnormalize(vcross(v0, z));
      #else
         #if (abs(v0.y) = Dm)
            #local vN = vnormalize(vcross(v0, y));
         #else
            #local vN = vnormalize(vcross(v0, x));
         #end
      #end
   #end
   vN
#end

// rotate around a specific axis
// Author: Rune S. Johansen
#macro PAUV_Axis_Rotate_Trans(Axis, Angle)
   #local vX = vaxis_rotate(x,Axis,Angle);
   #local vY = vaxis_rotate(y,Axis,Angle);
   #local vZ = vaxis_rotate(z,Axis,Angle);
//   transform {
      matrix < vX.x,vX.y,vX.z, vY.x,vY.y,vY.z, vZ.x,vZ.y,vZ.z, 0,0,0 >
//   }
#end


// based on original Reorient() macro by John VanSickle
#macro PAUV_Reorient_Trans(Axis1, Axis2)
   #local vX1 = vnormalize(Axis1);
   #local vX2 = vnormalize(Axis2);
   #local Y = vcross(vX1, vX2);
   #if(vlength(Y) > 0)
      #local vY = vnormalize(Y);
      #local vZ1 = vnormalize(vcross(vX1, vY));
      #local vZ2 = vnormalize(vcross(vX2, vY));
//      transform {
         matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
         matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
//      }
   #else
      #if (vlength(vX1-vX2)=0)
         transform {}
      #else
         #local vZ = PAUV_VPerp_To_Vector(vX2);
//         transform {
         PAUV_Axis_Rotate_Trans(vZ,180)
//}
      #end
   #end
#end

// --------------------
// Transformation macros:
// --------------------
// Reorients and deforms object so original x axis points along A, original y along B,
// and original z along C.
// Ligera modificacion de Shear_Trans en "transforms.inc"
#macro PAUV_Shear_Trans(A, B, C)
//   transform {
      matrix < A.x, A.y, A.z,
             B.x, B.y, B.z,
             C.x, C.y, C.z,
             0, 0, 0>
//   }
#end

// Similar to Reorient_Trans(), points y axis along Axis.
// ver Point_At_Trans de "transforms.inc"
#macro PAUV_Point_At_Trans(YAxis)
   #local Y = vnormalize(YAxis);
   #local X = PAUV_VPerp_To_Vector(Y);
   #local Z = vcross(X, Y);
   PAUV_Shear_Trans(X, Y, Z)
#end

#else
  #include "transforms.inc"
#end

#macro PAUV_Determinante ( Det, A11, A12, A21, A22 )
  #local Det            = ( A11*A22-A12*A21 );
#end

#macro PAUV_SistemaDoble ( Solucion, A, B, C, D, E, F )
  #local Det            = 0;
  PAUV_Determinante( Det, A, B, D, E )
  #if ( Det = 0 )
    #local Solucion   = < 0, 0, 0 >;
  #else
    #local DetX         = 0;
    #local DetY         = 0;
    PAUV_Determinante( DetX, C, B, F, E )
    PAUV_Determinante( DetY, A, C, D, F )
    #local Solucion   = < DetX/Det, DetY/Det, Det >;
  #end
#end

// ( PAUV_BanderaCentro = true ), confirma exito
#macro PAUV_CentroTriplePunto( Centro, C, P, Q )
  #local CP             = P-C;
  #local CQ             = Q-C;
  #local CP2            = ( C+P )/2;
  #local CQ2            = ( C+Q )/2;
  #local AEQ            = vdot( CQ, CQ );
  #local BEQ            = vdot( CQ, CP );
  #local CEQ            = vdot( CQ2, CQ );
  #local DEQ            = BEQ;
  #local EEQ            = vdot( CP, CP );
  #local FEQ            = vdot( CP2, CP );
  #local PAUV_Solucion  = <0,0,0>;
  PAUV_SistemaDoble( PAUV_Solucion, AEQ, BEQ, CEQ, DEQ, EEQ, FEQ )
  #if ( PAUV_Solucion.z = 0 )
    #local Centro       = < 0, 0, 0 >;
    #declare PAUV_BanderaCentro = false;
  #else
    #local Centro       = ( PAUV_Solucion.x*CQ+PAUV_Solucion.y*CP );
    #local Normal       = vnormalize( vcross( CP, CQ ) );
    #local Centro       = Centro+vdot( C, Normal )*Normal;
    #declare PAUV_BanderaCentro = true;
  #end
#end

#macro PAUV_InterpolacionTriplePunto( Resultado, C, P, Q, FraccionU )
  #local Centro         = < 0, 0, 0 >;
  PAUV_CentroTriplePunto( Centro, C, P, Q )
  #if ( PAUV_BanderaCentro )
    #local CP         = vnormalize( P-Centro );
    #local CQ         = vnormalize( Q-Centro );
    #local Normal     = vcross( CP, CQ );
    #local Angulo     = FraccionU*degrees( acos( vdot( CP, CQ ) ) );
    #local Resultado  = vaxis_rotate( P-Centro, Normal, Angulo )+Centro;
  #else
    #local Resultado  = P+FraccionU*( Q-P );
  #end
#end

#macro PAUV_CentroEsfericoTriplePunto
        ( CentroEsferico, CentroTriangulo, C, P, Q, RadioEsfera )
  PAUV_CentroTriplePunto( CentroTriangulo, C, P, Q )
  #if ( PAUV_BanderaCentro )
    #local Normal       = vnormalize( vcross( P-C, Q-C ) );
    #local PivReal      =
        RadioEsfera*RadioEsfera-vdot( P-CentroTriangulo, P-CentroTriangulo );
    #if ( PivReal <= 0 )
      #declare PAUV_BanderaEsfera       = false;
      #local CentroEsferico             = <0,0,0>;
    #else
      #declare PAUV_BanderaEsfera       = true;
      #local CentroEsferico             =
                        CentroTriangulo+sqrt( PivReal )*Normal;
    #end
  #end
#end

#macro PAUV_InterpolacionEsfericoTriplePuntoMedio
                        ( Resultado, C, P, Q, RadioEsfera )
  #local CentroEsfera           = < 0, 0, 0 >;
  #local CentroTriangulo        = < 0, 0, 0 >;
  PAUV_CentroEsfericoTriplePunto
        ( CentroEsfera, CentroTriangulo, C, P, Q, RadioEsfera )
  #if ( PAUV_BanderaEsfera )
    #local Rayo         = vnormalize( ( P+Q )/2-CentroEsfera );
    #local Resultado    = CentroEsfera+RadioEsfera*Rayo;
  #else
    #if ( PAUV_BanderaCentro )
      #local Rayo       = vnormalize( ( P+Q )/2-CentroTriangulo );
      #local Resultado  = CentroTriangulo+RadioEsfera*Rayo;
    #else
      #local Resultado  = ( P+Q )/2;
    #end
  #end
#end

#macro PAUV_InterpolacionEsfericoTriplePunto
                        ( Resultado, C, P, Q, RadioEsfera, FraccionU )
  #local CentroEsfera           = < 0, 0, 0 >;
  #local CentroTriangulo        = < 0, 0, 0 >;
  PAUV_CentroEsfericoTriplePunto
        ( CentroEsfera, CentroTriangulo, C, P, Q, RadioEsfera )
  #if ( PAUV_BanderaEsfera )
    #local CP         = vnormalize( P-CentroEsfera );
    #local CQ         = vnormalize( Q-CentroEsfera );
    #local Normal     = vcross( CP, CQ );
    #local Angulo     = FraccionU*degrees( acos( vdot( CP, CQ ) ) );
    #local Resultado  = vaxis_rotate
                ( P-CentroEsfera, Normal, Angulo )+CentroEsfera;
  #else
    #if ( PAUV_BanderaCentro )
      #local CP         = vnormalize( P-CentroTriangulo );
      #local CQ         = vnormalize( Q-CentroTriangulo );
      #local Normal     = vcross( CP, CQ );
      #local Angulo     = FraccionU*degrees( acos( vdot( CP, CQ ) ) );
      #local Resultado  = vaxis_rotate
                ( P-CentroTriangulo, Normal, Angulo )+CentroTriangulo;
    #else
      #local Resultado  = P+FraccionU*( Q-P );
    #end
  #end
#end

#macro PAUV_SweepTriplePunto( P, C, Q, Radio, BanderaEsfera )
  #local Centro         = < 0, 0, 0 >;
  PAUV_CentroTriplePunto( Centro, C, P, Q )
  union                 {
  #if ( PAUV_BanderaCentro )
    difference            {
      #local RadioPr    = sqrt( vdot( P-Centro, P-Centro ) );
      #local CP         = vnormalize( P-Centro );
      #local CQ         = vnormalize( Q-Centro );
      #local Normal     = vcross( CP, CQ );
      #local Angulo     = degrees( acos( vdot( CP, CQ ) ) );

      torus               {
        RadioPr   , Radio
        #if ( PAUV_POV3_1 )
          PAUV_Reorient_Trans( y, Normal )
        #else
          Reorient_Trans( y, Normal )
        #end
      }
      plane               {
        #local Normal1  = vnormalize( vcross( CP, Normal ) );
        -Normal1         , 0
      }
      plane               {
        #local Normal1  = vnormalize( vcross( Normal, CQ ) );
        -Normal1         , 0
      }
      translate         Centro
    }
  #else
      cylinder          {
        P       , Q     , Radio
      }
  #end
  #if ( BanderaEsfera )
    sphere      {
      P         , Radio
    }
    sphere      {
      Q         , Radio
    }
  #end
  }     // union total
#end
// Se genera un warning, si BanderaEsfera false...

#macro PAUV_AnilloTriplePunto( P, C, Q, GruesoR, GruesoZ, BanderaFinal )
  #local Centro         = < 0, 0, 0 >;
  PAUV_CentroTriplePunto( Centro, C, P, Q )
  union                 {
  #if ( PAUV_BanderaCentro )
    difference            {
      #local RadioPr    = sqrt( vdot( P-Centro, P-Centro ) );
      #local CP         = vnormalize( P-Centro );
      #local CQ         = vnormalize( Q-Centro );
      #local Normal     = vcross( CP, CQ );
      #local Angulo     = degrees( acos( vdot( CP, CQ ) ) );

      cylinder          {
        -GruesoZ/2*y    , +GruesoZ/2*y  , RadioPr+GruesoR/2
        #if ( PAUV_POV3_1 )
          PAUV_Reorient_Trans( y, Normal )
        #else
          Reorient_Trans( y, Normal )
        #end
      }
      cylinder          {
        -1.1*GruesoZ/2*y    , +1.1*GruesoZ/2*y  , RadioPr-GruesoR/2
        #if ( PAUV_POV3_1 )
          PAUV_Reorient_Trans( y, Normal )
        #else
          Reorient_Trans( y, Normal )
        #end
      }
      plane               {
        #local Normal1  = vnormalize( vcross( CP, Normal ) );
        -Normal1         , 0
      }
      plane               {
        #local Normal1  = vnormalize( vcross( Normal, CQ ) );
        -Normal1         , 0
      }
      translate         Centro
    }
  #else
      cylinder          {
        P       , Q     , Radio
      }
  #end
  #if ( BanderaFinal )
    #if ( PAUV_BanderaCentro )
      cylinder          {
        -GruesoZ/2*y    , GruesoZ/2*y   , GruesoR/2
        #if ( PAUV_POV3_1 )
          PAUV_Reorient_Trans( y, Normal )
        #else
          Reorient_Trans( y, Normal )
        #end
        translate       P
      }
      cylinder          {
        -GruesoZ/2*y    , GruesoZ/2*y   , GruesoR/2
        #if ( PAUV_POV3_1 )
          PAUV_Reorient_Trans( y, Normal )
        #else
          Reorient_Trans( y, Normal )
        #end
        translate       Q
      }
    #else
      sphere      {
        P         , Radio
      }
      sphere      {
        Q         , Radio
      }
    #end
  #end
  }     // union total
#end
// se genera un warning si BanderaFinal es false

#macro PAUV_SegmentoTriplePunto( P, C, Q,
                        GruesoZ, SegmentoSector, BanderaFinal )
  #local Centro         = < 0, 0, 0 >;
  PAUV_CentroTriplePunto( Centro, C, P, Q )
  union                 {
  #if ( PAUV_BanderaCentro )
    difference            {
      #local RadioPr    = sqrt( vdot( P-Centro, P-Centro ) );
      #local CP         = vnormalize( P-Centro );
      #local CQ         = vnormalize( Q-Centro );
      #local PQ         = vnormalize( Q-P );
      #local Normal     = vcross( CP, CQ );
      #local Angulo     = degrees( acos( vdot( CP, CQ ) ) );

      cylinder          {
        -GruesoZ/2*y    , +GruesoZ/2*y  , RadioPr
        #if ( PAUV_POV3_1 )
          PAUV_Reorient_Trans( y, Normal )
        #else
          Reorient_Trans( y, Normal )
        #end
      }
      #if ( SegmentoSector )
        plane               {
          #local Normal1  = vnormalize( vcross( PQ, Normal ) );
          Normal1          , vdot( Normal1, P-Centro )
        }
      #else
        plane               {
          #local Normal1  = vnormalize( vcross( CP, Normal ) );
          -Normal1         , 0
        }
        plane               {
          #local Normal1  = vnormalize( vcross( Normal, CQ ) );
          -Normal1         , 0
        }
      #end
      translate         Centro
    }
  #else
      cylinder          {
        P       , Q     , Radio
      }
  #end
  #if ( BanderaFinal )
    #if ( PAUV_BanderaCentro )
      object      {
        PAUV_SweepTriplePunto( P, C, Q, GruesoZ/2, true )
      }
      #if ( SegmentoSector )
        cylinder        {
          P             , Q     , GruesoZ/2
        }
      #else
        cylinder        {
          P             , Centro        , GruesoZ/2
        }
        cylinder        {
          Q             , Centro        , GruesoZ/2
        }
        sphere          {
          Centro        , GruesoZ/2
        }
      #end
    #else
      sphere      {
        P         , Radio
      }
      sphere      {
        Q         , Radio
      }
    #end
  #end
  }     // union total
#end
// se genera un warning si BanderaFinal es false

#macro PAUV_SegmentoEsfericoTriplePunto
                        ( C, P, Q, RadioEsfera, BanderaSector )
  #local CentroEsferico         = < 0, 0, 0 >;
  #local CentroTriangulo        = < 0, 0, 0 >;
  PAUV_CentroEsfericoTriplePunto
        ( CentroEsferico, CentroTriangulo, C, P, Q, RadioEsfera )
  #if ( PAUV_BanderaEsfera )
    union       {
      difference        {
        sphere          {
          CentroEsferico        , RadioEsfera
        }
        box             {
          // Tuve problemas usando el plane, y puse un box
          -RadioEsfera          , RadioEsfera
          #local NormalPlano    = vnormalize( vcross( Q-C, P-C ) );
          translate     ( RadioEsfera-
                    vdot( NormalPlano, CentroTriangulo-CentroEsferico ) )*y
          #if ( PAUV_POV3_1 )
            PAUV_Reorient_Trans( -y, NormalPlano )
          #else
            Reorient_Trans( -y, NormalPlano )
          #end
          translate     CentroEsferico
        }
      }
      #if ( BanderaSector )
        cone            {
          #local AlturaPrisma   = vlength( CentroTriangulo-CentroEsferico );
          CentroEsferico        , 0.0
          CentroTriangulo       ,
                sqrt( RadioEsfera*RadioEsfera-AlturaPrisma*AlturaPrisma )
        }
      #end
    }
  #else
    #if ( PAUV_BanderaCentro )
      disc              {
        CentroTriangulo ,
        vcross( P-C, Q-C ),
        vlength( CentroTriangulo-P )
      }
    #else
      cylinder          {
        P, Q, RadioEsfera/10
      }
    #end
  #end
#end

#macro PAUV_CascaronEsfericoTriplePunto
                        ( C, P, Q, RadioEsfera, GruesoCascaron, BanderaTorus )
  #local CentroEsferico         = < 0, 0, 0 >;
  #local CentroTriangulo        = < 0, 0, 0 >;
  PAUV_CentroEsfericoTriplePunto
        ( CentroEsferico, CentroTriangulo, C, P, Q, RadioEsfera )
  #if ( PAUV_BanderaEsfera )
    union       {
      difference        {
        sphere          {
          CentroEsferico        , RadioEsfera+GruesoCascaron/2
        }
        sphere          {
          CentroEsferico        , RadioEsfera-GruesoCascaron/2
        }
        box             {
          // Tuve problemas usando el plane, y puse un box
          -RadioEsfera*<1.1,1.0,1.1>, RadioEsfera*<1.1,1.0,1.1>
          #local NormalPlano    = vnormalize( vcross( Q-C, P-C ) );
          translate     ( RadioEsfera-
                    vdot( NormalPlano, CentroTriangulo-CentroEsferico ) )*y
          #if ( PAUV_POV3_1 )
            PAUV_Reorient_Trans( -y, NormalPlano )
          #else
            Reorient_Trans( -y, NormalPlano )
          #end
          translate     CentroEsferico
        }
        #if ( BanderaTorus )
          cone            {
            #local AlturaPrisma   = vlength( CentroTriangulo-CentroEsferico );
            #local Factor         = 2*RadioEsfera/AlturaPrisma;
            CentroEsferico        , 0.0
            Factor*CentroTriangulo-( Factor-1 )*CentroEsferico,
              Factor*sqrt( RadioEsfera*RadioEsfera-AlturaPrisma*AlturaPrisma )
            inverse
          }
        #end
      }
      #if ( BanderaTorus )
        torus           {
          #local AlturaPrisma   = vlength( CentroTriangulo-CentroEsferico );
          #local RadioTorus     =
                sqrt( RadioEsfera*RadioEsfera-AlturaPrisma*AlturaPrisma );
          RadioTorus    , GruesoCascaron/2
          #if ( PAUV_POV3_1 )
            PAUV_Reorient_Trans( -y, NormalPlano )
          #else
            Reorient_Trans( -y, NormalPlano )
          #end
          translate     CentroEsferico
                        +AlturaPrisma*NormalPlano
        }
      #end
    }
  #else
    #if ( PAUV_BanderaCentro )
      disc              {
        CentroTriangulo ,
        vcross( P-C, Q-C ),
        vlength( CentroTriangulo-P )
      }
    #else
      cylinder          {
        P, Q, RadioEsfera/10
      }
    #end
  #end
#end

#macro PAUV_TrianguloEsfericoTriplePunto
                        ( C, P, Q, RadioEsfera, GruesoCascaron, BanderaTorus )
  #local CentroEsferico         = < 0, 0, 0 >;
  #local CentroTriangulo        = < 0, 0, 0 >;
  PAUV_CentroEsfericoTriplePunto
        ( CentroEsferico, CentroTriangulo, C, P, Q, RadioEsfera )
  #if ( PAUV_BanderaEsfera )
    union       {
      difference        {
        sphere          {
          CentroEsferico        , RadioEsfera+GruesoCascaron/2
        }
        sphere          {
          CentroEsferico        , RadioEsfera-GruesoCascaron/2
        }
        plane           {
          #local Normal1        =
                vnormalize( vcross( P-CentroEsferico, C-CentroEsferico ) );
          Normal1      , vdot( Normal1, CentroEsferico )
        }
        plane           {
          #local Normal2        =
                vnormalize( vcross( C-CentroEsferico, Q-CentroEsferico ) );
          Normal2      , vdot( Normal2, CentroEsferico )
        }
        plane           {
          #local Normal3        =
                vnormalize( vcross( Q-CentroEsferico, P-CentroEsferico ) );
          Normal3      , vdot( Normal3, CentroEsferico )
        }
      }
      #if ( BanderaTorus )
        #macro PAUV_CentroCurvo( NuevoPunto, Lado1, Lado2 )
          #local CentroLado     = ( Lado1+Lado2 )/2;
          #local NuevoPunto     = CentroEsferico
                      +RadioEsfera*vnormalize( CentroLado-CentroEsferico );
        #end
        object          {
          #local CentroPC       = <0,0,0>;
          PAUV_CentroCurvo( CentroPC, P, C )
          PAUV_SweepTriplePunto( P, CentroPC, C,
                GruesoCascaron/2, false )
        }
        object          {
          #local CentroCQ       = <0,0,0>;
          PAUV_CentroCurvo( CentroCQ, C, Q )
          PAUV_SweepTriplePunto( C, CentroCQ, Q,
                GruesoCascaron/2, false )
        }
        object          {
          #local CentroQP       = <0,0,0>;
          PAUV_CentroCurvo( CentroQP, Q, P )
          PAUV_SweepTriplePunto( Q, CentroQP, P,
                GruesoCascaron/2, false )
        }
        sphere          {
          C             , GruesoCascaron/2
        }
        sphere          {
          P             , GruesoCascaron/2
        }
        sphere          {
          Q             , GruesoCascaron/2
        }
      #end
    }
  #else
    #if ( PAUV_BanderaCentro )
      disc              {
        CentroTriangulo ,
        vcross( P-C, Q-C ),
        vlength( CentroTriangulo-P )
      }
    #else
      cylinder          {
        P, Q, RadioEsfera/10
      }
    #end
  #end
#end

#macro PAUV_TrianguloEsfericoTriplePuntoLiso
                        ( C, P, Q, RadioEsfera, GruesoCascaron )
  #local CentroEsferico         = < 0, 0, 0 >;
  #local CentroTriangulo        = < 0, 0, 0 >;
  PAUV_CentroEsfericoTriplePunto
        ( CentroEsferico, CentroTriangulo, C, P, Q, RadioEsfera )
  #if ( PAUV_BanderaEsfera )
    difference        {
      sphere          {
        CentroEsferico        , RadioEsfera+GruesoCascaron/2
      }
      sphere          {
        CentroEsferico        , RadioEsfera-GruesoCascaron/2
      }
      plane           {
        #local Normal1        =
              vnormalize( vcross( P-CentroEsferico, C-CentroEsferico ) );
        Normal1      , vdot( Normal1, CentroEsferico )
      }
      plane           {
        #local Normal2        =
              vnormalize( vcross( C-CentroEsferico, Q-CentroEsferico ) );
        Normal2      , vdot( Normal2, CentroEsferico )
      }
      plane           {
        #local Normal3        =
              vnormalize( vcross( Q-CentroEsferico, P-CentroEsferico ) );
        Normal3      , vdot( Normal3, CentroEsferico )
      }
      bounded_by            {
        #local BoundedCentro        = ( C+P+Q )/3;
        #local BoundedRadio         =
            max( sqrt( vdot( C-P, C-P ) ),
                    sqrt( vdot( C-Q, C-Q ) ) );
        #local BoundedRadio         =
            max( BoundedRadio, sqrt( vdot( Q-P, Q-P ) ) );
        sphere              { BoundedCentro       , BoundedRadio }
      }
    }
  #else
    #if ( PAUV_BanderaCentro )
      disc              {
        CentroTriangulo ,
        vcross( P-C, Q-C ),
        vlength( CentroTriangulo-P )
      }
    #else
      cylinder          {
        P, Q, RadioEsfera/10
      }
    #end
  #end
#end

#macro PAUV_SegmentoTrianguloEsfericoTriplePunto
                ( C, P, Q, RadioEsfera, GruesoCascaron,
                        BanderaCP, BanderaPQ, BanderaQC, BanderaTorus )
  #local CentroEsferico         = < 0, 0, 0 >;
  #local CentroTriangulo        = < 0, 0, 0 >;
  PAUV_CentroEsfericoTriplePunto
        ( CentroEsferico, CentroTriangulo, C, P, Q, RadioEsfera )
  #if ( PAUV_BanderaEsfera )
    union       {
      difference  {
        union       {
          difference        {
            sphere          {
              CentroEsferico        , RadioEsfera+GruesoCascaron/2
            }
            sphere          {
              CentroEsferico        , RadioEsfera-GruesoCascaron/2
            }
            box             {
              // Tuve problemas usando el plane, y puse un box
              -RadioEsfera*<1.1,1.0,1.1>, RadioEsfera*<1.1,1.0,1.1>
              #local NormalPlano    = vnormalize( vcross( Q-C, P-C ) );
              translate     ( RadioEsfera-
                    vdot( NormalPlano, CentroTriangulo-CentroEsferico ) )*y
              #if ( PAUV_POV3_1 )
                PAUV_Reorient_Trans( -y, NormalPlano )
              #else
                Reorient_Trans( -y, NormalPlano )
              #end
              translate     CentroEsferico
            }
            #if ( BanderaTorus )
              cone            {
                #local AlturaPrisma   = vlength( CentroTriangulo-CentroEsferico );
                #local Factor         = 2*RadioEsfera/AlturaPrisma;
                CentroEsferico        , 0.0
            Factor*CentroTriangulo-( Factor-1 )*CentroEsferico,
            Factor*sqrt( RadioEsfera*RadioEsfera-AlturaPrisma*AlturaPrisma )
                inverse
              }
            #end
          }
          #if ( BanderaTorus )
            torus           {
              #local AlturaPrisma   = vlength( CentroTriangulo-CentroEsferico );
              #local RadioTorus     =
                sqrt( RadioEsfera*RadioEsfera-AlturaPrisma*AlturaPrisma );
              RadioTorus    , GruesoCascaron/2
              #if ( PAUV_POV3_1 )
                PAUV_Reorient_Trans( -y, NormalPlano )
              #else
                Reorient_Trans( -y, NormalPlano )
              #end
              translate     CentroEsferico
                        +AlturaPrisma*NormalPlano
            }
          #end
        }
        #if ( BanderaCP )
          plane           {
            #local Normal1        =
                vnormalize( vcross( P-CentroEsferico, C-CentroEsferico ) );
            Normal1      , vdot( Normal1, CentroEsferico )
          }
        #end
        #if ( BanderaQC )
          plane           {
            #local Normal2        =
                vnormalize( vcross( C-CentroEsferico, Q-CentroEsferico ) );
            Normal2      , vdot( Normal2, CentroEsferico )
          }
        #end
        #if ( BanderaPQ )
          plane           {
            #local Normal3        =
                vnormalize( vcross( Q-CentroEsferico, P-CentroEsferico ) );
            Normal3      , vdot( Normal3, CentroEsferico )
          }
        #end
      }
      #if ( BanderaTorus )
        #macro PAUV_CentroCurvo( NuevoPunto, Lado1, Lado2 )
          #local CentroLado     = ( Lado1+Lado2 )/2;
          #local NuevoPunto     = CentroEsferico
                      +RadioEsfera*vnormalize( CentroLado-CentroEsferico );
        #end
        #if ( BanderaCP )
          object          {
            #local CentroPC       = <0,0,0>;
            PAUV_CentroCurvo( CentroPC, P, C )
            PAUV_SweepTriplePunto( P, CentroPC, C,
                GruesoCascaron/2, true )
          }
        #end
        #if ( BanderaQC )
          object          {
            #local CentroCQ       = <0,0,0>;
            PAUV_CentroCurvo( CentroCQ, C, Q )
            PAUV_SweepTriplePunto( C, CentroCQ, Q,
                GruesoCascaron/2, true )
          }
        #end
        #if ( BanderaPQ )
          object          {
            #local CentroQP       = <0,0,0>;
            PAUV_CentroCurvo( CentroQP, Q, P )
            PAUV_SweepTriplePunto( Q, CentroQP, P,
                GruesoCascaron/2, true )
          }
        #end
      #end
    }
  #else
    #if ( PAUV_BanderaCentro )
      disc              {
        CentroTriangulo ,
        vcross( P-C, Q-C ),
        vlength( CentroTriangulo-P )
      }
    #else
      cylinder          {
        P, Q, RadioEsfera/10
      }
    #end
  #end
#end

#macro PAUV_PuenteTrianguloEsfericoTriplePunto
                ( C, P, Q, R, RadioEsfera, GruesoCascaron, BanderaTorus )
   #local CentroUno     = < 0, 0, 0 >;
   #local CentroDos     = < 0, 0, 0 >;
   PAUV_InterpolacionEsfericoTriplePuntoMedio
                        ( CentroUno, C, P, Q, RadioEsfera )
   PAUV_InterpolacionEsfericoTriplePuntoMedio
                        ( CentroDos, R, Q, P, RadioEsfera )
   union        {
     object     {
       PAUV_TrianguloEsfericoTriplePunto
        ( P, CentroDos, CentroUno, RadioEsfera, GruesoCascaron, BanderaTorus )
     }
     object     {
       PAUV_TrianguloEsfericoTriplePunto
        ( CentroUno, CentroDos, Q, RadioEsfera, GruesoCascaron, BanderaTorus )
     }
   }
#end

#macro PAUV_PlanoTriplePunto( PuntoA, PuntoB, PuntoC )
  plane         {
    #local Normal       =
        vnormalize( vcross( PuntoB-PuntoA, PuntoC-PuntoA ) );
    Normal,
    vdot( Normal, PuntoA )
  }
#end

