// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  27 mayo 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// PAUV ProcesadorAlimentosUtilVegetales
// El archivo dibuja un procesador de alimentos sencillo para uso domestico.  
// Ofrece una macro para cambiar las caracteristicas principales y texturas.   
// El boton de encendido de este modelo consiste en girar la tapa.
// Es compatible con POVRay 3.1.
//
// La macro principal tiene unicamente cuatro parametros
// #macro PAUV_ProcesadorAlimentos
//          ( FraccionEncendido, AnguloGirar, BanderaRecipiente, BanderaTapa )   
//      FraccionEncendido       : Valor entre 0.0 y 1.0 para indicar el giro
//              de la tapa para encender el aparato.  Utilice cero para apagado.
//      AnguloGirar             : Angulo para girar el rotor central y la barrita
//              de metal que le sirve de soporte.
//      BanderaRecipiente       : "on" dibuja el recipiente, "off" no lo dibuja.
//      BanderaTapa             : "on" dibuja la tapa, "off" no la dibuja.  La macro
//              no dibuja la tapa si no dibuja el recipiente.
//  
// Para un mayor control de las caracteristicas se requieren al menos dos macros.                     
// La siguiente versin de la macro, permite un mayor control de las caracteristicas,
// pero dibuja unicamente la base fija.
// #macro PAUV_ProcesadorAlimentosBase( AnguloGirar,
//         DiametroMayor, DiametroMenor, DistanciaCircular, DiametroDecorativo,
//         AlturaBase, DiametroSuperior, DecorativoSuperior,
//         BaseTransparente, GruesoTransparente, GruesoCilindroMetal,
//         TexturaBase, TexturaLabel, TexturaLabelBaseGiro, TexturaMetal, TexturaPatas )
//      AnguloGirar             : Angulo para girar el rotor central y la barrita
//              de metal que le sirve de soporte.            
//      DiametroMayor           : Corresponde al diametro de recipiente.  
//              Default es 67.9*L.
//      DiametroMenor           : Corresponde al diametro posterior de la base.
//              Default es 60.7*L.
//      DistanciaCircular       : Referencia para el largo de la base.  Corresponde
//              a la distancia entre los centros de los crculos gua.
//              Default es 46.0*L.
//      DiametroDecorativo      : Diametro guia para decoraciones inferiores y ancho
//              de placas.  Default es 14.3*L.
//      AlturaBase              : Altura guia para la base soporte y el recipiente.
//              Default es 71.5*L.
//      DiametroSuperior        : Corresponde a un diametro guia para la columna
//              soporte del procesador.  Default es 53.6*L.
//      DecorativoSuperior      : Diametro guia para decoraciones superiores.
//              Default es 7.15*L.
//      BaseTransparente        : Altura del cilindro segundario que sirve para
//              acomodar el recipiente firmemente a la base.
//              Default es 8.0*L.
//      GruesoTransparente      : Grueso principal de las laminas del recipiente.
//              Default es 1.43*L.
//      GruesoCilindroMetal     : Grueso referencia para el cilindro metalico de
//              la base que empuja el giro.  Default es 3.5*L.  
//      TexturaBase             : Textura principal de la base.
//              Default es PAUV_TexturaBase.
//      TexturaLabel            : Textura superior de la base.  Se utiliza para
//              ubicar la etiqueta "on" , "off" con color transparente GIF.
//              Puede sustituirla por su propio diseno.  
//              Default es PAUV_TexturaLabel.
//      TexturaLabelBaseGiro    : Textura de la base de giro.  Se utiliza para
//              pintar la base de giro con signos de ajuste de recipiente,
//              utiliza color transparente GIF.  Puede sustituir por su
//              propio diseno.  Default es PAUV_TexturaLabelBaseGiro.
//      TexturaMetal            : Textura a aplicar al cilindro guia de giro, anclado
//              a la base.  Default es PAUV_TexturaMetal.
//      TexturaPatas            : Textura de las patillas soporte.
//              Default es PAUV_TexturaPatas.          
//
// La siguiente macro dibuja unicamente el recipiente.  Para ubicar en posicion
// podria aplicar translate PAUV_PosicionRecipiente que se genera al llamar a la macro
// PAUV_ProcesadorAlimentos, aunque no la dibuje.
// #macro PAUV_ProcesadorAlimentosRecipiente( FraccionEncendido, BanderaTapa,
//         BanderaCuchilla, AnguloGirar,
//         DiametroRecipiente, DiametroDecorativo, AlturaBase,
//         BaseTransparente, GruesoTransparente, GruesoCilindroMetal,
//         MaterialRecipiente, TexturaCilindroGiro, TexturaCuchilla, TexturaFilo )
//      FraccionEncendido       : Valor entre 0.0 y 1.0 para indicar el giro
//              de la tapa para encender el aparato.  Utilice cero para apagado.
//      BanderaTapa             : "on" dibuja la tapa, "off" no la dibuja.  La macro
//              no dibuja la tapa si no dibuja el recipiente. 
//      BanderaCuchilla         : "on" dibuja las cuchillas y el cilindro soporte;
//              "off" no los dibuja.  Valor "on" por default.
//      AnguloGirar             : Angulo para girar el rotor central y la barrita
//              de metal que le sirve de soporte.            
//      DiametroRecipiente      : Corresponde al diametro de recipiente.  
//              Default es 67.9*L, el mismo DiametroMayor de PAUV_ProcesadorAlimentos.
//      DiametroDecorativo      : Diametro guia para decoraciones inferiores y ancho
//              de placas.  Default es 14.3*L.
//      AlturaBase              : Altura guia para la base soporte y el recipiente.
//              Default es 71.5*L.
//      BaseTransparente        : Altura del cilindro segundario que sirve para
//              acomodar el recipiente firmemente a la base.
//              Default es 8.0*L.
//      GruesoTransparente      : Grueso principal de las laminas del recipiente.
//              Default es 1.43*L.
//      GruesoCilindroMetal     : Grueso referencia para el cilindro metalico de
//              la base que empuja el giro.  Default es 3.5*L.  
//      MaterialRecipiente      : Material para aplicar al recipiente.
//              Default es PAUV_MaterialRecipiente.
//      TexturaCilindroGiro     : Textura para el cilindro soporte de cuchillas.
//              Default es PAUV_TexturaCilindroGiro.
//      TexturaCuchilla         : Textura principal de la cuchilla.
//              Default es PAUV_TexturaCuchilla.
//      TexturaFilo             : Por diferencia se aplica una textura al filo.
//              Default es PAUV_TexturaFilo.
//   
// La siguiente macro dibuja solo la tapa.
// #macro PAUV_ProcesadorAlimentosTapa(
//                DiametroRecipiente, AlturaBase, DiametroDecorativo,
//                GruesoTransparente, GruesoCilindroMetal, MaterialRecipiente )
//      DiametroRecipiente      : Corresponde al diametro de recipiente.  
//              Default es 67.9*L, el mismo DiametroMayor de PAUV_ProcesadorAlimentos.
//      AlturaBase              : Altura guia para la base soporte y el recipiente.
//              Default es 71.5*L.
//      DiametroDecorativo      : Diametro guia para decoraciones inferiores y ancho
//              de placas.  Default es 14.3*L.
//      GruesoTransparente      : Grueso principal de las laminas del recipiente.
//              Default es 1.43*L.
//      GruesoCilindroMetal     : Grueso referencia para el cilindro metalico de
//              la base que empuja el giro.  Default es 3.5*L.  
//      MaterialRecipiente      : Material para aplicar al recipiente.
//              Default es PAUV_MaterialRecipiente.
// 
// La siguiente macro dibuja solo las cuchillas.
// #macro PAUV_ProcesadorAlimentosCuchilla(
//          DiametroRecipiente, AlturaBase, BaseCuchilla, GruesoCilindroMetal,
//          TexturaCilindroGiro, TexturaCuchilla, TexturaFilo )
//      DiametroRecipiente      : Corresponde al diametro de recipiente.  
//              Default es 67.9*L, el mismo DiametroMayor de PAUV_ProcesadorAlimentos.
//      AlturaBase              : Altura guia para la base soporte y el recipiente.
//              Default es 71.5*L.
//      BaseCuchilla            : Altura de la cuchilla dentro del recipiente que sirve para
//              estimar un tamano apropiado.  La cuchillla, sin embargo, se dibujara
//              sobre el origen.  Corresponde a BaseTransparente+GruesoTransparente.
//              Default es 9.43*L.
//      GruesoCilindroMetal     : Grueso referencia para el cilindro metalico de
//              la base que empuja el giro.  Default es 3.5*L.  
//      TexturaCilindroGiro     : Textura para el cilindro soporte de cuchillas.
//              Default es PAUV_TexturaCilindroGiro.
//      TexturaCuchilla         : Textura principal de la cuchilla.
//              Default es PAUV_TexturaCuchilla.
//      TexturaFilo             : Por diferencia se aplica una textura al filo.
//              Default es PAUV_TexturaFilo.
//
// El aparato por defecto tiene las siguientes dimensiones:
//      Minimo                  = <-83.5, 0  , -68 >*L
//      Maximo                  = < 68  , 86.2, 57 >*L
// El cilindro de giro se centra sobre el origen del plano XZ, en forma perpendicular.
// El eje Y es el centro de los giros.  Note que descansa sobre dicho plano.  
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare PAUV_PosicionRecipiente
//      Vector que sirve para ubicar el recipiente.  Se genera en las macros pertinentes;
//      aunque se ordene no dibujarlo.  Por ejemplo podria llamar
//      a PAUV_ProcesadorAlimentos y no dibujar el recipiente, y solo obtener
//      su posicion inicial para una animacion del recipiente.
// #declare PAUV_PosicionTapa
//      Vector que sirve para ubicar la tapa.  Se genera en las macros pertinentes.
// #declare PAUV_PosicionCuchilla              
//      Vector que sirve para ubicar las cuchillas.  Se genera en las macros pertinentes.  
// #declare PAUV_DefaultTexturaBase             
//      Textura principal de la base.
// #declare PAUV_DefaultTexturaLabel            
//      Textura superior de la base.  Se utiliza para
//      ubicar la etiqueta "on" , "off" con color transparente GIF.
// #declare PAUV_DefaultTexturaLabelBaseGiro    
//      Textura de la base de giro.  Se utiliza para
//      pintar la base de giro con signos de ajuste de recipiente,
//      utiliza color transparente GIF.  
// #declare PAUV_DefaultTexturaMetal            
//      Textura a aplicar al cilindro guia de giro, anclado a la base.  
// #declare PAUV_DefaultTexturaPatas            
//      Textura de las patillas soporte.
// #declare PAUV_DefaultMaterialRecipiente      
//      Material para aplicar al recipiente.
// #declare PAUV_DefaultTexturaCilindroGiro     
//      Textura para el cilindro soporte de cuchillas.
// #declare PAUV_DefaultTexturaCuchilla         
//      Textura principal de la cuchilla.
// #declare PAUV_DefaultTexturaFilo             
//      Por diferencia se aplica una textura al filo.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default)
// #declare PAUV_TexturaBase                            = texture  { ... }           
//      Textura principal de la base.
// #declare PAUV_TexturaLabel                           = texture  { ... } 
//      Textura superior de la base.  Se utiliza para
//      ubicar la etiqueta "on" , "off" con color transparente GIF.
// #declare PAUV_TexturaLabelBaseGiro                   = texture  { ... } 
//      Textura de la base de giro.  Se utiliza para
//      pintar la base de giro con signos de ajuste de recipiente,
//      utiliza color transparente GIF.  
// #declare PAUV_TexturaMetal                           = texture  { ... } 
//      Textura a aplicar al cilindro guia de giro, anclado a la base.  
// #declare PAUV_TexturaPatas            
//      Textura de las patillas soporte.
// #declare PAUV_MaterialRecipiente                     = material { ... } 
//      Material para aplicar al recipiente.
// #declare PAUV_TexturaCilindroGiro                    = texture  { ... } 
//      Textura para el cilindro soporte de cuchillas.
// #declare PAUV_TexturaCuchilla                        = texture  { ... } 
//      Textura principal de la cuchilla.
// #declare PAUV_TexturaFilo             
//      Por diferencia se aplica una textura al filo.   = texture  { ... } 
// #declare PAUV_POV3_1                                 = off;
//      Valor on activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo simplemente
// #include "PAUV.inc"
// object        { PAUV_ProcesadorAlimentos( 0, 0, on, on ) }
//
// Otro ejemplo con las macros detalladas:
// #include "PAUV.inc"    
// union                        {    
//   object                     {
//     PAUV_ProcesadorAlimentosBase( 0, 0.0679, 0.0607, 0.046, 0.0143, 
//                 0.0715, 0.0536, 0.00715, 0.008, 0.00143, 0.0035,
//                 PAUV_TexturaBase, PAUV_TexturaLabel, PAUV_TexturaLabelBaseGiro,
//                 PAUV_TexturaMetal, PAUV_TexturaPatas )       
//   }                   
//   #declare PosRecipiente     = PAUV_PosicionRecipiente;  
//   #declare PosTapa           = PAUV_PosicionTapa;      
//   #declare PosCuchilla       = PAUV_PosicionCuchilla;
//   object                     {   
//     PAUV_ProcesadorAlimentosTapa( 0.0679, 0.0715, 0.0143, 0.00143, 0.0035,
//                  PAUV_MaterialRecipiente )
//     translate                PosTapa
//   }                                       
//   object                     {
//     PAUV_ProcesadorAlimentosCuchilla( 0.0679, 0.0715, 0.00943, 0.0035,
//                PAUV_TexturaCilindroGiro, PAUV_TexturaCuchilla, PAUV_TexturaFilo ) 
//     translate                PosCuchilla
//   }
//   object                     {
//     PAUV_ProcesadorAlimentosRecipiente( 0, off, off, 0, 0.0679, 0.0143, 0.0715,
//                 0.008, 0.00143, 0.0035, PAUV_MaterialRecipiente,
//                 PAUV_TexturaCilindroGiro, PAUV_TexturaCuchilla, PAUV_TexturaFilo )
//     translate                PosRecipiente
//   }                                                
// }
//
// O bien con modificadores:
// #include "PAUV.inc"                         
// #include "textures.inc"
// #declare PAUV_TexturaBase    = PinkAlabaster
// object                       {
//   PAUV_ProcesadorAlimentos( 0, 0, on, on )
// }
//
#include "colors.inc"
                     
global_settings                 {  
  max_trace_level               10
}
#declare OjoAbsoluto            = 256;
#declare VecesCentroAbsoluto    = 10;     
#declare L                      = 0.001;
camera {
  location  <   0,  0, -( VecesCentroAbsoluto+1 )*OjoAbsoluto >*L
  direction z
  sky       y
  angle     38.74
  // look_at  <   0,  0, -VecesCentroAbsoluto*OjoAbsoluto >*L
}         
light_source    {
         < 500  , 500   , -3000 >*L
         White
}
light_source    {
         <-500  , 500   , -3000 >*L
         White
}
background      {
         Gray50
}    

#include "PAUV.inc"  

#local   FactorAcercamiento     = 10;
 
object          {
  PAUV_ProcesadorAlimentos( 0, 0, on, on )   
  translate       -43*L*y+20*L*x
  translate       -( VecesCentroAbsoluto+1 )*( FactorAcercamiento-1 )
                        /( FactorAcercamiento )*OjoAbsoluto*L*z
}






