// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  27 mayo 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// PAUV ProcesadorAlimentosUtilVegetales
// El archivo dibuja un procesador de alimentos sencillo para uso domestico.  
// Ofrece una macro para cambiar las caracteristicas principales y texturas.   
// El boton de encendido de este modelo consiste en girar la tapa.
// Es compatible con POVRay 3.1.
//
// La macro principal tiene unicamente cuatro parametros
// #macro PAUV_ProcesadorAlimentos
//          ( FraccionEncendido, AnguloGirar, BanderaRecipiente, BanderaTapa )   
//      FraccionEncendido       : Valor entre 0.0 y 1.0 para indicar el giro
//              de la tapa para encender el aparato.  Utilice cero para apagado.
//      AnguloGirar             : Angulo para girar el rotor central y la barrita
//              de metal que le sirve de soporte.
//      BanderaRecipiente       : "on" dibuja el recipiente, "off" no lo dibuja.
//      BanderaTapa             : "on" dibuja la tapa, "off" no la dibuja.  La macro
//              no dibuja la tapa si no dibuja el recipiente.
//  
// Para un mayor control de las caracteristicas se requieren al menos dos macros.                     
// La siguiente versin de la macro, permite un mayor control de las caracteristicas,
// pero dibuja unicamente la base fija.
// #macro PAUV_ProcesadorAlimentosBase( AnguloGirar,
//         DiametroMayor, DiametroMenor, DistanciaCircular, DiametroDecorativo,
//         AlturaBase, DiametroSuperior, DecorativoSuperior,
//         BaseTransparente, GruesoTransparente, GruesoCilindroMetal,
//         TexturaBase, TexturaLabel, TexturaLabelBaseGiro, TexturaMetal, TexturaPatas )
//      AnguloGirar             : Angulo para girar el rotor central y la barrita
//              de metal que le sirve de soporte.            
//      DiametroMayor           : Corresponde al diametro de recipiente.  
//              Default es 67.9*L.
//      DiametroMenor           : Corresponde al diametro posterior de la base.
//              Default es 60.7*L.
//      DistanciaCircular       : Referencia para el largo de la base.  Corresponde
//              a la distancia entre los centros de los crculos gua.
//              Default es 46.0*L.
//      DiametroDecorativo      : Diametro guia para decoraciones inferiores y ancho
//              de placas.  Default es 14.3*L.
//      AlturaBase              : Altura guia para la base soporte y el recipiente.
//              Default es 71.5*L.
//      DiametroSuperior        : Corresponde a un diametro guia para la columna
//              soporte del procesador.  Default es 53.6*L.
//      DecorativoSuperior      : Diametro guia para decoraciones superiores.
//              Default es 7.15*L.
//      BaseTransparente        : Altura del cilindro segundario que sirve para
//              acomodar el recipiente firmemente a la base.
//              Default es 8.0*L.
//      GruesoTransparente      : Grueso principal de las laminas del recipiente.
//              Default es 1.43*L.
//      GruesoCilindroMetal     : Grueso referencia para el cilindro metalico de
//              la base que empuja el giro.  Default es 3.5*L.  
//      TexturaBase             : Textura principal de la base.
//              Default es PAUV_TexturaBase.
//      TexturaLabel            : Textura superior de la base.  Se utiliza para
//              ubicar la etiqueta "on" , "off" con color transparente GIF.
//              Puede sustituirla por su propio diseno.  
//              Default es PAUV_TexturaLabel.
//      TexturaLabelBaseGiro    : Textura de la base de giro.  Se utiliza para
//              pintar la base de giro con signos de ajuste de recipiente,
//              utiliza color transparente GIF.  Puede sustituir por su
//              propio diseno.  Default es PAUV_TexturaLabelBaseGiro.
//      TexturaMetal            : Textura a aplicar al cilindro guia de giro, anclado
//              a la base.  Default es PAUV_TexturaMetal.
//      TexturaPatas            : Textura de las patillas soporte.
//              Default es PAUV_TexturaPatas.          
//
// La siguiente macro dibuja unicamente el recipiente.  Para ubicar en posicion
// podria aplicar translate PAUV_PosicionRecipiente que se genera al llamar a la macro
// PAUV_ProcesadorAlimentos, aunque no la dibuje.
// #macro PAUV_ProcesadorAlimentosRecipiente( FraccionEncendido, BanderaTapa,
//         BanderaCuchilla, AnguloGirar,
//         DiametroRecipiente, DiametroDecorativo, AlturaBase,
//         BaseTransparente, GruesoTransparente, GruesoCilindroMetal,
//         MaterialRecipiente, TexturaCilindroGiro, TexturaCuchilla, TexturaFilo )
//      FraccionEncendido       : Valor entre 0.0 y 1.0 para indicar el giro
//              de la tapa para encender el aparato.  Utilice cero para apagado.
//      BanderaTapa             : "on" dibuja la tapa, "off" no la dibuja.  La macro
//              no dibuja la tapa si no dibuja el recipiente. 
//      BanderaCuchilla         : "on" dibuja las cuchillas y el cilindro soporte;
//              "off" no los dibuja.  Valor "on" por default.
//      AnguloGirar             : Angulo para girar el rotor central y la barrita
//              de metal que le sirve de soporte.            
//      DiametroRecipiente      : Corresponde al diametro de recipiente.  
//              Default es 67.9*L, el mismo DiametroMayor de PAUV_ProcesadorAlimentos.
//      DiametroDecorativo      : Diametro guia para decoraciones inferiores y ancho
//              de placas.  Default es 14.3*L.
//      AlturaBase              : Altura guia para la base soporte y el recipiente.
//              Default es 71.5*L.
//      BaseTransparente        : Altura del cilindro segundario que sirve para
//              acomodar el recipiente firmemente a la base.
//              Default es 8.0*L.
//      GruesoTransparente      : Grueso principal de las laminas del recipiente.
//              Default es 1.43*L.
//      GruesoCilindroMetal     : Grueso referencia para el cilindro metalico de
//              la base que empuja el giro.  Default es 3.5*L.  
//      MaterialRecipiente      : Material para aplicar al recipiente.
//              Default es PAUV_MaterialRecipiente.
//      TexturaCilindroGiro     : Textura para el cilindro soporte de cuchillas.
//              Default es PAUV_TexturaCilindroGiro.
//      TexturaCuchilla         : Textura principal de la cuchilla.
//              Default es PAUV_TexturaCuchilla.
//      TexturaFilo             : Por diferencia se aplica una textura al filo.
//              Default es PAUV_TexturaFilo.
//   
// La siguiente macro dibuja solo la tapa.
// #macro PAUV_ProcesadorAlimentosTapa(
//                DiametroRecipiente, AlturaBase, DiametroDecorativo,
//                GruesoTransparente, GruesoCilindroMetal, MaterialRecipiente )
//      DiametroRecipiente      : Corresponde al diametro de recipiente.  
//              Default es 67.9*L, el mismo DiametroMayor de PAUV_ProcesadorAlimentos.
//      AlturaBase              : Altura guia para la base soporte y el recipiente.
//              Default es 71.5*L.
//      DiametroDecorativo      : Diametro guia para decoraciones inferiores y ancho
//              de placas.  Default es 14.3*L.
//      GruesoTransparente      : Grueso principal de las laminas del recipiente.
//              Default es 1.43*L.
//      GruesoCilindroMetal     : Grueso referencia para el cilindro metalico de
//              la base que empuja el giro.  Default es 3.5*L.  
//      MaterialRecipiente      : Material para aplicar al recipiente.
//              Default es PAUV_MaterialRecipiente.
// 
// La siguiente macro dibuja solo las cuchillas.
// #macro PAUV_ProcesadorAlimentosCuchilla(
//          DiametroRecipiente, AlturaBase, BaseCuchilla, GruesoCilindroMetal,
//          TexturaCilindroGiro, TexturaCuchilla, TexturaFilo )
//      DiametroRecipiente      : Corresponde al diametro de recipiente.  
//              Default es 67.9*L, el mismo DiametroMayor de PAUV_ProcesadorAlimentos.
//      AlturaBase              : Altura guia para la base soporte y el recipiente.
//              Default es 71.5*L.
//      BaseCuchilla            : Altura de la cuchilla dentro del recipiente que sirve para
//              estimar un tamano apropiado.  La cuchillla, sin embargo, se dibujara
//              sobre el origen.  Corresponde a BaseTransparente+GruesoTransparente.
//              Default es 9.43*L.
//      GruesoCilindroMetal     : Grueso referencia para el cilindro metalico de
//              la base que empuja el giro.  Default es 3.5*L.  
//      TexturaCilindroGiro     : Textura para el cilindro soporte de cuchillas.
//              Default es PAUV_TexturaCilindroGiro.
//      TexturaCuchilla         : Textura principal de la cuchilla.
//              Default es PAUV_TexturaCuchilla.
//      TexturaFilo             : Por diferencia se aplica una textura al filo.
//              Default es PAUV_TexturaFilo.
//
// El aparato por defecto tiene las siguientes dimensiones:
//      Minimo                  = <-83.5, 0  , -68 >*L
//      Maximo                  = < 68  , 86.2, 57 >*L
// El cilindro de giro se centra sobre el origen del plano XZ, en forma perpendicular.
// El eje Y es el centro de los giros.  Note que descansa sobre dicho plano.  
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare PAUV_PosicionRecipiente
//      Vector que sirve para ubicar el recipiente.  Se genera en las macros pertinentes;
//      aunque se ordene no dibujarlo.  Por ejemplo podria llamar
//      a PAUV_ProcesadorAlimentos y no dibujar el recipiente, y solo obtener
//      su posicion inicial para una animacion del recipiente.
// #declare PAUV_PosicionTapa
//      Vector que sirve para ubicar la tapa.  Se genera en las macros pertinentes.
// #declare PAUV_PosicionCuchilla              
//      Vector que sirve para ubicar las cuchillas.  Se genera en las macros pertinentes.  
// #declare PAUV_DefaultTexturaBase             
//      Textura principal de la base.
// #declare PAUV_DefaultTexturaLabel            
//      Textura superior de la base.  Se utiliza para
//      ubicar la etiqueta "on" , "off" con color transparente GIF.
// #declare PAUV_DefaultTexturaLabelBaseGiro    
//      Textura de la base de giro.  Se utiliza para
//      pintar la base de giro con signos de ajuste de recipiente,
//      utiliza color transparente GIF.  
// #declare PAUV_DefaultTexturaMetal            
//      Textura a aplicar al cilindro guia de giro, anclado a la base.  
// #declare PAUV_DefaultTexturaPatas            
//      Textura de las patillas soporte.
// #declare PAUV_DefaultMaterialRecipiente      
//      Material para aplicar al recipiente.
// #declare PAUV_DefaultTexturaCilindroGiro     
//      Textura para el cilindro soporte de cuchillas.
// #declare PAUV_DefaultTexturaCuchilla         
//      Textura principal de la cuchilla.
// #declare PAUV_DefaultTexturaFilo             
//      Por diferencia se aplica una textura al filo.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default)
// #declare PAUV_TexturaBase                            = texture  { ... }           
//      Textura principal de la base.
// #declare PAUV_TexturaLabel                           = texture  { ... } 
//      Textura superior de la base.  Se utiliza para
//      ubicar la etiqueta "on" , "off" con color transparente GIF.
// #declare PAUV_TexturaLabelBaseGiro                   = texture  { ... } 
//      Textura de la base de giro.  Se utiliza para
//      pintar la base de giro con signos de ajuste de recipiente,
//      utiliza color transparente GIF.  
// #declare PAUV_TexturaMetal                           = texture  { ... } 
//      Textura a aplicar al cilindro guia de giro, anclado a la base.  
// #declare PAUV_TexturaPatas            
//      Textura de las patillas soporte.
// #declare PAUV_MaterialRecipiente                     = material { ... } 
//      Material para aplicar al recipiente.
// #declare PAUV_TexturaCilindroGiro                    = texture  { ... } 
//      Textura para el cilindro soporte de cuchillas.
// #declare PAUV_TexturaCuchilla                        = texture  { ... } 
//      Textura principal de la cuchilla.
// #declare PAUV_TexturaFilo             
//      Por diferencia se aplica una textura al filo.   = texture  { ... } 
// #declare PAUV_POV3_1                                 = off;
//      Valor on activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo simplemente
// #include "PAUV.inc"
// object        { PAUV_ProcesadorAlimentos( 0, 0, on, on ) }
//
// Otro ejemplo con las macros detalladas:
// #include "PAUV.inc"    
// union                        {    
//   object                     {
//     PAUV_ProcesadorAlimentosBase( 0, 0.0679, 0.0607, 0.046, 0.0143, 
//                 0.0715, 0.0536, 0.00715, 0.008, 0.00143, 0.0035,
//                 PAUV_TexturaBase, PAUV_TexturaLabel, PAUV_TexturaLabelBaseGiro,
//                 PAUV_TexturaMetal, PAUV_TexturaPatas )       
//   }                   
//   #declare PosRecipiente     = PAUV_PosicionRecipiente;  
//   #declare PosTapa           = PAUV_PosicionTapa;      
//   #declare PosCuchilla       = PAUV_PosicionCuchilla;
//   object                     {   
//     PAUV_ProcesadorAlimentosTapa( 0.0679, 0.0715, 0.0143, 0.00143, 0.0035,
//                  PAUV_MaterialRecipiente )
//     translate                PosTapa
//   }                                       
//   object                     {
//     PAUV_ProcesadorAlimentosCuchilla( 0.0679, 0.0715, 0.00943, 0.0035,
//                PAUV_TexturaCilindroGiro, PAUV_TexturaCuchilla, PAUV_TexturaFilo ) 
//     translate                PosCuchilla
//   }
//   object                     {
//     PAUV_ProcesadorAlimentosRecipiente( 0, off, off, 0, 0.0679, 0.0143, 0.0715,
//                 0.008, 0.00143, 0.0035, PAUV_MaterialRecipiente,
//                 PAUV_TexturaCilindroGiro, PAUV_TexturaCuchilla, PAUV_TexturaFilo )
//     translate                PosRecipiente
//   }                                                
// }
//
// O bien con modificadores:
// #include "PAUV.inc"                         
// #include "textures.inc"
// #declare PAUV_TexturaBase    = PinkAlabaster
// object                       {
//   PAUV_ProcesadorAlimentos( 0, 0, on, on )
// }
//

#include "colors.inc"
#include "textures.inc" 
#include "metals.inc"
#include "PAUV_AU1.inc"
        
#if ( version < 3.2 )
  #ifndef( PAUV_POV3_1 )
    #declare PAUV_POV3_1        = on;
  #end
#else
  #ifndef( PAUV_POV3_1 )
    #declare PAUV_POV3_1        = off;
  #end
#end

#declare PAUV_L                 = 0.001;

#declare PAUV_DefaultTexturaBase        =
  texture                               {
    pigment { White }
    normal  { bumps  scale 1 }
    finish  { metallic }
  }

#ifndef ( PAUV_TexturaBase )
  #declare PAUV_TexturaBase             = PAUV_DefaultTexturaBase
#end  // #ifndef ( PAUV_TexturaBase )  

#declare PAUV_DefaultTexturaLabel       =
  texture                               {
    pigment { White }
    normal  { bumps  scale 1 }
    finish  { metallic }
  }   
  texture                               {   
    pigment                             {    
      image_map                         { 
        gif   "PAUV_LA1.gif"
        transmit   0, 1  
        once
      }                     
      translate         -0.5
      rotate            90*x 
      rotate            -90*y
      scale             2
    }
  }
    
#ifndef ( PAUV_TexturaLabel )        
  #declare PAUV_TexturaLabel            = PAUV_DefaultTexturaLabel
#end  // #ifndef ( PAUV_TexturaLabel )  

#declare PAUV_DefaultTexturaLabelBaseGiro       =
  texture                               {
    pigment { White }
    normal  { bumps  scale 1 }
    finish  { metallic }
  }   
  texture                               {   
    pigment                             {    
      image_map                         { 
        gif   "PAUV_LA2.gif"
        transmit   0, 1  
        once
      }                     
      translate         -0.5
      rotate            90*x 
      rotate            -90*y
      scale             2
    }
  }
    
#ifndef ( PAUV_TexturaLabelBaseGiro )        
  #declare PAUV_TexturaLabelBaseGiro            = PAUV_DefaultTexturaLabelBaseGiro
#end  // #ifndef ( PAUV_TexturaLabel )  
    
    
#declare PAUV_DefaultTexturaMetal       =
  texture                               { 
    T_Chrome_3B
    normal  { bumps 0.1 scale 0.1 }
  }

#ifndef ( PAUV_TexturaMetal )
  #declare PAUV_TexturaMetal            = PAUV_DefaultTexturaMetal
#end  // #ifndef ( PAUV_TexturaMetal )

#declare PAUV_DefaultTexturaCilindroGiro   =
  texture                               {
    pigment { White }
    normal  { bumps 2 scale 0.1 }
  }

#ifndef ( PAUV_TexturaCilindroGiro )
  #declare PAUV_TexturaCilindroGiro         = PAUV_DefaultTexturaCilindroGiro
#end  // #ifndef ( PAUV_TexturaCilindroGiro )

#declare PAUV_DefaultTexturaCuchilla    =
  texture                               {
    T_Chrome_3B
    normal  { bumps 0.1 scale 0.1 }
  }

#ifndef ( PAUV_TexturaCuchilla )
  #declare PAUV_TexturaCuchilla         = PAUV_DefaultTexturaCuchilla
#end  // #ifndef ( PAUV_TexturaMetal )

#declare PAUV_DefaultTexturaFilo        =
  texture                               {
    T_Chrome_4B
    normal  { bumps 0.1 scale 0.1 }
  }

#ifndef ( PAUV_TexturaFilo )
  #declare PAUV_TexturaFilo             = PAUV_DefaultTexturaFilo
#end  // #ifndef ( PAUV_TexturaMetal )

#declare PAUV_DefaultTexturaPatas       =
  texture                               {
    pigment { Gray30 }
    normal  { bumps 2 scale 0.1 }
  }

#ifndef ( PAUV_TexturaPatas )
  #declare PAUV_TexturaPatas            = PAUV_DefaultTexturaPatas
#end  // #ifndef ( PAUV_TexturaPatas )

#declare PAUV_DefaultMaterialRecipiente =
  material                              {
    texture                             {
      NBglass                             }
  }

#ifndef ( PAUV_MaterialRecipiente )
  #declare PAUV_MaterialRecipiente      = PAUV_DefaultMaterialRecipiente
#end  // #ifndef( PAUV_MaterialRecipiente )

#macro PAUV_ProcesadorAlimentosBase( AnguloGirar,
   DiametroMayor, DiametroMenor, DistanciaCircular, DiametroDecorativo,
   AlturaBase, DiametroSuperior, DecorativoSuperior,
   BaseTransparente, GruesoTransparente, GruesoCilindroMetal,
   TexturaBase, TexturaLabel, TexturaLabelBaseGiro, TexturaMetal, TexturaPatas )
  union                                 {
    #local AnguloGuiaR                  =
      asin( 0.5*( DiametroMayor-DiametroMenor )/DistanciaCircular );
    #local PuntoGuia                    =
                <-sin(AnguloGuiaR),0,cos(AnguloGuiaR)>;
    #local PuntoGuiaPr                  = < PuntoGuia.x, PuntoGuia.z >;
    #local RadioDiferencia              =
             DiametroMayor/2+DiametroDecorativo/2;
    // Base Inferior
    union                               {
      // Placa Inferior
      #local FactorUnder                = 11.4/14.3;
      union                             {
        // Placa Inferior capa sobre
        #local C                        = 0;
        #while ( C < 2 )
          #if ( C = 0 )
            #local FD                   = FactorUnder;
          #else  // #else ( C = 0 )
            #local FD                   = 1.0;
          #end   // #else ( C = 0 )
          difference                      {
            union                         {
              torus                       {
                DiametroMayor/2, DiametroDecorativo*FD/2
              }
              cylinder                    {
                0, DiametroDecorativo*FD/2*y, DiametroMayor/2
              }
              cylinder                    {
                PuntoGuia*DiametroMayor/2,
                PuntoGuia*DiametroMenor/2-DistanciaCircular*x,
                DiametroDecorativo*FD/2
              }
              cylinder                    {
                PuntoGuia*DiametroMayor/2,
                PuntoGuia*DiametroMenor/2-DistanciaCircular*x,
                DiametroDecorativo*FD/2
                scale                     <1,1,-1>
              }
              torus                       {
                DiametroMenor/2, DiametroDecorativo*FD/2
                translate                 -DistanciaCircular*x
              }
              cylinder                    {
                0, DiametroDecorativo*FD/2*y, DiametroMenor/2
                translate                 -DistanciaCircular*x
              }
              prism                       {
                0,
                DiametroDecorativo*FD/2
                5,
                PuntoGuiaPr*DiametroMayor/2,
                PuntoGuiaPr*DiametroMayor*<1,-1>/2,
                PuntoGuiaPr*DiametroMenor*<1,-1>/2-DistanciaCircular*<1,0>,
                PuntoGuiaPr*DiametroMenor/2-DistanciaCircular*<1,0>,
                PuntoGuiaPr*DiametroMayor/2
              }
            }
            // Lo define como capa sobre
            plane                         {
              y, 0
            }
            #if ( C = 0 )
              scale                     <1,-1,1>
            #end  // #if ( C = 0 )
          }
          #local C                      = C+1;
        #end  //  #while ( C < 2 )
        // Placa inferior capa under
        texture                         {
          TexturaBase
        }
      }
      // Patitas de base inferior
      #local C                          = 0;
      #while ( C < 4 )
        union                           {
          difference                    {
            sphere                      {
              0, 1
              scale             < DiametroDecorativo/3,
                                  3*DiametroDecorativo/4,
                                  DiametroDecorativo/3 >
            }
            plane                       {
              -y, 0
            }
            plane                       {
              y, 0
              translate                 -4*DiametroDecorativo/8*y
            }
            texture                     {
              TexturaBase
            }
          }
          cylinder                      {
            0, -9*DiametroDecorativo/17*y,
            DiametroDecorativo/4
            texture { TexturaPatas }
          }
          #if ( C > 1 )
            translate         PuntoGuia*DiametroMayor/2
          #else
            translate         PuntoGuia*DiametroMenor/2
          #end
          #if ( mod( C, 2 ) = 0 )
            scale                       <1,1,-1>
          #end  // #if ( mod( C, 2 ) = 0 )
          #if ( C > 1 )
            scale                       <-1,1,1>
          #else  // #else ( C > 1 )
            translate                   -DistanciaCircular*x
          #end   // #else ( C > 1 )

        }
        #local C                        = C+1;
      #end  // #while ( C < 3 )
    }  // Fin Base Inferior
    // Base Alta
    union                               {
      // La Base Alta requiere espacio para el recipiente
      difference                        {
        union                           {
          cone                          {
            0, DiametroMenor/2+FactorUnder*DiametroDecorativo/2,
            AlturaBase*y,
            DiametroSuperior/2+DecorativoSuperior/2
            translate                   -DistanciaCircular*x
          }
          #local FactorCompresion       =
            ( DiametroSuperior/2+DecorativoSuperior/2 )/
            ( DiametroMenor/2+FactorUnder*DiametroDecorativo/2 );
          prism                         {
            conic_sweep
            FactorCompresion,
            1,
            4,
            PuntoGuiaPr*( DiametroMayor/2+FactorUnder*DiametroDecorativo/2 )
            +<DistanciaCircular,0>,
            PuntoGuiaPr*( DiametroMenor/2+FactorUnder*DiametroDecorativo/2 ),
            PuntoGuiaPr*<1,-1>*
            ( DiametroMenor/2+FactorUnder*DiametroDecorativo/2 ),
            PuntoGuiaPr*<1,-1>*
            ( DiametroMayor/2+FactorUnder*DiametroDecorativo/2 )
            +<DistanciaCircular,0>
            translate           -y-DistanciaCircular*x
            scale               <1,-AlturaBase/(1-FactorCompresion),1>
          }
          sphere                        {
            0, 1
            texture                     {  
              TexturaLabel
            }
            scale <DiametroSuperior/2,DecorativoSuperior,DiametroSuperior/2>  
            translate                   AlturaBase*y-DistanciaCircular*x
          }
          object                        {
            PAUV_SweepTriplePunto
              ( PuntoGuia*DiametroSuperior/2, -DiametroSuperior/2*x,
                PuntoGuia*<1,1,-1>*DiametroSuperior/2,
                DecorativoSuperior/2, true )
            translate                   AlturaBase*y-DistanciaCircular*x
          }
          cylinder                      {
            PuntoGuia*DiametroSuperior/2-DistanciaCircular*x,
            PuntoGuia*DiametroSuperior*DiametroMayor/DiametroMenor/2,
            DecorativoSuperior/2
            translate                   AlturaBase*y
          }
          cylinder                      {
            PuntoGuia*DiametroSuperior/2-DistanciaCircular*x,
            PuntoGuia*DiametroSuperior*DiametroMayor/DiametroMenor/2,
            DecorativoSuperior/2
            scale                       <1,1,-1>
            translate                   AlturaBase*y
          }
        }
        // Crea espacio para el recipiente
        cylinder                        {
          0, 2*AlturaBase*y, RadioDiferencia
        }
        box                             {
          <-DiametroMayor-DistanciaCircular,0,-DiametroMayor>,
          <0,DecorativoSuperior/10,DiametroMayor>
          translate                     0.9*AlturaBase*y
        }
        difference                      {
          union                         {
            torus                       {
              1.1*RadioDiferencia, 0.1*RadioDiferencia
            }
            cylinder                    {
              -0.05*RadioDiferencia*y, 0.05*RadioDiferencia*y,
              1.05*RadioDiferencia
            }
            translate                   0.9*AlturaBase*y
          }
          plane                         {
            -z, 0
          }
        }
      }
      difference                        {
        cylinder                          {
          0, AlturaBase*y, DiametroSuperior/2
          translate                       -DistanciaCircular*x
        }
        cylinder                        {
          0, 2*AlturaBase*y, RadioDiferencia
        }
      }
      texture                           {
        TexturaBase
      }
    }  // Fin Base Alta
    // Base Recipiente
    difference                          {
      superellipsoid                    {
        <1.0,0.1>
        rotate                  90*x
        texture                           {
          TexturaLabelBaseGiro
        }
        scale                   < DiametroMayor/2-1.1*GruesoTransparente,
                                  BaseTransparente,
                                  DiametroMayor/2-1.1*GruesoTransparente >
      }
      cone                          {
        0, DiametroMayor/6,
        BaseTransparente*y, DiametroMayor/3
        translate                   BaseTransparente/2*y
      }
      difference                    {
        cylinder                    {
          0, BaseTransparente*y, DiametroMayor/2
        }
        plane                       {
          -x, 0
          rotate                    -45*z
          rotate                    80*y
        }
        plane                       {
          x, 0
          rotate                    45*z
          rotate                    110*y
        }
        translate                   BaseTransparente/2*y
      }
      plane                         {
        y, 0
      }
      #local C                          = 0;
      #while ( C < 2 )
        union                           {
          difference                    {
            cylinder                    {
             -0.01*BaseTransparente*y, 1.005*BaseTransparente/2*y
              DiametroMayor/2
            }
            cylinder                    {
              -0.02*BaseTransparente*y, 1.01*BaseTransparente/2*y,
              DiametroMayor/2-2.1*GruesoTransparente
            }
            plane                     {
              -x, 0
            }
            plane                     {
              x, 0
              rotate                  -30*y
            }
          }
          difference                    {
            cylinder                    {
             -0.01*BaseTransparente*y, 1.005*BaseTransparente/2*y
              DiametroMayor/2
            }
            cylinder                    {
              -0.02*BaseTransparente*y, 1.01*BaseTransparente/2*y,
              DiametroMayor/2-2.1*GruesoTransparente
            }
            plane                     {
              -x, 0
            }
            plane                     {
              x, 0
              rotate                  -15*y
            }
            rotate                      -15*y
            translate                   BaseTransparente/2*y
          }
          #if ( C = 1 )
            scale                       <-1,1,-1>
          #end  // #if ( C = 1 )
        }
        #local C                        = C+1;
      #end  // #while ( C < 2 )
      plane                             {
        x, 0
        translate               -0.30*DiametroMayor*x
      }     
      texture                           {  
        TexturaBase
      }
      translate                       DiametroDecorativo/2*y
    }
    // Cilindro Metal
    union                               {
      cylinder                          {
        0, 0.75*AlturaBase*y, GruesoCilindroMetal/2
      }
      cylinder                          {
        0, 1.5*BaseTransparente*y, GruesoCilindroMetal
      }
      cylinder                          {
        -GruesoCilindroMetal/4*z, GruesoCilindroMetal/4*z,
        GruesoCilindroMetal
        translate               0.5*AlturaBase*y
      }
      cone                              {
        3*BaseTransparente/4*y, DiametroMayor/8,
        BaseTransparente*y, DiametroMayor/10
      }
      texture                           {
        TexturaMetal
      }
      rotate                            AnguloGirar*y
      translate                         DiametroDecorativo/2*y
    }
    translate           9*DiametroDecorativo/17*y 
    #declare PAUV_PosicionRecipiente    = 9*DiametroDecorativo/17*y+
                        1.01*DiametroDecorativo/2*y;
    #declare PAUV_PosicionTapa          = ( 0.9*AlturaBase-DiametroDecorativo/2 )*y
                        +PAUV_PosicionRecipiente;
    #declare PAUV_PosicionCuchilla      = ( BaseTransparente+GruesoTransparente )*y
                        +PAUV_PosicionRecipiente; 
  }
#end  // #macro PAUV_ProcesadorAlimentosUtilVegetales

#macro PAUV_ProcesadorAlimentosTapa(
                DiametroRecipiente, AlturaBase, DiametroDecorativo,
                GruesoTransparente, GruesoCilindroMetal,
                MaterialRecipiente )
  union                                 {
    #local RadioDiferencia              =
             DiametroRecipiente/2+DiametroDecorativo/2;
    // Boton
    difference                          {
      union                             {
        torus                           {
          1.1*RadioDiferencia, 0.075*RadioDiferencia
        }
        cylinder                        {
          0, 0.0375*RadioDiferencia*y, 1.1*RadioDiferencia
        }
      }
      torus                           {
        1.1*RadioDiferencia, 0.050*RadioDiferencia
      }
      cylinder                          {
        -0.1*RadioDiferencia, 0.1*RadioDiferencia, DiametroRecipiente/2
      }
      plane                             {
        z, 0
      }
      plane                             {
        -z, 0
        rotate          -30*y
      }
    }
    // Cilindro cuerpo
    difference                          {
      cylinder                          {
        0, 0.1*AlturaBase*y, DiametroRecipiente/2
      }
      cylinder                          {
        -0.1*AlturaBase*y, 0.2*AlturaBase*y,
        DiametroRecipiente/2-0.4*GruesoTransparente
      }
    }
    difference                          {
      union                             {
        difference                      {
          torus                         {
            DiametroRecipiente/2-2*GruesoTransparente,
            2*GruesoTransparente
          }
          torus                         {
            DiametroRecipiente/2-2*GruesoTransparente,
            3*GruesoTransparente/2
          }
          plane                         {
            y, 0
          }
        }
        difference                      {
          sphere                        {
            0, DiametroRecipiente/2-7*GruesoTransparente/2
          }
          sphere                        {
            0, DiametroRecipiente/2-4*GruesoTransparente
          }
          cylinder                      {
            0, -DiametroRecipiente*y, 1.1*GruesoCilindroMetal
          }
          plane                         {
            -y,0
          }
          scale                 <1,0.2*AlturaBase/DiametroRecipiente,1>
        }
      }
      translate                         0.1*AlturaBase*y
    }
    difference                          {
      intersection                        {
        cylinder                          {
          -0.1*DiametroRecipiente*z, 0.1*DiametroRecipiente*z,
          DiametroRecipiente/2-7*GruesoTransparente/2
        }
        union                           {
          plane                         {
            -y, 0
          }
          difference                              {
            sphere                            {
              0, DiametroRecipiente/2-7*GruesoTransparente/2
            }
            plane                         {
              -y, 0
            }
          }
        }
      }
      cylinder                          {
        ( -0.1*DiametroRecipiente+GruesoTransparente/2 )*z,
        (  0.1*DiametroRecipiente-GruesoTransparente/2 )*z,
        DiametroRecipiente/2-8*GruesoTransparente/2
      }
      
      scale                 <1,0.2*AlturaBase/DiametroRecipiente,1>
      translate                         0.1*AlturaBase*y
    }
    rotate                  140*y  
    material                            {
      MaterialRecipiente
    }         
    #declare PAUV_PosicionTapa          = <0,0,0>;
  }
#end  // #macro PAUV_ProcesadorAlimentosTapa

#macro PAUV_ProcesadorAlimentosCuchilla(
   DiametroRecipiente, AlturaBase, BaseCuchilla, GruesoCilindroMetal,
   TexturaCilindroGiro, TexturaCuchilla, TexturaFilo )
  union                          {
    #local C                    = 0;
    #while ( C < 2 )
      union                             {
        intersection                       {
          cylinder                            {
            -0.01*AlturaBase*y, 0.011*AlturaBase*y, 0.3*DiametroRecipiente
            translate         0.1*DiametroRecipiente*x
          }
          difference                          {
            cylinder                          {
              0, 0.01*AlturaBase*y, 0.3*DiametroRecipiente
            }
            cylinder                          {
              -0.01*AlturaBase*y, 0.02*AlturaBase*y, 0.3*DiametroRecipiente
              translate               0.1*DiametroRecipiente*z
            }
            cone                              {
              0, 0.3*DiametroRecipiente,
              0.011*AlturaBase*y, 0.27*DiametroRecipiente
              inverse
              texture                         {
                TexturaFilo
              }
            }
          }
          texture                           {
            TexturaCuchilla
          }
          translate                 +0.150*DiametroRecipiente*z
        }
        cylinder                        {
          -0.01*AlturaBase*y, 0.02*AlturaBase*y, 2.5*GruesoCilindroMetal
          texture                       {
            TexturaCilindroGiro
          }
        }
        #if ( C = 0 )
          scale                 <-1,-1,-1>
          translate             0.03*AlturaBase*y
        #else  // #else ( C = 0 )
          translate            -0.03*AlturaBase*y
        #end   // #else ( C = 0 )
        translate                   0.05*AlturaBase*y
      }
      #local C                  = C+1;
    #end  // #while ( C < 2 )
    difference                  {
      union                     {
        cylinder                {
          0.1*AlturaBase*y,
            ( 0.9*AlturaBase-BaseCuchilla )*y, GruesoCilindroMetal*1.25
        }
        cone                    {
          0, 2.25*GruesoCilindroMetal,
          ( 0.8*AlturaBase-BaseCuchilla )*y, 2.05*GruesoCilindroMetal
        }
      }
      cylinder                  {
        0, AlturaBase*y, 0.5*GruesoCilindroMetal
      }
      #local C                  = 0;
      #while ( C < 12 )
        cylinder                {
          0.2*AlturaBase*y, AlturaBase*y, 0.2*GruesoCilindroMetal
          translate             2.25*GruesoCilindroMetal*z
          rotate                360*C/12*y
        }
        #local C                = C+1;
      #end  // #while ( C < 12 )
      texture                   {
        TexturaCilindroGiro
      }
    }    
    #declare PAUV_PosicionCuchilla              = <0,0,0>;
  }
#end  // #macro PAUV_ProcesadorAlimentosCuchilla

#macro PAUV_ProcesadorAlimentosRecipiente( FraccionEncendido, BanderaTapa,
        BanderaCuchilla, AnguloGirar,
        DiametroRecipiente, DiametroDecorativo, AlturaBase,
        BaseTransparente, GruesoTransparente,
        GruesoCilindroMetal,
        MaterialRecipiente,
        TexturaCilindroGiro, TexturaCuchilla, TexturaFilo )
  union                                 {
    // Cuerpo Principal
    union                               {
      difference                        {
        cylinder                        {
          0, 0.99*AlturaBase*y-DiametroDecorativo/2*y, DiametroRecipiente/2
        }
        cylinder                        {
          -0.1*AlturaBase*y, AlturaBase*y,
          DiametroRecipiente/2-GruesoTransparente
        }
        difference                      {
          cylinder                        {
            0, 0.3*AlturaBase*y, 1.1*DiametroRecipiente/2
          }
          cylinder                      {
            -0.1*AlturaBase*y, 0.5*AlturaBase*y,
            DiametroRecipiente/2-GruesoTransparente/2
          }
          translate                     0.89*AlturaBase*y  
          translate                     -DiametroDecorativo/2*y
        }
      }
      difference                        {
        cylinder                        {
          0, GruesoTransparente*y, DiametroRecipiente/2
        }
        cylinder                        {
          -GruesoTransparente*y, 2*GruesoTransparente*y,
          2*GruesoCilindroMetal
        }
        translate                       BaseTransparente*y
      }
      difference                        {
        cylinder                        {
          0, 0.7*AlturaBase*y,
          2*GruesoCilindroMetal
        }
        cylinder                        {
          -GruesoTransparente*y, 0.8*AlturaBase*y,
          2*GruesoCilindroMetal-GruesoTransparente
        }
        translate                       BaseTransparente*y
      }
      material                          {
        MaterialRecipiente
      }
    }  // Cuerpo principal
    // Tapa
    #if ( BanderaTapa )
      object                            {
        PAUV_ProcesadorAlimentosTapa(
          DiametroRecipiente, AlturaBase, DiametroDecorativo,
          GruesoTransparente, GruesoCilindroMetal,
          MaterialRecipiente )                
        rotate                          FraccionEncendido*25*y  
        translate                   ( 0.9*AlturaBase-DiametroDecorativo/2 )*y 
      }
    #end  // #if ( BanderaTapa )
    #if ( BanderaCuchilla )
      object                            {
        PAUV_ProcesadorAlimentosCuchilla(
          DiametroRecipiente, AlturaBase, BaseTransparente+GruesoTransparente,
          GruesoCilindroMetal, TexturaCilindroGiro,
          TexturaCuchilla, TexturaFilo )
        translate       ( BaseTransparente+GruesoTransparente )*y
        rotate                          AnguloGirar*y
      }
    #end  // #if ( BanderaCuchilla )  
    #declare PAUV_PosicionTapa          = ( 0.9*AlturaBase-DiametroDecorativo/2 )*y;
    #declare PAUV_PosicionCuchilla      = ( BaseTransparente+GruesoTransparente )*y; 
    #declare PAUV_PosicionRecipiente    = <0,0,0>;
  }
#end  // #macro PAUV_ProcesadorAlimentosRecipiente

#macro PAUV_ProcesadorAlimentos( FraccionEncendido, AnguloGirar, BanderaRecipiente, BanderaTapa )
  union                                 {
    #local L                    = PAUV_L;
    #local DiametroMayor        = 67.9*L;
    #local DiametroMenor        = 60.7*L;
    #local DistanciaCircular    = 46.0*L;
    #local DiametroDecorativo   = 14.3*L;
    #local AlturaBase           = 71.5*L;
    #local DiametroSuperior     = 53.6*L;
    #local DecorativoSuperior   = 7.15*L;
    #local BaseTransparente     = 8.0*L;
    #local GruesoTransparente   = 1.43*L;
    #local GruesoCilindroMetal  = 3.5*L;    
    PAUV_ProcesadorAlimentosBase( AnguloGirar,
      DiametroMayor, DiametroMenor, DistanciaCircular, DiametroDecorativo, 
      AlturaBase, DiametroSuperior, DecorativoSuperior,
      BaseTransparente, GruesoTransparente,
      GruesoCilindroMetal,
      PAUV_TexturaBase, PAUV_TexturaLabel, PAUV_TexturaLabelBaseGiro,
      PAUV_TexturaMetal, PAUV_TexturaPatas )       
    #if ( BanderaRecipiente )
      object                  {
        PAUV_ProcesadorAlimentosRecipiente( FraccionEncendido, BanderaTapa,
          on, AnguloGirar,
          DiametroMayor, DiametroDecorativo, AlturaBase,
          BaseTransparente, GruesoTransparente,
          GruesoCilindroMetal,
          PAUV_MaterialRecipiente,
          PAUV_TexturaCilindroGiro, PAUV_TexturaCuchilla, PAUV_TexturaFilo )
        translate               1.01*DiametroDecorativo/2*y
        translate               9*DiametroDecorativo/17*y 
      }
    #end  // #if ( BanderaRecipiente )
    #declare PAUV_PosicionRecipiente    = 9*DiametroDecorativo/17*y+
                        1.01*DiametroDecorativo/2*y;
    #declare PAUV_PosicionTapa          = ( 0.9*AlturaBase-DiametroDecorativo/2 )*y
                        +PAUV_PosicionRecipiente;
    #declare PAUV_PosicionCuchilla      = ( BaseTransparente+GruesoTransparente )*y
                        +PAUV_PosicionRecipiente; 
  }
#end  // #macro PAUV_ProcesadorAlimentos


