// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  29 julio 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// MTAE MapaTierraAproximacionEsferica 
// El archivo dibuja un mapa esferico de la tierra para escritorio.  
// Tiene una macro para modificar algunas caractersticas fundamentales.
// Es compatible con POVRay 3.1, pero las aproximaciones deforman el mapa
// de forma intolerable para uso acadmico.
//
// La macro principal tiene unicamente un parametro
// #macro MTAE_MapaTierra( AnguloRotar )
//      AnguloRotar             : Angulo en grados para rotar la esfera.       
//
// Si desea un mayor control sobre las caracteristicas, puede usar la
// siguiente macro.
// #macro MTAE_MapaTierraAproximacionEsferica( AnguloRotar, AnguloInclinacion,
//        DiametroFundamental, DiametroSoporte, GruesoSoporte, AlturaBase, DiametroBase,
//        TexturaEsfera, TexturaSoporte, TexturaRadial, TexturaBase )
//      AnguloRotar             : Angulo en grados para rotar la esfera.
//      AnguloInclinacion       : Angulo de inclinacion del eje de rotacion.
//              Default es el dato astronomico 23.5.
//      DiametroFundamental     : Diametro de la esfera que sirve de mapa.
//              Default es 154*L.
//      DiametroSoporte         : Diametro del soporte curvo de la estructura.
//              Default es 184*L.
//      GruesoSoporte           : Grueso del soporte curvo.  Default es 8.0*L.
//      AlturaBase              : Altura de la base.  Default es 45*L.
//      DiametroBase            : Diametro de la base circular.  Default es 100*L. 
//      TexturaEsfera           : Textura del mapa.  Default es MTAE_TexturaEsfera. 
//      TexturaSoporte          : Textura del soporte curvo.  Default es MTAE_TexturaSoporte.
//      TexturaRadial           : Textura de los soportes circulares en el eje
//              de rotacion.  En el original traan marcas para el ngulo horario.
//              Default es MTAE_TexturaRadial.
//      TexturaBase             : Textura para aplicar a la base.  
//              Default es MTAE_TexturaBase.
//
// La esfera por defecto tiene las siguientes caracteristicas:   
//      Altura                  : 229*L
//              ( DiametroSoporte+AlturaBase )
//      DiametroSoporte         : 184*L
//      DiametroMapa            : 154*L
// El eje de la base inferior descansa centrado sobre el origen del plano XZ.
// El soporte curvo se orienta hacia X+.  
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare MTAE_DefaultTexturaEsfera 
//      Textura del mapa.
// #declare MTAE_DefaultTexturaSoporte
//      Textura del soporte curvo.
// #declare MTAE_DefaultTexturaRadial
//      Textura de los soportes circulares en el eje de rotacion.
//      En el original traian marcas para el angulo horario. 
// #declare MTAE_DefaultTexturaBase
//      Textura para aplicar a la base.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default) 
// #declare MTAE_GIFImagen                              = "MTAE_IM1.GIF"
//      Contiene el mapa de la Tierra a aplicar a la estructura.
//      Utilice una imagen para uv_mapping en esfera.  No utilice
//      proyeccion Mercator, puede resultar util la camara esferica.
// #declare MTAE_TexturaEsfera                          = texture { ... }
//      Textura del mapa.
// #declare MTAE_TexturaSoporte                         = texture { ... }
//      Textura del soporte curvo.
// #declare MTAE_TexturaRadial                          = texture { ... }
//      Textura de los soportes circulares en el eje de rotacion.
//      En el original traian marcas para el angulo horario. 
// #declare MTAE_TexturaBase                            = texture { ... }
//      Textura para aplicar a la base.
// #declare MTAE_POV3_1                                 = off;
//      Valor on activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente.
//
// Para colocarlo simplemente
// #include "MTAE.inc"
// object        { MTAE_MapaTierra( 0 ) }
//
// Otro ejemplo con modificador
// #include "MTAE.inc"   
// #include "textures"
// object        { MTAE_MapaTierra( 0 ) }
//   
// Ejemplo con la macro detallada, mismo objeto default
// #include "MTAE.inc"
// object        {  
//   MTAE_MapaTierraAproximacionEsferica( 0, 23.5, 0.154, 0.184, 0.008, 0.045, 0.10,
//      MTAE_TexturaEsfera, MTAE_TexturaSoporte, MTAE_TexturaRadial, MTAE_TexturaBase )
// }
//
#include "colors.inc"

#declare OjoAbsoluto            = 256;
#declare VecesCentroAbsoluto    = 10;     
#declare L                      = 0.001;
camera {
        location  <   0,  0, -( VecesCentroAbsoluto+1 )*OjoAbsoluto >*L
        direction z
        sky       y
        angle     38.74
//        look_at  <   0,  0, -VecesCentroAbsoluto*OjoAbsoluto >*L
}         
light_source    {
         < 500  , 500   , -3000 >*L
         White
}  
background      {
         Gray50
}    

#include "MTAE.inc"
  
#declare FactorAcercamiento     = 5.5;  
  
object          {
  MTAE_MapaTierra( 0 )     
  translate           -0.11*y
  translate       -( VecesCentroAbsoluto+1 )*( FactorAcercamiento-1 )
                        /( FactorAcercamiento )*OjoAbsoluto*L*z
}


