// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  29 julio 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// MTAE MapaTierraAproximacionEsferica 
// El archivo dibuja un mapa esferico de la tierra para escritorio.  
// Tiene una macro para modificar algunas caractersticas fundamentales.
// Es compatible con POVRay 3.1, pero las aproximaciones deforman el mapa
// de forma intolerable para uso acadmico.
//
// La macro principal tiene unicamente un parametro
// #macro MTAE_MapaTierra( AnguloRotar )
//      AnguloRotar             : Angulo en grados para rotar la esfera.       
//
// Si desea un mayor control sobre las caracteristicas, puede usar la
// siguiente macro.
// #macro MTAE_MapaTierraAproximacionEsferica( AnguloRotar, AnguloInclinacion,
//        DiametroFundamental, DiametroSoporte, GruesoSoporte, AlturaBase, DiametroBase,
//        TexturaEsfera, TexturaSoporte, TexturaRadial, TexturaBase )
//      AnguloRotar             : Angulo en grados para rotar la esfera.
//      AnguloInclinacion       : Angulo de inclinacion del eje de rotacion.
//              Default es el dato astronomico 23.5.
//      DiametroFundamental     : Diametro de la esfera que sirve de mapa.
//              Default es 154*L.
//      DiametroSoporte         : Diametro del soporte curvo de la estructura.
//              Default es 184*L.
//      GruesoSoporte           : Grueso del soporte curvo.  Default es 8.0*L.
//      AlturaBase              : Altura de la base.  Default es 45*L.
//      DiametroBase            : Diametro de la base circular.  Default es 100*L. 
//      TexturaEsfera           : Textura del mapa.  Default es MTAE_TexturaEsfera. 
//      TexturaSoporte          : Textura del soporte curvo.  Default es MTAE_TexturaSoporte.
//      TexturaRadial           : Textura de los soportes circulares en el eje
//              de rotacion.  En el original traan marcas para el ngulo horario.
//              Default es MTAE_TexturaRadial.
//      TexturaBase             : Textura para aplicar a la base.  
//              Default es MTAE_TexturaBase.
//
// La esfera por defecto tiene las siguientes caracteristicas:   
//      Altura                  : 229*L
//              ( DiametroSoporte+AlturaBase )
//      DiametroSoporte         : 184*L
//      DiametroMapa            : 154*L
// El eje de la base inferior descansa centrado sobre el origen del plano XZ.
// El soporte curvo se orienta hacia X+.  
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare MTAE_DefaultTexturaEsfera 
//      Textura del mapa.
// #declare MTAE_DefaultTexturaSoporte
//      Textura del soporte curvo.
// #declare MTAE_DefaultTexturaRadial
//      Textura de los soportes circulares en el eje de rotacion.
//      En el original traian marcas para el angulo horario. 
// #declare MTAE_DefaultTexturaBase
//      Textura para aplicar a la base.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default) 
// #declare MTAE_GIFImagen                              = "MTAE_IM1.GIF"
//      Contiene el mapa de la Tierra a aplicar a la estructura.
//      Utilice una imagen para uv_mapping en esfera.  No utilice
//      proyeccion Mercator, puede resultar util la camara esferica.
// #declare MTAE_TexturaEsfera                          = texture { ... }
//      Textura del mapa.
// #declare MTAE_TexturaSoporte                         = texture { ... }
//      Textura del soporte curvo.
// #declare MTAE_TexturaRadial                          = texture { ... }
//      Textura de los soportes circulares en el eje de rotacion.
//      En el original traian marcas para el angulo horario. 
// #declare MTAE_TexturaBase                            = texture { ... }
//      Textura para aplicar a la base.
// #declare MTAE_POV3_1                                 = off;
//      Valor on activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente.
//
// Para colocarlo simplemente
// #include "MTAE.inc"
// object        { MTAE_MapaTierra( 0 ) }
//
// Otro ejemplo con modificador
// #include "MTAE.inc"   
// #include "textures"
// object        { MTAE_MapaTierra( 0 ) }
//   
// Ejemplo con la macro detallada, mismo objeto default
// #include "MTAE.inc"
// object        {  
//   MTAE_MapaTierraAproximacionEsferica( 0, 23.5, 0.154, 0.184, 0.008, 0.045, 0.10,
//      MTAE_TexturaEsfera, MTAE_TexturaSoporte, MTAE_TexturaRadial, MTAE_TexturaBase )
// }
//
#include "colors.inc"
#declare MTAE_L                 = 0.001;

#if ( version < 3.2 )
  #ifndef( MTAE_POV3_1 )
    #declare MTAE_POV3_1        = on;
  #end
#else
  #ifndef( MTAE_POV3_1 )
    #declare MTAE_POV3_1        = off;
  #end
#end
                      
#declare MTAE_GIFImagen         = "MTAE_IM1.GIF"                      
                      
#declare MTAE_DefaultTexturaEsfera     =    
    texture                     {
    pigment                     {
      image_map                 { 
        gif MTAE_GIFImagen
      }              
      #if ( MTAE_POV3_1 )
        scale             2*x
        translate         0.5
      #end  // #if ( MTAE_POV3_1 )
    } 
    normal                      {   
      bumps
      scale             0.3
    }
    finish                      {  
      crand             0.5
      phong             0.4
      phong_size        40
      irid              { 0.5 }  
      metallic
    } 
    }
    texture                     {  
      pigment                   {
        gradient y
        scale   0.05
        pigment_map             { 
          [ 0.0 Clear ]
          [ 0.95 Clear ]
          [ 0.95 Clear ]
          [ 1.0 Black ]
        }
      }
    }
    texture                     {   
      pigment                   { 
        gradient x
        scale   0.025
        pigment_map             { 
          [ 0.0 Clear ]
          [ 0.95 Clear ]
          [ 0.95 Clear ]
          [ 1.0 Black ]
        }
      }
    }
  
#ifndef ( MTAE_TexturaEsfera )        
  #declare MTAE_TexturaEsfera           = MTAE_DefaultTexturaEsfera
#end  // #ifndef ( MTAE_TexturaEsfera )    
                                                            
#declare MTAE_DefaultTexturaSoporte     =
  texture                               {   
    pigment                             {  
      color MidnightBlue transmit 0.8
                         
    }
  }                                                            
                                                            
#ifndef ( MTAE_TexturaSoporte )        
  #declare MTAE_TexturaSoporte  = MTAE_DefaultTexturaSoporte
#end  // #ifndef ( MTAE_TexturaSoporte ) 
 
#declare MTAE_DefaultTexturaRadial     =
  texture                               {   
    pigment                             {  
      color Cyan*0.5
                         
    }
  }                                                            
                                                            
#ifndef ( MTAE_TexturaRadial )        
  #declare MTAE_TexturaRadial  = MTAE_DefaultTexturaRadial
#end  // #ifndef ( MTAE_TexturaSoporte ) 
 
#declare MTAE_DefaultTexturaBase     =
  texture                               {   
    pigment                             {  
      color MidnightBlue
                         
    }
  }                                                            
                                                            
#ifndef ( MTAE_TexturaBase )        
  #declare MTAE_TexturaBase  = MTAE_DefaultTexturaBase
#end  // #ifndef ( MTAE_TexturaSoporte ) 
 
 
#macro MTAE_Planeta( TexturaEsfera ) 
  sphere                        {  
    0, 0.5    
    #if ( !MTAE_POV3_1 )
      uv_mapping         
    #end  // #if ( !MTAE_POV3_1 )  
    texture                     {  
      TexturaEsfera
    }
  }
#end  // macro MTAE_Planeta

#macro MTAE_MapaTierraAproximacionEsferica( AnguloRotar, AnguloInclinacion,
        DiametroFundamental, DiametroSoporte, GruesoSoporte, AlturaBase, DiametroBase,
        TexturaEsfera, TexturaSoporte, TexturaRadial, TexturaBase )
  union                         { 
    #local RadioExceso          = ( DiametroSoporte-DiametroFundamental )/2;
    // Globo y soporte
    union                       { 
      // Globo
      object                    {  
        MTAE_Planeta( TexturaEsfera )
        scale                   DiametroFundamental 
        rotate                  AnguloRotar*y
      }  
      // soporte curvo
      merge                     {
        // soporte Mayor
        difference              {  
          cylinder              {
            -GruesoSoporte/2*z, GruesoSoporte/2*z, DiametroSoporte/2
          }
          cylinder              {   
            -GruesoSoporte*z, GruesoSoporte*z,
              DiametroSoporte/2-RadioExceso/8
          }        
          box                   {   
            <-DiametroSoporte,0,-GruesoSoporte>,
            <0,-DiametroSoporte,+GruesoSoporte> 
          }                          
          box                   {   
            <-DiametroSoporte,0,-GruesoSoporte>,
            <0,DiametroSoporte,+GruesoSoporte> 
            translate           -DiametroFundamental/2*y
            rotate              45*z                 
            translate           +DiametroFundamental/2*y
          }                          
        } 
        difference              {
          cylinder              {
            -GruesoSoporte/16*z, GruesoSoporte/16*z, DiametroSoporte/2
          }
          cylinder              {   
            -GruesoSoporte*z, GruesoSoporte*z,
              DiametroSoporte/2-11*RadioExceso/16
          }        
          box                   {   
            <-DiametroSoporte,0,-GruesoSoporte>,
            <0,-DiametroSoporte,+GruesoSoporte> 
          }                          
          box                   {   
            <-DiametroSoporte,0,-GruesoSoporte>,
            <0,DiametroSoporte,+GruesoSoporte> 
            translate           -DiametroFundamental/2*y
            rotate              45*z                 
            translate           +DiametroFundamental/2*y
          }                          
        }  
        cylinder                {   
          -DiametroSoporte/2*y, ( DiametroSoporte/2-11*RadioExceso/16 )*y, GruesoSoporte/2
        }      
        #local C                = 0;
        #while ( C < 2 )  
          union                 {
            cylinder                {   
              ( DiametroSoporte/2-11*RadioExceso/16 )*y, 
              ( DiametroSoporte/2-13*RadioExceso/16 )*y,
              GruesoSoporte*3/4
            }
            cylinder                {   
              ( DiametroSoporte/2-14*RadioExceso/16 )*y, 
              ( DiametroSoporte/2-16*RadioExceso/16 )*y,
              GruesoSoporte*3/2         
              texture { TexturaRadial }
            }
            #if ( C = 0 )        
              scale             <1,-1,1>
            #end  // #if ( C = 0 )                      
          }
          #local C              = C+1;         
        #end      
        // marcas angulares
        union                 {  
          #local Desp         = 2;
          #local C            = 0;
          #while ( C < 175 )      
            box               {    
              <GruesoSoporte/20, 0, +GruesoSoporte/3 >,                                                  
              <-GruesoSoporte/20, 5*RadioExceso/16, -GruesoSoporte/3 >
              translate       ( DiametroSoporte/2-11*RadioExceso/16 )*y
              rotate            -C*z  
            } 
            #local C          = C+Desp;
          #end  // #while ( C >= -85 )
          
        }
        texture                 {   
          TexturaSoporte
        }     
      }                           
      rotate                  -AnguloInclinacion*z
      translate                 ( DiametroSoporte/2+AlturaBase )*y
    }  
    // Base Inferior
    union                       { 
      #local CompresionInicial  = 0.975;  
      #local FraccionCono       = 0.1;
      cone                      { 
        0, DiametroBase/2,
        FraccionCono*AlturaBase*y, CompresionInicial*DiametroBase/2
      }  
      sor                       {    
        6,           
        <CompresionInicial*DiametroBase*1.5,0>,
        <CompresionInicial*DiametroBase/2,FraccionCono*AlturaBase>,
        <2*GruesoSoporte,2*FraccionCono*AlturaBase>,
        <3*GruesoSoporte/2,3*FraccionCono*AlturaBase>,
        <3*GruesoSoporte/4,AlturaBase >,
        <3*GruesoSoporte/4,1.5*AlturaBase>   
      }
      texture                   { 
        TexturaBase
      }
    }
  }
#end  // #macro MTAE_MapaTierraAproximacionEsferica

#macro MTAE_MapaTierra( AnguloRotar )       
  object                        {        
    #local L                    = MTAE_L;
    #local DiametroFundamental  = 154*L;    
    #local DiametroSoporte      = 184*L;
    #local GruesoSoporte        = 8.0*L;  
    #local AnguloInclinacion    = 23.5; 
    #local AlturaBase           = 45*L;
    #local DiametroBase         = 100*L;
    MTAE_MapaTierraAproximacionEsferica( AnguloRotar, AnguloInclinacion,
      DiametroFundamental, 
      DiametroSoporte, GruesoSoporte, AlturaBase, DiametroBase,
      MTAE_TexturaEsfera, MTAE_TexturaSoporte, MTAE_TexturaRadial, MTAE_TexturaBase )
  }
#end  // #macro MTAE_MapaTierra