// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  13 mayo 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// SPUP SofaParaUnaPersona
// El archivo dibuja un sofa.  Ofrece una macro para cambiar las caracteristicas
// principales, y arruga el asiento en forma algo burda.  El usuario puede
// usar su propio arreglo de alturas.  
// Es compatible con POVRay 3.1.
//
// La macro principal tiene unicamente un parametro
// #macro SPUP_Sofa( AsientoRed, FraccionDeformado )    
//      AsientoRed              : "off" mas rapido, no permite deformar el sofa;
//                                "on" mas lento, permite deformar el sofa.
//      FraccionDeformado       : 0.0 para deformacion minima y 1.0 maxima.
//              Simula en forma burda una deformacion por tomar asiento.
//                       
// La siguiente versin de la macro, permite un mayor control de las caracteristicas.
// #macro SPUP_SofaParaUnaPersona( AsientoRed, CorreccionAltura,
//                FrentePrincipal, AltoPrincipal, ProfundidadPrincipal,
//                AltoPrimerNivel, AltoSegundoNivel, FrenteLibre,
//                ProfundidadLibre, AltoAsientoLibre,
//                RadioPata, AltoPata, InternarPata,
//                TexturaPrincipal, TexturaBotonSofa, TexturaPatas,
//                TexturaPrimerNivel, TexturaAsiento )
//      AsientoRed              : "off" mas rapido, no permite deformar el sofa;
//                                "on" mas lento, permite deformar el sofa.
//      CorreccionAltura        : array [9][4] de valores reales cercanos a la unidad.
//                Corresponde a fracciones propias o unitarias para deformar el sofa.
//                Puede usar SPUP_CorreccionUnitaria (minimo) o SPUP_CorreccionAltura (maxima).
//                Si agrega 1.0 en todos los campos produce minimo de deformacion.
//                No utilice valores cercanos a cero (toca fondo) ni negativos.  
//      FrentePrincipal         : Frente total del sofa.  Default es 572*L.
//      AltoPrincipal           : Alto total del sofa.  Default es 515*L.
//      ProfundidadPrincipal    : Profundidad total del sofa.  Default es 643*L.
//      AltoPrimerNivel         : Representa el alto de la base de asiento, sin el asiento.
//                Default es 200*L.
//      AltoSegundoNivel        : Alto desde el piso por encima del brazo.
//                Default es 350*L.
//      FrenteLibre             : Representa el frente libre para tomar asiento.
//                Default es 350*L.
//      ProfundidadLibre        : Representa la profundidad libre para tomar asiento.
//                Default es 400*L.
//      AltoAsientoLibre        : Alto neto de la colcha para sentarse.
//                Default es 70*L.
//      RadioPata               : Radio de las patas.  Default es 21.5*L.
//      AltoPata                : Alto de las patas.  Default es 70*L.
//      InternarPata            : Distancia para internar el centro de las patas,
//                respecto del borde.  Default es 50*L.
//      TexturaPrincipal        : Textura principal del sofa.  
//                Default es SPUP_TexturaPrincipal.
//      TexturaBotonSofa        : Textura del boton decorativo de los brazos.
//                Default es SPUP_TexturaBotonSofa.
//      TexturaPatas            : Textura de las patas.  Default es SPUP_TexturaPatas.
//      TexturaPrimerNivel      : Textura del primer nivel y fondo de asiento del sofa.
//                Default es SPUP_TexturaPrimerNivel.
//      TexturaAsiento          : Textura para el asiento.  Default es SPUP_TexturaAsiento.      
//      
// El Sofa por defecto cerrado se puede encerrar en la region:
//      Alto Principal Y        = 515*L
//      Frente Principal X      = 572*L
//      Profundidad Principal Z = 643*L
//      Alto Asiento            = 270*L max       
// Sobre el plano XZ, centrado en el origen de coordenadas.
// El frente hacia Z-, gravedad Y-.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores. 
// #declare SPUP_CorreccionUnitaria     = array [9][4]
//      Arreglo real completamente unitario.  Representa deformacion minima, y puede
//      utilizarse como parametro CorreccionAltura.    
// #declare SPUP_CorreccionAltura       = array [9][4]
//      Arreglo real para deformar el sofa.  Representa deformacion maxima, y puede
//      utilizarse como parametro CorreccionAltura.  Sus valores oscilan entre 0.60 y 1.00.
// #declare SPUP_Patas                  = object { ... }
//      Objeto patas de sofa sin textura.  Podria ser util para reforzar un sofa grande.
// #declare SPUP_DefaultTexturaPrincipal        
//      Textura principal del sofa.  
// #declare SPUP_DefaultTexturaBotonSofa        
//      Textura del boton decorativo de los brazos.
// #declare SPUP_DefaultTexturaPatas            
//      Textura de las patas.  
// #declare SPUP_DefaultTexturaPrimerNivel      
//      Textura del primer nivel y fondo de de asiento del sofa.
// #declare SPUP_DefaultTexturaAsiento          
//      Textura para el asiento.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default)
// #declare SPUP_TexturaPrincipal                       = texture { ... }               
//      Textura principal del sofa.  
// #declare SPUP_TexturaBotonSofa                       = texture { ... } 
//      Textura del boton decorativo de los brazos.
// #declare SPUP_TexturaPatas                           = texture { ... } 
//      Textura de las patas.  
// #declare SPUP_TexturaPrimerNivel                     = texture { ... } 
//      Textura del primer nivel y fondo de de asiento del sofa.
// #declare SPUP_TexturaAsiento                         = texture { ... } 
//      Textura para el asiento.
// #declare SPUP_POV3_1                                 = off;
//      Valor on activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo simplemente
// #include "SPUP.inc"
// object        { SPUP_Sofa( off, 0.0 ) }
//
// Otro ejemplo con modificador
// #include "SPUP.inc" 
// #include "textures.inc" 
// #declare SPUP_TexturaPrincipal        =
//    texture                           {   
//      average
//      texture_map             { 
//        [ 0.8 SPUP_DefaultTexturaPrincipal ]
//        [ 0.2 Rust ]
//      }
//    }       
// object        {
//   SPUP_Sofa( on, 0.25 )
// }
//
// O bien con la macro detallada
// #include "SPUP.inc"
// object                       {
//   SPUP_SofaParaUnaPersona( on, SPUP_CorreccionUnitaria,
//      0.572, 0.515, 0.643, 0.200, 0.350, 0.350, 0.400, 0.070, 0.0215, 0.070, 0.050,
//      SPUP_TexturaPrincipal, SPUP_TexturaBotonSofa,
//      SPUP_TexturaPatas, SPUP_TexturaPrimerNivel, SPUP_TexturaAsiento )
// }
//

#include "colors.inc"

#declare EjeMejorado            = false;
#declare OjoAbsoluto            = 256;
#declare VecesCentroAbsoluto    = 10;     
#declare L                      = 0.001;
camera {
        location  <   0,  0, -( VecesCentroAbsoluto+1 )*OjoAbsoluto >*L
        direction z
        sky       y
        angle     38.74
//        look_at  <   0,  0, -VecesCentroAbsoluto*OjoAbsoluto >*L
} 
 
light_source    {
         < 500  , 500   , -3000 >*L
         White
}
background      {
         Gray50
}    


#include "SPUP.inc"                

#local   FactorAcercamiento     = 2;
 
object          {
  SPUP_Sofa( on, 0.25 )   
  translate     -0.25*y
  translate       -( VecesCentroAbsoluto+1 )*( FactorAcercamiento-1 )
                        /( FactorAcercamiento )*OjoAbsoluto*L*z
}




