// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  13 mayo 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// SPUP SofaParaUnaPersona
// El archivo dibuja un sofa.  Ofrece una macro para cambiar las caracteristicas
// principales, y arruga el asiento en forma algo burda.  El usuario puede
// usar su propio arreglo de alturas.  
// Es compatible con POVRay 3.1.
//
// La macro principal tiene unicamente un parametro
// #macro SPUP_Sofa( AsientoRed, FraccionDeformado )    
//      AsientoRed              : "off" mas rapido, no permite deformar el sofa;
//                                "on" mas lento, permite deformar el sofa.
//      FraccionDeformado       : 0.0 para deformacion minima y 1.0 maxima.
//              Simula en forma burda una deformacion por tomar asiento.
//                       
// La siguiente versin de la macro, permite un mayor control de las caracteristicas.
// #macro SPUP_SofaParaUnaPersona( AsientoRed, CorreccionAltura,
//                FrentePrincipal, AltoPrincipal, ProfundidadPrincipal,
//                AltoPrimerNivel, AltoSegundoNivel, FrenteLibre,
//                ProfundidadLibre, AltoAsientoLibre,
//                RadioPata, AltoPata, InternarPata,
//                TexturaPrincipal, TexturaBotonSofa, TexturaPatas,
//                TexturaPrimerNivel, TexturaAsiento )
//      AsientoRed              : "off" mas rapido, no permite deformar el sofa;
//                                "on" mas lento, permite deformar el sofa.
//      CorreccionAltura        : array [9][4] de valores reales cercanos a la unidad.
//                Corresponde a fracciones propias o unitarias para deformar el sofa.
//                Puede usar SPUP_CorreccionUnitaria (minimo) o SPUP_CorreccionAltura (maxima).
//                Si agrega 1.0 en todos los campos produce minimo de deformacion.
//                No utilice valores cercanos a cero (toca fondo) ni negativos.  
//      FrentePrincipal         : Frente total del sofa.  Default es 572*L.
//      AltoPrincipal           : Alto total del sofa.  Default es 515*L.
//      ProfundidadPrincipal    : Profundidad total del sofa.  Default es 643*L.
//      AltoPrimerNivel         : Representa el alto de la base de asiento, sin el asiento.
//                Default es 200*L.
//      AltoSegundoNivel        : Alto desde el piso por encima del brazo.
//                Default es 350*L.
//      FrenteLibre             : Representa el frente libre para tomar asiento.
//                Default es 350*L.
//      ProfundidadLibre        : Representa la profundidad libre para tomar asiento.
//                Default es 400*L.
//      AltoAsientoLibre        : Alto neto de la colcha para sentarse.
//                Default es 70*L.
//      RadioPata               : Radio de las patas.  Default es 21.5*L.
//      AltoPata                : Alto de las patas.  Default es 70*L.
//      InternarPata            : Distancia para internar el centro de las patas,
//                respecto del borde.  Default es 50*L.
//      TexturaPrincipal        : Textura principal del sofa.  
//                Default es SPUP_TexturaPrincipal.
//      TexturaBotonSofa        : Textura del boton decorativo de los brazos.
//                Default es SPUP_TexturaBotonSofa.
//      TexturaPatas            : Textura de las patas.  Default es SPUP_TexturaPatas.
//      TexturaPrimerNivel      : Textura del primer nivel y fondo de asiento del sofa.
//                Default es SPUP_TexturaPrimerNivel.
//      TexturaAsiento          : Textura para el asiento.  Default es SPUP_TexturaAsiento.      
//      
// El Sofa por defecto cerrado se puede encerrar en la region:
//      Alto Principal Y        = 515*L
//      Frente Principal X      = 572*L
//      Profundidad Principal Z = 643*L
//      Alto Asiento            = 270*L max       
// Sobre el plano XZ, centrado en el origen de coordenadas.
// El frente hacia Z-, gravedad Y-.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores. 
// #declare SPUP_CorreccionUnitaria     = array [9][4]
//      Arreglo real completamente unitario.  Representa deformacion minima, y puede
//      utilizarse como parametro CorreccionAltura.    
// #declare SPUP_CorreccionAltura       = array [9][4]
//      Arreglo real para deformar el sofa.  Representa deformacion maxima, y puede
//      utilizarse como parametro CorreccionAltura.  Sus valores oscilan entre 0.60 y 1.00.
// #declare SPUP_Patas                  = object { ... }
//      Objeto patas de sofa sin textura.  Podria ser util para reforzar un sofa grande.
// #declare SPUP_DefaultTexturaPrincipal        
//      Textura principal del sofa.  
// #declare SPUP_DefaultTexturaBotonSofa        
//      Textura del boton decorativo de los brazos.
// #declare SPUP_DefaultTexturaPatas            
//      Textura de las patas.  
// #declare SPUP_DefaultTexturaPrimerNivel      
//      Textura del primer nivel y fondo de de asiento del sofa.
// #declare SPUP_DefaultTexturaAsiento          
//      Textura para el asiento.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default)
// #declare SPUP_TexturaPrincipal                       = texture { ... }               
//      Textura principal del sofa.  
// #declare SPUP_TexturaBotonSofa                       = texture { ... } 
//      Textura del boton decorativo de los brazos.
// #declare SPUP_TexturaPatas                           = texture { ... } 
//      Textura de las patas.  
// #declare SPUP_TexturaPrimerNivel                     = texture { ... } 
//      Textura del primer nivel y fondo de de asiento del sofa.
// #declare SPUP_TexturaAsiento                         = texture { ... } 
//      Textura para el asiento.
// #declare SPUP_POV3_1                                 = off;
//      Valor on activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo simplemente
// #include "SPUP.inc"
// object        { SPUP_Sofa( off, 0.0 ) }
//
// Otro ejemplo con modificador
// #include "SPUP.inc" 
// #include "textures.inc" 
// #declare SPUP_TexturaPrincipal        =
//    texture                           {   
//      average
//      texture_map             { 
//        [ 0.8 SPUP_DefaultTexturaPrincipal ]
//        [ 0.2 Rust ]
//      }
//    }       
// object        {
//   SPUP_Sofa( on, 0.25 )
// }
//
// O bien con la macro detallada
// #include "SPUP.inc"
// object                       {
//   SPUP_SofaParaUnaPersona( on, SPUP_CorreccionUnitaria,
//      0.572, 0.515, 0.643, 0.200, 0.350, 0.350, 0.400, 0.070, 0.0215, 0.070, 0.050,
//      SPUP_TexturaPrincipal, SPUP_TexturaBotonSofa,
//      SPUP_TexturaPatas, SPUP_TexturaPrimerNivel, SPUP_TexturaAsiento )
// }
//

#declare SPUP_L                         = 0.001;

#declare SPUP_SplineObject0_USE_NORMAL_TRANSFORM     = on;
#include "SPUP_AU2.inc"
#include "SPUP_AU1.inc"
#include "woods.inc"   
#include "stones.inc"             
             
#declare SPUP_DefaultTexturaPrincipal                =
  texture                               {    
    T_Stone43
    normal                              {   
      quilted
      control0  0.2
      control1  0.2
      scale     0.01  
      turbulence        0.05
    }
  }

#ifndef ( SPUP_TexturaPrincipal )
  #declare SPUP_TexturaPrincipal        = SPUP_DefaultTexturaPrincipal
#end  // #ifndef ( SPUP_TexturaPatas )

#declare SPUP_DefaultTexturaPrimerNivel = SPUP_DefaultTexturaPrincipal

#ifndef ( SPUP_TexturaPrimerNivel )
  #declare SPUP_TexturaPrimerNivel      = SPUP_DefaultTexturaPrimerNivel
#end  // #ifndef ( SPUP_TexturaPrimerNivel )

#declare SPUP_DefaultTexturaAsiento     = 
  texture                       {    
      T_Stone43  
    normal                      {   
      quilted
      control0  0.9
      control1  0.1
      scale     0.05
    }   
    scale               0.1
  }

#ifndef ( SPUP_TexturaAsiento )
  #declare SPUP_TexturaAsiento          = SPUP_DefaultTexturaAsiento
#end  // #ifndef ( SPUP_TexturaAsiento )
                                                             
#declare SPUP_DefaultTexturaBotonSofa   = SPUP_DefaultTexturaAsiento

#ifndef ( SPUP_TexturaBotonSofa )
  #declare SPUP_TexturaBotonSofa        = SPUP_DefaultTexturaBotonSofa
#end  // #ifndef ( SPUP_TexturaBotonSofa )

#declare SPUP_DefaultTexturaPatas       = 
  texture                               {
    T_Wood21
    scale       0.1
    normal                              { 
      waves
      scale     0.1
    } 
  }  

#ifndef ( SPUP_TexturaPatas )
  #declare SPUP_TexturaPatas            = SPUP_DefaultTexturaPatas
#end  // #ifndef ( SPUP_TexturaPatas )

#declare SPUP_Patas                     =
  object                                {
    SPUP_SplineObject0
    rotate        -180*x
    scale         <1,0.5/0.375,1>
    translate             0.5*y
    // cilindro de radio 0.5 y alto unitario
  }

#macro SPUP_Brazo( TexturaPrincipal, TexturaBotonSofa )
  union                                 {
    difference                          {
      superellipsoid                    {
        <0.5,0.1>
        scale                           <0.5,0.5,1>
      }
      #local C                          = 0;
      #while ( C < 2 )
        intersection                    {
          torus                         {
            0.35, 0.15
            rotate                      90*x
            inverse
          }
          cylinder                      {
            -0.20*z, 0.20*z, 0.3
          }
          translate                     -0.85*z
          #if ( C = 0 )
            scale                       <1,1,-1>
          #end  // #if ( C = 0 )
        }
        #local C                        = C+1;
      #end  // #while ( C < 2 )
    }
    #local C                            = 0;
    #while ( C < 2 )
      superellipsoid                    {
        <0.7,0.7>
        scale                           <0.225,0.225,0.025>
        rotate                          45*z
        texture                         {
          TexturaBotonSofa
        }
        translate                       -0.975*z
        #if ( C = 0 )
          scale                         <1,1,-1>
        #end  // #if ( C = 0 )
      }
      #local C                          = C+1;
    #end  // #while ( C < 2 )
    scale               <1.025,1.025,1>
    texture             { TexturaPrincipal }
  }
#end  // SPUP_Brazo

#declare SPUP_CorreccionAltura  = array [9][4]
  {
    { 1.00, 1.00, 1.00, 1.00 },
    { 0.75, 0.65, 0.82, 0.90 },
    { 0.65, 0.60, 0.70, 0.80 },
    { 0.75, 0.65, 0.82, 0.90 },
    { 0.85, 0.70, 0.85, 1.00 },
    { 0.75, 0.65, 0.82, 0.90 },
    { 0.65, 0.60, 0.70, 0.80 },
    { 0.75, 0.65, 0.82, 0.90 },
    { 1.00, 1.00, 1.00, 1.00 }
  }
      
#declare SPUP_CorreccionUnitaria  = array [9][4]
  {
    { 1.00, 1.00, 1.00, 1.00 },
    { 1.00, 1.00, 1.00, 1.00 },
    { 1.00, 1.00, 1.00, 1.00 },
    { 1.00, 1.00, 1.00, 1.00 },
    { 1.00, 1.00, 1.00, 1.00 },
    { 1.00, 1.00, 1.00, 1.00 },
    { 1.00, 1.00, 1.00, 1.00 },
    { 1.00, 1.00, 1.00, 1.00 },
    { 1.00, 1.00, 1.00, 1.00 }
  }
      
#declare SPUP_RedAsiento        = array [11][6][4]
  { { {
<-0.520,-0.050,-0.450>,<-0.050, 0.000,-1.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.520, 0.700,-0.425>,<-0.050, 1.000,-4.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.520, 0.700,-0.250>,<-0.050, 1.000,-0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.520, 0.700,+0.000>,<-0.050, 1.000, 0.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.520, 0.700,+0.250>,<-0.050, 1.000, 0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.520, 0.700,+0.500>,<-0.050, 1.000, 0.050>,<off,off,1>,<-1,-0.75,0.100>
      }
    },
    { {
<-0.400,-0.050,-0.475>,<-0.040, 0.000,-1.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.400, 0.750,-0.450>,<-0.040, 1.000,-4.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.400, 0.800,-0.250>,<-0.040, 1.000,-0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.400, 0.850,+0.000>,<-0.040, 1.000, 0.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.400, 0.800,+0.250>,<-0.040, 1.000, 0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.400, 0.700,+0.500>,<-0.040, 1.000, 0.050>,<off,off,1>,<-1,-9.75,0.100>
      }
    },
    { {
<-0.300,-0.050,-0.475>,<-0.030, 0.000,-1.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.300, 0.750,-0.450>,<-0.030, 1.000,-4.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.300, 0.850,-0.250>,<-0.030, 1.000,-0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.300, 0.925,+0.000>,<-0.030, 1.000, 0.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.300, 0.850,+0.250>,<-0.030, 1.000, 0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.300, 0.700,+0.500>,<-0.030, 1.000, 0.050>,<off,off,1>,<-1,-9.75,0.100>
      }
    },
    { {
<-0.200,-0.050,-0.475>,<-0.020, 0.000,-1.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.200, 0.775,-0.450>,<-0.020, 1.000,-4.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.200, 0.875,-0.250>,<-0.020, 1.000,-0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.200, 0.975,+0.000>,<-0.020, 1.000, 0.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.200, 0.875,+0.250>,<-0.020, 1.000, 0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.200, 0.700,+0.500>,<-0.020, 1.000, 0.050>,<off,off,1>,<-1,-9.75,0.100>
      }
    },
    { {
<-0.100,-0.050,-0.475>,<-0.010, 0.000,-1.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.100, 0.795,-0.450>,<-0.010, 1.000,-4.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.100, 0.895,-0.250>,<-0.010, 1.000,-0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.100, 0.995,+0.000>,<-0.010, 1.000, 0.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.100, 0.895,+0.250>,<-0.010, 1.000, 0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.100, 0.700,+0.500>,<-0.010, 1.000, 0.050>,<off,off,1>,<-1,-9.75,0.100>
      }
    },
    { {
<-0.000,-0.050,-0.475>,< 0.000, 0.000,-1.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.000, 0.800,-0.450>,< 0.000, 1.000,-4.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.000, 0.900,-0.250>,< 0.000, 1.000,-0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.000, 1.000,+0.000>,< 0.000, 1.000, 0.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.000, 0.900,+0.250>,< 0.000, 1.000, 0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<-0.000, 0.700,+0.500>,< 0.000, 1.000, 0.050>,<off,off,1>,<-1,-0.75,0.100>
      }
    },
    { {
<+0.100,-0.050,-0.475>,< 0.010, 0.000,-1.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.100, 0.795,-0.450>,< 0.010, 1.000,-4.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.100, 0.895,-0.250>,< 0.010, 1.000,-0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.100, 0.995,+0.000>,< 0.010, 1.000, 0.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.100, 0.895,+0.250>,< 0.010, 1.000, 0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.100, 0.700,+0.500>,< 0.010, 1.000, 0.050>,<off,off,1>,<-1,-0.75,0.100>
      }
    },
    { {
<+0.200,-0.050,-0.475>,< 0.020, 0.000,-1.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.200, 0.775,-0.450>,< 0.020, 1.000,-4.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.200, 0.875,-0.250>,< 0.020, 1.000,-0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.200, 0.975,+0.000>,< 0.020, 1.000, 0.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.200, 0.875,+0.250>,< 0.020, 1.000, 0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.200, 0.700,+0.500>,< 0.020, 1.000, 0.050>,<off,off,1>,<-1,-9.75,0.100>
      }
    },
    { {
<+0.300,-0.050,-0.475>,< 0.030, 0.000,-1.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.300, 0.750,-0.450>,< 0.030, 1.000,-4.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.300, 0.850,-0.250>,< 0.030, 1.000,-0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.300, 0.925,+0.000>,< 0.030, 1.000, 0.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.300, 0.850,+0.250>,< 0.030, 1.000, 0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.300, 0.700,+0.500>,< 0.030, 1.000, 0.050>,<off,off,1>,<-1,-9.75,0.100>
      }
    },
    { {
<+0.400,-0.050,-0.475>,< 0.040, 0.000,-1.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.400, 0.750,-0.450>,< 0.040, 1.000,-4.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.400, 0.800,-0.250>,< 0.040, 1.000,-0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.400, 0.850,+0.000>,< 0.040, 1.000, 0.000>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.400, 0.800,+0.250>,< 0.040, 1.000, 0.025>,<on ,off,3>,<-1,+9.75,0.015>
      },{
<+0.400, 0.700,+0.500>,< 0.040, 1.000, 0.050>,<off,off,1>,<-1,-9.75,0.100>
      }
    },
    { {
<+0.520,-0.050,-0.450>,< 0.050, 0.000,-1.000>,<off,off,2>,<-1,+9.75,0.025>
      },{
<+0.520, 0.700,-0.425>,< 0.050, 1.000,-4.000>,<off,off,2>,<-1,+9.75,0.025>
      },{
<+0.520, 0.700,-0.250>,< 0.050, 1.000,-0.025>,<off,off,2>,<-1,+9.75,0.025>
      },{
<+0.520, 0.700,+0.000>,< 0.050, 1.000, 0.000>,<off,off,2>,<-1,+9.75,0.025>
      },{
<+0.520, 0.700,+0.250>,< 0.050, 1.000, 0.025>,<off,off,2>,<-1,+9.75,0.025>
      },{
<+0.520, 0.700,+0.500>,< 0.050, 1.000, 0.050>,<off,off,1>,<-1,-9.75,0.100>
      }
    }
  }


#macro SPUP_SofaParaUnaPersona( AsientoRed, CorreccionAltura,
                FrentePrincipal, AltoPrincipal, ProfundidadPrincipal,
                AltoPrimerNivel, AltoSegundoNivel, FrenteLibre,
                ProfundidadLibre, AltoAsientoLibre,
                RadioPata, AltoPata, InternarPata,
                TexturaPrincipal, TexturaBotonSofa, TexturaPatas,
                TexturaPrimerNivel, TexturaAsiento )
  union                                 {
    // Asiento
    #if ( AsientoRed )
      #local RedInterna        = array [11][6][4]
      #local C                            = 0;
      #while ( C < 11 )
        #local D                          = 0;
        #while ( D < 6 )
          #local E                        = 0;
          #while ( E < 4 )
            #local RedInterna[C][D][E]    = SPUP_RedAsiento[C][D][E];
            #local E                      = E+1;
          #end // #while ( E < 4 )
          #local D                        = D+1;
        #end
        #local C                          = C+1;
      #end
      #local C = 0;
      #while ( C < 9 )
        #local D                          = 0;
        #while ( D < 4 )
          #local RedInterna[C+1][D+1][0]  =
              < RedInterna[C+1][D+1][0].x,
                CorreccionAltura[C][D]*RedInterna[C+1][D+1][0].y,
                RedInterna[C+1][D+1][0].z >;
          #local D                        = D+1;
        #end
        #local C                          = C+1;
      #end
      object                              {
        SPUP_Red( RedInterna, "", off, 0 )
        scale                     < FrenteLibre,
                 AltoAsientoLibre, ProfundidadLibre >
        translate                 -ProfundidadLibre/2*z+
                       ( ProfundidadLibre-ProfundidadPrincipal/2 )*z
                       +AltoPrimerNivel*y
        texture           { TexturaAsiento }
      }
    #else // #else ( AsientoRed )
      superellipsoid                    {
        <0.2,0.2>
        scale           < FrenteLibre, AltoAsientoLibre, ProfundidadLibre >/2
        translate               AltoAsientoLibre/2*y
        translate                 -ProfundidadLibre/2*z+
                       ( ProfundidadLibre-ProfundidadPrincipal/2 )*z
                       +AltoPrimerNivel*y
        texture           { TexturaAsiento }
      }
    #end  // #else ( AsientoRed )
    // Respaldar
    union                               {
      // Respaldo superior
      object                            {
        SPUP_Brazo( TexturaPrincipal, TexturaBotonSofa )
        rotate                          90*y
        scale                           < FrentePrincipal/2,
                  AltoPrincipal-AltoSegundoNivel,
                  ProfundidadPrincipal-ProfundidadLibre >
        translate               AltoSegundoNivel*y
                  +( AltoPrincipal-AltoSegundoNivel )*y/2
                  -( 0*ProfundidadPrincipal-ProfundidadLibre )*z/2
      }
      // Respaldo medio
      superellipsoid                    {
        <0.1,0.1>
        scale                           <FrenteLibre,
                      AltoPrincipal-AltoSegundoNivel,
                      ProfundidadPrincipal-ProfundidadLibre>/2
        translate               AltoPrimerNivel*y
                  +( AltoSegundoNivel-AltoPrimerNivel )*y/2
                  -( 0*ProfundidadPrincipal-ProfundidadLibre )*z/2
        texture                         {
          TexturaPrincipal
        }
      }
    }
    
    // Brazos Izquierdo y Derecho
    #local C                            = 0;
    #while ( C < 2 )
      object                            {
        SPUP_Brazo( TexturaPrincipal, TexturaBotonSofa )
        scale
          < ( FrentePrincipal-FrenteLibre )/2 ,
            ( AltoSegundoNivel-AltoPrimerNivel ),
            ProfundidadPrincipal/2 >
        translate               AltoPrimerNivel*y
                                +( AltoSegundoNivel-AltoPrimerNivel )*y/2
                                +( FrentePrincipal+FrenteLibre )*x/4
        #if ( C = 0 )
          scale                 <-1,1,1>
        #end  // #if ( C = 0 )
      }
      #local C                          = C+1;
    #end  // #while ( C < 2 )
  
    // Primer Nivel
    superellipsoid                      {
      <0.1,0.1>
      scale                             < FrentePrincipal/2,
              ( AltoPrimerNivel-AltoPata )/2, ProfundidadPrincipal/2 >
      translate                 AltoPata*y+( AltoPrimerNivel-AltoPata )/2*y
      texture                           {
        TexturaPrimerNivel
      }
    }
    // Cuatro Patas
    #local C = 0;
    #while ( C < 4 )
      object                            {
        SPUP_Patas
        scale                           < RadioPata*2, AltoPata, RadioPata*2 >
        translate                       < FrentePrincipal/2-InternarPata,
                         0, ProfundidadPrincipal/2-InternarPata >
        #if ( mod( C, 2 ) = 0 )
          scale                         <-1,1,1>
        #end
        #if ( div( C, 2 ) = 0 )
          scale                         <1,1,-1>
        #end
        texture                         {
          TexturaPatas
        }
      }
      #local C                          = C+1;
    #end  // #while ( C < 4 )
  }  // union
#end  // #macro SPUP_SofaParaUnaPersona

#macro SPUP_Sofa( AsientoRed, FraccionDeformado )
  object                                {
    #local L                            = SPUP_L;
    #local FrentePrincipal              = 572*L;
    #local AltoPrincipal                = 515*L;
    #local ProfundidadPrincipal         = 643*L;
    #local AltoPrimerNivel              = 200*L;
    #local AltoSegundoNivel             = 350*L;
    #local FrenteLibre                  = 350*L;
    #local ProfundidadLibre             = 400*L;
    #local AltoAsientoLibre             = 70*L;
    #local RadioPata                    = 43*L/2;
    #local AltoPata                     = 70*L;
    #local InternarPata                 = 50*L;
    #local CorreccionAltura             = array [9][4]
    #local C = 0;
    #while ( C < 9 )
      #local D                          = 0;
      #while ( D < 4 )
        #local CorreccionAltura[C][D]   = FraccionDeformado*
                  ( SPUP_CorreccionAltura[C][D]-1 )+1;
        #local D                        = D+1;
      #end
      #local C                          = C+1;
    #end
    SPUP_SofaParaUnaPersona( AsientoRed, CorreccionAltura,
      FrentePrincipal, AltoPrincipal, ProfundidadPrincipal,
      AltoPrimerNivel, AltoSegundoNivel, FrenteLibre,
      ProfundidadLibre, AltoAsientoLibre,
      RadioPata, AltoPata, InternarPata,
      SPUP_TexturaPrincipal, SPUP_TexturaBotonSofa,
      SPUP_TexturaPatas, SPUP_TexturaPrimerNivel, SPUP_TexturaAsiento )
  }
#end  // #macro SPUP_Sofa

