// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  26 junio 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// RDHV RadioDespertadorHorarioVerano
// El archivo dibuja un Radio Despertador sencillo, con indicadores de cristal liquido. 
// Ofrece una macro para cambiar las caracteristicas principales y texturas.   
// Es compatible con POVRay 3.1.
//
// La macro principal tiene unicamente cuatro parametros
// #macro RDHV_RadioDespertador( Hora, Minuto, Indicadores, BanderaRadial )   
//      Hora                    : Entero para escribir la hora en la pantalla.
//      Minuto                  : Entero para escribir los minutos en la pantalla.
//      Indicadores             : Entero para elegir los indicadores.  Un Valor de
//              cero no enciende ningun indicador.  Para encender un indicador sume
//              el valor de su selector.
//                      RDHV_LUZDST                    =  1
//                      RDHV_LUZAM                     =  2
//                      RDHV_LUZPM                     =  4
//                      RDHV_LUZALARM                  =  8
//                      RDHV_LUZBATERIA                = 16
//      BanderaRadial           : "on" modelo de bordes curvos.  "off" modelo prismatico.
//
// La siguiente versin de la macro, permite un mayor control de las caracteristicas.
// #macro RDHV_RadioDespertadorHorarioVerano( Hora, Minuto, Indicadores,
//        BanderaRadial, Frente, Profundidad, Radial, Cizalla,
//        ArregloBotones, TexturaPrincipal, TexturaLabel, ArregloTexturasExtra,
//        TexturaLabelLUZ, TexturaTransparente, TexturaLUZ, TexturaFondoLUZ )
//      Hora                    : Entero para escribir la hora en la pantalla.
//      Minuto                  : Entero para escribir los minutos en la pantalla.
//      Indicadores             : Entero para elegir los indicadores.  Un Valor de
//              cero no enciende ningun indicador.  Para encender un indicador sume
//              el valor de su selector.
//                      RDHV_LUZDST                    =  1
//                      RDHV_LUZAM                     =  2
//                      RDHV_LUZPM                     =  4
//                      RDHV_LUZALARM                  =  8
//                      RDHV_LUZBATERIA                = 16
//      BanderaRadial           : "on" modelo de bordes curvos.  "off" modelo prismatico. 
//      Frente                  : Frente X para la radio, sin el borde curvo.             
//              Default es 71.5*L.
//      Profundidad             : Referencia para la profundidad Z de la radio.
//              Default es 95.0*L.
//      Radial                  : Radio de los laterales curvos.  La altura referencia
//              del aparato se asignara como 2*Radial.
//              Default es 19.7*L.
//      Cizalla                 : Fraccion para transformacion oblicua en Z del prisma base.
//              Default es 2/11.
//      ArregloBotones          : Arreglo bidimensional de reales.  Para describir los
//              botones de la parte superior del aparato.  
//              Cada dato tiene la composicion
//              { RDHV_IndiceBotonVisible, RDHV_IndiceBotonU, RDHV_IndiceBotonV,
//                RDHV_IndiceBotonFrente, RDHV_IndiceBotonRadio, RDHV_IndiceTexturaBoton }    
//              Por ejemplo para apagar el boton C, asigne
//              #declare ArregloBotones[C][RDHV_IndiceBotonVisible] = off;
//              RDHV_ArregloBotones  
//                      RDHV_IndiceBotonVisible         : "on" dibuja el boton, 
//                              "off" no lo dibuja.
//                      RDHV_IndiceBotonU               : Fraccion propia entre 0 y 1,
//                              para ubicacion frontal en la parte superior. 
//                              0.0 borde izquierdo, 1.0 borde derecho.
//                      RDHV_IndiceBotonV               : Fraccion propia entre 0 y 1,
//                              para abicacion Z en la parte superior.
//                              0.0 zona frontal, 1.0 al fondo.
//                      RDHV_IndiceBotonFrente          : Utilice 0.0 para botones 
//                              redondos.  Fraccion propia para indicar el largo X
//                              de un boton alargado.
//                      RDHV_IndiceBotonRadio           : El radio del boton, o
//                              de sus extremos;  si se trata de un boton alargado.
//                      RDHV_IndiceTexturaBoton         : Entero a partir de cero ubica
//                              la textura en el arreglo parametro ArregloTexturasExtra.
//                              Utilice valor negativo para no aplicar ninguna textura.  
//      TexturaPrincipal        : Textura principal a aplicar al aparato.
//              Default es RDHV_TexturaPrincipal.
//      TexturaLabel            : Textura que se aplica por diferencia a la parte superior.
//              Su funcion es etiquetar los botones, y pintar un parlante.
//              Default es RDHV_TexturaLabel.
//      ArregloTexturasExtra    : Tipo array para texturas.  Podria tener un unico
//              elemento.  Corresponde a las texturas asignadas por ArregloBotones.
//              Si asigna todas las texturas negativas, este valor se ignora.
//              Default es RDHV_ArregloTexturasExtra.
//      TexturaLabelLUZ         : Textura que se aplica al frente del radio.  Incluye
//              la rotulacion de emisoras e indicadores luminosos.
//              Default es RDHV_TexturaLabelLUZ.
//      TexturaTransparente     : Corresponde a una cubierta plastica protectora de
//              la pantalla de cristal liquido y todo el frente del aparato.
//              Default es RDHV_TexturaTransparente.
//      TexturaLUZ              : El color de la luz se pinta con esta textura.
//              Probablemente convenga asignar un valor ambient elevado
//              para cuartos oscuros. 
//      TexturaFondoLUZ         : Se aplica al fondo de la pantalla de cristal liquido.
//              Default es RDHV_TexturaFondoLUZ.
//  
// Esta macro dibuja solo el frente del RadioDespertador sin aplicar la cizalla,
// centrado como se indica mas adelante.  Podria ser util para agregar
// relojes de cristal liquido a otros objetos.
// #macro RDHV_DisplayClock( Hora, Minutos, Indicadores, FraccionDisplay,
//             BanderaRadial, Frente, ProfundidadDisplay, Radial,
//             TexturaLabelLUZ, TexturaTransparente,
//             TexturaLUZ, TexturaFondoLUZ )  
//      Hora                    : Entero para escribir la hora en la pantalla.
//      Minuto                  : Entero para escribir los minutos en la pantalla.
//      Indicadores             : Entero para elegir los indicadores.  Un Valor de
//              cero no enciende ningun indicador.  Para encender un indicador sume
//              el valor de su selector.
//                      RDHV_LUZDST                    =  1
//                      RDHV_LUZAM                     =  2
//                      RDHV_LUZPM                     =  4
//                      RDHV_LUZALARM                  =  8
//                      RDHV_LUZBATERIA                = 16  
//      FraccionDisplay         : Fraccion del alto del Display ocupado por el
//              despliegue incluyendo el fondo.  Default es 0.5.
//      BanderaRadial           : "on" modelo de bordes curvos.  "off" modelo prismatico. 
//      Frente                  : Frente X para la radio, sin el borde curvo.             
//              Default es 71.5*L.         
//      ProfundidadDisplay      : Profundidad aproximada del Display.
//              Default es 3.6*L.
//      Radial                  : Radio de los laterales curvos.  La altura referencia,
//              del aparato se tomara a partir de 2*Radial.
//              Default es 19.7*L.
//      TexturaLabelLUZ         : Textura que se aplica al frente del radio.  Incluye
//              la rotulacion de emisoras e indicadores luminosos.
//              Default es RDHV_TexturaLabelLUZ.
//      TexturaTransparente     : Corresponde a una cubierta plastica protectora de
//              la pantalla de cristal liquido y todo el frente del aparato.
//              Default es RDHV_TexturaTransparente.
//      TexturaLUZ              : El color de la luz se pinta con esta textura.
//              Probablemente convenga asignar un valor ambient elevado,
//              para cuartos oscuros. 
//      TexturaFondoLUZ         : Se aplica al fondo de la pantalla de cristal liquido.
//              Default es RDHV_TexturaFondoLUZ.
//
// Esta macro dibuja un Digito de la pantalla de cristal liquido, sin ubicar.
// #macro RDHV_DisplayDigito( Digito, Cizalla, BanderaUno, BanderaApagado,
//              TexturaEncendido, TexturaApagado )
//      Digito                  : Numero entero desde 0 a 9, a desplegar.
//      Cizalla                 : Cizalla en el eje Y del digito.
//      BanderaUno              : "on" indica que el digito solo puede valer uno o cero.
//              "off" indice un digito usual.  Se le asigna menor tamano.
//      BanderaApagado          : "on", dibuja las barras apagadas con TexturaApagado.
//              "off" ignora las barras apagadas.
//      TexturaEncendido        : Textura que se asigna a las barras encendidas.
//      TexturaApagado          : Permite asignar una textura a las barras apagadas.
//              Si BanderaApagado es "off" se ignora.              
//
// El aparato por defecto tiene las siguientes dimensiones:
//      Alto                            =  47*L
//      Frente en X (cilindrico)        = 111*L 
//      Frente en X (prismatico)        =  72*L 
//      Profundidad en Z                = 108*x  
// Se dibuja sobre el plano XZ.  El frente del aparato se encuentra centrado
// sobre el origen, de forma que se ubica totalmente detras del plano XY hacia Z-,
// con gravedad Y-.
// RDHV_DisplayClock dibuja el objeto sin cizalla en Z, tambien detras del plano XY
// hacia Z-.  El display se colocara centrado en el eje Y.
// RDHV_DisplayDigito dibuja numeros mediante dos cuadrados guias.
// Los cuadrados guias que forman el digito sin contar el grueso y cizalla son unitarios,
// el grueso de linea es 0.2.  La profundidad Z es de 0.1 centrada en el plano XY.
// El cuadrado guia sin contar el grueso y la cizalla, iniciaria en el origen.  
// Se dibujan desplazandose hacia arriba y a la derecha.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare RDHV_ArregloBotones1        = array [11][6]
//      Incluye descripciones de los botones default.  Sirve como
//      parametro en la macro detallada.
// #declare RDHV_DefaultTexturaPrincipal        
//      Textura principal a aplicar al aparato.
// #declare RDHV_DefaultTexturaLabel            
//      Textura que se aplica por diferencia a la parte superior.
//      Su funcion es etiquetar los botones, y pintar un parlante.
// #declare RDHV_DefaultTexturaLabelLUZ         
//      Textura que se aplica al frente del radio.  Incluye
//      la rotulacion de emisoras e indicadores luminosos.
// #declare RDHV_DefaultTexturaTransparente     
//      Corresponde a una cubierta plastica protectora de
//      la pantalla de cristal liquido y todo el frente del aparato.
// #declare RDHV_DefaultTexturaLUZ              
//      El color de la luz se pinta con esta textura.
//      Probablemente convenga asignar un valor ambient elevado para cuartos oscuros. 
// #declare RDHV_DefaultTexturaFondoLUZ         
//      Se aplica al fondo de la pantalla de cristal liquido. 
// #declare RDHV_DefaultTexturaExtra
//      Se aplica a los botones.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default)  
// #declare RDHV_ArregloTexturasExtra           = array [1] 
//                              { RDHV_DefaultTexturaExtra }
//      Textura a aplicar a los botones.  Se define como arreglo por requerimientos
//      de la macro detallada.
// #declare RDHV_TexturaPrincipal        
//      Textura principal a aplicar al aparato.
// #declare RDHV_TexturaLabel            
//      Textura que se aplica por diferencia a la parte superior.
//      Su funcion es etiquetar los botones, y pintar un parlante.
// #declare RDHV_TexturaLabelLUZ         
//      Textura que se aplica al frente del radio.  Incluye
//      la rotulacion de emisoras e indicadores luminosos.
// #declare RDHV_TexturaTransparente     
//      Corresponde a una cubierta plastica protectora de
//      la pantalla de cristal liquido y todo el frente del aparato.
// #declare RDHV_TexturaLUZ              
//      El color de la luz se pinta con esta textura.
//      Probablemente convenga asignar un valor ambient elevado para cuartos oscuros. 
// #declare RDHV_TexturaFondoLUZ         
//      Se aplica al fondo de la pantalla de cristal liquido.
// #declare RDHV_POV3_1                                 = off;
//      Valor "on" activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo simplemente
// #include "RDHV.inc"
// object        { RDHV_RadioDespertador( 6, 45, 2, on ) }
//
// Otro ejemplo con la macro detallada:
// #include "RDHV.inc"   
// object                       { 
//   RDHV_RadioDespertadorHorarioVerano( 6, 45, 2, on,
//          0.0715, 0.095, 0.0197, 2/11,
//          RDHV_ArregloBotones1, RDHV_TexturaPrincipal, RDHV_TexturaLabel, 
//          RDHV_ArregloTexturasExtra, RDHV_TexturaLabelLUZ, RDHV_TexturaTransparente,
//          RDHV_TexturaLUZ, RDHV_TexturaFondoLUZ )
// }                   
//
// O bien con modificadores:
// #include "RDHV.inc"                         
// #include "textures.inc"
// #declare RDHV_TexturaPrincipal  = PinkAlabaster
// object                       {
//   RDHV_RadioDespertador( 6, 45, 2, on )
// }
//
#include "colors.inc"

#declare OjoAbsoluto            = 256;
#declare VecesCentroAbsoluto    = 10;     
#declare L                      = 0.001;
camera {
        location  <   0,  0, -( VecesCentroAbsoluto+1 )*OjoAbsoluto >*L
        direction z
        sky       y
        angle     46.92
        right     16/9*x
//        look_at  <   0,  0, -VecesCentroAbsoluto*OjoAbsoluto >*L
}         
light_source    {
         < 500  , 500   , -3000 >*L
         White
}
light_source    {
         <-500  ,-500   , -3000 >*L
         White
}
background      {
         Gray50
}    
#include "RDHV.inc"

#local FactorAcercamiento       = 20;

object                          {
  RDHV_RadioDespertador( 6, 45, 10, on )
  translate       -0.023*y
  translate       -( VecesCentroAbsoluto+1 )
         *( FactorAcercamiento-1 )/( FactorAcercamiento )*OjoAbsoluto*L*z       
}



