// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  26 junio 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// RDHV RadioDespertadorHorarioVerano
// El archivo dibuja un Radio Despertador sencillo, con indicadores de cristal liquido. 
// Ofrece una macro para cambiar las caracteristicas principales y texturas.   
// Es compatible con POVRay 3.1.
//
// La macro principal tiene unicamente cuatro parametros
// #macro RDHV_RadioDespertador( Hora, Minuto, Indicadores, BanderaRadial )   
//      Hora                    : Entero para escribir la hora en la pantalla.
//      Minuto                  : Entero para escribir los minutos en la pantalla.
//      Indicadores             : Entero para elegir los indicadores.  Un Valor de
//              cero no enciende ningun indicador.  Para encender un indicador sume
//              el valor de su selector.
//                      RDHV_LUZDST                    =  1
//                      RDHV_LUZAM                     =  2
//                      RDHV_LUZPM                     =  4
//                      RDHV_LUZALARM                  =  8
//                      RDHV_LUZBATERIA                = 16
//      BanderaRadial           : "on" modelo de bordes curvos.  "off" modelo prismatico.
//
// La siguiente versin de la macro, permite un mayor control de las caracteristicas.
// #macro RDHV_RadioDespertadorHorarioVerano( Hora, Minuto, Indicadores,
//        BanderaRadial, Frente, Profundidad, Radial, Cizalla,
//        ArregloBotones, TexturaPrincipal, TexturaLabel, ArregloTexturasExtra,
//        TexturaLabelLUZ, TexturaTransparente, TexturaLUZ, TexturaFondoLUZ )
//      Hora                    : Entero para escribir la hora en la pantalla.
//      Minuto                  : Entero para escribir los minutos en la pantalla.
//      Indicadores             : Entero para elegir los indicadores.  Un Valor de
//              cero no enciende ningun indicador.  Para encender un indicador sume
//              el valor de su selector.
//                      RDHV_LUZDST                    =  1
//                      RDHV_LUZAM                     =  2
//                      RDHV_LUZPM                     =  4
//                      RDHV_LUZALARM                  =  8
//                      RDHV_LUZBATERIA                = 16
//      BanderaRadial           : "on" modelo de bordes curvos.  "off" modelo prismatico. 
//      Frente                  : Frente X para la radio, sin el borde curvo.             
//              Default es 71.5*L.
//      Profundidad             : Referencia para la profundidad Z de la radio.
//              Default es 95.0*L.
//      Radial                  : Radio de los laterales curvos.  La altura referencia
//              del aparato se asignara como 2*Radial.
//              Default es 19.7*L.
//      Cizalla                 : Fraccion para transformacion oblicua en Z del prisma base.
//              Default es 2/11.
//      ArregloBotones          : Arreglo bidimensional de reales.  Para describir los
//              botones de la parte superior del aparato.  
//              Cada dato tiene la composicion
//              { RDHV_IndiceBotonVisible, RDHV_IndiceBotonU, RDHV_IndiceBotonV,
//                RDHV_IndiceBotonFrente, RDHV_IndiceBotonRadio, RDHV_IndiceTexturaBoton }    
//              Por ejemplo para apagar el boton C, asigne
//              #declare ArregloBotones[C][RDHV_IndiceBotonVisible] = off;
//              RDHV_ArregloBotones  
//                      RDHV_IndiceBotonVisible         : "on" dibuja el boton, 
//                              "off" no lo dibuja.
//                      RDHV_IndiceBotonU               : Fraccion propia entre 0 y 1,
//                              para ubicacion frontal en la parte superior. 
//                              0.0 borde izquierdo, 1.0 borde derecho.
//                      RDHV_IndiceBotonV               : Fraccion propia entre 0 y 1,
//                              para abicacion Z en la parte superior.
//                              0.0 zona frontal, 1.0 al fondo.
//                      RDHV_IndiceBotonFrente          : Utilice 0.0 para botones 
//                              redondos.  Fraccion propia para indicar el largo X
//                              de un boton alargado.
//                      RDHV_IndiceBotonRadio           : El radio del boton, o
//                              de sus extremos;  si se trata de un boton alargado.
//                      RDHV_IndiceTexturaBoton         : Entero a partir de cero ubica
//                              la textura en el arreglo parametro ArregloTexturasExtra.
//                              Utilice valor negativo para no aplicar ninguna textura.  
//      TexturaPrincipal        : Textura principal a aplicar al aparato.
//              Default es RDHV_TexturaPrincipal.
//      TexturaLabel            : Textura que se aplica por diferencia a la parte superior.
//              Su funcion es etiquetar los botones, y pintar un parlante.
//              Default es RDHV_TexturaLabel.
//      ArregloTexturasExtra    : Tipo array para texturas.  Podria tener un unico
//              elemento.  Corresponde a las texturas asignadas por ArregloBotones.
//              Si asigna todas las texturas negativas, este valor se ignora.
//              Default es RDHV_ArregloTexturasExtra.
//      TexturaLabelLUZ         : Textura que se aplica al frente del radio.  Incluye
//              la rotulacion de emisoras e indicadores luminosos.
//              Default es RDHV_TexturaLabelLUZ.
//      TexturaTransparente     : Corresponde a una cubierta plastica protectora de
//              la pantalla de cristal liquido y todo el frente del aparato.
//              Default es RDHV_TexturaTransparente.
//      TexturaLUZ              : El color de la luz se pinta con esta textura.
//              Probablemente convenga asignar un valor ambient elevado
//              para cuartos oscuros. 
//      TexturaFondoLUZ         : Se aplica al fondo de la pantalla de cristal liquido.
//              Default es RDHV_TexturaFondoLUZ.
//  
// Esta macro dibuja solo el frente del RadioDespertador sin aplicar la cizalla,
// centrado como se indica mas adelante.  Podria ser util para agregar
// relojes de cristal liquido a otros objetos.
// #macro RDHV_DisplayClock( Hora, Minutos, Indicadores, FraccionDisplay,
//             BanderaRadial, Frente, ProfundidadDisplay, Radial,
//             TexturaLabelLUZ, TexturaTransparente,
//             TexturaLUZ, TexturaFondoLUZ )  
//      Hora                    : Entero para escribir la hora en la pantalla.
//      Minuto                  : Entero para escribir los minutos en la pantalla.
//      Indicadores             : Entero para elegir los indicadores.  Un Valor de
//              cero no enciende ningun indicador.  Para encender un indicador sume
//              el valor de su selector.
//                      RDHV_LUZDST                    =  1
//                      RDHV_LUZAM                     =  2
//                      RDHV_LUZPM                     =  4
//                      RDHV_LUZALARM                  =  8
//                      RDHV_LUZBATERIA                = 16  
//      FraccionDisplay         : Fraccion del alto del Display ocupado por el
//              despliegue incluyendo el fondo.  Default es 0.5.
//      BanderaRadial           : "on" modelo de bordes curvos.  "off" modelo prismatico. 
//      Frente                  : Frente X para la radio, sin el borde curvo.             
//              Default es 71.5*L.         
//      ProfundidadDisplay      : Profundidad aproximada del Display.
//              Default es 3.6*L.
//      Radial                  : Radio de los laterales curvos.  La altura referencia,
//              del aparato se tomara a partir de 2*Radial.
//              Default es 19.7*L.
//      TexturaLabelLUZ         : Textura que se aplica al frente del radio.  Incluye
//              la rotulacion de emisoras e indicadores luminosos.
//              Default es RDHV_TexturaLabelLUZ.
//      TexturaTransparente     : Corresponde a una cubierta plastica protectora de
//              la pantalla de cristal liquido y todo el frente del aparato.
//              Default es RDHV_TexturaTransparente.
//      TexturaLUZ              : El color de la luz se pinta con esta textura.
//              Probablemente convenga asignar un valor ambient elevado,
//              para cuartos oscuros. 
//      TexturaFondoLUZ         : Se aplica al fondo de la pantalla de cristal liquido.
//              Default es RDHV_TexturaFondoLUZ.
//
// Esta macro dibuja un Digito de la pantalla de cristal liquido, sin ubicar.
// #macro RDHV_DisplayDigito( Digito, Cizalla, BanderaUno, BanderaApagado,
//              TexturaEncendido, TexturaApagado )
//      Digito                  : Numero entero desde 0 a 9, a desplegar.
//      Cizalla                 : Cizalla en el eje Y del digito.
//      BanderaUno              : "on" indica que el digito solo puede valer uno o cero.
//              "off" indice un digito usual.  Se le asigna menor tamano.
//      BanderaApagado          : "on", dibuja las barras apagadas con TexturaApagado.
//              "off" ignora las barras apagadas.
//      TexturaEncendido        : Textura que se asigna a las barras encendidas.
//      TexturaApagado          : Permite asignar una textura a las barras apagadas.
//              Si BanderaApagado es "off" se ignora.              
//
// El aparato por defecto tiene las siguientes dimensiones:
//      Alto                            =  47*L
//      Frente en X (cilindrico)        = 111*L 
//      Frente en X (prismatico)        =  72*L 
//      Profundidad en Z                = 108*x  
// Se dibuja sobre el plano XZ.  El frente del aparato se encuentra centrado
// sobre el origen, de forma que se ubica totalmente detras del plano XY hacia Z-,
// con gravedad Y-.
// RDHV_DisplayClock dibuja el objeto sin cizalla en Z, tambien detras del plano XY
// hacia Z-.  El display se colocara centrado en el eje Y.
// RDHV_DisplayDigito dibuja numeros mediante dos cuadrados guias.
// Los cuadrados guias que forman el digito sin contar el grueso y cizalla son unitarios,
// el grueso de linea es 0.2.  La profundidad Z es de 0.1 centrada en el plano XY.
// El cuadrado guia sin contar el grueso y la cizalla, iniciaria en el origen.  
// Se dibujan desplazandose hacia arriba y a la derecha.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare RDHV_ArregloBotones1        = array [11][6]
//      Incluye descripciones de los botones default.  Sirve como
//      parametro en la macro detallada.
// #declare RDHV_DefaultTexturaPrincipal        
//      Textura principal a aplicar al aparato.
// #declare RDHV_DefaultTexturaLabel            
//      Textura que se aplica por diferencia a la parte superior.
//      Su funcion es etiquetar los botones, y pintar un parlante.
// #declare RDHV_DefaultTexturaLabelLUZ         
//      Textura que se aplica al frente del radio.  Incluye
//      la rotulacion de emisoras e indicadores luminosos.
// #declare RDHV_DefaultTexturaTransparente     
//      Corresponde a una cubierta plastica protectora de
//      la pantalla de cristal liquido y todo el frente del aparato.
// #declare RDHV_DefaultTexturaLUZ              
//      El color de la luz se pinta con esta textura.
//      Probablemente convenga asignar un valor ambient elevado para cuartos oscuros. 
// #declare RDHV_DefaultTexturaFondoLUZ         
//      Se aplica al fondo de la pantalla de cristal liquido. 
// #declare RDHV_DefaultTexturaExtra
//      Se aplica a los botones.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default)  
// #declare RDHV_ArregloTexturasExtra           = array [1] 
//                              { RDHV_DefaultTexturaExtra }
//      Textura a aplicar a los botones.  Se define como arreglo por requerimientos
//      de la macro detallada.
// #declare RDHV_TexturaPrincipal        
//      Textura principal a aplicar al aparato.
// #declare RDHV_TexturaLabel            
//      Textura que se aplica por diferencia a la parte superior.
//      Su funcion es etiquetar los botones, y pintar un parlante.
// #declare RDHV_TexturaLabelLUZ         
//      Textura que se aplica al frente del radio.  Incluye
//      la rotulacion de emisoras e indicadores luminosos.
// #declare RDHV_TexturaTransparente     
//      Corresponde a una cubierta plastica protectora de
//      la pantalla de cristal liquido y todo el frente del aparato.
// #declare RDHV_TexturaLUZ              
//      El color de la luz se pinta con esta textura.
//      Probablemente convenga asignar un valor ambient elevado para cuartos oscuros. 
// #declare RDHV_TexturaFondoLUZ         
//      Se aplica al fondo de la pantalla de cristal liquido.
// #declare RDHV_POV3_1                                 = off;
//      Valor "on" activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo simplemente
// #include "RDHV.inc"
// object        { RDHV_RadioDespertador( 6, 45, 2, on ) }
//
// Otro ejemplo con la macro detallada:
// #include "RDHV.inc"   
// object                       { 
//   RDHV_RadioDespertadorHorarioVerano( 6, 45, 2, on,
//          0.0715, 0.095, 0.0197, 2/11,
//          RDHV_ArregloBotones1, RDHV_TexturaPrincipal, RDHV_TexturaLabel, 
//          RDHV_ArregloTexturasExtra, RDHV_TexturaLabelLUZ, RDHV_TexturaTransparente,
//          RDHV_TexturaLUZ, RDHV_TexturaFondoLUZ )
// }                   
//
// O bien con modificadores:
// #include "RDHV.inc"                         
// #include "textures.inc"
// #declare RDHV_TexturaPrincipal  = PinkAlabaster
// object                       {
//   RDHV_RadioDespertador( 6, 45, 2, on )
// }
//

#include "colors.inc"
#include "RDHV_AU1.inc"

#declare RDHV_L                         = 0.001;

#declare RDHV_DefaultTexturaPrincipal   =
  texture                               {
    pigment                             {
      Gray15
    } 
    normal                              {    
      bumps
    }
  }

#ifndef ( RDHV_TexturaPrincipal )
  #declare RDHV_TexturaPrincipal        = RDHV_DefaultTexturaPrincipal
#end  // #ifndef ( RDHV_TexturaPrincipal ) 

#declare RDHV_DefaultTexturaLabel       =
  texture                               {  
    pigment                             {   
      Gray10
    }
  }         
  texture                               {    
    pigment                             {   
      image_map                         {  
        gif     "RDHV_IM2.gif"  
        once
      }                         
      rotate                    90*x
    }
  }
           
#ifndef ( RDHV_TexturaLabel )        
  #declare RDHV_TexturaLabel            = RDHV_DefaultTexturaLabel
#end  // #ifndef ( RDHV_TexturaLabel )           
           
#declare RDHV_DefaultTexturaLabelLUZ                =
  texture               { 
    pigment             { 
      Gray10
    } 
  }
  texture               { 
    pigment             { 
      image_map         {  
        gif             "RDHV_IM1.gif"  
        once
      }
    } 
  }   
    
#ifndef ( RDHV_TexturaLabelLUZ )
  #declare RDHV_TexturaLabelLUZ              = RDHV_DefaultTexturaLabelLUZ
#end  // #ifndef ( RDHV_TexturaLabelLUZ ) 

#declare RDHV_DefaultTexturaTransparente       =
  texture { pigment { Green transmit 0.95 } }

#ifndef ( RDHV_TexturaTransparente )
  #declare RDHV_TexturaTransparente     = RDHV_DefaultTexturaTransparente
#end  // #ifndef ( RDHV_TexturaTransparente )

#declare RDHV_DefaultTexturaLUZ                =
  texture { pigment { Green } finish { ambient 0.6 diffuse 0.3 } }

#ifndef ( RDHV_TexturaLUZ )
  #declare RDHV_TexturaLUZ              = RDHV_DefaultTexturaLUZ
#end  // #ifndef ( RDHV_TexturaLUZ )

#declare RDHV_DefaultTexturaFondoLUZ                =
  texture { pigment { Gray10 } }

#ifndef ( RDHV_TexturaFondoLUZ )
  #declare RDHV_TexturaFondoLUZ              = RDHV_DefaultTexturaFondoLUZ
#end  // #ifndef ( RDHV_TexturaFondoLUZ )
 
#declare RDHV_DefaultTexturaExtra            =
  texture { pigment { Gray30 } } 
 
#declare RDHV_IndiceTotalBoton          = 6;
#declare RDHV_IndiceBotonVisible        = 0;
#declare RDHV_IndiceBotonU              = 1;
#declare RDHV_IndiceBotonV              = 2;
#declare RDHV_IndiceBotonFrente         = 3;
#declare RDHV_IndiceBotonRadio          = 4;
#declare RDHV_IndiceTexturaBoton        = 5;  
#declare RDHV_LUZDST                    = 1;
#declare RDHV_LUZAM                     = 2;
#declare RDHV_LUZPM                     = 4;
#declare RDHV_LUZALARM                  = 8;
#declare RDHV_LUZBATERIA                = 16;


#declare RDHV_ArregloBotones1           = array [11][RDHV_IndiceTotalBoton]
   { {   on, 0.1, 0.1, 0.50, 0.075, 0   },
     {   on, 0.875, 0.125, 0.00, 0.10, 0  },
     {   on, 0.35, 0.30, 0.00, 0.05, 0  },
     {   on, 0.1, 0.30, 0.00, 0.075, 0  },
     {   on, 0.50, 0.3, 0.00, 0.05, 0  },
     {   on, 0.65, 0.3, 0.00, 0.05, 0  },
     {   off, 0.10, 0.45, 0.45, 0.025, 0 },
     {   on, 0.10, 0.45, 0.0, 0.025, 0 },
     {   on, 0.2, 0.45, 0.05, 0.025, 0 },
     {   on, 0.35, 0.45, 0.05, 0.025, 0 },
     {   on, 0.55, 0.45, 0.0, 0.025, 0 }
   }
   

#declare RDHV_ArregloTexturasExtra           = array [1]
   { RDHV_DefaultTexturaExtra  }

#macro RDHV_RadioDespertadorHorarioVerano( Hora, Minuto, Indicadores,
        BanderaRadial, Frente, Profundidad, Radial, Cizalla,
        ArregloBotones, TexturaPrincipal, TexturaLabel, ArregloTexturasExtra,
        TexturaLabelLUZ, TexturaTransparente, TexturaLUZ, TexturaFondoLUZ )
  union                                 {
    #local AlturaPatasDelantera         = 5.4/95.0*Profundidad;
    #local AlturaPatasPosterior         = 1.6/95.0*Profundidad;
    #local ProfundidadDisplay           = 3.6/95*Profundidad;
    #if ( BanderaRadial )
      #local FrenteTotal                = Frente+2*Radial;
    #else  // #else ( BanderaRadial )
      #local FrenteTotal                = Frente;
    #end   // #else ( BanderaRadial )
    // BloquePrincipal
    union                               {
      difference                          {
        union                             {
          box                             {
            <-Frente/2,0,0>,
            <+Frente/2,-2*Radial,Profundidad>
          }
          #if ( BanderaRadial )
            cylinder                      {
              0, Profundidad*z, Radial
              translate         -Frente/2*x-Radial*y
            }
            cylinder                      {
              0, Profundidad*z, Radial
              translate         +Frente/2*x-Radial*y
            }
          #end  // #if ( BanderaRadial )
          matrix   <1,0,0,
                    0,1,Cizalla,
                    0,0,1,
                    0,0,0>
        }
        box                             {
          <-Frente,-0.02*Radial,-Profundidad>,
          <+Frente,+0.02*Radial,+2*Profundidad>
          translate                     -Radial*y
        }
        box                             {     
          <-1, 0, 0>, 1
          texture                       {   
            TexturaLabel 
            translate                   -0.5*x-0.025*z
            scale                       <2.75,1,1>
          }             
          scale                         <Frente/2,1,Profundidad>  
          translate                     -0.001*Radial*y
        }
        #local C                        = 0;
        #local TotalBotonArriba         = dimension_size( ArregloBotones, 1 );
        #while ( C < TotalBotonArriba )
            cylinder                      {
              0.001*Radial*y, -0.05*Radial*y,
              1.1*ArregloBotones[C][RDHV_IndiceBotonRadio]*Frente
              translate           (ArregloBotones[C][RDHV_IndiceBotonU]-0.5)*Frente*x
              translate           ArregloBotones[C][RDHV_IndiceBotonV]*Profundidad*z
            }
            #if ( ArregloBotones[C][RDHV_IndiceBotonFrente] > 0 )
              box                           {
                <0,0.001,-1.1>,
                <ArregloBotones[C][RDHV_IndiceBotonFrente],-0.05,1.1>
                scale   <Frente,Radial,ArregloBotones[C][RDHV_IndiceBotonRadio]*Frente>
                translate           (ArregloBotones[C][RDHV_IndiceBotonU]-0.5)*Frente*x
                translate           ArregloBotones[C][RDHV_IndiceBotonV]*Profundidad*z
              }
              cylinder                      {
                0.001*Radial*y, -0.05*Radial*y,
                1.1*ArregloBotones[C][RDHV_IndiceBotonRadio]*Frente
                translate           (ArregloBotones[C][RDHV_IndiceBotonU]-0.5)*Frente*x
                translate           ArregloBotones[C][RDHV_IndiceBotonFrente]*Frente*x
                translate           ArregloBotones[C][RDHV_IndiceBotonV]*Profundidad*z
              }
            #end  // #if ( ArregloBotones[C][RDHV_IndiceBotonFrente > 0 ])
          #local C                      = C+1;
        #end  // #while ( C < TotalBotonArriba )
      }
      box                               {
        <-FrenteTotal/2,-0.022*Radial, 0>*0.99,
        <+FrenteTotal/2,+0.022*Radial,+Profundidad>*0.99
        translate                     -Radial*y
        matrix   <1,0,0,
                  0,1,Cizalla,
                  0,0,1,
                  0,0,0>
      }
      #local C                        = 0;
      #local TotalBotonArriba         = dimension_size( ArregloBotones, 1 );
      #while ( C < TotalBotonArriba )
        #if ( ArregloBotones[C][RDHV_IndiceBotonVisible] )
          union                         {
            cylinder                      {
              0.05*Radial*y, -0.05*Radial*y,
              1.0*ArregloBotones[C][RDHV_IndiceBotonRadio]*Frente
              translate           (ArregloBotones[C][RDHV_IndiceBotonU]-0.5)*Frente*x
              translate           ArregloBotones[C][RDHV_IndiceBotonV]*Profundidad*z
            }
            #if ( ArregloBotones[C][RDHV_IndiceBotonFrente] > 0 )
              box                           {
                <0,0.05,-1.0>,
                <ArregloBotones[C][RDHV_IndiceBotonFrente],-0.05,1.0>
                scale   <Frente,Radial,ArregloBotones[C][RDHV_IndiceBotonRadio]*Frente>
                translate           (ArregloBotones[C][RDHV_IndiceBotonU]-0.5)*Frente*x
                translate           ArregloBotones[C][RDHV_IndiceBotonV]*Profundidad*z
              }
              cylinder                      {
                0.05*Radial*y, -0.05*Radial*y,
                1.0*ArregloBotones[C][RDHV_IndiceBotonRadio]*Frente
                translate           (ArregloBotones[C][RDHV_IndiceBotonU]-0.5)*Frente*x
                translate           ArregloBotones[C][RDHV_IndiceBotonFrente]*Frente*x
                translate           ArregloBotones[C][RDHV_IndiceBotonV]*Profundidad*z
              }
            #end  // #if ( ArregloBotones[C][RDHV_IndiceBotonFrente > 0 ])
            #if ( ArregloBotones[C][RDHV_IndiceTexturaBoton] >= 0 )
              texture                   {
                ArregloTexturasExtra
                [ ArregloBotones[C][RDHV_IndiceTexturaBoton] ]
              }
            #end  // #if ( ...RDHV_IndiceBotonTextura )
          }
        #end  // #if ( ...RDHV_IndiceBotonPosBoton ... )
        #local C                      = C+1;
      #end  // #while ( C < TotalBotonArriba )
      object                            {
        RDHV_DisplayClock( Hora, Minuto,Indicadores, 0.5,
            BanderaRadial, Frente, ProfundidadDisplay, Radial,
            TexturaLabelLUZ, TexturaTransparente,
            TexturaLUZ, TexturaFondoLUZ )
        translate               -Radial*y
        matrix   <1,0,0,
                  0,1,Cizalla,
                  0,0,1,
                  0,0,0>
      }
      translate                   2*Radial*y+2*Radial*Cizalla*z
      translate                   -0.10*Profundidad*z
      #local Angulo               =
              ( AlturaPatasDelantera-AlturaPatasPosterior )/( 0.9*Profundidad );
      #local Angulo               = asin( Angulo );
      #local SepProf              = 0.8*Profundidad*cos( Angulo );
      rotate                     degrees( Angulo )*x
      translate                 AlturaPatasDelantera*y
      texture                           {
        TexturaPrincipal
      }
    }
    union                               {
      #if ( BanderaRadial )
        #local FrentePata               = Frente;
      #else  // #else ( BanderaRadial )
        #local FrentePata               = 0.9*Frente;
      #end   // #else ( BanderaRadial )
      cylinder                          {
        -0.5*FrentePata*x, 0.5*FrentePata*x, 0.6*AlturaPatasDelantera
        scale                   <1,2,1>
        translate              1.2*AlturaPatasDelantera*y
      }
      #local C                          = 0;
      #while ( C < 2 )
        sphere                          {
          <0.5*FrentePata,0,0>, 0.6*AlturaPatasDelantera
          scale                 <1,2,1>
          #if ( C =1 )
            scale                       <-1,1,1>
          #end  // #if ( C = 1 )
          translate             1.2*AlturaPatasDelantera*y
        }
        sphere                          {
          <0.45*Frente,2*AlturaPatasPosterior,
           0.8*Profundidad*cos(Angulo)>, 2*AlturaPatasPosterior
          #if ( C =1 )
            scale                       <-1,1,1>
          #end  // #if ( C = 1 )
        }
        #local C                        = C+1;
      #end  // #while ( C < 2 )
      texture                           {
        TexturaPrincipal
      }
    }
    translate                   0.10*Profundidad*cos( Angulo )*z
    translate                   ProfundidadDisplay*cos( Angulo )*z
  }
#end  // #macro RDHV_RadioDespertadorHorarioVerano


#macro RDHV_RadioDespertador( Hora, Minuto, Indicadores, BanderaRadial )
  object                                {
    #local L                            = RDHV_L;
    #local Frente                       = 71.5*L;
    #local Profundidad                  = 95.0*L;
    #local Radial                       = 19.7*L;
    #local Cizalla                      = 2/11;
    RDHV_RadioDespertadorHorarioVerano( Hora, Minuto,Indicadores,
          BanderaRadial, Frente, Profundidad, Radial, Cizalla,
          RDHV_ArregloBotones1, RDHV_TexturaPrincipal, RDHV_TexturaLabel, RDHV_ArregloTexturasExtra,
          RDHV_TexturaLabelLUZ, RDHV_TexturaTransparente,
          RDHV_TexturaLUZ, RDHV_TexturaFondoLUZ )
  }
#end  // #macro RDHV_RadioDespertador


