// This file is licensed under the terms of the CC-LGPL.
// NOTA: El juego "Nudos Iniciales", al que alude la portada del disco,
// fue programado por nosotros.  La imagen se cambia facilmente.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  18 noviembre 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// D7OR Disco700MBOnlyRead
// El archivo dibuja una caja para CD con disco.   
// Se puede modificar la imagen y otras caracteristicas.
// Internamente se incluyen macros que permiten modificar
// muchas caracteristicas.  No se documentaron para ahorrar tiempo,
// puesto que se consideraron de poco interes para el usuario final.   
// Es compatible con POVRay 3.1.
//
// La macro carece de parametros
// #macro D7OR_CajaCD( BanderaDisco, AnguloAbrir, NombreImagenGIF )
//      BanderaDisco            : "on" dibuja el CD interior.  "off" no lo dibuja.
//      AnguloAbrir             : Angulo en grados de apertura de la caja.
//      NombreImagenGIF         : Para cambiar facilmente la portada del disco.
//              Indique el nombre del archivo GIF como String.  
//              Si utiliza "" sin nombre, se dibuja la portada de "Nudos Iniciales".
//
// Cuando cerrada la caja se encuentra contenida enteramente en:
// <0,0,0> ... <LargoCaja,AltoCaja,-GruesoCaja>   
//      LargoCaja               = 100*L          
//      AltoCaja                =  87*L   
//      GruesoCaja              =   7*L
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare D7OR_DefaultMaterialPrincipal 
//      Material principal de la caja.         
// #declare D7OR_DefaultMaterialDecoradoPrincipal
//      Material para el decorado lateral, superior e inferior.          
// #declare D7OR_DefaultMaterialSoporte                        
//      Material para el soporte interno del disco.
// #declare D7OR_DefaultTexturaCaratulaDisco  
//      Textura del papel para la cara frontal de la caja.      
// #declare D7OR_DefaultTexturaLabelPosterior   
//      Textura del papel para la cara posterior de la caja.     
// #declare D7OR_DefaultTexturaLabelLateralDerecha   
//      Textura del papel para el lateral derecho de la caja.
// #declare D7OR_DefaultTexturaLabelLateralIzquierda         
//      Textura del papel para el lateral izquierdo de la caja.
// #declare D7OR_DefaultTexturaCentralDisco        
//      Textura para el centro del disco CD.   
// #declare D7OR_DefaultTexturaMetalDisco   
//      Textura metalica del disco CD.     
// #declare D7OR_DefaultTexturaLabelFrente
//      Textura para la etiqueta del disco CD.        
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default) 
// #declare D7OR_MaterialPrincipal              = material { ... }
//      Material principal de la caja.         
// #declare D7OR_MaterialDecoradoPrincipal      = material { ... }
//      Material para el decorado lateral, superior e inferior.          
// #declare D7OR_MaterialSoporte                = material { ... }        
//      Material para el soporte interno del disco.
// #declare D7OR_TexturaCaratulaDisco           = texture  { ... }
//      Textura del papel para la cara frontal de la caja.      
// #declare D7OR_TexturaLabelPosterior          = texture  { ... }
//      Textura del papel para la cara posterior de la caja.     
// #declare D7OR_TexturaLabelLateralDerecha     = texture  { ... }
//      Textura del papel para el lateral derecho de la caja.
// #declare D7OR_TexturaLabelLateralIzquierda   = texture  { ... }      
//      Textura del papel para el lateral izquierdo de la caja.
// #declare D7OR_TexturaCentralDisco            = texture  { ... }
//      Textura para el centro del disco CD.   
// #declare D7OR_TexturaMetalDisco              = texture  { ... }
//      Textura metalica del disco CD.     
// #declare D7OR_TexturaLabelFrente             = texture  { ... }
//      Textura para la etiqueta del disco CD.        
// #declare JFSG_POV3_1                         = off;
//      Valor "on" activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo conviene elevar primero el valor de max_trace_level,
// de lo contrario, aparecen rayas negras antiesteticas.
// #include "D7OR.inc"                                  
// global_settings              { max_trace_level 8 }
// object        { D7OR_CajaCD( on, 60, "" ) }
//            
// Cambiar la portada
// #include "D7OR.inc"
// global_settings              { max_trace_level 8 }
// object        { D7OR_CajaCD( on, 60, "custom.gif" ) }
//
// O bien con modificadores:
// #include "D7OR.inc"                         
// #include "textures.inc"     
// global_settings              { max_trace_level 8 }
// #declare D7OR_MaterialPrincipal      = material { M_Glass }
// object                       {
//   D7OR_CajaCD( on, 60, "" )
// }
//
#include "colors.inc"
                         
global_settings         {
  max_trace_level       8
} 

#declare OjoAbsoluto            = 256;
#declare VecesCentroAbsoluto    = 10;     
#declare L                      = 0.001;
camera {
        location  <   0,  0, -( VecesCentroAbsoluto+1 )*OjoAbsoluto >*L
        direction z
        sky       y
        angle     38.74
//        look_at  <   0,  0, -VecesCentroAbsoluto*OjoAbsoluto >*L
}

light_source    {
         < 500  , -500   , -3000 >*L
         White
}  

light_source    {
         <-500  , -500   , -3000 >*L
         White
}
  
background      {
         Gray50
}    


#include "d7or.inc" 

#local FactorAcercamiento       = 11;                               
                               
object                                  {
    D7OR_CajaCD( on, 60, "" )            
    translate       +0.050*x-0.0435*y
    translate       -( VecesCentroAbsoluto+1 )*( FactorAcercamiento-1 )
                          /( FactorAcercamiento )*OjoAbsoluto*L*z        
}




