// This file is licensed under the terms of the CC-LGPL.
// NOTA: El juego "Nudos Iniciales", al que alude la portada del disco,
// fue programado por nosotros.  La imagen se cambia facilmente.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  18 noviembre 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// D7OR Disco700MBOnlyRead
// El archivo dibuja una caja para CD con disco.   
// Se puede modificar la imagen y otras caracteristicas.
// Internamente se incluyen macros que permiten modificar
// muchas caracteristicas.  No se documentaron para ahorrar tiempo,
// puesto que se consideraron de poco interes para el usuario final.   
// Es compatible con POVRay 3.1.
//
// La macro carece de parametros
// #macro D7OR_CajaCD( BanderaDisco, AnguloAbrir, NombreImagenGIF )
//      BanderaDisco            : "on" dibuja el CD interior.  "off" no lo dibuja.
//      AnguloAbrir             : Angulo en grados de apertura de la caja.
//      NombreImagenGIF         : Para cambiar facilmente la portada del disco.
//              Indique el nombre del archivo GIF como String.  
//              Si utiliza "" sin nombre, se dibuja la portada de "Nudos Iniciales".
//
// Cuando cerrada la caja se encuentra contenida enteramente en:
// <0,0,0> ... <LargoCaja,AltoCaja,-GruesoCaja>   
//      LargoCaja               = 100*L          
//      AltoCaja                =  87*L   
//      GruesoCaja              =   7*L
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare D7OR_DefaultMaterialPrincipal 
//      Material principal de la caja.         
// #declare D7OR_DefaultMaterialDecoradoPrincipal
//      Material para el decorado lateral, superior e inferior.          
// #declare D7OR_DefaultMaterialSoporte                        
//      Material para el soporte interno del disco.
// #declare D7OR_DefaultTexturaCaratulaDisco  
//      Textura del papel para la cara frontal de la caja.      
// #declare D7OR_DefaultTexturaLabelPosterior   
//      Textura del papel para la cara posterior de la caja.     
// #declare D7OR_DefaultTexturaLabelLateralDerecha   
//      Textura del papel para el lateral derecho de la caja.
// #declare D7OR_DefaultTexturaLabelLateralIzquierda         
//      Textura del papel para el lateral izquierdo de la caja.
// #declare D7OR_DefaultTexturaCentralDisco        
//      Textura para el centro del disco CD.   
// #declare D7OR_DefaultTexturaMetalDisco   
//      Textura metalica del disco CD.     
// #declare D7OR_DefaultTexturaLabelFrente
//      Textura para la etiqueta del disco CD.        
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default) 
// #declare D7OR_MaterialPrincipal              = material { ... }
//      Material principal de la caja.         
// #declare D7OR_MaterialDecoradoPrincipal      = material { ... }
//      Material para el decorado lateral, superior e inferior.          
// #declare D7OR_MaterialSoporte                = material { ... }        
//      Material para el soporte interno del disco.
// #declare D7OR_TexturaCaratulaDisco           = texture  { ... }
//      Textura del papel para la cara frontal de la caja.      
// #declare D7OR_TexturaLabelPosterior          = texture  { ... }
//      Textura del papel para la cara posterior de la caja.     
// #declare D7OR_TexturaLabelLateralDerecha     = texture  { ... }
//      Textura del papel para el lateral derecho de la caja.
// #declare D7OR_TexturaLabelLateralIzquierda   = texture  { ... }      
//      Textura del papel para el lateral izquierdo de la caja.
// #declare D7OR_TexturaCentralDisco            = texture  { ... }
//      Textura para el centro del disco CD.   
// #declare D7OR_TexturaMetalDisco              = texture  { ... }
//      Textura metalica del disco CD.     
// #declare D7OR_TexturaLabelFrente             = texture  { ... }
//      Textura para la etiqueta del disco CD.        
// #declare JFSG_POV3_1                         = off;
//      Valor "on" activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo conviene elevar primero el valor de max_trace_level,
// de lo contrario, aparecen rayas negras antiesteticas.
// #include "D7OR.inc"                                  
// global_settings              { max_trace_level 8 }
// object        { D7OR_CajaCD( on, 60, "" ) }
//            
// Cambiar la portada
// #include "D7OR.inc"
// global_settings              { max_trace_level 8 }
// object        { D7OR_CajaCD( on, 60, "custom.gif" ) }
//
// O bien con modificadores:
// #include "D7OR.inc"                         
// #include "textures.inc"     
// global_settings              { max_trace_level 8 }
// #declare D7OR_MaterialPrincipal      = material { M_Glass }
// object                       {
//   D7OR_CajaCD( on, 60, "" )
// }
//

#declare D7OR_L                                 = 0.001;
#include "colors.inc"
#include "metals.inc"  
#include "stones.inc"

#declare D7OR_DefaultMaterialPrincipal          =
  material                      {
    texture                     {
      pigment                   {
        White
        transmit                0.925
      }
      finish                    {
        phong                   0.05
        phong_size              0.05
      }
    }
  }  

#ifndef ( D7OR_MaterialPrincipal )
  #declare D7OR_MaterialPrincipal       = D7OR_DefaultMaterialPrincipal
#end  // #ifndef ( D7OR_MaterialPrincipal )

#declare D7OR_DefaultMaterialDecoradoPrincipal          =
  material                      {
    texture                     {
      pigment                   {
        White
        transmit                0.9
      }
      finish                    {
        phong                   0.1
        phong_size              0.1
      }
      normal                    {
        gradient                x
        scale                   0.001
        ramp_wave
      }
    }
  }

#ifndef ( D7OR_MaterialDecoradoPrincipal )
  #declare D7OR_MaterialDecoradoPrincipal       =
                        D7OR_DefaultMaterialDecoradoPrincipal
#end  // #ifndef ( D7OR_MaterialDecoradoPrincipal )

#declare D7OR_DefaultMaterialSoporte    = 
  material                      {
    texture                     {
      pigment                   {
        White
        transmit                0.9
      }
      finish                    {
        phong                   0.05
        phong_size              0.05
      }
    }
  }  


#ifndef ( D7OR_MaterialSoporte )
  #declare D7OR_MaterialSoporte          =
                        D7OR_DefaultMaterialSoporte
#end  // #ifndef ( D7OR_MaterialSoporte )

#declare D7OR_DefaultTexturaCentralDisco        =
  texture                               {
    pigment                             {
      White transmit 0.6
    }
  }

#ifndef ( D7OR_TexturaCentralDisco )
  #declare D7OR_TexturaCentralDisco             =
                        D7OR_DefaultTexturaCentralDisco
#end  // #ifndef ( D7OR_TexturaCentralDisco )

#declare D7OR_DefaultTexturaMetalDisco        =
  texture                               {
    pigment { Silver }
  }

#ifndef ( D7OR_TexturaMetalDisco )
  #declare D7OR_TexturaMetalDisco             =
                        D7OR_DefaultTexturaMetalDisco
#end  // #ifndef ( D7OR_TexturaMetalDisco )

#declare D7OR_DefaultTexturaLabelFrente        =
  texture                               {
    pigment                     {   
      image_map                 {    
        gif         "D7OR_IM1.gif"
      }
    } 
  } 
    
#ifndef ( D7OR_TexturaLabelFrente )
  #declare D7OR_TexturaLabelFrente             =
                        D7OR_DefaultTexturaLabelFrente
#end  // #ifndef ( D7OR_TexturaLabelFrente )
    
#declare D7OR_DefaultTexturaCaratulaDisco        = D7OR_DefaultTexturaLabelFrente

#ifndef ( D7OR_TexturaCaratulaDisco )
  #declare D7OR_TexturaCaratulaDisco             =
                        D7OR_DefaultTexturaCaratulaDisco
#end  // #ifndef ( D7OR_TexturaCaratulaDisco )
    
#declare D7OR_DefaultTexturaLabelPosterior        =
  texture                               {   
    brick                               
    texture { T_Stone26 } texture { T_Stone31 }
    scale               0.05
  } 

#ifndef ( D7OR_TexturaLabelPosterior )
  #declare D7OR_TexturaLabelPosterior             =
                        D7OR_DefaultTexturaLabelPosterior
#end  // #ifndef ( D7OR_TexturaLabelPosterior )

#declare D7OR_DefaultTexturaLabelLateralDerecha   = D7OR_DefaultTexturaLabelPosterior

#ifndef ( D7OR_TexturaLabelLateralDerecha )
  #declare D7OR_TexturaLabelLateralDerecha             =
                        D7OR_DefaultTexturaLabelLateralDerecha
#end  // #ifndef ( D7OR_TexturaLabelLateralDerecha )

#declare D7OR_DefaultTexturaLabelLateralIzquierda = D7OR_DefaultTexturaLabelPosterior

#ifndef ( D7OR_TexturaLabelLateralIzquierda )
  #declare D7OR_TexturaLabelLateralIzquierda             =
                        D7OR_DefaultTexturaLabelLateralIzquierda
#end  // #ifndef ( D7OR_TexturaLabelLateralIzquierda )

#macro D7OR_CajaSuperior( BanderaLabel,
        LargoCaja, AltoCaja, GruesoCaja, GruesoPlastico,
        BordeGiro,
        MaterialPrincipal, MaterialDecoradoPrincipal,
        TexturaLabelFrente )
  union                         {
    #local C                    = 0;
    #while ( C < 2 )
      merge                     {
        #local SujetadorCilindro        = 0.12*LargoCaja;
        difference              {
          prism                   {
            0, GruesoPlastico,
            8,
            <-GruesoCaja/2,-GruesoCaja/2>,
            < LargoCaja-GruesoCaja/2,-GruesoCaja/2>,
            < LargoCaja-GruesoCaja/2,+GruesoCaja/2-GruesoPlastico>,
            <-GruesoCaja/2+GruesoCaja,+GruesoCaja/2-GruesoPlastico>,
            <-GruesoCaja/2+GruesoCaja-GruesoPlastico,+GruesoCaja/2>,
            <-GruesoCaja/2+GruesoPlastico,+GruesoCaja/2>,
            <-GruesoCaja/2,+GruesoCaja/2-GruesoPlastico>,
            <-GruesoCaja/2,-GruesoCaja/2>
            translate             -AltoCaja/2*y
            material                    {
              MaterialPrincipal
            }
            
          }
          box                           {
            <+LargoCaja-GruesoCaja/2-3*SujetadorCilindro/2, -1.1*AltoCaja/2,
             -GruesoCaja/2+2*GruesoPlastico >,
            <+LargoCaja-GruesoCaja/2-  SujetadorCilindro  ,               0,
             -GruesoCaja/2+  GruesoPlastico >
          }
          box                           {
            <-GruesoCaja/2+GruesoPlastico,-0.005*GruesoPlastico,
               -GruesoCaja/2+GruesoPlastico>,
            <+LargoCaja-GruesoCaja/2-GruesoPlastico,0.005*GruesoPlastico,
               +GruesoCaja/2-GruesoPlastico>
            translate             -AltoCaja/2*y
            material                    {
              MaterialDecoradoPrincipal
            }
          }
        }
        difference                      {
          cylinder                        {
            ( -GruesoCaja/2+2*GruesoPlastico )*z,
            ( -GruesoCaja/2+3*GruesoPlastico )*z,
            SujetadorCilindro/4
          }
          plane                         {
            y, GruesoPlastico
          }
          translate             0.0001*GruesoPlastico
          translate             ( +LargoCaja-GruesoCaja/2
                                -5*SujetadorCilindro/4 )*x
          translate                -AltoCaja/2*y

        }
        box                             {
          < +LargoCaja-GruesoCaja/2-GruesoPlastico, -AltoCaja/2,
            -GruesoCaja/2 >,
          < +LargoCaja-GruesoCaja/2               , +AltoCaja/2,
            -GruesoCaja/2+GruesoPlastico >
        }
        box                             {
          < +LargoCaja-GruesoCaja/2-2*GruesoPlastico, -3*AltoCaja/8,
            -GruesoCaja/2 >,
          < +LargoCaja-GruesoCaja/2-3*GruesoPlastico, -1*AltoCaja/8,
            -GruesoCaja/2+2*GruesoPlastico >
        }
        cylinder                            {
          0, 2*GruesoPlastico*y, GruesoPlastico
          translate         -AltoCaja/2*y
        }
        #if ( C = 0 )
          scale                 <+1,-1,+1>
        #end  // #if ( C = 0 )
      }
      #local C                  = C+1;
    #end  // #while ( C < 2 )
    union                               {
      box                               {
        < -GruesoCaja/2+BordeGiro, -AltoCaja/2,
          -GruesoCaja/2+1*GruesoPlastico/4 >,
        < +LargoCaja-GruesoCaja/2, +AltoCaja/2,
          -GruesoCaja/2+3*GruesoPlastico/4 >
      }
      box                               {
        < -GruesoCaja/2+BordeGiro+  GruesoPlastico, -AltoCaja/2,
          -GruesoCaja/2+1*GruesoPlastico >,
        < -GruesoCaja/2+BordeGiro+2*GruesoPlastico, +AltoCaja/2,
          -GruesoCaja/2+3*GruesoPlastico >
      }
    }
    #if ( BanderaLabel )
      box                       {
        0, 1
        translate               -0.5*z
        texture                 {
          TexturaLabelFrente
        }
        scale                   < LargoCaja-BordeGiro-7*GruesoPlastico,
                          AltoCaja-4*GruesoPlastico, 0.002*GruesoPlastico >
        translate    <-GruesoCaja/2+BordeGiro+3*GruesoPlastico,
                        -AltoCaja/2+2*GruesoPlastico, 0 >
        rotate                  0.1
        translate               ( -GruesoCaja/2+GruesoPlastico )*z
      }
    #end  // #if ( BanderaLabel )  
    material                    {
      MaterialPrincipal
    }
  }
#end  // #macro D7OR_CajaSuperior

#macro D7OR_CajaInferior( BanderaLabelPosterior,
        BanderaLabelLateralIzquierda,
        BanderaLabelLateralDerecha  ,
        LargoCaja, AltoCaja, GruesoCaja, GruesoPlastico,
        BordeGiro, Aire,
        MaterialPrincipal, TexturaLabelPosterior,
        TexturaLabelLateralIzquierda,
        TexturaLabelLateralDerecha  )
  union                         {
    #local C                    = 0;
    #while ( C < 2 )
      merge                     {
        #local SujetadorCilindro        = 0.12*LargoCaja;
        difference              {
          prism                 {
            0, GruesoPlastico,
            19,
            < -GruesoCaja/2, +GruesoCaja/2 >,
            < +LargoCaja-GruesoCaja/2-GruesoPlastico, +GruesoCaja/2 >,
            < +LargoCaja-GruesoCaja/2-GruesoPlastico, -GruesoCaja/2+2*GruesoPlastico >,
            < +LargoCaja-GruesoCaja/2-2*SujetadorCilindro/2,
              -GruesoCaja/2+2*GruesoPlastico >,
            < +LargoCaja-GruesoCaja/2-2*SujetadorCilindro/2,
              -GruesoCaja/2+3*GruesoPlastico >,
            < +LargoCaja-GruesoCaja/2-3*SujetadorCilindro/2,
              -GruesoCaja/2+3*GruesoPlastico >,
            < +LargoCaja-GruesoCaja/2-3*SujetadorCilindro/2,
              -GruesoCaja/2+2*GruesoPlastico >,
            < -GruesoCaja/2+2*LargoCaja/3,
              -GruesoCaja/2+2*GruesoPlastico >,
            < -GruesoCaja/2+2*LargoCaja/3,
              +GruesoCaja/2-3*GruesoPlastico/2 >,
            < -GruesoCaja/2+1*LargoCaja/3,
              +GruesoCaja/2-1*GruesoPlastico   >,
            < -GruesoCaja/2+1*LargoCaja/3,
              -GruesoCaja/2+2*GruesoPlastico >,
            < -GruesoCaja/2+BordeGiro+3*SujetadorCilindro/2,
              -GruesoCaja/2+2*GruesoPlastico >,
            < -GruesoCaja/2+BordeGiro+3*SujetadorCilindro/2,
              -GruesoCaja/2+3*GruesoPlastico >,
            < -GruesoCaja/2+BordeGiro+2*SujetadorCilindro/2,
              -GruesoCaja/2+3*GruesoPlastico >,
            < -GruesoCaja/2+BordeGiro+2*SujetadorCilindro/2,
              -GruesoCaja/2+2*GruesoPlastico >,
            < -GruesoCaja/2+BordeGiro, -GruesoCaja/2+2*GruesoPlastico >,
            < -GruesoCaja/2+BordeGiro-GruesoPlastico, -GruesoCaja/2+GruesoPlastico >,
            < -GruesoCaja/2, -GruesoCaja/2+GruesoPlastico >,
            < -GruesoCaja/2, +GruesoCaja/2 >
            translate           ( -AltoCaja/2+GruesoPlastico+Aire )*y
          }
          cylinder              {
            0, 4*GruesoPlastico*y, GruesoPlastico/2
            translate           ( LargoCaja-BordeGiro-GruesoCaja/2 )*x
            translate           +GruesoPlastico/2*z
            translate           -AltoCaja/2*y
          }
          cylinder              {
            0, 4*GruesoPlastico*y, GruesoPlastico/2
            translate           ( 2*LargoCaja/3 )*x
            translate           +GruesoPlastico/2*z
            translate           -AltoCaja/2*y
          }
        }
        #if ( C = 0)
          scale                 <1,-1,1>
        #end  // #if ( C = 0 )
      }
      #local C                  = C+1;
    #end  // #while ( C < 2 )
    box                         {
      < -GruesoCaja/2+BordeGiro, -AltoCaja/2, +GruesoCaja/2 >,
      < -GruesoCaja/2+LargoCaja, +AltoCaja/2, +GruesoCaja/2-GruesoPlastico >
    }
    box                         {
      < -GruesoCaja/2+1.1*BordeGiro, -AltoCaja/2+GruesoPlastico, +GruesoCaja/2 >,
      < -GruesoCaja/2          , +AltoCaja/2-GruesoPlastico, +GruesoCaja/2-GruesoPlastico >
    }
    box                         {
      < -GruesoCaja/2+LargoCaja-2*GruesoPlastico, -AltoCaja/2+GruesoPlastico,
        +GruesoCaja/2 >,
      < -GruesoCaja/2+LargoCaja-1*GruesoPlastico, +AltoCaja/2-GruesoPlastico,
        -GruesoCaja/2+GruesoPlastico+Aire >
    }
    box                         {
      < -GruesoCaja/2                 , -AltoCaja/2+GruesoPlastico,
        +GruesoCaja/2 >,
      < -GruesoCaja/2+1*GruesoPlastico, +AltoCaja/2-GruesoPlastico,
        -GruesoCaja/2+GruesoPlastico+Aire >
    }
    #if ( BanderaLabelPosterior )
      box                       {
        0, 1
        translate               -0.5*z
        texture                 {
          TexturaLabelPosterior
        }
        scale                   < LargoCaja-4*GruesoPlastico,
                                  AltoCaja-4*GruesoPlastico,
                                  0.002*GruesoPlastico >
        translate               <-GruesoCaja/2+2*GruesoPlastico,
           -AltoCaja/2+2*GruesoPlastico, +GruesoCaja/2-GruesoPlastico >
      }
    #end  // #if ( BanderaLabelPosterior )
    #if ( BanderaLabelLateralIzquierda )
      box                       {
        0, 1
        translate               -0.5*x
        texture                 {
          TexturaLabelLateralIzquierda
        }
        scale                   < 0.002*GruesoPlastico,
                                  AltoCaja-4*GruesoPlastico,
                                  GruesoCaja-2*GruesoPlastico >
        translate               < -GruesoCaja/2+2*GruesoPlastico,
           -AltoCaja/2+2*GruesoPlastico, -GruesoCaja/2+GruesoPlastico >
      }
    #end  // #if ( BanderaLabelLateralIzquierda )
    #if ( BanderaLabelLateralDerecha )
      box                       {
        0, 1
        translate               -0.5*x
        texture                 {
          TexturaLabelLateralDerecha
        }
        scale                   < 0.002*GruesoPlastico,
                                  AltoCaja-4*GruesoPlastico,
                                  GruesoCaja-3*GruesoPlastico >
        translate               < -GruesoCaja/2+LargoCaja-2*GruesoPlastico,
           -AltoCaja/2+2*GruesoPlastico, -GruesoCaja/2+2*GruesoPlastico >
      }
    #end  // #if ( BanderaLabelLateralDerecha )
    material                    {
      MaterialPrincipal
    }
  }
#end  // #macro D7OR_CajaInferior

#macro D7OR_SoporteCD(
        LargoCaja, AltoCaja, GruesoCaja, GruesoPlastico,
        BordeGiro, Aire, DiametroDisco, DiametroHuecoDisco,
        MaterialSoporte )
  union                         {
    difference                  {
      box                         {
        < -GruesoCaja/2+BordeGiro,
          -AltoCaja/2+2*GruesoPlastico,
          +GruesoCaja/2-GruesoPlastico-Aire >,
        < +LargoCaja-GruesoCaja/2-2*GruesoPlastico,
          +AltoCaja/2-2*GruesoPlastico,
          -GruesoCaja/2+1*GruesoPlastico >
      }
      box                         {
        < -GruesoCaja/2+BordeGiro+GruesoPlastico,
          -AltoCaja,
          -GruesoCaja/2+2*GruesoPlastico >,
        < +LargoCaja-GruesoCaja/2-3*GruesoPlastico,
          +AltoCaja,
          -GruesoCaja/2 >
      }
      #local RadioCil         = ( LargoCaja-BordeGiro )/2;
      difference                  {
        cylinder                        {
          (+GruesoCaja/2-2*GruesoPlastico )*z, -GruesoCaja/2*z,
          RadioCil-3*GruesoPlastico
          translate     ( -GruesoCaja/2+LargoCaja-RadioCil )*x
        }
        cylinder                        {
          ( +GruesoCaja/2-2*GruesoPlastico )*z,
          ( +GruesoCaja/2-3*GruesoPlastico )*z,
          0.10*LargoCaja
          translate     ( -GruesoCaja/2+LargoCaja-RadioCil )*x
        }
        cylinder                        {
          ( +GruesoCaja/2-2*GruesoPlastico )*z,
          ( -GruesoCaja/2+1*GruesoPlastico )*z,
          min( 0.05*LargoCaja, DiametroHuecoDisco/2 )
          translate     ( -GruesoCaja/2+LargoCaja-RadioCil )*x
        }
        #local C                        = 0;
        #while ( C < 6 )
          difference                    {
            cylinder                    {
              -GruesoCaja/2*z, +GruesoCaja/2*z,
              0.025*LargoCaja
              scale             <3,1,1>
            }
            cylinder                    {
              -GruesoCaja/2*z, +GruesoCaja/2*z,
              0.020*LargoCaja
              scale             <3,1,1>
            }
            plane                       {
              -x, 0
            }
            translate           0.100*LargoCaja*x
            rotate              360*C/6*z
            translate     ( -GruesoCaja/2+LargoCaja-RadioCil )*x
          }
          #local C                      = C+1;
        #end  // #while ( C < 6 )
      }
      cylinder                        {
        ( +GruesoCaja/2 )*z,
        ( +GruesoCaja/2-3*GruesoPlastico/2 )*z,
        0.08*LargoCaja
        translate     ( -GruesoCaja/2+LargoCaja-RadioCil )*x
      }
      difference                  {
        box                         {
          < -GruesoCaja/2,
            -AltoCaja/2+3*GruesoPlastico, -GruesoCaja/2+3*GruesoPlastico >,
          < +LargoCaja-GruesoCaja/2,
            +AltoCaja/2-3*GruesoPlastico, +GruesoCaja/2 >
        }
        cylinder                        {
          +GruesoCaja/2*z, -GruesoCaja/2*z, RadioCil
          translate     ( -GruesoCaja/2+LargoCaja-RadioCil )*x
        }
      }
    }
    box                         {
      < -GruesoCaja/2, -AltoCaja/2+GruesoPlastico,
                -GruesoCaja/2 >,
      < -GruesoCaja/2+BordeGiro, +AltoCaja/2-GruesoPlastico,
                -GruesoCaja/2+GruesoPlastico >
    }
    material                    {
      MaterialSoporte
    }
  }
#end  // #macro D7OR_SoporteCD

#macro D7OR_CD( DiametroDisco, DiametroHuecoDisco, GrosorDisco,
          TexturaCentralDisco, TexturaMetalDisco,
          TexturaCaratulaDisco )
union                           {
  difference                    {
      #local RadioCil         = ( LargoCaja-BordeGiro )/2;
    cylinder                    {
      0, -GrosorDisco*z, DiametroDisco/2
    }
    cylinder                    {
      +GrosorDisco*z, -2*GrosorDisco*z, DiametroHuecoDisco/2
    }
    #local LimiteTextura        = 2*DiametroHuecoDisco/DiametroDisco;
    texture                     {
      onion
      scale                     DiametroDisco/2
      texture_map               {
        [ 0.0 TexturaCentralDisco ]
        [ LimiteTextura TexturaCentralDisco ]
        [ LimiteTextura TexturaCentralDisco ]
        [ 1.0 TexturaMetalDisco   ]
      }
    }
  }
  difference                    {
    cylinder                    {
      -GrosorDisco*z, -1.01*GrosorDisco*z, 0.95*DiametroDisco/2
    }
    cylinder                    {
      +GrosorDisco*z, -2*GrosorDisco*z, 3*DiametroHuecoDisco/2
    }
    texture                     {
      TexturaCaratulaDisco
    }
  }
}
#end  // #macro D7OR_CD

#macro D7OR_CajaCD( BanderaDisco, AnguloAbrir, NombreImagenGIF )
  union                         {
    #local L                    = D7OR_L;
    #local LargoCaja            = 100*L;
    #local AltoCaja             =  87*L;
    #local GruesoCaja           =   7*L;
    #local GruesoPlastico       =   1.2*L;
    #local Aire                 =   0.2*L;
    #local BordeGiro            =   8*L;
    #local DiametroDisco        =  82.5*L;
    #local DiametroHuecoDisco   =  10*L;
    #local GrosorDisco          =   1*L;                   
    #if ( strcmp( NombreImagenGIF, "" ) != 0 )   
      #declare D7OR_TexturaLabelFrente          =
      texture                               {
        pigment                     {   
          image_map                 {    
            gif         NombreImagenGIF 
          } 
        } 
      }                            
    #end  // #if ( strcmp( NombreImagenGIF, "" ) != 0 )
    object                      {
      D7OR_CajaSuperior( on,
        LargoCaja, AltoCaja, GruesoCaja, GruesoPlastico, BordeGiro,
        D7OR_MaterialPrincipal, D7OR_MaterialDecoradoPrincipal,
        D7OR_TexturaLabelFrente )
      rotate                    AnguloAbrir*y
    }
    object                      {
      D7OR_CajaInferior( on, on, on,
        LargoCaja, AltoCaja, GruesoCaja, GruesoPlastico,
        BordeGiro, Aire,
        D7OR_MaterialPrincipal, D7OR_TexturaLabelPosterior,
        D7OR_TexturaLabelLateralIzquierda,
        D7OR_TexturaLabelLateralDerecha  )
    }
    object                      {
      D7OR_SoporteCD(
        LargoCaja, AltoCaja, GruesoCaja, GruesoPlastico,
        BordeGiro, Aire, DiametroDisco, DiametroHuecoDisco,
        D7OR_MaterialSoporte )
    }
    #if ( BanderaDisco )
      object                    {
        D7OR_CD( DiametroDisco, DiametroHuecoDisco, GrosorDisco,
          D7OR_TexturaCentralDisco, D7OR_TexturaMetalDisco,
          D7OR_TexturaCaratulaDisco )
        translate     ( -GruesoCaja/2+1*LargoCaja/2+BordeGiro/2 )*x
        translate       ( -GruesoCaja/2+3*GruesoPlastico )*z
      }
    #end  // #if ( BanderaDisco ) 
    translate           AltoCaja/2*y  
    translate           -GruesoCaja/2*z
    translate           +GruesoCaja/2*x  
    translate           -LargoCaja*x
  }
#end  // #macro D7OR_CajaCD
