// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  21 octubre 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// JVPA JaulaVesperticaPericoAve 
// El archivo dibuja una jaula para aves.  Utilizada en muchos paises
// para exhibir estos animales.  Incluye una macro para modificar varias
// de sus caracteristicas principale, texturas inclusive.
// Es compatible con POVRay 3.1.
//
// La macro principal tiene unicamente un parametro  
// #macro JVPA_Jaula( AnguloColumpio )        
//      AnguloColumpio          : Angulo para girar el columpio en una u 
//              otra direccion.
//
// La siguiente variante permite abrir las puertas y/o eliminar la bandeja.
// #macro JVPA_JaulaAbierta( AnguloColumpio, BanderaBandeja,
//                         PuertaIzquierda, PuertaCentral, PuertaDerecha )
//      AnguloColumpio          : Angulo para girar el columpio en una u 
//              otra direccion.
//      BanderaBandeja          : "on" dibuja la bandeja inferior, "off" no la dibuja.
//      PuertaIzquierda         : Fraccion "propia" para abrir la puertecilla izquierda.
//              Utilice 0 para cerrado, y 1 para totalmente abierto.
//      PuertaCentral           : Fraccion "propia" para abrir la puertecilla central.
//              Utilice 0 para cerrado, y 1 para totalmente abierto.
//      PuertaDerecha           : Fraccion "propia" para abrir la puertecilla derecha.
//              Utilice 0 para cerrado, y 1 para totalmente abierto.                 
//
// La siguiente macro permite un mayor control de las caracteristicas.
// #macro JVPA_JaulaVespertinaPericoAve( AnguloColumpio, BanderaBandeja, AbrirPuertas,
//        Frente, Profundidad,
//        AltoBase, AltoPiso, PaseBandeja, LateralTechoPlano,
//        ExcesoTecho, AltoColumpio,
//        TotalAlambresFrente, TotalAlambresProfundidad, ArregloVentanas,
//        ArregloPalitos, GruesoAlambrito, GruesoAlambre, CurvaDecorativa,
//        ArregloTexturas )
//      AnguloColumpio          : Angulo para girar el columpio en una u 
//              otra direccion.
//      BanderaBandeja          : "on" dibuja la bandeja inferior, "off" no la dibuja.
//      AbrirPuertas            : array de reales, dimensin igual al total de ventanas.
//              Son fracciones "propias" para abrir las ventanas definidas.
//              Utilice 0 para cerrado, y 1 para totalmente abierto.
//              Defaul es { 0.0, 0.0, 0.0 }, equivala a la variable
//              JVPA_TresVentanasCerradas.
//      Frente                  : Referencia para el frente X de la jaula.
//              Default es 316*L.
//      Profundidad             : Referencia para la profundidad Z de la jaula.
//              Default es 172*L.
//      AltoBase                : Referencia para el alto Y de la jaula.
//              Default es 197*L.
//      AltoPiso                : Alto de ventana.  Default es 75*L.
//      PaseBandeja             : Alto de abertura para la bandeja.
//              Default es 11*L.
//      LateralTechoPlano       : Seccion plana lateral del techo.  Considerar
//              que aplica a derecha e izquierda.  Default es 86*L.
//      ExcesoTecho             : Referencia para las salientes en exceso del techo.
//              Default es 32*L.
//      AltoColumpio            : Alto del columpio.  Default es 110*L.
//      TotalAlambresFrente     : Total de alambres al frente.  Default es 36.
//      TotalAlambresProfundidad                : Total de alambres a lo profundo.
//              Default es 20.
//      ArregloVentanas         : Arreglo de vectores 3D, que describen las ventas.
//              < Piso, AlambreIzquierdo, AlambreDerecho >.  Default es JVPA_ArregloVentanas.
//                      Piso                    : A partir de "uno", que representa 
//                                el primer nivel
//                                accesible para ventanas luego de una separacion
//                                razonable de la bandeja.  En muchas jaulas sera
//                                el unico valor posible.
//                      AlambreIzquierdo        : Numero de alambre a la izquierda
//                                para agarrar la ventana (si se dibuja).
//                      AlambreDerecho          : Numero de alambre a la derecha
//                                para agarrar la ventana (si se dibuja).
//                                Obligatorio AlambreDerecho > AlambreIzquierdo.
//      ArregloPalitos          : Arreglo de vectores 2D, para palitos de madera, 
//              sin contar el columpio.  <Piso, AlambreIzquierdo >.
//              Default es JVPA_ArregloPalitos.
//                      Piso                    : A partir de "uno", que representa 
//                                el primer nivel
//                                accesible para ventanas luego de una separacion
//                                razonable de la bandeja.  En muchas jaulas sera
//                                el unico valor posible.
//                      AlambreIzquierdo        : Numero de alambre a la izquierda
//                                para soportar el palito.
//      GruesoAlambrito         : Grueso principal de alambre de la jaula.
//              Default es 1.5*L.
//      GruesoAlambre           : Grueso de alambre para dar firmeza.
//              Default es 1.8*L.                                   
//      CurvaDecorativa         : Radio de ciertas curvas de la jaula. 
//              Default es 7*L.   
//      ArregloTexturas         : array [ 5 ] de texturas.  Corresponde a
//              { TexturaJaula, TexturaTecho, TexturaVentana, TexturaMadera,
//              TexturaBandeja }.  Valor por defecto
//              JVPA_DefaultArregloTexturas = { JVPA_TexturaJaula, 
//              JVPA_TexturaTecho, JVPA_TexturaVentana, JVPA_TexturaMadera,
//              JVPA_TexturaBandeja }
//
// Si no dibuja la bandeja, puede ubicarla con la siguiente macro.
// #macro JVPA_BandejaJaula( FrenteJaula, ProfundidadJaula, PaseBandeja,
//                GruesoAlambre, TexturaBandeja )
//      FrenteJaula             : Referencia para el frente X de la jaula.
//              Default es 316*L.
//      ProfundidadJaula        : Referencia para la profundidad Z de la jaula.
//              Default es 172*L.
//      PaseBandeja             : Alto de abertura para la bandeja.
//              Default es 11*L.
//      GruesoAlambre           : Grueso de alambre para dar firmeza.
//              Default es 1.8*L.                                   
//      TexturaBandeja          : Textura de la bandeja.  
//              Default es JVPA_TexturaBandeja.
//
// La jaula por defecto tiene las siguientes caracteristicas:   
// Alto 275*L
// Profundidad ..-93*L+90*L
// Frente 380*L
//      Altura en Y             : 275*L  
//      Profundidad en Z        : -93*L..90*L
//      Frente en X             : 380*L
// La jaula descansa semicentrada sobre el plano XZ.  Frente hacia Z-, gravedad Y-.
// Cuando hablamos de derecha de jaula, nos referimos a la derecha de un observador
// desde Z- hacia el origen.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare JVPA_ArregloVentanas
//      Describe las ventanas por defecto de la jaula.  
// #declare JVPA_DefaultArregloTexturas
//      Sirve como parametro ArregloTexturas en macro.
//      Corresponde a { JVPA_TexturaJaula, 
//      JVPA_TexturaTecho, JVPA_TexturaVentana, JVPA_TexturaMadera,
//      JVPA_TexturaBandeja }
// #declare JVPA_ArregloPalitos
//      Describe los palitos por defecto de la jaula, sin incluir el columpio. 
// #declare JVPA_TresVentanasCerradas
//      Creada para que el usuario la utilice como parametro cuando dibuja
//      tres ventanas unicamente.  Indica a la macro, que las tres ventanas
//      se encuentran cerradas.
// #declare JVPA_PosicionBandeja
//      Se genera al llamar a las macros que generan la Jaula.  Puede servir
//      para ubicar la bandeja mediante un translate apropiado, cuando
//      asigne "off" al parametro BanderaBandeja. 
// #declare JVPA_DefaultTexturaJaula
//      Textura principal de la jaula.
// #declare JVPA_DefaultTexturaTecho            
//      Textura del techo.  
// #declare JVPA_DefaultTexturaVentana          
//      Textura de las ventanas.  
// #declare JVPA_DefaultTexturaMadera           
//      Textura de los palitos de madera.
// #declare JVPA_DefaultTexturaBandeja          
//      Textura de la bandeja.  
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default) 
// #declare JVPA_TexturaJaula                           = texture { ... }
//      Textura principal de la jaula.
// #declare JVPA_TexturaTecho                           = texture { ... }
//      Textura del techo.  
// #declare JVPA_TexturaVentana                         = texture { ... } 
//      Textura de las ventanas.  
// #declare JVPA_TexturaMadera                          = texture { ... }
//      Textura de los palitos de madera.
// #declare JVPA_TexturaBandeja                         = texture { ... }
//      Textura de la bandeja.  
// #declare JVPA_POV3_1                                 = off;
//      Valor on activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente.
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo simplemente
// #include "JVPA.inc"
// object        { JVPA_Jaula( 0 ) }
//                           
// Otro ejemplo con la macro para abrir la jaula
// #include "JVPA.inc"   
// object        { JVPA_JaulaAbierta( 0, on, 0, 0, 0 ) }
//   
// Ejemplo con la macro detallada, mismo objeto default
// #include "JVPA.inc"   
// object        {  
//   JVPA_JaulaVespertinaPericoAve( o, on, JVPA_TresVentanasCerradas, 
//      0.316, 0.172, 0.197, 0.075, 0.011, 0.086, 0.032, 0.110, 36, 20,
//      JVPA_ArregloVentanas, JVPA_ArregloPalitos, 0.0015, 0.0018, 0.007, 
//      JVPA_DefaultArregloTexturas )
// }
//           
// Con bandeja externa...
// #include "JVPA.inc"   
// object        {  
//   JVPA_JaulaVespertinaPericoAve( o, off, JVPA_TresVentanasCerradas, 
//      0.316, 0.172, 0.197, 0.075, 0.011, 0.086, 0.032, 0.110, 36, 20,
//      JVPA_ArregloVentanas, JVPA_ArregloPalitos, 0.0015, 0.0018, 0.007, 
//      JVPA_DefaultArregloTexturas )
// }                                      
// object        { 
//   JVPA_BandejaJaula( 0.316, 0.172, 0.011, 0.018, JVPA_TexturaBandeja )
//   translate          JVPA_PosicionBandeja
// }
//         
// Con modificadores
// #include "JVPA.inc"
// #include "textures.inc"
// #declare JVPA_TexturaJaula   = PinkAlabaster
// object       { JVPA_Jaula( 0 ) }
//
#include "colors.inc"

#declare OjoAbsoluto            = 256;
#declare VecesCentroAbsoluto    = 10;     
#declare L                      = 0.001;
camera {
        location  <   0,  0, -( VecesCentroAbsoluto+1 )*OjoAbsoluto >*L
        direction z
        sky       y
        angle     38.74
//        look_at  <   0,  0, -VecesCentroAbsoluto*OjoAbsoluto >*L
}
light_source    {
         < 500  , 500   , -3000 >*L
         White
}
background      {
         Gray50
}

#include "JVPA.inc"
   
#local FactorAcercamiento       = 4;   
   
object                          {
  JVPA_Jaula( 0 )
  translate                     -0.137*y   
  translate       -( VecesCentroAbsoluto+1 )*( FactorAcercamiento-1 )
                        /( FactorAcercamiento )*OjoAbsoluto*L*z
}
