// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  21 octubre 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// JVPA JaulaVesperticaPericoAve 
// El archivo dibuja una jaula para aves.  Utilizada en muchos paises
// para exhibir estos animales.  Incluye una macro para modificar varias
// de sus caracteristicas principale, texturas inclusive.
// Es compatible con POVRay 3.1.
//
// La macro principal tiene unicamente un parametro  
// #macro JVPA_Jaula( AnguloColumpio )        
//      AnguloColumpio          : Angulo para girar el columpio en una u 
//              otra direccion.
//
// La siguiente variante permite abrir las puertas y/o eliminar la bandeja.
// #macro JVPA_JaulaAbierta( AnguloColumpio, BanderaBandeja,
//                         PuertaIzquierda, PuertaCentral, PuertaDerecha )
//      AnguloColumpio          : Angulo para girar el columpio en una u 
//              otra direccion.
//      BanderaBandeja          : "on" dibuja la bandeja inferior, "off" no la dibuja.
//      PuertaIzquierda         : Fraccion "propia" para abrir la puertecilla izquierda.
//              Utilice 0 para cerrado, y 1 para totalmente abierto.
//      PuertaCentral           : Fraccion "propia" para abrir la puertecilla central.
//              Utilice 0 para cerrado, y 1 para totalmente abierto.
//      PuertaDerecha           : Fraccion "propia" para abrir la puertecilla derecha.
//              Utilice 0 para cerrado, y 1 para totalmente abierto.                 
//
// La siguiente macro permite un mayor control de las caracteristicas.
// #macro JVPA_JaulaVespertinaPericoAve( AnguloColumpio, BanderaBandeja, AbrirPuertas,
//        Frente, Profundidad,
//        AltoBase, AltoPiso, PaseBandeja, LateralTechoPlano,
//        ExcesoTecho, AltoColumpio,
//        TotalAlambresFrente, TotalAlambresProfundidad, ArregloVentanas,
//        ArregloPalitos, GruesoAlambrito, GruesoAlambre, CurvaDecorativa,
//        ArregloTexturas )
//      AnguloColumpio          : Angulo para girar el columpio en una u 
//              otra direccion.
//      BanderaBandeja          : "on" dibuja la bandeja inferior, "off" no la dibuja.
//      AbrirPuertas            : array de reales, dimensin igual al total de ventanas.
//              Son fracciones "propias" para abrir las ventanas definidas.
//              Utilice 0 para cerrado, y 1 para totalmente abierto.
//              Defaul es { 0.0, 0.0, 0.0 }, equivala a la variable
//              JVPA_TresVentanasCerradas.
//      Frente                  : Referencia para el frente X de la jaula.
//              Default es 316*L.
//      Profundidad             : Referencia para la profundidad Z de la jaula.
//              Default es 172*L.
//      AltoBase                : Referencia para el alto Y de la jaula.
//              Default es 197*L.
//      AltoPiso                : Alto de ventana.  Default es 75*L.
//      PaseBandeja             : Alto de abertura para la bandeja.
//              Default es 11*L.
//      LateralTechoPlano       : Seccion plana lateral del techo.  Considerar
//              que aplica a derecha e izquierda.  Default es 86*L.
//      ExcesoTecho             : Referencia para las salientes en exceso del techo.
//              Default es 32*L.
//      AltoColumpio            : Alto del columpio.  Default es 110*L.
//      TotalAlambresFrente     : Total de alambres al frente.  Default es 36.
//      TotalAlambresProfundidad                : Total de alambres a lo profundo.
//              Default es 20.
//      ArregloVentanas         : Arreglo de vectores 3D, que describen las ventas.
//              < Piso, AlambreIzquierdo, AlambreDerecho >.  Default es JVPA_ArregloVentanas.
//                      Piso                    : A partir de "uno", que representa 
//                                el primer nivel
//                                accesible para ventanas luego de una separacion
//                                razonable de la bandeja.  En muchas jaulas sera
//                                el unico valor posible.
//                      AlambreIzquierdo        : Numero de alambre a la izquierda
//                                para agarrar la ventana (si se dibuja).
//                      AlambreDerecho          : Numero de alambre a la derecha
//                                para agarrar la ventana (si se dibuja).
//                                Obligatorio AlambreDerecho > AlambreIzquierdo.
//      ArregloPalitos          : Arreglo de vectores 2D, para palitos de madera, 
//              sin contar el columpio.  <Piso, AlambreIzquierdo >.
//              Default es JVPA_ArregloPalitos.
//                      Piso                    : A partir de "uno", que representa 
//                                el primer nivel
//                                accesible para ventanas luego de una separacion
//                                razonable de la bandeja.  En muchas jaulas sera
//                                el unico valor posible.
//                      AlambreIzquierdo        : Numero de alambre a la izquierda
//                                para soportar el palito.
//      GruesoAlambrito         : Grueso principal de alambre de la jaula.
//              Default es 1.5*L.
//      GruesoAlambre           : Grueso de alambre para dar firmeza.
//              Default es 1.8*L.                                   
//      CurvaDecorativa         : Radio de ciertas curvas de la jaula. 
//              Default es 7*L.   
//      ArregloTexturas         : array [ 5 ] de texturas.  Corresponde a
//              { TexturaJaula, TexturaTecho, TexturaVentana, TexturaMadera,
//              TexturaBandeja }.  Valor por defecto
//              JVPA_DefaultArregloTexturas = { JVPA_TexturaJaula, 
//              JVPA_TexturaTecho, JVPA_TexturaVentana, JVPA_TexturaMadera,
//              JVPA_TexturaBandeja }
//
// Si no dibuja la bandeja, puede ubicarla con la siguiente macro.
// #macro JVPA_BandejaJaula( FrenteJaula, ProfundidadJaula, PaseBandeja,
//                GruesoAlambre, TexturaBandeja )
//      FrenteJaula             : Referencia para el frente X de la jaula.
//              Default es 316*L.
//      ProfundidadJaula        : Referencia para la profundidad Z de la jaula.
//              Default es 172*L.
//      PaseBandeja             : Alto de abertura para la bandeja.
//              Default es 11*L.
//      GruesoAlambre           : Grueso de alambre para dar firmeza.
//              Default es 1.8*L.                                   
//      TexturaBandeja          : Textura de la bandeja.  
//              Default es JVPA_TexturaBandeja.
//
// La jaula por defecto tiene las siguientes caracteristicas:   
// Alto 275*L
// Profundidad ..-93*L+90*L
// Frente 380*L
//      Altura en Y             : 275*L  
//      Profundidad en Z        : -93*L..90*L
//      Frente en X             : 380*L
// La jaula descansa semicentrada sobre el plano XZ.  Frente hacia Z-, gravedad Y-.
// Cuando hablamos de derecha de jaula, nos referimos a la derecha de un observador
// desde Z- hacia el origen.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare JVPA_ArregloVentanas
//      Describe las ventanas por defecto de la jaula.  
// #declare JVPA_DefaultArregloTexturas
//      Sirve como parametro ArregloTexturas en macro.
//      Corresponde a { JVPA_TexturaJaula, 
//      JVPA_TexturaTecho, JVPA_TexturaVentana, JVPA_TexturaMadera,
//      JVPA_TexturaBandeja }
// #declare JVPA_ArregloPalitos
//      Describe los palitos por defecto de la jaula, sin incluir el columpio. 
// #declare JVPA_TresVentanasCerradas
//      Creada para que el usuario la utilice como parametro cuando dibuja
//      tres ventanas unicamente.  Indica a la macro, que las tres ventanas
//      se encuentran cerradas.
// #declare JVPA_PosicionBandeja
//      Se genera al llamar a las macros que generan la Jaula.  Puede servir
//      para ubicar la bandeja mediante un translate apropiado, cuando
//      asigne "off" al parametro BanderaBandeja. 
// #declare JVPA_DefaultTexturaJaula
//      Textura principal de la jaula.
// #declare JVPA_DefaultTexturaTecho            
//      Textura del techo.  
// #declare JVPA_DefaultTexturaVentana          
//      Textura de las ventanas.  
// #declare JVPA_DefaultTexturaMadera           
//      Textura de los palitos de madera.
// #declare JVPA_DefaultTexturaBandeja          
//      Textura de la bandeja.  
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default) 
// #declare JVPA_TexturaJaula                           = texture { ... }
//      Textura principal de la jaula.
// #declare JVPA_TexturaTecho                           = texture { ... }
//      Textura del techo.  
// #declare JVPA_TexturaVentana                         = texture { ... } 
//      Textura de las ventanas.  
// #declare JVPA_TexturaMadera                          = texture { ... }
//      Textura de los palitos de madera.
// #declare JVPA_TexturaBandeja                         = texture { ... }
//      Textura de la bandeja.  
// #declare JVPA_POV3_1                                 = off;
//      Valor on activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente.
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo simplemente
// #include "JVPA.inc"
// object        { JVPA_Jaula( 0 ) }
//                           
// Otro ejemplo con la macro para abrir la jaula
// #include "JVPA.inc"   
// object        { JVPA_JaulaAbierta( 0, on, 0, 0, 0 ) }
//   
// Ejemplo con la macro detallada, mismo objeto default
// #include "JVPA.inc"   
// object        {  
//   JVPA_JaulaVespertinaPericoAve( o, on, JVPA_TresVentanasCerradas, 
//      0.316, 0.172, 0.197, 0.075, 0.011, 0.086, 0.032, 0.110, 36, 20,
//      JVPA_ArregloVentanas, JVPA_ArregloPalitos, 0.0015, 0.0018, 0.007, 
//      JVPA_DefaultArregloTexturas )
// }
//           
// Con bandeja externa...
// #include "JVPA.inc"   
// object        {  
//   JVPA_JaulaVespertinaPericoAve( o, off, JVPA_TresVentanasCerradas, 
//      0.316, 0.172, 0.197, 0.075, 0.011, 0.086, 0.032, 0.110, 36, 20,
//      JVPA_ArregloVentanas, JVPA_ArregloPalitos, 0.0015, 0.0018, 0.007, 
//      JVPA_DefaultArregloTexturas )
// }                                      
// object        { 
//   JVPA_BandejaJaula( 0.316, 0.172, 0.011, 0.018, JVPA_TexturaBandeja )
//   translate          JVPA_PosicionBandeja
// }
//         
// Con modificadores
// #include "JVPA.inc"
// #include "textures.inc"
// #declare JVPA_TexturaJaula   = PinkAlabaster
// object       { JVPA_Jaula( 0 ) }
//
#include "colors.inc"
#include "woods.inc"   
#include "stones.inc"

#declare JVPA_L                           = 0.001;

#if ( version < 3.2 )
  #ifndef( JVPA_POV3_1 )
    #declare JVPA_POV3_1        = on;
  #end
#else
  #ifndef( JVPA_POV3_1 )
    #declare JVPA_POV3_1        = off;
  #end
#end
                      
#declare JVPA_DefaultTexturaJaula       =
  texture                               { 
    pigment { White }
    normal      {   
      granite
    }
  }

#ifndef ( JVPA_TexturaJaula )
  #declare JVPA_TexturaJaula            = JVPA_DefaultTexturaJaula
#end // #ifndef ( JVPA_TexturaJaula )

#declare JVPA_DefaultTexturaTecho       =
  texture                               {
    pigment { Cyan }  
    normal  { granite }
  }

#ifndef ( JVPA_TexturaTecho )
  #declare JVPA_TexturaTecho            = JVPA_DefaultTexturaTecho
#end // #ifndef ( JVPA_TexturaTecho )

#declare JVPA_DefaultTexturaVentana       =
  texture                               {
    pigment { Red } 
    normal      {   
      bumps
      turbulence        2
    }
  }

#ifndef ( JVPA_TexturaVentana )
  #declare JVPA_TexturaVentana            = JVPA_DefaultTexturaVentana
#end // #ifndef ( JVPA_TexturaVentana )
 
#declare JVPA_DefaultTexturaBandeja       =
  texture                               {
    pigment { Silver } 
    normal      {   
      bumps
      turbulence        2
    }
  }

#ifndef ( JVPA_TexturaBandeja )
  #declare JVPA_TexturaBandeja            = JVPA_DefaultTexturaBandeja
#end // #ifndef ( JVPA_TexturaBandeja )

 
#declare JVPA_DefaultTexturaMadera       =
  texture                               {
    T_Wood10
  }

#ifndef ( JVPA_TexturaMadera )
  #declare JVPA_TexturaMadera            = JVPA_DefaultTexturaMadera
#end // #ifndef ( JVPA_TexturaMadera )
                                                                         
#declare JVPA_DefaultArregloTexturas    = array [ 5 ]
  { JVPA_TexturaJaula , JVPA_TexturaTecho  , JVPA_TexturaVentana, 
    JVPA_TexturaMadera, JVPA_TexturaBandeja }

#declare JVPA_ArregloVentanas           = array [3]
                { <1,2,8>, <1,14,23>, <1,29,35> }
 
#declare JVPA_ArregloPalitos       = array [2]
                { <1,9>, <1,27> }  
                
#declare JVPA_TresVentanasCerradas      = array [3] { 0, 0, 0 }           
 
#macro JVPA_Gancho( DiametroHueco )
  union                                 {
    difference                          {
      torus                             {
        DiametroHueco, DiametroHueco/2
        rotate                  90*x
      }
      box                               {
        -1, z
        scale                   3*DiametroHueco
      }
      box                               {
        -1, z
        scale                   3*DiametroHueco
        rotate                  -60*z
      }
    }
    cylinder                            {
      0, -DiametroHueco*( 1+cos( pi/6 ) )/( 2*sin( pi/6 ) )*y,
      DiametroHueco/2
      translate                 -DiametroHueco*x
      rotate                    -60*z
    }
  }  // union
#end  // JVPA_Gancho( Curvatura )

#macro JVPA_CurvaPerpendicular( Curvatura, DiametroAlambre )
  difference                    {
    torus                       {
      Curvatura, DiametroAlambre/2
      rotate                    90*x
    }
    plane                       {
      y, 0
    }
    plane                       {
      x, 0
    }
    translate                   -Curvatura*( x+y )
  }
#end  // #macro JVPA_CurvaPerpendicular

#macro JVPA_Curva45( Curvatura, DiametroAlambre )
  difference                    {
    torus                       {
      Curvatura*cos( 3*pi/8 ), DiametroAlambre/2
      rotate                    90*x
    }
    plane                       {
      x, 0
    }
    plane                       {
      y, 0
      rotate                    45*z
    }
    translate                   -Curvatura*cos( 3*pi/8 )*<1,1,0>
  }
#end  // #macro JVPA_Curva45()

#macro JVPA_VentanaJaula( X1, Y1, X2, Y2, TotalAlambres, GruesoAlambre )
  union                         {
    #local SeparacionFrontal    = ( X2-X1 )/( TotalAlambres+1 );
    #local RadioTorus           =
                SeparacionFrontal*( TotalAlambres-1 )/2;
    #local ObjetoMuesca         =
      union                     {
        difference              {
          torus                 {
            SeparacionFrontal/2, GruesoAlambre/2
            rotate              90*y
            translate           SeparacionFrontal*z/2
          }
          plane                 {
            x, 0
          }
        }
        cylinder                {
          0, -SeparacionFrontal*x, GruesoAlambre/2
          translate             SeparacionFrontal*z
        }
        translate               -GruesoAlambre*z
      }
    #local C                    = 0;
    #while ( C < TotalAlambres )
      #local RelX               = -RadioTorus+SeparacionFrontal*C;
      #local ExcY               = sqrt( RadioTorus*RadioTorus-RelX*RelX );
      cylinder                  {
        ( Y1-GruesoAlambre/2 )*y,
        ( Y2+GruesoAlambre/2+ExcY )*y,
        GruesoAlambre/2
        translate               RelX*x+( X1+X2 )*x/2
      }
      #local C                  = C+1;
    #end  // #while ( C < TotalAlambres )
    difference                  {
      torus                     {
        RadioTorus, GruesoAlambre/2
        rotate                  90*x
      }
      plane                     {
        y, 0
      }
      translate                 ( X1+X2 )/2*x
      translate                 ( Y2+GruesoAlambre/2 )*y
    }
    #local RadioCentral         = min( RadioTorus*0.90, ( Y2-Y1 )/4 );
    torus                       {
      RadioCentral, GruesoAlambre/2
      rotate                    90*x
      translate                 -GruesoAlambre*z
      translate                 ( X1+X2 )*x/2+( Y1+Y2 )*y/2
    }
    cylinder                    {
      X1*x, X2*x, GruesoAlambre/2
      translate                 +Y1*y-GruesoAlambre*z
    }
    cylinder                    {
      X1*x, X2*x, GruesoAlambre/2
      translate                 +Y2*y-GruesoAlambre*z
    }
    object                      {
      ObjetoMuesca
      translate                 X2*x+Y2*y
    }
    object                      {
      ObjetoMuesca
      translate                 X2*x+Y1*y
    }
    object                      {
      ObjetoMuesca
      scale                     <-1,1,1>
      translate                 X1*x+Y2*y
    }
    object                      {
      ObjetoMuesca
      scale                     <-1,1,1>
      translate                 X1*x+Y1*y
    }
    translate                   -GruesoAlambre*z
  }
#end  // #macro JVPA_VentanaJaula()

#macro JVPA_BandejaJaula( FrenteJaula, ProfundidadJaula, PaseBandeja,
                GruesoAlambre, TexturaBandeja )
  union                         {
    box                         {
      < -( FrenteJaula-PaseBandeja )/2, 0, -ProfundidadJaula/2 >,
      < +( FrenteJaula-PaseBandeja )/2, 0.025*PaseBandeja,
        +ProfundidadJaula/2-2*GruesoAlambre >
    }
    box                         {
      < -( FrenteJaula-PaseBandeja )/2, 0,
        +ProfundidadJaula/2-2*GruesoAlambre-0.025*PaseBandeja >,
      < +( FrenteJaula-PaseBandeja )/2, 0.5*PaseBandeja,
        +ProfundidadJaula/2-2*GruesoAlambre >
    }
    box                         {
      < -( FrenteJaula-PaseBandeja )/2, 0, -ProfundidadJaula/2 >,
      < -( FrenteJaula-PaseBandeja )/2+0.025*PaseBandeja, 0.5*PaseBandeja,
        +ProfundidadJaula/2-2*GruesoAlambre >
    }    
    box                         {
      < +( FrenteJaula-PaseBandeja )/2, 0, -ProfundidadJaula/2 >,
      < +( FrenteJaula-PaseBandeja )/2-0.025*PaseBandeja, 0.5*PaseBandeja,
        +ProfundidadJaula/2-2*GruesoAlambre >
    }    
    box                         {
      < -( FrenteJaula-PaseBandeja )/2, 0, 0 >,
      < +( FrenteJaula-PaseBandeja )/2, 2*PaseBandeja,
        +0.025*PaseBandeja >
      rotate                    -45*x
      translate                 -ProfundidadJaula/2*z
    }
    
    texture                     {
      TexturaBandeja
    }
  }
#end  // #macro JVPA_BandejaJaula

#macro JVPA_JaulaVespertinaPericoAve( AnguloColumpio, BanderaBandeja, AbrirPuertas,
        Frente, Profundidad,
        AltoBase, AltoPiso, PaseBandeja, LateralTechoPlano,
        ExcesoTecho, AltoColumpio,
        TotalAlambresFrente, TotalAlambresProfundidad, ArregloVentanas,
        ArregloPalitos, GruesoAlambrito, GruesoAlambre, CurvaDecorativa,
        ArregloTexturas )
  union                         {   
    #local TexturaJaula         = ArregloTexturas[ 0 ] 
    #local TexturaTecho         = ArregloTexturas[ 1 ] 
    #local TexturaVentana       = ArregloTexturas[ 2 ] 
    #local TexturaMadera        = ArregloTexturas[ 3 ] 
    #local TexturaBandeja       = ArregloTexturas[ 4 ]
    #local UCorX1               = cos( 3*pi/8 );
    #local UCor2                = UCorX1/sqrt( 2 );
    #local U45                  = 1/sqrt( 2 );
    #local Usual45              = CurvaDecorativa*U45;
    #local UsualCorX1           = CurvaDecorativa*UCorX1;
    #local UsualCor2            = CurvaDecorativa*UCor2;
    #local AjusteAlambre        = ( GruesoAlambre-GruesoAlambrito )/2;
    #local TotalVentanas        = dimension_size( ArregloVentanas, 1 );
    #local TotalPalitos         = dimension_size( ArregloPalitos, 1 );
    #local AnchoColumpio        = 0.6*AltoColumpio;
    union                       {
      #local C                  = 0;
      #while ( C < TotalAlambresProfundidad )
        #switch( C )
          #case ( 0 )
          #case ( TotalAlambresProfundidad-1 )
            cylinder            {
              -GruesoAlambrito/2*y,
              ( AltoBase+GruesoAlambre )*y, GruesoAlambre/2
              translate         ( Frente/2-AjusteAlambre )*x
              translate         -Profundidad/2*z
                        +C*Profundidad/( TotalAlambresProfundidad-1 )*z
            }
            cylinder            {
              -GruesoAlambrito/2*y,
              ( AltoBase+GruesoAlambre )*y, GruesoAlambre/2
              translate         -( Frente/2-AjusteAlambre )*x
              translate         -Profundidad/2*z
                        +C*Profundidad/( TotalAlambresProfundidad-1 )*z
            }
          #break
          #else
            union                       {
              cylinder            {
                Usual45*y,                AltoBase*y, GruesoAlambrito/2
                translate         Frente/2*x
              }
              cylinder            {
                Usual45*y,                AltoBase*y, GruesoAlambrito/2
                translate         -Frente/2*x
              }
              object                    {
                JVPA_CurvaPerpendicular( CurvaDecorativa, GruesoAlambrito )
                scale           <1,-1,1>
                translate         Frente/2*x
              }
              object                    {
                JVPA_CurvaPerpendicular( CurvaDecorativa, GruesoAlambrito )
                scale           <-1,-1,1>
                translate         -Frente/2*x
              }
              cylinder                  {
                -( Frente/2-Usual45 )*x, ( Frente/2-Usual45 )*x,
                GruesoAlambrito/2
              }
              translate         -Profundidad/2*z
                        +C*Profundidad/( TotalAlambresProfundidad-1 )*z
            }
        #end  // #switch
        #local C                = C+1;
      #end  // #while ( C < TotalAlambresProfundidad )
      // Lineas de piso en Profundidad
      #local Simetrico          = 0;
      #while ( Simetrico < 2 )
        union                           {
          #local PivoteY        = AltoBase-GruesoAlambre/2;
          #while ( PivoteY > 0 )
            union                       {
              cylinder                  {
                -Profundidad/2*z, Profundidad/2*z, GruesoAlambre/2
              }
              object                    {
                JVPA_Gancho( GruesoAlambre )
                translate               GruesoAlambre*y
                rotate                  90*y
                rotate                  90*z
                translate               -Profundidad/2*z
              }
              object                    {
                JVPA_Gancho( GruesoAlambre )
                translate               GruesoAlambre*y
                rotate                  90*y
                rotate                  90*z
                translate               -Profundidad/2*z
                scale                   <1,1,-1>
              }
              translate         ( Frente/2+GruesoAlambrito/2+
                                        GruesoAlambre/2 )*x
              translate         PivoteY*y
            }
            #local PivoteY      = PivoteY-AltoPiso;
          #end  // #while ( PivoteY < AltoBase )
          #if ( Simetrico = 0 )
            scale               < -1, 1, 1 >
          #end  // #if ( Simetrico = 0 )
        }
        #local Simetrico        = Simetrico+1;
      #end  // #while ( Simetrico < 2 )
      
      texture                           {
        TexturaJaula
      }
    }
    // Frontales
    union                               {
      cylinder                      {
        -( Frente/2+GruesoAlambrito/2 )*x,
         ( Frente/2+GruesoAlambrito/2 )*x,
        GruesoAlambre/2
        translate                   PaseBandeja*y
        translate                   -( Profundidad/2+GruesoAlambre )*z
      }
      #local Simetrico                  = 0;
      #while ( Simetrico < 2 )
        union                           {
          cylinder                      {
            -( Frente/2+GruesoAlambrito/2 )*x,
             ( Frente/2+GruesoAlambrito/2 )*x,
            GruesoAlambre/2
            translate                   AjusteAlambre*y
            translate                   ( Profundidad/2+GruesoAlambre )*z
          }
          #local TotalPisos             = 0;
          #local PivoteY                = AltoPiso-PaseBandeja;
          #while ( PivoteY < AltoBase )
            #local TotalPisos           = TotalPisos+1;
            cylinder                      {
              -( Frente/2+GruesoAlambrito/2 )*x,
               ( Frente/2+GruesoAlambrito/2 )*x,
              GruesoAlambre/2
              translate                   PivoteY*y
              translate                   ( Profundidad/2+GruesoAlambre )*z
            }
            #local PivoteY              = PivoteY+AltoPiso;
          #end  // #while ( PivoteY < AltoBase )
          #if ( Simetrico = 0 )
            scale                       <1,1,-1>
          #end  // #if ( Simetrico = 0 )
        }
        #local Simetrico                = Simetrico+1;
      #end  // #while ( Simetrico < 2 )
      // Barras Frontales
      difference                        {
        #local SeparacionFrontal        = Frente/( TotalAlambresFrente-1 );
        #local ExcesoY                  = Frente/2-LateralTechoPlano;
        union                           {
          #local Sime                   = 0;
          #while ( Sime < 2 )
            #local PivoteX              = -Frente/2+1.001*SeparacionFrontal;
            #while ( PivoteX < ( Frente/2 )  )
              #if ( Sime = 0 )
                #local BaseInferior     = PaseBandeja-GruesoAlambre/2;
              #else  // #else ( Simetrico = 0 )
                #local BaseInferior     = -GruesoAlambrito/2;
              #end   // #else ( Simetrico = 0 )
              #local BaseSuperior       = AltoBase+GruesoAlambre;
              #if ( abs( PivoteX ) < ExcesoY )
                #local BaseSuperior     = BaseSuperior+ExcesoY-abs( PivoteX );
              #end  // #if ( abs( PivoteX ) < ExcesoY )
              cylinder                  {
                BaseInferior*y,
                BaseSuperior*y,
                GruesoAlambrito/2
                translate                ( Profundidad/2+AjusteAlambre )*z
                translate                PivoteX*x
                #if ( Sime = 0 )
                  scale                 <1,1,-1>
                #end  // #if ( Sime = 0 )
              }
              #local PivoteX            = PivoteX+SeparacionFrontal;
            #end  // #while ( PivoteX < LateralTechoPlano )
            #local Sime                 = Sime+1;
          #end  // #while ( Sime < 2 )
        }
        #local Ventana                  = 0;
        #while ( Ventana < TotalVentanas )
          #if ( ArregloVentanas[Ventana].x < TotalPisos )
            #if ( ArregloVentanas[Ventana].z < TotalAlambresFrente )
              #local AnchoBox           =
                 ArregloVentanas[Ventana].z-ArregloVentanas[Ventana].y-0.5;
              #local AnchoBox           = AnchoBox*SeparacionFrontal;
              box                       {
                <-AnchoBox/2,GruesoAlambre/2,-Profundidad>,
                <+AnchoBox/2,AltoPiso-GruesoAlambre/2,0>
                translate               -PaseBandeja*y
                translate     ( ArregloVentanas[Ventana].x*AltoPiso )*y
                translate     -Frente/2*x+
                        ( ArregloVentanas[Ventana].y+
                          ArregloVentanas[Ventana].z-2 )*SeparacionFrontal*x/2
                pigment { Green }
              }
            #end  // #if ( ArregloVentanas[Ventana].z < TotalAlambresFrente )
          #end  // #if ( ArregloVentanas[Ventana.x < TotalPisos ])
          #local Ventana                = Ventana+1;
        #end  // #while ( C < TotalVentanas )
      }
      texture                           {
        TexturaJaula
      }
    }
    // Techo
    union                               {
      #local ProfundidadTecho           = Profundidad+2*GruesoAlambre;
      #local BarraTecho                 =
        union                           {
          cylinder                      {
            -ProfundidadTecho/2*z, ProfundidadTecho/2*z, GruesoAlambre/2
          }
          object                        {
            JVPA_Gancho( GruesoAlambre )
            translate                   GruesoAlambre*y
            rotate                      180*x
            rotate                      90*y
            translate                   -ProfundidadTecho/2*z
          }
          object                        {
            JVPA_Gancho( GruesoAlambre )
            translate                   GruesoAlambre*y
            rotate                      180*x
            rotate                      -90*y
            translate                   +ProfundidadTecho/2*z
          }
          translate                     GruesoAlambre*y
        }
      #local DeltaZ                     =
                 ProfundidadTecho/( TotalAlambresProfundidad-1 );
      #local SimeX                      = 0;
      #while ( SimeX < 2 )
        union                           {
          #local C                      = 0;
          #while ( C < TotalAlambresProfundidad )
            #if ( ( C = 0 ) | ( C = ( TotalAlambresProfundidad-1 ) ) )
              #local GruesoReja         = GruesoAlambre;
              #local AjusteY            = 0;
            #else  // #else ( GruesoReja )
              #local GruesoReja         = GruesoAlambrito;
              #local AjusteY            = AjusteAlambre;
            #end   // #else ( GruesoReja )
            union                       {
              cylinder                  {
                -( Frente/2+GruesoAlambre )*x, -ExcesoY*x, GruesoReja/2
              }
              object                    {
                JVPA_Curva45( CurvaDecorativa, GruesoReja )
                translate               ( ExcesoY-UsualCorX1+UsualCor2 )*y
                translate               UsualCorX1*x
              }
              cylinder                  {
                -ExcesoY*x, ExcesoY*y-UsualCor2*(x+y), GruesoReja/2
              }
              cylinder                  {
                0, -ExcesoTecho*( x+y ), GruesoReja/2
                translate               -( Frente/2+GruesoAlambre )*x
              }
              translate                 AjusteY*y
              translate                 -ProfundidadTecho/2*z+C*DeltaZ*z
            }
            #local C                    = C+1;
          #end  // #while ( PivoteZ < ( 0.5001*ProfundidadTecho ) )
          object                        {
            BarraTecho
            translate                   -( Frente/2-LateralTechoPlano*0.7 )*x
          }
          object                        {
            BarraTecho
            translate                   -GruesoAlambre*y
            rotate                      45*z
            translate                   +GruesoAlambre*y
            translate                   -( Frente/2+GruesoAlambre )*x
            translate              -( ExcesoTecho-GruesoAlambrito/2 )*( x+y )
          }
          object                        {
            BarraTecho
            translate                   -GruesoAlambre*y
            rotate                      45*z
            translate                   +GruesoAlambre*y
            translate                   -( Frente/2+GruesoAlambre )*x
            translate                   -( GruesoAlambre )*( x+y )
          }
          #if ( SimeX = 0 )
            scale                       <-1,1,1>
          #end  // #if ( SimeX = 0 )
        }
        #local SimeX                    = SimeX+1;
      #end  // #while ( SimeX < 0 )
      object                            {
        BarraTecho
        translate               ( ExcesoY-UsualCorX1+UsualCor2 )*y
      }
      translate                 ( AltoBase+GruesoAlambre/2 )*y
      texture                           {
        TexturaTecho
      }
    }
    // Ventanas
    union                               {
      #local Ventana                  = 0;
      #while ( Ventana < TotalVentanas )
        #if ( ArregloVentanas[Ventana].x < TotalPisos )
          #if ( ArregloVentanas[Ventana].z < TotalAlambresFrente )
             #local X1                  =  -Frente/2+
                  ( ArregloVentanas[Ventana].y-1 )*SeparacionFrontal;
             #local X2                  =  -Frente/2+
                  ( ArregloVentanas[Ventana].z-1 )*SeparacionFrontal;
             #local Y1                  = -PaseBandeja+
                  ArregloVentanas[Ventana].x*AltoPiso;
             #local Y2                  = Y1+AltoPiso;
             #local TotalAlambres       =
                ArregloVentanas[Ventana].z-ArregloVentanas[Ventana].y-1;    
             #local MaximaApertura     = AltoPiso-2*GruesoAlambre;   
             object                     {
               JVPA_VentanaJaula( X1, Y1, X2, Y2,
                     TotalAlambres, GruesoAlambre )
               translate                -Profundidad/2*z
               translate                +GruesoAlambre*y   
               translate                AbrirPuertas[Ventana]*MaximaApertura*y
             }
          #end  // #if ( ArregloVentanas[Ventana].z < TotalAlambresFrente )
        #end  // #if ( ArregloVentanas[Ventana.x < TotalPisos ])
        #local Ventana                = Ventana+1;
      #end  // #while ( C < TotalVentanas )
      texture                           {
        TexturaVentana
      }
    }
    // Accesorios 
    #if ( BanderaBandeja )
      object                              {
        JVPA_BandejaJaula( Frente, Profundidad,
                  PaseBandeja, GruesoAlambre, TexturaBandeja )
        translate                         GruesoAlambre*y/2
      } 
    #end  // #if ( BanderaBandeja )
    #declare JVPA_PosicionBandeja       = GruesoAlambre*y;  
    union                               {
      #local Palitos                    = 0;
      #while ( Palitos < TotalPalitos )
        #if ( ArregloPalitos[Palitos].u < TotalPisos )
          #if ( ArregloPalitos[Palitos].v < ( TotalAlambresFrente+1 ) )
             #local X1                  =  -Frente/2+
                  ( ArregloPalitos[Palitos].v-1 )*SeparacionFrontal;
             #local X2                  =  X1+SeparacionFrontal;
             #local Y1                  = -PaseBandeja+
                  ArregloPalitos[Palitos].u*AltoPiso;
             #local Y2                  = Y1+SeparacionFrontal;
             box                        {
               <X1,Y1,-Profundidad/2-PaseBandeja>,
               <X2,Y2,+Profundidad/2+PaseBandeja>
             }
          #end  // #if ( ArregloPalitos[Palitos].z < TotalAlambresFrente )
        #end  // #if ( ArregloPalitos[Palitos.x < TotalPisos ])
        #local Palitos                = Palitos+1;
      #end  // #while ( C < TotalPalitos )
      texture                           {
        TexturaMadera
      }
    }
    // Columpio
    union                               {
      cylinder                          {
        0, -AltoColumpio*y, GruesoAlambre/2
        translate                       -GruesoAlambre*x
        translate                       -AnchoColumpio*z/2
      }
      cylinder                          {
        0, -AltoColumpio*y, GruesoAlambre/2
        translate                       -GruesoAlambre*x
        translate                       +AnchoColumpio*z/2
      }
      object                            {
        JVPA_Gancho( GruesoAlambre )
        rotate                  90*z
        scale                   <-1,1,1>
        translate                       -AnchoColumpio/2*z
      }
      object                            {
        JVPA_Gancho( GruesoAlambre )
        rotate                  90*z
        scale                   <-1,1,1>
        translate                       +AnchoColumpio/2*z
      }
      cylinder                          {
        -( AnchoColumpio/2+SeparacionFrontal )*z,
        +( AnchoColumpio/2+SeparacionFrontal )*z,
        1.25*SeparacionFrontal/2
        translate                       -AltoColumpio*y
        texture                         {
          TexturaMadera
        }
      }  
      rotate                    AnguloColumpio*z
      translate               ( ExcesoY-UsualCorX1+UsualCor2 )*y
      translate                 ( AltoBase+3*GruesoAlambre/2 )*y
      texture                           {
        TexturaBandeja
      }
    }  // Columpio 
    translate                   GruesoAlambre*y/2
  }
#end  // #macro JVPA_JaulaVespertinaPericoAmor()

#macro JVPA_JaulaAbierta( AnguloColumpio, BanderaBandeja,
                         PuertaIzquierda, PuertaCentral, PuertaDerecha )
  object                        {
    #local L                    = JVPA_L;
    #local Frente               = 316*L;
    #local Profundidad          = 172*L;
    #local AltoBase             = 197*L;
    #local AltoPiso             = 75*L;
    #local PaseBandeja          = 11*L;
    #local LateralTechoPlano    = 86*L;
    #local ExcesoTecho          = 32*L;
    #local AltoColumpio         = 110*L;
    #local AbrirPuertas         = array [3]
                { 0.775*PuertaIzquierda, PuertaCentral, 0.775*PuertaDerecha }
    #local TotalAlambresProfundidad             = 20;
    #local TotalAlambresFrente                  = 36;
    #local GruesoAlambrito                      = 1.5*L;
    #local GruesoAlambre                        = 1.8*L;
    #local CurvaDecorativa                      = 7*L;
    JVPA_JaulaVespertinaPericoAve( AnguloColumpio, BanderaBandeja,
        AbrirPuertas, Frente, Profundidad,
        AltoBase, AltoPiso, PaseBandeja, LateralTechoPlano,
        ExcesoTecho, AltoColumpio,
        TotalAlambresFrente, TotalAlambresProfundidad, JVPA_ArregloVentanas,
        JVPA_ArregloPalitos, GruesoAlambrito, GruesoAlambre, CurvaDecorativa,
        JVPA_DefaultArregloTexturas )
  }
#end  // #macro JVPA_JaulaAbierta() 

#macro JVPA_Jaula( AnguloColumpio )        
  object                                {   
    JVPA_JaulaAbierta( AnguloColumpio, on, 0, 0, 0 )
  }
#end  // #macro JVPA_Jaula( AnguloColumpio )
