// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com
// Apdo. 964-1250 Escaz, San Jos, Costa Rica
// dedicado a Jess y Mara...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho... 18 junio 2012
//                
// Mis dibujos estn en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY 
//
// ALSF_Au1.pov es un archivo experimental en desarrollo
// Se recomienda no utilizarlo directamente en sus propias
// animaciones, y esperar futuras versiones.
// Se incluye aqu como auxiliar
// para la graficacion del objeto
// Es la fusion de cuatro archivos personales
// en uno solo, para evitar saturacion de los
// archivos #include en el futuro (el limite actual es 10)
// Las explicaciones se encuentran dividias
// en cuatro secciones, siguiendo la secuencia original.
//
// #macro ALSF_Determinante ( Det, A11, A12, A21, A22 )
//      Calcula el determinante de una matriz 2*2
//                     A11   A12   = A11*A12-A12*A21
//                     A21   A22  
//      Det     : OUTPUT resultado float del determinante
//      A11     : casilla A11 de la matriz
//      A12     : casilla A12 de la matriz
//      A21     : casilla A21 de la matriz
//      A22     : casilla A22 de la matriz
//
// #macro ALSF_SistemaDoble ( Solucion, A, B, C, D, E, F )
//      Resuelve el sistema de ecuaciones Lineales 2*2
//              Ax+By   = C     Solucion = < x,y,Determinante  >
//              Dx+Ey   = F
//      Solucion        : OUTPUT devuelve la solucion como <x,y,Determinante>
//              O podria ser vector nulo si Determinante = 0
//      A               : constante multiplica x en ecuacion primera
//      B               : constante multiplica y en ecuacion primera
//      C               : constante resultado en ecuacion primera
//      D               : constante multiplica x en ecuacion segunda
//      E               : constante multiplica y en ecuacion segunda
//      F               : constante resultado en ecuacion segunda
//
// #macro ALSF_CentroTriplePunto( Centro, C, P, Q )
//      Calculo Centro de un circulo que pase por los vectores C, P y Q
//      o vector nulo si fracaso
//      ALSF_BanderaCentro      = true  si exito
//                                false si fracaso
//      Centro          : OUTPUT devuelve el centro solicitado o vector
//              nulo si fracaso
//      C               : Punto del crculo
//              Se recomienda (innecesario) colocarlo en medio de P y Q.
//      P               : Otro punto del crculo
//      Q               : Otro punto del crculo
//
// #macro ALSF_CentroEsfericoTriplePunto
//        ( CentroEsferico, CentroTriangulo, C, P, Q, RadioEsfera )
//      Calculo Centro de un circulo y esfera
//      que pase por los vectores C, P y Q
//      o vector nulo si fracaso, la esfera tiene radio RadioEsfera
//      ALSF_BanderaCentro      = true  si exito en triangulo
//                                false si fracaso en triangulo
//      ALSF_BanderaEsfera      = true  si exito en esfera
//                                false si fracaso en esfera ( vector nulo )
//      Nota: es posible exito en Centro de Triangulo y fracaso en Esfera
//              por ejemplo si RadioEsfera es muy pequeno
//      CentroEsferico  : OUTPUT devuelve el centro esfera solicitado o vector
//              nulo si fracaso
//      CentroTriangulo : OUTPUT devuelve el centro plano de triangulo
//              solicitado o vector nulo si fracaso
//      C               : Punto del crculo inscrito a esfera
//      P               : Otro punto del crculo inscrito a esfera
//      Q               : Otro punto del crculo inscrito a esfera
//      RadioEsfera     : Radio solicitado de esfera
//
// #macro ALSF_SweepTriplePunto( P, C, Q, Radio, BanderaEsfera )
//      Genera Torus que pase por los vectores P, C y Q
//      C en medio de P y Q, el torus de grueso Radio.
//      BanderaEsfera true agrega esferas en los extremos
//      En la versin actual el ngulo debera ser menor o igual a 180.
//              Si aALSFados genera cilindro.
//      P               : punto inicial del recorrido del torus
//      C               : punto central del recorrido del torus
//      Q               : punto final del recorrido del torus
//      Radio           : radio interno del torus
//      BanderaEsfera   : si true coloca esferas en los extremos
//                        si false se ignora
//
// #macro ALSF_AnilloTriplePunto( P, C, Q, GruesoR, GruesoZ, BanderaFinal )
//      Similar a ALSF_SweepTriplePunto (arriba), pero el torus
//      es de base interna cuadrangular. Es decir se genera
//      por diferencia de anillos cilindricos.
//      Genera Anillo Cilidrico que pase por los vectores P, C y Q
//      C en medio de P y Q.
//      GruesoR es el "grueso" del anillo cilindrico y GruesoZ es el
//      grueso perpendicular al recorrido sweep.
//      Los puntos se colocan centrados al recorrido.
//      BanderaEsfera true agrega cilindros en los extremos
//      En la versin actual el ngulo debera ser menor o igual a 180.
//              ADVERTENCIA: Si aALSFados genera cilindro.
//              Disculpas por los problemas que esto podria causar
//              Podria remediarlo induciendo un pequeo defecto
//              en el recorrido.
//      P               : punto inicial del recorrido del anillo cilidrico
//      C               : punto central del recorrido del anillo cilindro
//      Q               : punto final del recorrido del anillo cilindrico
//      GruesoR         : grueso radial del anillo
//      GruesoZ         : grueso perpendicular al radio del anillo
//      BanderaFinal    : si true coloca cilindros en los extremos
//                        si false se ignora
//
// #macro ALSF_SegmentoTriplePunto( P, C, Q,
//                        GruesoZ, SegmentoSector, BanderaFinal )
//      Similar a ALSF_SweepTriplePunto (arriba), pero se genera
//      un Segmento o un SectorCircular segun bandera SegmentoSector
//      el borde es plano o toroidal segun BanderaFinal
//      Genera Segmento o Sector Circular que pase por la curva P, C y Q
//      C en medio de P y Q.
//      GruesoZ es el "grueso"
//      grueso perpendicular al recorrido sweep.
//      Los puntos se colocan centrados al recorrido.
//      BanderaEsfera true redondea con toroides y cilindros
//      los bordes para que queden curvos
//      En la versin actual el ngulo debera ser menor o igual a 180.
//              ADVERTENCIA: Si aALSFados genera cilindro.
//              Disculpas por los problemas que esto podria causar
//              Podria remediarlo induciendo un pequeo defecto
//              en el recorrido.
//      P               : punto inicial del arco circular
//      C               : punto central del arco circular curva
//      Q               : punto final de la curva del arco circular
//      GruesoZ         : grueso perpendicular al radio del anillo
//      SegmentoSector  : si true se trata de Segmento Circular
//                              relleno hasta cuerda interior
//                        si false se trata de Sector Circular
//                              relleno hasta centro del circulo
//      BanderaFinal    : si false son bordes planos
//                        si true los bordes son curvos con toriodes, etc
//                        si false se ignora
//
// #macro ALSF_InterpolacionTriplePunto( Resultado, C, P, Q, FraccionU )
//      Calculo Interpolacion de un arco de circulo que pasa
//      por los vectores C, P y Q.  C en el centro de curva
//      o vector nulo si fracaso
//      ALSF_BanderaCentro      = true  si exito
//                                false si fracaso
//      El resultado es algo asi a P+FraccionU*(Q-P), pero en la "curva"
//      Resultado       : OUTPUT devuelve el vector interpolado solicitado o
//              nulo si fracaso
//      C               : Punto del crculo
//              Se deberia colocar en medio de P y Q.
//      P               : Otro punto del crculo
//      Q               : Otro punto del crculo
//      FraccionU       : Recorre de 0 a 1.  0 es P y 1 es Q.
//
// #macro ALSF_SegmentoEsfericoTriplePunto
//                        ( C, P, Q, RadioEsfera, BanderaSector )
//      Dibuja un segmento esferico, es decir
//      la zona entre un plano y una esfera.  Si BanderaSector es true
//      entonces el dibujo agrega un plano a la figura.
//      C               : Punto del crculo
//      P               : Otro punto del crculo
//      Q               : Otro punto del crculo
//      RadioEsfera     : es el radio de la esfera,
//              si falla dibuja un disco
//      BanderaSector   : si TRUE agrega un cono, si FALSE solo el segmento
//
// #macro ALSF_CascaronEsfericoTriplePunto
//               ( C, P, Q, RadioEsfera, GruesoCascaron, BanderaTorus )
//      Dibuja un cascaron esferico, es decir
//      la zona entre dos esferas.  BanderaTorus agrega un torus decorativo.
//      C               : Punto del circulo guia
//      P               : Otro punto del circulo guia
//      Q               : Otro punto del circulo guia
//      RadioEsfera     : Radio medio cascaron, con respecto a los puntos
//      GruesoCascaron  : Grueso del cascaron
//      BanderaTorus    : Si TRUE agrega torus decorativo al final
//
// #macro ALSF_TrianguloEsfericoTriplePunto
//              ( C, P, Q, RadioEsfera, GruesoCascaron, BanderaTorus )
//      Dibuja un triangulo esferico
//      ( un triangulo en la superficie de una esfera )
//      a manera de cascara de grueso GruesoCascaron
//      C               : Punto del circulo guia
//      P               : Otro punto del circulo guia
//      Q               : Otro punto del circulo guia
//      RadioEsfera     : Radio medio cascaron, con respecto a los puntos
//      GruesoCascaron  : Grueso del cascaron
//      BanderaTorus    : Si TRUE agrega torus y esferas decorativas
//              a los extremos del triangulo esferico
//
// #macro ALSF_TrianguloEsfericoTriplePuntoLiso
//              ( C, P, Q, RadioEsfera, GruesoCascaron )
//      Dibuja un triangulo esferico
//      ( un triangulo en la superficie de una esfera )
//      a manera de cascara de grueso GruesoCascaron
//      C               : Punto del circulo guia
//      P               : Otro punto del circulo guia
//      Q               : Otro punto del circulo guia
//      RadioEsfera     : Radio medio cascaron, con respecto a los puntos
//      GruesoCascaron  : Grueso del cascaron
//
// #macro ALSF_PuenteTrianguloEsfericoTriplePunto
//                ( C, P, Q, R, RadioEsfera, GruesoCascaron, BanderaTorus )
//      Suelen producirse "huecos" al unir dos Triangulos Esfericos
//      Esta macro intenta rellenar el hueco
//      La idea es rellenar con dos Triangulos Esfericos la union
//      Entre el TrianguloEsferico ( C, P, Q ) y el ( Q, P, R )
//      La zona PQ de ambos triangulos que no calzaron bien.
//      Utilice un RadioEsfera promedio o a su propio criterio.
//      BanderaTorus true agrega Torus a los bordes para mejorar la calza.
//      C               : Punto del circulo guia 1
//      P               : Otro punto guia comun a ambos TriangulosEsfericos
//      Q               : Otro punto guia comun a ambos TriangulosEsfericos
//      R               : Punto del circulo guia 2
//      RadioEsfera     : Radio medio cascaron, con respecto a los puntos
//        Se recomienda un promedio de los radios en los TriangulosEsfericos
//      GruesoCascaron  : Grueso del cascaron
//      BanderaTorus    : Si TRUE agrega torus y esferas para mejorar la calza
//
// #macro ALSF_SegmentoTrianguloEsfericoTriplePunto
//                ( C, P, Q, RadioEsfera, GruesoCascaron,
//                        BanderaCP, BanderaPQ, BanderaQC, BanderaTorus )
//      Se puede considerar una figura intermedia entre
//      ALSF_CascaronEsfericoTriplePunto y ALSF_TrianguloEsfericoTriplePunto
//      La idea es crear un segmento esferico, y recortarle a voluntad
//      de las banderas BanderaCP, BanderaPQ y Bandera QC, los lados
//      que se requieran de un supuesto triangulo esferico
//      inscrito en la superficie de una esfera.
//      C               : Punto del circulo guia
//      P               : Otro punto del circulo guia
//      Q               : Otro punto del circulo guia
//      RadioEsfera     : Radio medio cascaron, con respecto a los puntos
//      GruesoCascaron  : Grueso del cascaron
//      BanderaCP       : TRUE-> Recorta en el lado CP del triangulo esferico
//      BanderaPQ       : TRUE-> Recorta en el lado PQ del triangulo esferico
//      BanderaQC       : TRUE-> Recorta en el lado QC del triangulo esferico
//      BanderaTorus    : Si TRUE agrega torus y esferas decorativas
//              a los extremos del cascaron-triangulo esferico
//
// #macro ALSF_InterpolacionEsfericoTriplePuntoMedio
//                        ( Resultado, C, P, Q, RadioEsfera )
//      Calculo Interpolacion de un arco de esfera que pasa
//      por los vectores P y Q siguiente un arco de esfera.
//      C es otro punto del casco esferico de RadioEsfera.
//      Se obtiene el PuntoMedio de dicho arco.
//      ALSF_BanderaEsfera      = true  si exito
//                                false si fracaso
//      ALSF_BanderaCentro      = true exito parcial como circulo
//                                false se interpreto como ALSFa de P a Q
//      El resultado es algo asi a (P+Q)/2, pero en el "arco esferico".
//      Resultado       : OUTPUT devuelve el vector interpolado
//      C               : Punto guia de la esfera
//      P               : Otro punto base de la interpolacion
//      Q               : Otro punto base de la interpolacion
//      RadioEsfera     : Radio de la esfera interpolada.
//              Si error se tratara de interpretar como circulo.
//
// #macro ALSF_InterpolacionEsfericoTriplePunto
//                        ( Resultado, C, P, Q, RadioEsfera, FraccionU )
//      Calculo Interpolacion de un arco de esfera que pasa
//      por los vectores P y Q siguiente un arco de esfera.
//      C es otro punto del casco esferico de RadioEsfera.
//      Se obtiene interpolacion de 0 a 1 segun FraccionU de dicho arco.
//      ALSF_BanderaEsfera      = true  si exito
//                                false si fracaso
//      ALSF_BanderaCentro      = true exito parcial como circulo
//                                false se interpreto como ALSFa de P a Q
//      El resultado es algo asi a P+FraccionU*(Q-P), pero en "arco esferico".
//      Resultado       : OUTPUT devuelve el vector interpolado
//      C               : Punto guia de la esfera
//      P               : Otro punto base de la interpolacion
//      Q               : Otro punto base de la interpolacion
//      RadioEsfera     : Radio de la esfera interpolada.
//              Si error se tratara de interpretar como circulo.
//      FraccionU       : Recorre de 0 a 1.  0 es P y 1 es Q.
//
// #macro ALSF_PlanoTriplePunto( PuntoA, PuntoB, PuntoC )
//      Crea un plano infinito que pasa por los tres puntos.
//      La normal se orienta segun PuntoB-PuntoA x PuntoC-PuntoA.
//      Se considera util en diferencias y similares, para biselar.
//      PuntoA          : Uno de los puntos que sirve de vertice
//              en el producto cruz.
//      PuntoB          : Otro punto del plano
//      PuntoC          : Otro punto del plano
//



#if ( version < 3.2 )
  #ifndef( ALSF_POV3_1 )
    #declare ALSF_POV3_1        = on;
  #end
#else
  #ifndef( ALSF_POV3_1 )
    #declare ALSF_POV3_1        = off;
  #end
#end

#if ( ALSF_POV3_1 )
// Las macros ALSF_Reorient_Trans y ALSF_Axis_Rotate_Trans
// se transcribe casi identica a la original
// en "transforms.inc" Reorient_Trans y Axis_Rotate_Trans
// se copia por compatibilidad con POVRay 3.1.
// La macro ALSF_VPerp_To_Vector
// se tomo de "math.inc" VPerp_To_Vector
// por compatibilidad con POVRay 3.1.


// Returns a vector perpendicular to V
// Author: Tor Olav Kristensen
#macro ALSF_VPerp_To_Vector(v0)
   #if (vlength(v0) = 0)
      #local vN = <0, 0, 0>;
   #else
      #local Dm = min(abs(v0.x), abs(v0.y));
      #local Dm = min(abs(v0.z),Dm);
      #if (abs(v0.z) = Dm)
         #local vN = vnormalize(vcross(v0, z));
      #else
         #if (abs(v0.y) = Dm)
            #local vN = vnormalize(vcross(v0, y));
         #else
            #local vN = vnormalize(vcross(v0, x));
         #end
      #end
   #end
   vN
#end

// rotate around a specific axis
// Author: Rune S. Johansen
#macro ALSF_Axis_Rotate_Trans(Axis, Angle)
   #local vX = vaxis_rotate(x,Axis,Angle);
   #local vY = vaxis_rotate(y,Axis,Angle);
   #local vZ = vaxis_rotate(z,Axis,Angle);
//   transform {
      matrix < vX.x,vX.y,vX.z, vY.x,vY.y,vY.z, vZ.x,vZ.y,vZ.z, 0,0,0 >
//   }
#end


// based on original Reorient() macro by John VanSickle
#macro ALSF_Reorient_Trans(Axis1, Axis2)
   #local vX1 = vnormalize(Axis1);
   #local vX2 = vnormalize(Axis2);
   #local Y = vcross(vX1, vX2);
   #if(vlength(Y) > 0)
      #local vY = vnormalize(Y);
      #local vZ1 = vnormalize(vcross(vX1, vY));
      #local vZ2 = vnormalize(vcross(vX2, vY));
//      transform {
         matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
         matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
//      }
   #else
      #if (vlength(vX1-vX2)=0)
         transform {}
      #else
         #local vZ = ALSF_VPerp_To_Vector(vX2);
//         transform {
         ALSF_Axis_Rotate_Trans(vZ,180)
//}
      #end
   #end
#end

// --------------------
// Transformation macros:
// --------------------
// Reorients and deforms object so original x axis points along A, original y along B,
// and original z along C.
// Ligera modificacion de Shear_Trans en "transforms.inc"
#macro ALSF_Shear_Trans(A, B, C)
//   transform {
      matrix < A.x, A.y, A.z,
             B.x, B.y, B.z,
             C.x, C.y, C.z,
             0, 0, 0>
//   }
#end

// Similar to Reorient_Trans(), points y axis along Axis.
// ver Point_At_Trans de "transforms.inc"
#macro ALSF_Point_At_Trans(YAxis)
   #local Y = vnormalize(YAxis);
   #local X = ALSF_VPerp_To_Vector(Y);
   #local Z = vcross(X, Y);
   ALSF_Shear_Trans(X, Y, Z)
#end

#else
  #include "transforms.inc"
#end

#macro ALSF_Determinante ( Det, A11, A12, A21, A22 )
  #local Det            = ( A11*A22-A12*A21 );
#end

#macro ALSF_SistemaDoble ( Solucion, A, B, C, D, E, F )
  #local Det            = 0;
  ALSF_Determinante( Det, A, B, D, E )
  #if ( Det = 0 )
    #local Solucion   = < 0, 0, 0 >;
  #else
    #local DetX         = 0;
    #local DetY         = 0;
    ALSF_Determinante( DetX, C, B, F, E )
    ALSF_Determinante( DetY, A, C, D, F )
    #local Solucion   = < DetX/Det, DetY/Det, Det >;
  #end
#end

// ( ALSF_BanderaCentro = true ), confirma exito
#macro ALSF_CentroTriplePunto( Centro, C, P, Q )
  #local CP             = P-C;
  #local CQ             = Q-C;
  #local CP2            = ( C+P )/2;
  #local CQ2            = ( C+Q )/2;
  #local AEQ            = vdot( CQ, CQ );
  #local BEQ            = vdot( CQ, CP );
  #local CEQ            = vdot( CQ2, CQ );
  #local DEQ            = BEQ;
  #local EEQ            = vdot( CP, CP );
  #local FEQ            = vdot( CP2, CP );
  #local ALSF_Solucion  = <0,0,0>;
  ALSF_SistemaDoble( ALSF_Solucion, AEQ, BEQ, CEQ, DEQ, EEQ, FEQ )
  #if ( ALSF_Solucion.z = 0 )
    #local Centro       = < 0, 0, 0 >;
    #declare ALSF_BanderaCentro = false;
  #else
    #local Centro       = ( ALSF_Solucion.x*CQ+ALSF_Solucion.y*CP );
    #local Normal       = vnormalize( vcross( CP, CQ ) );
    #local Centro       = Centro+vdot( C, Normal )*Normal;
    #declare ALSF_BanderaCentro = true;
  #end
#end

#macro ALSF_InterpolacionTriplePunto( Resultado, C, P, Q, FraccionU )
  #local Centro         = < 0, 0, 0 >;
  ALSF_CentroTriplePunto( Centro, C, P, Q )
  #if ( ALSF_BanderaCentro )
    #local CP         = vnormalize( P-Centro );
    #local CQ         = vnormalize( Q-Centro );
    #local Normal     = vcross( CP, CQ );
    #local Angulo     = FraccionU*degrees( acos( vdot( CP, CQ ) ) );
    #local Resultado  = vaxis_rotate( P-Centro, Normal, Angulo )+Centro;
  #else
    #local Resultado  = P+FraccionU*( Q-P );
  #end
#end

#macro ALSF_CentroEsfericoTriplePunto
        ( CentroEsferico, CentroTriangulo, C, P, Q, RadioEsfera )
  ALSF_CentroTriplePunto( CentroTriangulo, C, P, Q )
  #if ( ALSF_BanderaCentro )
    #local Normal       = vnormalize( vcross( P-C, Q-C ) );
    #local PivReal      =
        RadioEsfera*RadioEsfera-vdot( P-CentroTriangulo, P-CentroTriangulo );
    #if ( PivReal <= 0 )
      #declare ALSF_BanderaEsfera       = false;
      #local CentroEsferico             = <0,0,0>;
    #else
      #declare ALSF_BanderaEsfera       = true;
      #local CentroEsferico             =
                        CentroTriangulo+sqrt( PivReal )*Normal;
    #end
  #end
#end

#macro ALSF_InterpolacionEsfericoTriplePuntoMedio
                        ( Resultado, C, P, Q, RadioEsfera )
  #local CentroEsfera           = < 0, 0, 0 >;
  #local CentroTriangulo        = < 0, 0, 0 >;
  ALSF_CentroEsfericoTriplePunto
        ( CentroEsfera, CentroTriangulo, C, P, Q, RadioEsfera )
  #if ( ALSF_BanderaEsfera )
    #local Rayo         = vnormalize( ( P+Q )/2-CentroEsfera );
    #local Resultado    = CentroEsfera+RadioEsfera*Rayo;
  #else
    #if ( ALSF_BanderaCentro )
      #local Rayo       = vnormalize( ( P+Q )/2-CentroTriangulo );
      #local Resultado  = CentroTriangulo+RadioEsfera*Rayo;
    #else
      #local Resultado  = ( P+Q )/2;
    #end
  #end
#end

#macro ALSF_InterpolacionEsfericoTriplePunto
                        ( Resultado, C, P, Q, RadioEsfera, FraccionU )
  #local CentroEsfera           = < 0, 0, 0 >;
  #local CentroTriangulo        = < 0, 0, 0 >;
  ALSF_CentroEsfericoTriplePunto
        ( CentroEsfera, CentroTriangulo, C, P, Q, RadioEsfera )
  #if ( ALSF_BanderaEsfera )
    #local CP         = vnormalize( P-CentroEsfera );
    #local CQ         = vnormalize( Q-CentroEsfera );
    #local Normal     = vcross( CP, CQ );
    #local Angulo     = FraccionU*degrees( acos( vdot( CP, CQ ) ) );
    #local Resultado  = vaxis_rotate
                ( P-CentroEsfera, Normal, Angulo )+CentroEsfera;
  #else
    #if ( ALSF_BanderaCentro )
      #local CP         = vnormalize( P-CentroTriangulo );
      #local CQ         = vnormalize( Q-CentroTriangulo );
      #local Normal     = vcross( CP, CQ );
      #local Angulo     = FraccionU*degrees( acos( vdot( CP, CQ ) ) );
      #local Resultado  = vaxis_rotate
                ( P-CentroTriangulo, Normal, Angulo )+CentroTriangulo;
    #else
      #local Resultado  = P+FraccionU*( Q-P );
    #end
  #end
#end

#macro ALSF_SweepTriplePunto( P, C, Q, Radio, BanderaEsfera )
  #local Centro         = < 0, 0, 0 >;
  ALSF_CentroTriplePunto( Centro, C, P, Q )
  union                 {
  #if ( ALSF_BanderaCentro )
    difference            {
      #local RadioPr    = sqrt( vdot( P-Centro, P-Centro ) );
      #local CP         = vnormalize( P-Centro );
      #local CQ         = vnormalize( Q-Centro );
      #local Normal     = vcross( CP, CQ );
      #local Angulo     = degrees( acos( vdot( CP, CQ ) ) );

      torus               {
        RadioPr   , Radio
        #if ( ALSF_POV3_1 )
          ALSF_Reorient_Trans( y, Normal )
        #else
          Reorient_Trans( y, Normal )
        #end
      }
      plane               {
        #local Normal1  = vnormalize( vcross( CP, Normal ) );
        -Normal1         , 0
      }
      plane               {
        #local Normal1  = vnormalize( vcross( Normal, CQ ) );
        -Normal1         , 0
      }
      translate         Centro
    }
  #else
      cylinder          {
        P       , Q     , Radio
      }
  #end
  #if ( BanderaEsfera )
    sphere      {
      P         , Radio
    }
    sphere      {
      Q         , Radio
    }
  #end
  }     // union total
#end
// Se genera un warning, si BanderaEsfera false...

#macro ALSF_AnilloTriplePunto( P, C, Q, GruesoR, GruesoZ, BanderaFinal )
  #local Centro         = < 0, 0, 0 >;
  ALSF_CentroTriplePunto( Centro, C, P, Q )
  union                 {
  #if ( ALSF_BanderaCentro )
    difference            {
      #local RadioPr    = sqrt( vdot( P-Centro, P-Centro ) );
      #local CP         = vnormalize( P-Centro );
      #local CQ         = vnormalize( Q-Centro );
      #local Normal     = vcross( CP, CQ );
      #local Angulo     = degrees( acos( vdot( CP, CQ ) ) );

      cylinder          {
        -GruesoZ/2*y    , +GruesoZ/2*y  , RadioPr+GruesoR/2
        #if ( ALSF_POV3_1 )
          ALSF_Reorient_Trans( y, Normal )
        #else
          Reorient_Trans( y, Normal )
        #end
      }
      cylinder          {
        -1.1*GruesoZ/2*y    , +1.1*GruesoZ/2*y  , RadioPr-GruesoR/2
        #if ( ALSF_POV3_1 )
          ALSF_Reorient_Trans( y, Normal )
        #else
          Reorient_Trans( y, Normal )
        #end
      }
      plane               {
        #local Normal1  = vnormalize( vcross( CP, Normal ) );
        -Normal1         , 0
      }
      plane               {
        #local Normal1  = vnormalize( vcross( Normal, CQ ) );
        -Normal1         , 0
      }
      translate         Centro
    }
  #else
      cylinder          {
        P       , Q     , Radio
      }
  #end
  #if ( BanderaFinal )
    #if ( ALSF_BanderaCentro )
      cylinder          {
        -GruesoZ/2*y    , GruesoZ/2*y   , GruesoR/2
        #if ( ALSF_POV3_1 )
          ALSF_Reorient_Trans( y, Normal )
        #else
          Reorient_Trans( y, Normal )
        #end
        translate       P
      }
      cylinder          {
        -GruesoZ/2*y    , GruesoZ/2*y   , GruesoR/2
        #if ( ALSF_POV3_1 )
          ALSF_Reorient_Trans( y, Normal )
        #else
          Reorient_Trans( y, Normal )
        #end
        translate       Q
      }
    #else
      sphere      {
        P         , Radio
      }
      sphere      {
        Q         , Radio
      }
    #end
  #end
  }     // union total
#end
// se genera un warning si BanderaFinal es false

#macro ALSF_SegmentoTriplePunto( P, C, Q,
                        GruesoZ, SegmentoSector, BanderaFinal )
  #local Centro         = < 0, 0, 0 >;
  ALSF_CentroTriplePunto( Centro, C, P, Q )
  union                 {
  #if ( ALSF_BanderaCentro )
    difference            {
      #local RadioPr    = sqrt( vdot( P-Centro, P-Centro ) );
      #local CP         = vnormalize( P-Centro );
      #local CQ         = vnormalize( Q-Centro );
      #local PQ         = vnormalize( Q-P );
      #local Normal     = vcross( CP, CQ );
      #local Angulo     = degrees( acos( vdot( CP, CQ ) ) );

      cylinder          {
        -GruesoZ/2*y    , +GruesoZ/2*y  , RadioPr
        #if ( ALSF_POV3_1 )
          ALSF_Reorient_Trans( y, Normal )
        #else
          Reorient_Trans( y, Normal )
        #end
      }
      #if ( SegmentoSector )
        plane               {
          #local Normal1  = vnormalize( vcross( PQ, Normal ) );
          Normal1          , vdot( Normal1, P-Centro )
        }
      #else
        plane               {
          #local Normal1  = vnormalize( vcross( CP, Normal ) );
          -Normal1         , 0
        }
        plane               {
          #local Normal1  = vnormalize( vcross( Normal, CQ ) );
          -Normal1         , 0
        }
      #end
      translate         Centro
    }
  #else
      cylinder          {
        P       , Q     , Radio
      }
  #end
  #if ( BanderaFinal )
    #if ( ALSF_BanderaCentro )
      object      {
        ALSF_SweepTriplePunto( P, C, Q, GruesoZ/2, true )
      }
      #if ( SegmentoSector )
        cylinder        {
          P             , Q     , GruesoZ/2
        }
      #else
        cylinder        {
          P             , Centro        , GruesoZ/2
        }
        cylinder        {
          Q             , Centro        , GruesoZ/2
        }
        sphere          {
          Centro        , GruesoZ/2
        }
      #end
    #else
      sphere      {
        P         , Radio
      }
      sphere      {
        Q         , Radio
      }
    #end
  #end
  }     // union total
#end
// se genera un warning si BanderaFinal es false

#macro ALSF_SegmentoEsfericoTriplePunto
                        ( C, P, Q, RadioEsfera, BanderaSector )
  #local CentroEsferico         = < 0, 0, 0 >;
  #local CentroTriangulo        = < 0, 0, 0 >;
  ALSF_CentroEsfericoTriplePunto
        ( CentroEsferico, CentroTriangulo, C, P, Q, RadioEsfera )
  #if ( ALSF_BanderaEsfera )
    union       {
      difference        {
        sphere          {
          CentroEsferico        , RadioEsfera
        }
        box             {
          // Tuve problemas usando el plane, y puse un box
          -RadioEsfera          , RadioEsfera
          #local NormalPlano    = vnormalize( vcross( Q-C, P-C ) );
          translate     ( RadioEsfera-
                    vdot( NormalPlano, CentroTriangulo-CentroEsferico ) )*y
          #if ( ALSF_POV3_1 )
            ALSF_Reorient_Trans( -y, NormalPlano )
          #else
            Reorient_Trans( -y, NormalPlano )
          #end
          translate     CentroEsferico
        }
      }
      #if ( BanderaSector )
        cone            {
          #local AlturaPrisma   = vlength( CentroTriangulo-CentroEsferico );
          CentroEsferico        , 0.0
          CentroTriangulo       ,
                sqrt( RadioEsfera*RadioEsfera-AlturaPrisma*AlturaPrisma )
        }
      #end
    }
  #else
    #if ( ALSF_BanderaCentro )
      disc              {
        CentroTriangulo ,
        vcross( P-C, Q-C ),
        vlength( CentroTriangulo-P )
      }
    #else
      cylinder          {
        P, Q, RadioEsfera/10
      }
    #end
  #end
#end

#macro ALSF_CascaronEsfericoTriplePunto
                        ( C, P, Q, RadioEsfera, GruesoCascaron, BanderaTorus )
  #local CentroEsferico         = < 0, 0, 0 >;
  #local CentroTriangulo        = < 0, 0, 0 >;
  ALSF_CentroEsfericoTriplePunto
        ( CentroEsferico, CentroTriangulo, C, P, Q, RadioEsfera )
  #if ( ALSF_BanderaEsfera )
    union       {
      difference        {
        sphere          {
          CentroEsferico        , RadioEsfera+GruesoCascaron/2
        }
        sphere          {
          CentroEsferico        , RadioEsfera-GruesoCascaron/2
        }
        box             {
          // Tuve problemas usando el plane, y puse un box
          -RadioEsfera*<1.1,1.0,1.1>, RadioEsfera*<1.1,1.0,1.1>
          #local NormalPlano    = vnormalize( vcross( Q-C, P-C ) );
          translate     ( RadioEsfera-
                    vdot( NormalPlano, CentroTriangulo-CentroEsferico ) )*y
          #if ( ALSF_POV3_1 )
            ALSF_Reorient_Trans( -y, NormalPlano )
          #else
            Reorient_Trans( -y, NormalPlano )
          #end
          translate     CentroEsferico
        }
        #if ( BanderaTorus )
          cone            {
            #local AlturaPrisma   = vlength( CentroTriangulo-CentroEsferico );
            #local Factor         = 2*RadioEsfera/AlturaPrisma;
            CentroEsferico        , 0.0
            Factor*CentroTriangulo-( Factor-1 )*CentroEsferico,
              Factor*sqrt( RadioEsfera*RadioEsfera-AlturaPrisma*AlturaPrisma )
            inverse
          }
        #end
      }
      #if ( BanderaTorus )
        torus           {
          #local AlturaPrisma   = vlength( CentroTriangulo-CentroEsferico );
          #local RadioTorus     =
                sqrt( RadioEsfera*RadioEsfera-AlturaPrisma*AlturaPrisma );
          RadioTorus    , GruesoCascaron/2
          #if ( ALSF_POV3_1 )
            ALSF_Reorient_Trans( -y, NormalPlano )
          #else
            Reorient_Trans( -y, NormalPlano )
          #end
          translate     CentroEsferico
                        +AlturaPrisma*NormalPlano
        }
      #end
    }
  #else
    #if ( ALSF_BanderaCentro )
      disc              {
        CentroTriangulo ,
        vcross( P-C, Q-C ),
        vlength( CentroTriangulo-P )
      }
    #else
      cylinder          {
        P, Q, RadioEsfera/10
      }
    #end
  #end
#end

#macro ALSF_TrianguloEsfericoTriplePunto
                        ( C, P, Q, RadioEsfera, GruesoCascaron, BanderaTorus )
  #local CentroEsferico         = < 0, 0, 0 >;
  #local CentroTriangulo        = < 0, 0, 0 >;
  ALSF_CentroEsfericoTriplePunto
        ( CentroEsferico, CentroTriangulo, C, P, Q, RadioEsfera )
  #if ( ALSF_BanderaEsfera )
    union       {
      difference        {
        sphere          {
          CentroEsferico        , RadioEsfera+GruesoCascaron/2
        }
        sphere          {
          CentroEsferico        , RadioEsfera-GruesoCascaron/2
        }
        plane           {
          #local Normal1        =
                vnormalize( vcross( P-CentroEsferico, C-CentroEsferico ) );
          Normal1      , vdot( Normal1, CentroEsferico )
        }
        plane           {
          #local Normal2        =
                vnormalize( vcross( C-CentroEsferico, Q-CentroEsferico ) );
          Normal2      , vdot( Normal2, CentroEsferico )
        }
        plane           {
          #local Normal3        =
                vnormalize( vcross( Q-CentroEsferico, P-CentroEsferico ) );
          Normal3      , vdot( Normal3, CentroEsferico )
        }
      }
      #if ( BanderaTorus )
        #macro ALSF_CentroCurvo( NuevoPunto, Lado1, Lado2 )
          #local CentroLado     = ( Lado1+Lado2 )/2;
          #local NuevoPunto     = CentroEsferico
                      +RadioEsfera*vnormalize( CentroLado-CentroEsferico );
        #end
        object          {
          #local CentroPC       = <0,0,0>;
          ALSF_CentroCurvo( CentroPC, P, C )
          ALSF_SweepTriplePunto( P, CentroPC, C,
                GruesoCascaron/2, false )
        }
        object          {
          #local CentroCQ       = <0,0,0>;
          ALSF_CentroCurvo( CentroCQ, C, Q )
          ALSF_SweepTriplePunto( C, CentroCQ, Q,
                GruesoCascaron/2, false )
        }
        object          {
          #local CentroQP       = <0,0,0>;
          ALSF_CentroCurvo( CentroQP, Q, P )
          ALSF_SweepTriplePunto( Q, CentroQP, P,
                GruesoCascaron/2, false )
        }
        sphere          {
          C             , GruesoCascaron/2
        }
        sphere          {
          P             , GruesoCascaron/2
        }
        sphere          {
          Q             , GruesoCascaron/2
        }
      #end
    }
  #else
    #if ( ALSF_BanderaCentro )
      disc              {
        CentroTriangulo ,
        vcross( P-C, Q-C ),
        vlength( CentroTriangulo-P )
      }
    #else
      cylinder          {
        P, Q, RadioEsfera/10
      }
    #end
  #end
#end

#macro ALSF_TrianguloEsfericoTriplePuntoLiso
                        ( C, P, Q, RadioEsfera, GruesoCascaron )
  #local CentroEsferico         = < 0, 0, 0 >;
  #local CentroTriangulo        = < 0, 0, 0 >;
  ALSF_CentroEsfericoTriplePunto
        ( CentroEsferico, CentroTriangulo, C, P, Q, RadioEsfera )
  #if ( ALSF_BanderaEsfera )
    difference        {
      sphere          {
        CentroEsferico        , RadioEsfera+GruesoCascaron/2
      }
      sphere          {
        CentroEsferico        , RadioEsfera-GruesoCascaron/2
      }
      plane           {
        #local Normal1        =
              vnormalize( vcross( P-CentroEsferico, C-CentroEsferico ) );
        Normal1      , vdot( Normal1, CentroEsferico )
      }
      plane           {
        #local Normal2        =
              vnormalize( vcross( C-CentroEsferico, Q-CentroEsferico ) );
        Normal2      , vdot( Normal2, CentroEsferico )
      }
      plane           {
        #local Normal3        =
              vnormalize( vcross( Q-CentroEsferico, P-CentroEsferico ) );
        Normal3      , vdot( Normal3, CentroEsferico )
      }
      #local BoundedCentro        = ( C+P+Q )/3;
      translate         -BoundedCentro
      scale             1.05
      translate         BoundedCentro
      bounded_by            {
        #local BoundedRadio         =
            max( sqrt( vdot( C-P, C-P ) ),
                    sqrt( vdot( C-Q, C-Q ) ) );
        #local BoundedRadio         =
            max( BoundedRadio, sqrt( vdot( Q-P, Q-P ) ) );
        sphere              { BoundedCentro       , BoundedRadio }
      }
    }
  #else
    #if ( ALSF_BanderaCentro )
      disc              {
        CentroTriangulo ,
        vcross( P-C, Q-C ),
        vlength( CentroTriangulo-P )
      }
    #else
      cylinder          {
        P, Q, RadioEsfera/10
      }
    #end
  #end
#end

#macro ALSF_SegmentoTrianguloEsfericoTriplePunto
                ( C, P, Q, RadioEsfera, GruesoCascaron,
                        BanderaCP, BanderaPQ, BanderaQC, BanderaTorus )
  #local CentroEsferico         = < 0, 0, 0 >;
  #local CentroTriangulo        = < 0, 0, 0 >;
  ALSF_CentroEsfericoTriplePunto
        ( CentroEsferico, CentroTriangulo, C, P, Q, RadioEsfera )
  #if ( ALSF_BanderaEsfera )
    union       {
      difference  {
        union       {
          difference        {
            sphere          {
              CentroEsferico        , RadioEsfera+GruesoCascaron/2
            }
            sphere          {
              CentroEsferico        , RadioEsfera-GruesoCascaron/2
            }
            box             {
              // Tuve problemas usando el plane, y puse un box
              -RadioEsfera*<1.1,1.0,1.1>, RadioEsfera*<1.1,1.0,1.1>
              #local NormalPlano    = vnormalize( vcross( Q-C, P-C ) );
              translate     ( RadioEsfera-
                    vdot( NormalPlano, CentroTriangulo-CentroEsferico ) )*y
              #if ( ALSF_POV3_1 )
                ALSF_Reorient_Trans( -y, NormalPlano )
              #else
                Reorient_Trans( -y, NormalPlano )
              #end
              translate     CentroEsferico
            }
            #if ( BanderaTorus )
              cone            {
                #local AlturaPrisma   = vlength( CentroTriangulo-CentroEsferico );
                #local Factor         = 2*RadioEsfera/AlturaPrisma;
                CentroEsferico        , 0.0
            Factor*CentroTriangulo-( Factor-1 )*CentroEsferico,
            Factor*sqrt( RadioEsfera*RadioEsfera-AlturaPrisma*AlturaPrisma )
                inverse
              }
            #end
          }
          #if ( BanderaTorus )
            torus           {
              #local AlturaPrisma   = vlength( CentroTriangulo-CentroEsferico );
              #local RadioTorus     =
                sqrt( RadioEsfera*RadioEsfera-AlturaPrisma*AlturaPrisma );
              RadioTorus    , GruesoCascaron/2
              #if ( ALSF_POV3_1 )
                ALSF_Reorient_Trans( -y, NormalPlano )
              #else
                Reorient_Trans( -y, NormalPlano )
              #end
              translate     CentroEsferico
                        +AlturaPrisma*NormalPlano
            }
          #end
        }
        #if ( BanderaCP )
          plane           {
            #local Normal1        =
                vnormalize( vcross( P-CentroEsferico, C-CentroEsferico ) );
            Normal1      , vdot( Normal1, CentroEsferico )
          }
        #end
        #if ( BanderaQC )
          plane           {
            #local Normal2        =
                vnormalize( vcross( C-CentroEsferico, Q-CentroEsferico ) );
            Normal2      , vdot( Normal2, CentroEsferico )
          }
        #end
        #if ( BanderaPQ )
          plane           {
            #local Normal3        =
                vnormalize( vcross( Q-CentroEsferico, P-CentroEsferico ) );
            Normal3      , vdot( Normal3, CentroEsferico )
          }
        #end
      }
      #if ( BanderaTorus )
        #macro ALSF_CentroCurvo( NuevoPunto, Lado1, Lado2 )
          #local CentroLado     = ( Lado1+Lado2 )/2;
          #local NuevoPunto     = CentroEsferico
                      +RadioEsfera*vnormalize( CentroLado-CentroEsferico );
        #end
        #if ( BanderaCP )
          object          {
            #local CentroPC       = <0,0,0>;
            ALSF_CentroCurvo( CentroPC, P, C )
            ALSF_SweepTriplePunto( P, CentroPC, C,
                GruesoCascaron/2, true )
          }
        #end
        #if ( BanderaQC )
          object          {
            #local CentroCQ       = <0,0,0>;
            ALSF_CentroCurvo( CentroCQ, C, Q )
            ALSF_SweepTriplePunto( C, CentroCQ, Q,
                GruesoCascaron/2, true )
          }
        #end
        #if ( BanderaPQ )
          object          {
            #local CentroQP       = <0,0,0>;
            ALSF_CentroCurvo( CentroQP, Q, P )
            ALSF_SweepTriplePunto( Q, CentroQP, P,
                GruesoCascaron/2, true )
          }
        #end
      #end
    }
  #else
    #if ( ALSF_BanderaCentro )
      disc              {
        CentroTriangulo ,
        vcross( P-C, Q-C ),
        vlength( CentroTriangulo-P )
      }
    #else
      cylinder          {
        P, Q, RadioEsfera/10
      }
    #end
  #end
#end

#macro ALSF_PuenteTrianguloEsfericoTriplePunto
                ( C, P, Q, R, RadioEsfera, GruesoCascaron, BanderaTorus )
   #local CentroUno     = < 0, 0, 0 >;
   #local CentroDos     = < 0, 0, 0 >;
   ALSF_InterpolacionEsfericoTriplePuntoMedio
                        ( CentroUno, C, P, Q, RadioEsfera )
   ALSF_InterpolacionEsfericoTriplePuntoMedio
                        ( CentroDos, R, Q, P, RadioEsfera )
   union        {
     object     {
       ALSF_TrianguloEsfericoTriplePunto
        ( P, CentroDos, CentroUno, RadioEsfera, GruesoCascaron, BanderaTorus )
     }
     object     {
       ALSF_TrianguloEsfericoTriplePunto
        ( CentroUno, CentroDos, Q, RadioEsfera, GruesoCascaron, BanderaTorus )
     }
   }
#end

#macro ALSF_PlanoTriplePunto( PuntoA, PuntoB, PuntoC )
  plane         {
    #local Normal       =
        vnormalize( vcross( PuntoB-PuntoA, PuntoC-PuntoA ) );
    Normal,
    vdot( Normal, PuntoA )
  }
#end

//              Variables generales
// ALSF_PruebaDeterminante
//      Variable util que se asigna en procesos Lineales,
//      se reactualiza automaticamente cuando se requiere
//      true    : indica que el ultimo determinante calculado  no es nulo
//      false   : indica que el ultimo determinante calculado es nulo
// ALSF_Determinante
//      Devuelve el valor del ultimo determinante calculado
// ALSF_CasillaMatrizCero
//      Valor que sera tomado como cero en una matriz,
//      puede redeclararse a gusto del usuario
//      Su valor actual es 1E-6,
//      puesto que se supone un GaussJordan en unidades L
//      probablemente funcione bien
//
// #macro ALSF_SistemaLinealGaussJordan( MatrizPrincipal, VectorResultado )
//      Resuelve el sistema Lineal
//              [MatrizPrincipal]*[X] = [VectorResultado]
//      Si todo sale bien, MatrizPrincipal es de salida matriz unitaria
//      VectorResultado = [X] con los resultados en orden
//      Consulte de salida las variables generales
//      ALSF_PruebaDeterminante y ALSF_Determinante
//              Variables
//      MatrizPrincipal         : Matriz cuadrada con los coeficientes
//              OUTPUT : matriz unitaria en el mejor de los casos,
//                      sin sentido en otros
//      VectorResultado         : Vector de resultados
//              OUTPUT : los valores de las variables si hay exito
//
// #macro ALSF_SistemaLineal( FlechaOutput, MatrizPrincipal, VectorResultado )
//      Funcion similar a ALSF_SistemaLinealGaussJordan, pero
//      VectorResultado no se modifica
//      Tanto FlechaOutput y VectorResultado deberian estar preinicializados
//      con el tamano correcto.
//      Consulte de salida las variables generales
//      ALSF_PruebaDeterminante y ALSF_Determinante
//              Variables
//      FlechaOutput            : Vector de salida preinicilizado en tamano,
//              pero sus datos de entrada carecen de interes.
//              OUTPUT : si exito los valores de las variables
//      MatrizPrincipal         : Matriz cuadrada con los coeficientes
//              OUTPUT : matriz unitaria en el mejor de los casos,
//                      sin sentido en otros
//      VectorResultado         : Vector de resultados no se modifica
//
// #macro ALSF_MyCopy ( NuevoArreglo, ArregloAnterior, Pos1, Total )
//      Para realizar transferencia de informacion entre arreglos
//      Lineales unicamente
//      Copia a partir de posicion Pos1 un total de Total valores
//              Variables
//      NuevoArreglo            : Con al menos Total de tamano Lineal.
//              OUTPUT : el arreglo solicitado
//      ArregloAnterior         : Contiene la informacion solicitada.
//              No se modifica, pero la informacion DEBE existir.
//      Pos1                    : A partir de cero, indica la posicion
//              inicial de copia
//      Total                   : Total de valores a copiar.
//
// #macro ALSF_ProductoMatrizFlecha ( FlechaResultado, MatrizA, FlechaB )
//      Realiza el producto matriz vector
//              [FlechaResultado] = [MatrizA]*[FlechaB]
//      Las dimensiones deberian ser consistentes pero no se revisa
//              Variables
//      FlechaResultado         : Devuelve el resultado del producto,
//              datos de entrada se ignoran.  Su tamano debe
//              estar predeclarado
//      MatrizA                 : Contiene la matriz de producto
//      FlechaB                 : No se modifica, contiene el factor derecho.
//


#declare ALSF_PruebaDeterminante        = false;
#declare ALSF_DeterminanteLin           = 0.0;
#declare ALSF_CasillaMatrizCero         = 1E-6;

#macro ALSF_SistemaLinealGaussJordan( MatrizPrincipal, VectorResultado )
  #local TamanoMiMatriz         = dimension_size( MatrizPrincipal, 1 );
  #declare ALSF_DeterminanteLin = 1.0;
  #if ( TamanoMiMatriz = dimension_size( MatrizPrincipal, 2 ) )
    #local Columna              = 0;
    #declare ALSF_PruebaDeterminante                    = true;
    #while ( Columna < TamanoMiMatriz )
      #if ( ALSF_PruebaDeterminante )
        #local MejorFila        = -1;
        #local MejorValor       = abs( ALSF_CasillaMatrizCero );
        #local C                = Columna;
        #while ( C < TamanoMiMatriz )
          #if ( abs( MatrizPrincipal[C][Columna] ) > MejorValor )
            #local MejorFila  = C;
            #local MejorValor = abs( MatrizPrincipal[C][Columna] );
          #end
          #local C            = C+1;
        #end
        #if ( MejorFila < 0 )
          #declare ALSF_PruebaDeterminante      = false;
          #declare ALSF_DeterminanteLin         = 0.0;
        #else
          #if ( MejorFila > Columna )
            #local C              = Columna;
            #while ( C < TamanoMiMatriz )
              #local PivoteReal   = MatrizPrincipal[Columna][C];
              #local MatrizPrincipal[Columna][C]        =
                                        MatrizPrincipal[MejorFila][C];
              #local MatrizPrincipal[MejorFila][C]      = PivoteReal;
              #local C            = C+1;
            #end
            #local PivoteReal     = VectorResultado[Columna];
            #local VectorResultado[Columna]             =
                                        VectorResultado[MejorFila];
            #local VectorResultado[MejorFila]           = PivoteReal;
            #declare ALSF_DeterminanteLin               =
                                        -ALSF_DeterminanteLin;
          #end
        #end
        #if ( ALSF_PruebaDeterminante )
          #local Escala         = MatrizPrincipal[Columna][Columna];
          #declare ALSF_DeterminanteLin         =
                                ALSF_DeterminanteLin*Escala;
          #local C              = Columna;
          #while ( C < TamanoMiMatriz )
            #local MatrizPrincipal[Columna][C]  =
                                MatrizPrincipal[Columna][C]/Escala;
            #local C            = C+1;
          #end
          #local VectorResultado[Columna]       =
                                VectorResultado[Columna]/Escala;
          #local FilaB          = 0;
          #while ( FilaB < TamanoMiMatriz )
            #if ( FilaB != Columna )
              #local EscalarSuma        = -MatrizPrincipal[FilaB][Columna];
              #if (EscalarSuma != 0 )
                #local C              = Columna;
                #while ( C < TamanoMiMatriz )
                  #local MatrizPrincipal[ FilaB ][ C ]  =
                              MatrizPrincipal[ FilaB ][ C ]+
                              EscalarSuma*MatrizPrincipal[ Columna ][ C ];
                  #local C            = C+1;
                #end
                #local VectorResultado[ FilaB ]         =
                              VectorResultado[ FilaB ]+
                              EscalarSuma*VectorResultado[ Columna ];
              #end
            #end
            #local FilaB        = FilaB+1;
          #end
        #end
      #end
      #local Columna            = Columna+1;
    #end
  #else
    #error "Intento un determinante de matriz no cuadrada"
  #end
#end

#macro ALSF_MyCopy ( NuevoArreglo, ArregloAnterior, Pos1, Total )
  #local C              = 0;
  #while ( C < Total )
    #local NuevoArreglo[ C ]    = ArregloAnterior[ Pos1+C ];
    #local C            = C+1;
  #end
#end

#macro ALSF_ProductoMatrizFlecha ( FlechaResultado, MatrizA, FlechaB )
  #local C                      = 0;
  #while ( C < dimension_size( MatrizA, 1 ) )
    #local D                    = 0;
    #local PivoteResultado      = 0.0;
    #while ( D < dimension_size( MatrizA, 2 ) )
      #local PivoteResultado    = PivoteResultado+
                MatrizA[ C ][ D ]*FlechaB[ D ];
      #local D                  = D+1;
    #end
    #local FlechaResultado[ C ] = PivoteResultado;
    #local C                    = C+1;
  #end
#end

#macro ALSF_SistemaLineal ( FlechaOutput, MatrizPrincipal, FlechaResultado )
  #local DimensionCuadrada      = dimension_size( MatrizPrincipal, 1 );
  ALSF_MyCopy( FlechaOutput, FlechaResultado, 0, DimensionCuadrada )
  ALSF_SistemaLinealGaussJordan( MatrizPrincipal, FlechaOutput )
#end

// El objetivo principal de este archivo son las macros
// ALSF_MultiQuadric y ALSF_MultiTrianguloEsferico
// para creacion de laminas curvas especificando normales.
// Algunas reglas generales para su uso:
// A. Al aumentar el parametro subdivision, se aumenta la probabilidad
//      de que el limite entre dos figuras curvas calcen, con la condicion
//      de que tengan el mismo extremo y normales extremas.
//      No necesitan el mismo grado de subdivision.
// B. Aumente la subdivision solo lo conveniente, pues se vuelve muy lento.
// C. ALSF_MultiQuadric deberia usarse con archivos (no obligatorio),
//      utilice ALSF_InicializarQuadricFile
//      antes de ALSF_MultiQuadric,
//      y aplique al final ALSF_FinalizarQuadricFile.
//      Utilice modo de escritura la primera vez que genera los datos,
//      y modo de lectura, cuando ya este seguro de los datos.
// D. ALSF_MultiTrianguloEsferico requiere mayor subdivision para calzar
//      los limites, pero no requiere archivo, pues sus calculos son mas
//      rapidos.  Utilizar ALSF_MultiTrianguloEsferico le evita la molestia
//      de utilizar archivos extras.
// E. ALSF_MultiQuadric, unicamente funciona en estructuras elipsoidales.
//      Utilice ALSF_MultiTrianguloEsferico, cuando ALSF_MultiQuadric fracase.
// NOTA Teorica:
//      La formula del Punto Medio y su normal de este archivo,
//      no debe por supuesto;
//      considerarse la interpolacion "verdadera".
//      Posee varios defectos conocidos:
//      a.  Al subdividir no se regenera la misma curva.
//      b.  No hay continuidad C1 en la secuencia de lineas, ni superficies.
//      c.  Normales paralelas en cualquier direccion generan una linea recta.
//          (matematicamente las derivadas se anulan en los puntos extremos)
//      Se elige, por su simplicidad.
//      La formula original es una funcion de dos parametros cubicos.
//      Tanto el modo Quadric, y el modo casquete esferico
//      son simplemente aproximaciones.
//      La verdadera funcion parametrica cubica fallaria mucho menos que
//      los casquetes esfericos y elipsoidales.
//      En las siguientes formulas las normales deben ser unitarias
//      previamente.
//      g(i,j)  = 2(Qj-Qi)*((nj-4ni)+2ni*nj*(nj-ni))/(9*(5+4ni*nj))
//      Interpolacion de lineas con normales
//      P(u)    = (1-u)Qi+uQj
//              +1.5u(1-u)((2-3u)g(i,j)(2ni+nj)+(3u-1)g(j,i)(ni+2nj))
//      Interpolacion de triangulos con normales
//      A(i,j)  = 2Qi+Qj+g(i,j)*(2ni+nj)/3
//      C(i,j)  = (Qi+Qj)/2+3(g(i,j)(2ni+nj)+g(j,i)(ni+2nj))/16
//      M       = (Q1+Q2+Q3)/3+k(C(1,3)+C(2,1)+C(3,2)-Q1-Q2-Q3)/3
//      k algun numero real, se recomienda un valor entre 4/3 y 4.
//      P(u,v)  = +(1-3u-3v)(2-3u-3v)(1-u-v)Q1/2
//                +9u(2-3u-3v)(1-u-v)A(1,3)/2
//                +9u(3u-1)(1-u-v)A(3,1)/2
//                +u(3u-1)(3u-2)Q3/2
//                +9v(2-3u-3v)(1-u-v)A(1,2)/2
//                +27uv(1-u-v)M
//                +9uv(3u-1)A(3,2)/2
//                +9v(3v-1)(1-u-v)A(2,1)/2
//                +9uv(3v-1)A(2,3)/2
//                +v(3v-1)(3v-2)Q2/2
//      Probablemente sea conveniente utilizar normales u,v,
//      para disminuir el acolchado, pues no es continua C1.
//
//                      Variables Generales
// ALSF_FactorGrueso
//      Variable para determinar el grueso de regiones
//      elipsoidales.  Relacionado con una fraccion
//      del promedio de los radios.
//      Se redefine con cada llamado a las macros
//      ALSF_MultiQuadric y ALSF_MultiQuadricGeneral
// ALSF_FactorBox
//      Tamano de un box {} para diferencias.
//      La idea es simular un plano infinito;  debido a dificultades
//      con la diferencia de planos.
//      Probablemente requiera aumentar su valor en estructuras muy grandes.
// ALSF_NormalZero
//      Valor que se considerara como una normal de valor cero
//      esto induce una interpolacion de normal lineal en vez de cubica
// ALSF_NormalCubica
//      "on" la interpolacion de la normal central es cubica
//      "off" la interpolacion de la normal central es el promedio de ambas
//      Advertencia : Se ha observado mayor inestabilidad en el modo cubico,
//      pero produce curvas mas suaves cuando funciona.
//
// Macros
// #macro ALSF_PuntoCentral
//      ( VectorCentro, VectorA, VectorB, NormalA, NormalB )
//      Utilizando una spline cubica, estima un punto central
//      posible de una curva conociendo sus extremos y normales
//      en los extremos.
//      Concuerda con el punto central de ALSF_MultiQuadric
//      En el caso ALSF_MultiTrianguloEsferico, el punto central
//      concuerda con la condicion de que Subdivision > 1.
//      VectorCentro            : Vector que devuelve el resultado
//      VectorA                 : Un punto extremo de la curva
//      VectorB                 : Otro punto extremo
//      NormalA                 : Normal en VectorA
//      NormalB                 : Normal en VectorB
//
// #macro ALSF_BoxTriplePunto( PuntoA, PuntoB, PuntoC )
//      Util en difference {} para simular una diferencia de planos
//      cuando plane presente problemas.
//      El plano simulado pasaria por los tres puntos dados.
//      La variable global ALSF_FactorBox representa el tamano del box grande.
//      PuntoA                  : Uno de los puntos del plano
//      PuntoB                  : Otro de los puntos del plano
//      PuntoC                  : Otro de los puntos del plano
//
// #macro ALSF_QuadricGeneral
//      ( VectorA, VectorB, VectorC, NormalA, NormalB, NormalC,
//                        BanderaLaminar, BanderaSegmento, FactorGrueso )
//      Genera una figura similar a un triangulo esferico
//      sin subdivisiones adicionales que pase por los puntos
//      VectorA, VectorB, VectorC con las normales dadas.
//      Si tiene vecinos concordantes, el limite calza en los extremos
//      y punto medio.
//      Si esto no es suficiente deberia utilizar ALSF_MultiQuadric.
//      Esta macro no utiliza archivos.
//      VectorA                 : Uno de los puntos extremos
//      VectorB                 : Otro de los puntos extremos
//      VectorC                 : Otro punto extremo
//      NormalA                 : Normal en el VectorA
//      NormalB                 : Normal en el VectorB
//      NormalC                 : Normal en el VectorC
//      BanderaLaminar          : "on" genera una estructura laminar
//                                "off" rellena hacia el centro del elipsoide
//      BanderaSegmento         : "on" si BanderaLaminar es "off" unicamente
//                                rellena hasta un plano que pase por
//                                VectorA, VectorB y VectorC.
//      FactorGrueso            : Aplicable al grueso de la lamina si
//                                BanderaLaminar es "on".
//                                Relacionado con una fraccion del promedio
//                                de los radios.
//
// #macro ALSF_Quadric
//      ( VectorA, VectorB, VectorC, NormalA, NormalB, NormalC, FactorGrueso )
//      Genera una figura similar a un triangulo esferico
//      Esta macro no utiliza archivos.
//      VectorA                 : Uno de los puntos extremos
//      VectorB                 : Otro de los puntos extremos
//      VectorC                 : Otro punto extremo
//      NormalA                 : Normal en el VectorA
//      NormalB                 : Normal en el VectorB
//      NormalC                 : Normal en el VectorC
//      FactorGrueso            : Aplicable al grueso de la lamina si
//                                BanderaLaminar es "on".
//                                Relacionado con una fraccion del promedio
//                                de los radios.
// #macro ALSF_MultiQuadricGeneral
//      ( VectorA, VectorB, VectorC, NormalA, NormalB, NormalC, Subdivision,
//                        BanderaLaminar, BanderaSegmento, FactorGrueso )
//      Genera una figura similar a un triangulo esferico
//      con subdivisiones adicionales que pase por los puntos
//      VectorA, VectorB, VectorC con las normales dadas.
//      Si tiene vecinos concordantes, el limite calzara mejor
//      a mayor grado de subdivision, pero con un coste
//      de velocidad.  El vecino no necesita tener el mismo grado
//      de subdivision.
//      Esta macro puede utilizar archivos
//      esto se establece con ALSF_InicializarQuadricFile
//      No es obligatorio, y puede utilizarse sin inicializacion,
//      pero es mas lento.
//      VectorA                 : Uno de los puntos extremos
//      VectorB                 : Otro de los puntos extremos
//      VectorC                 : Otro punto extremo
//      NormalA                 : Normal en el VectorA
//      NormalB                 : Normal en el VectorB
//      NormalC                 : Normal en el VectorC
//      Subdivision             : Indica el grado de subdivision
//                                como pow( 4, Subdivision )
//                                Utilice cero o uno para solo un triangulo.
//      BanderaLaminar          : "on" genera una estructura laminar
//                                "off" rellena hacia el centro del elipsoide
//                                pero este centro variaria con
//                                cada subtriangulo.
//      BanderaSegmento         : "on" si BanderaLaminar es "off" unicamente
//                                rellena hasta un plano que pase por
//                                los vertices de los subtriangulos.
//      FactorGrueso            : Aplicable al grueso de la lamina si
//                                BanderaLaminar es "on".
//                                Relacionado con una fraccion del promedio
//                                de los radios.
//
// #macro ALSF_MultiQuadric
//      ( VectorA, VectorB, VectorC, NormalA, NormalB, NormalC,
//                        Subdivision, FactorGrueso )
//      Genera una figura similar a un triangulo esferico
//      con subdivisiones adicionales que pase por los puntos
//      VectorA, VectorB, VectorC con las normales dadas.
//      Si tiene vecinos concordantes, el limite calzara mejor
//      a mayor grado de subdivision, pero con un coste
//      de velocidad.  El vecino no necesita tener el mismo grado
//      de subdivision.
//      Esta macro puede utilizar archivos
//      esto se establece con ALSF_InicializarQuadricFile
//      No es obligatorio, y puede utilizarse sin inicializacion,
//      pero es mas lento.
//      VectorA                 : Uno de los puntos extremos
//      VectorB                 : Otro de los puntos extremos
//      VectorC                 : Otro punto extremo
//      NormalA                 : Normal en el VectorA
//      NormalB                 : Normal en el VectorB
//      NormalC                 : Normal en el VectorC
//      Subdivision             : Indica el grado de subdivision
//                                como pow( 4, Subdivision )
//                                Utilice cero o uno para solo un triangulo.
//      FactorGrueso            : Aplicable al grueso de la lamina si
//                                BanderaLaminar es "on".
//                                Relacionado con una fraccion del promedio
//                                de los radios.
//
// #macro ALSF_InicializarQuadricFile( MyFileName, BanderaLectura )
//      Inicializa un archivo MyFileName
//      para lectura o escritura
//      En modo de escritura calculo los datos y los almacena
//      en un archivo, en modo de lectura lee el archivo
//      sin realizar los calculos.
//      Por ejemplo.
//         #declare Recalculo           = true;
//         ALSF_InicializarQuadricFile( "DATA.TXT", !Recalculo )
//         ALSF_MultiQuadric(x,y,z,x,y,z,3,0.005)
//         ALSF_FinalizarQuadricFile()
//      La siguiente oportunidad, simplemente ejecute
//         #declare Recalculo           = false;
//         ALSF_InicializarQuadricFile( "DATA.TXT", !Recalculo )
//         ALSF_MultiQuadric(x,y,z,x,y,z,3,0.005)
//         ALSF_FinalizarQuadricFile()
//      El proceso Quadric solo permite un archivo abierto a la vez.
//      Si no detecta archivo abierto, simplemente realiza los calculos
//      completos.
//      CUIDADO : ALSF_MultiQuadric carece de control de errores,
//              y realiza una lectura pasiva de la informacion.
//      MyFileName              : Nombre del archivo
//      BanderaLectura          : "true" indica que el archivo
//              existe con la informacion deseada y se leera pasivamente.
//              "false" solicita recalculo y guardar la informacion
//              en el archivo.
//
// #macro ALSF_FinalizarQuadricFile( )
//      Finaliza el archivo MyFileName abierto con
//      ALSF_InicializarQuadricFile
//      Aunque POVRay cierra los archivos automaticamente al final.
//      Es util por orden, o si requiere cambiar de archivo.
//      O pasar a modo de calculo total sin error.
//
// #macro ALSF_MultiTrianguloEsferico
//      ( VectorA, VectorB, VectorC, NormalA, NormalB, NormalC,
//              Subdivision, RadioEsfera, GruesoCascaron )
//      Genera una figura similar a un triangulo esferico
//      con subdivisiones adicionales que pase por los puntos
//      VectorA, VectorB, VectorC.
//      El triangulo esferico utiliza NormalA, NormalB, NormalC
//      unicamente en el proceso de subdivision.
//      Es decir, a mayor subdivision las normales calzaran mejor;
//      sin subdivision las normales no calzaran.
//      Si tiene vecinos concordantes, el limite calzara mejor
//      a mayor grado de subdivision, pero con un coste
//      de velocidad.  El vecino no necesita tener el mismo grado
//      de subdivision.
//      Esta macro no utiliza archivos.
//      VectorA                 : Uno de los puntos extremos
//      VectorB                 : Otro de los puntos extremos
//      VectorC                 : Otro punto extremo
//      NormalA                 : Normal en el VectorA
//      NormalB                 : Normal en el VectorB
//      NormalC                 : Normal en el VectorC
//      Subdivision             : Indica el grado de subdivision
//                                como pow( 4, Subdivision )
//                                Utilice cero o uno para solo un triangulo.
//      RadioEsfera             : Radio de la esfera que intenta ajustar
//                                los puntos VectorA, VectorB, VectorC
//      GruesoCascaron          : Grueso de la lamina.
//

#declare ALSF_FactorGrueso      = 0.005;

#declare ALSF_FactorBox         = 1000;

#declare ALSF_NormalZero        = 1E-6;

#declare ALSF_NormalCubica      = on;

#declare ALSF_MatrizQuadric     = array [6][6]
        { {0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},
          {0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0} }

#declare ALSF_VectorQuadric     = array [6]
        { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#declare ALSF_VectorResultadoQuadric    = array [6]
        { -1000, -1000, -1000, -1000, -1000, -1000 }

#declare ALSF_DatosQuadricBasico        = array [6]
        { 0,0,0,0,0,0 }

#macro ALSF_ImplementationVectorToMatriz()
  #local C              = 0;
  #while ( C < 6 )
    #local XVal         = ALSF_VectorQuadric[C].x;
    #local YVal         = ALSF_VectorQuadric[C].y;
    #local ZVal         = ALSF_VectorQuadric[C].z;
    #declare ALSF_MatrizQuadric[C][0]   = XVal*XVal;
    #declare ALSF_MatrizQuadric[C][1]   = YVal*YVal;
    #declare ALSF_MatrizQuadric[C][2]   = ZVal*ZVal;
    #declare ALSF_MatrizQuadric[C][3]   = XVal;
    #declare ALSF_MatrizQuadric[C][4]   = YVal;
    #declare ALSF_MatrizQuadric[C][5]   = ZVal;
    #local C            = C+1;
  #end
#end

#macro ALSF_ImplementationVectorToQuadric()
  ALSF_ImplementationVectorToMatriz()
  ALSF_SistemaLineal( ALSF_DatosQuadricBasico,
                ALSF_MatrizQuadric, ALSF_VectorResultadoQuadric )
#end

#macro ALSF_PuntoCentral
  ( VectorCentro, VectorA, VectorB, NormalA, NormalB )
  #local UnitarioA      = NormalA/sqrt( vdot( NormalA, NormalA ) );
  #local UnitarioB      = NormalB/sqrt( vdot( NormalB, NormalB ) );
  #local DotUnitario    = vdot( UnitarioA, UnitarioB );
  #local Gab            = 2*vdot( VectorB-VectorA,
          ( UnitarioB-4*UnitarioA )+2*DotUnitario*
                ( UnitarioB-UnitarioA ) )/( 9*( 5+4*DotUnitario ) );
  #local Gba            = 2*vdot( VectorA-VectorB,
          ( UnitarioA-4*UnitarioB )+2*DotUnitario*
                ( UnitarioA-UnitarioB ) )/( 9*( 5+4*DotUnitario ) );
  #local VectorCentro   = ( VectorA+VectorB )/2
                +3/16*( Gab*( 2*UnitarioA+UnitarioB )
                        +Gba*( UnitarioA+2*UnitarioB ) );
#end

// Normales ingresan unitarias
#macro ALSF_ImplementationVectorNormalToVectorQuadric
  ( VectorA, VectorB, VectorC, NormalA, NormalB, NormalC )
  #declare ALSF_VectorQuadric[0]   = VectorA;
  #declare ALSF_VectorQuadric[1]   = VectorB;
  #declare ALSF_VectorQuadric[2]   = VectorC;
  ALSF_PuntoCentral
        ( ALSF_VectorQuadric[3], VectorA, VectorB, NormalA, NormalB )
  ALSF_PuntoCentral
        ( ALSF_VectorQuadric[4], VectorB, VectorC, NormalB, NormalC )
  ALSF_PuntoCentral
        ( ALSF_VectorQuadric[5], VectorC, VectorA, NormalC, NormalA )
#end

#macro ALSF_BoxTriplePunto( PuntoA, PuntoB, PuntoC )
  box           {
    #local Normal       =
        vnormalize( vcross( PuntoB-PuntoA, PuntoC-PuntoA ) );
    -ALSF_FactorBox,ALSF_FactorBox*(x+z)
    translate   vdot( Normal, PuntoA )*y
    #if ( ALSF_POV3_1 )
      ALSF_Point_At_Trans( Normal )
    #else
      Point_At_trans( Normal )
    #end
  }
#end

#macro ALSF_QuadricGeneral
  ( VectorA, VectorB, VectorC, NormalA, NormalB, NormalC,
                        BanderaLaminar, BanderaSegmento, FactorGrueso )
  object                {
    #declare ALSF_PruebaDeterminante    = false;
    #local UnitarioA      = NormalA/sqrt( vdot( NormalA, NormalA ) );
    #local UnitarioB      = NormalB/sqrt( vdot( NormalB, NormalB ) );
    #local UnitarioC      = NormalC/sqrt( vdot( NormalC, NormalC ) );
    ALSF_ImplementationVectorNormalToVectorQuadric
        ( VectorA, VectorB, VectorC, UnitarioA, UnitarioB, UnitarioC )
    ALSF_ImplementationVectorToQuadric()
    #local PuntoA   = ALSF_VectorQuadric[0];
    #local PuntoB   = ALSF_VectorQuadric[1];
    #local PuntoC   = ALSF_VectorQuadric[2];
    #local PuntoD   = ALSF_VectorQuadric[3];
    #local PuntoE   = ALSF_VectorQuadric[4];
    #local PuntoF   = ALSF_VectorQuadric[5];
    #if ( ALSF_PruebaDeterminante )
      difference        {
        #if ( BanderaLaminar )
          // Probablemente sea mejor un sphere
          quadric           {
            < ALSF_DatosQuadricBasico[0],
              ALSF_DatosQuadricBasico[1],
              ALSF_DatosQuadricBasico[2] >, 0,
            < ALSF_DatosQuadricBasico[3],
              ALSF_DatosQuadricBasico[4],
              ALSF_DatosQuadricBasico[5] >,
            ( -1+FactorGrueso )*ALSF_VectorResultadoQuadric[0]
          }
          // Probablemente sea mejor un sphere
          quadric           {
            < ALSF_DatosQuadricBasico[0],
              ALSF_DatosQuadricBasico[1],
              ALSF_DatosQuadricBasico[2] >, 0,
            < ALSF_DatosQuadricBasico[3],
              ALSF_DatosQuadricBasico[4],
              ALSF_DatosQuadricBasico[5] >,
            ( -1-FactorGrueso )*ALSF_VectorResultadoQuadric[0]
          }
        #else
          // Probablemente sea mejor un sphere
          quadric           {
            < ALSF_DatosQuadricBasico[0],
              ALSF_DatosQuadricBasico[1],
              ALSF_DatosQuadricBasico[2] >, 0,
            < ALSF_DatosQuadricBasico[3],
              ALSF_DatosQuadricBasico[4],
              ALSF_DatosQuadricBasico[5] >,
            ( -1 )*ALSF_VectorResultadoQuadric[0]
            inverse
          }
        #end
        #if ( BanderaSegmento )
          ALSF_BoxTriplePunto( PuntoA, PuntoB, PuntoC )
        #end
        ALSF_BoxTriplePunto( PuntoB, PuntoE, PuntoC )
        ALSF_BoxTriplePunto( PuntoC, PuntoF, PuntoA )
        ALSF_BoxTriplePunto( PuntoA, PuntoD, PuntoB )
      }
    #else
      triangle          {
        PuntoA, PuntoB, PuntoC
      }
    #end
  }
#end

#macro ALSF_Quadric
  ( VectorA, VectorB, VectorC, NormalA, NormalB, NormalC, FactorGrueso )
  ALSF_QuadricGeneral( VectorA, VectorB, VectorC,
                        NormalA, NormalB, NormalC, on, off, FactorGrueso )
#end

#macro ALSF_ImplementationPuntoCentralMulti
  ( VectorCentro, UnitarioCentro, VectorA, VectorB, UnitarioA, UnitarioB )
  #local DotUnitario    = vdot( UnitarioA, UnitarioB );
  #local Gab            = 2*vdot( VectorB-VectorA,
          ( UnitarioB-4*UnitarioA )+2*DotUnitario*
                ( UnitarioB-UnitarioA ) )/( 9*( 5+4*DotUnitario ) );
  #local Gba            = 2*vdot( VectorA-VectorB,
          ( UnitarioA-4*UnitarioB )+2*DotUnitario*
                ( UnitarioA-UnitarioB ) )/( 9*( 5+4*DotUnitario ) );
  #local PivoteAB       = Gab*( 2*UnitarioA+UnitarioB );
  #local PivoteBA       = Gba*( UnitarioA+2*UnitarioB );
  #local PivoteExceso   = PivoteAB+PivoteBA;
  #local VectorCentro   = ( VectorA+VectorB )/2+3/16*PivoteExceso;
  #if ( ALSF_NormalCubica )
    #local PivoteDer      = VectorB-VectorA+9/8*( PivoteBA-PivoteAB );
    #local UnitarioCentro = vdot( PivoteDer, PivoteDer )*PivoteExceso-
                             vdot( PivoteDer, PivoteExceso )*PivoteDer;
    #local PivoteNormal   = sqrt( vdot( UnitarioCentro, UnitarioCentro ) );
    #if ( PivoteNormal <= ALSF_NormalZero )
      #local UnitarioCentro     = ( UnitarioA+UnitarioB )/2;
      #local PivoteNormal       =
                        sqrt( vdot( UnitarioCentro, UnitarioCentro ) );
    #end
    #local UnitarioCentro  = UnitarioCentro/PivoteNormal;
  #else
    #local UnitarioCentro = ( UnitarioA+UnitarioB )/2;
    #local UnitarioCentro =
                UnitarioCentro/sqrt( vdot( UnitarioCentro, UnitarioCentro ) );
  #end
#end

#macro ALSF_ImplementationQuadricGeneral
  ( VectorA, VectorB, VectorC, NormalA, NormalB, NormalC,
                        BanderaLaminar, BanderaSegmento )
  object                {
    #declare ALSF_PruebaDeterminante    = false;
    ALSF_ImplementationVectorNormalToVectorQuadric
        ( VectorA, VectorB, VectorC, NormalA, NormalB, NormalC )
    ALSF_ImplementationVectorToQuadric()
    #local PuntoA   = ALSF_VectorQuadric[0];
    #local PuntoB   = ALSF_VectorQuadric[1];
    #local PuntoC   = ALSF_VectorQuadric[2];
    #local PuntoD   = ALSF_VectorQuadric[3];
    #local PuntoE   = ALSF_VectorQuadric[4];
    #local PuntoF   = ALSF_VectorQuadric[5];
    #ifdef ( ALSF_QuadricFileHandle )
      #if ( ALSF_PruebaDeterminante )
        #write ( ALSF_QuadricFileHandle, true, "," )
        #write ( ALSF_QuadricFileHandle,
                  PuntoA, ",", PuntoB, ",", PuntoC, ",", PuntoD, ",",
                  PuntoE, ",", PuntoF, "," )
        #local C                  = 0;
        #while ( C < 6 )
          #write ( ALSF_QuadricFileHandle, ALSF_DatosQuadricBasico[ C ], "," )
          #local C                = C+1;
        #end
        #write ( ALSF_QuadricFileHandle, "\n" )
      #else
        #write ( ALSF_QuadricFileHandle, false, "," )
        #write ( ALSF_QuadricFileHandle,
                  PuntoA, ",", PuntoB, ",", PuntoC, ",\n" )
      #end
    #end
    #if ( ALSF_PruebaDeterminante )
      difference        {
        #if ( BanderaLaminar )
          // Probablemente sea mejor un sphere
          quadric           {
            < ALSF_DatosQuadricBasico[0],
              ALSF_DatosQuadricBasico[1],
              ALSF_DatosQuadricBasico[2] >, 0,
            < ALSF_DatosQuadricBasico[3],
              ALSF_DatosQuadricBasico[4],
              ALSF_DatosQuadricBasico[5] >,
            ( -1+ALSF_FactorGrueso )*ALSF_VectorResultadoQuadric[0]
          }
          // Probablemente sea mejor un sphere
          quadric           {
            < ALSF_DatosQuadricBasico[0],
              ALSF_DatosQuadricBasico[1],
              ALSF_DatosQuadricBasico[2] >, 0,
            < ALSF_DatosQuadricBasico[3],
              ALSF_DatosQuadricBasico[4],
              ALSF_DatosQuadricBasico[5] >,
            ( -1-ALSF_FactorGrueso )*ALSF_VectorResultadoQuadric[0]
          }
        #else
          // Probablemente sea mejor un sphere
          quadric           {
            < ALSF_DatosQuadricBasico[0],
              ALSF_DatosQuadricBasico[1],
              ALSF_DatosQuadricBasico[2] >, 0,
            < ALSF_DatosQuadricBasico[3],
              ALSF_DatosQuadricBasico[4],
              ALSF_DatosQuadricBasico[5] >,
            ( -1+ALSF_FactorGrueso )*ALSF_VectorResultadoQuadric[0]
            inverse
          }
        #end
        #if ( BanderaSegmento )
          ALSF_BoxTriplePunto( PuntoA, PuntoB, PuntoC )
        #end
        ALSF_BoxTriplePunto( PuntoB, PuntoE, PuntoC )
        ALSF_BoxTriplePunto( PuntoC, PuntoF, PuntoA )
        ALSF_BoxTriplePunto( PuntoA, PuntoD, PuntoB )
        ALSF_ImplementationQuadricBounded( PuntoA, PuntoB, PuntoC )
      }
    #else
      triangle          {
        PuntoA, PuntoB, PuntoC
      }
    #end
  }
#end

// Normales deben ser unitarias
#macro ALSF_ImplementationMultiQuadric
  ( VectorA, VectorB, VectorC, NormalA, NormalB, NormalC, Subdivision,
                        BanderaLaminar, BanderaSegmento )
  #if ( Subdivision > 1 )
    #local VectorF                = < 0, 0, 0 >;
    #local VectorD                = < 0, 0, 0 >;
    #local VectorE                = < 0, 0, 0 >;
    #local UnitarioF              = < 0, 0, 0 >;
    #local UnitarioD              = < 0, 0, 0 >;
    #local UnitarioE              = < 0, 0, 0 >;
    ALSF_ImplementationPuntoCentralMulti
        ( VectorF, UnitarioF, VectorA, VectorB, NormalA, NormalB )
    ALSF_ImplementationPuntoCentralMulti
        ( VectorD, UnitarioD, VectorB, VectorC, NormalB, NormalC )
    ALSF_ImplementationPuntoCentralMulti
        ( VectorE, UnitarioE, VectorC, VectorA, NormalC, NormalA )
    union       {
      ALSF_ImplementationMultiQuadric
        ( VectorA, VectorF, VectorE, NormalA, UnitarioF, UnitarioE,
                  Subdivision-1, BanderaLaminar, BanderaSegmento )
      ALSF_ImplementationMultiQuadric
        ( VectorF, VectorB, VectorD, UnitarioF, NormalB, UnitarioD,
                  Subdivision-1, BanderaLaminar, BanderaSegmento )
      ALSF_ImplementationMultiQuadric
        ( VectorE, VectorD, VectorC, UnitarioE, UnitarioD, NormalC,
                  Subdivision-1, BanderaLaminar, BanderaSegmento )
      ALSF_ImplementationMultiQuadric
        ( VectorF, VectorD, VectorE, UnitarioF, UnitarioD, UnitarioE,
                  Subdivision-1, BanderaLaminar, BanderaSegmento )
    }
  #else
    ALSF_ImplementationQuadricGeneral
       ( VectorA, VectorB, VectorC, NormalA, NormalB, NormalC,
                        BanderaLaminar, BanderaSegmento )
  #end
#end

#macro ALSF_ImplementationQuadricBounded( PuntoA, PuntoB, PuntoC )
  bounded_by            {
    #local BoundedCentro        = ( PuntoA+PuntoB+PuntoC )/3;
    #local BoundedRadio         =
        max( sqrt( vdot( PuntoB-PuntoA, PuntoB-PuntoA ) ),
                sqrt( vdot( PuntoC-PuntoA, PuntoC-PuntoA ) ) );
    #local BoundedRadio         =
        max( BoundedRadio, sqrt( vdot( PuntoC-PuntoB, PuntoC-PuntoB ) ) );
    sphere              { BoundedCentro       , BoundedRadio }
  }
#end

#macro ALSF_ImplementationQuadricFile()
  object                {
    #read ( ALSF_QuadricFileHandle, BanderaCurvo )
    #if ( BanderaCurvo )
      #read ( ALSF_QuadricFileHandle,
                PuntoA, PuntoB, PuntoC, PuntoD,
                PuntoE, PuntoF )
      #local C                  = 0;
      #while ( C < 6 )
        #read ( ALSF_QuadricFileHandle, ALSF_DatosQuadricBasico[ C ] )
        #local C                = C+1;
      #end
    #else
      #read ( ALSF_QuadricFileHandle,
                PuntoA, PuntoB, PuntoC )
    #end
    #if ( BanderaCurvo  )
      difference        {
/*        #local A1               = ALSF_DatosQuadricBasico[ 0 ];
        #local B1               = ALSF_DatosQuadricBasico[ 3 ];
        #local C1               = ALSF_DatosQuadricBasico[ 1 ];
        #local D1               = ALSF_DatosQuadricBasico[ 4 ];
        #local E1               = ALSF_DatosQuadricBasico[ 2 ];
        #local F1               = ALSF_DatosQuadricBasico[ 5 ];
        #local G1               = ALSF_VectorResultadoQuadric[ 0 ];
        #if ( A1 < 0 )
          #local A1             = -A1;
          #local B1             = -B1;
          #local C1             = -C1;
          #local D1             = -D1;
          #local E1             = -E1;
          #local F1             = -F1;
          #local G1             = -G1;
        #end
        #local CentroCurvo      = -0.5*< B1, D1, F1 >/< A1, C1, E1 >;
        #local FactorCurvo      = G1-0.5*vdot( CentroCurvo, < B1, D1, F1 > );*/
        #if ( BanderaLaminar )
          // Probablemente sea mejor un sphere
/*          #if ( ( C1 > 0 ) & ( E1 > 0 ) & ( FactorCurvo > 0 ) )
          difference    {
            sphere      {
              0         , 1+ALSF_FactorGrueso
            }
            sphere      {
              0         , 1-ALSF_FactorGrueso
            }
            scale       < sqrt( FactorCurvo/A1 ),
                          sqrt( FactorCurvo/C1 ),
                          sqrt( FactorCurvo/E1 ) >
            translate   CentroCurvo
          }
          #else*/
          quadric           {
            < ALSF_DatosQuadricBasico[0],
              ALSF_DatosQuadricBasico[1],
              ALSF_DatosQuadricBasico[2] >, 0,
            < ALSF_DatosQuadricBasico[3],
              ALSF_DatosQuadricBasico[4],
              ALSF_DatosQuadricBasico[5] >,
            ( -1+ALSF_FactorGrueso )*ALSF_VectorResultadoQuadric[0]
          }
          // Probablemente sea mejor un sphere
          quadric           {
            < ALSF_DatosQuadricBasico[0],
              ALSF_DatosQuadricBasico[1],
              ALSF_DatosQuadricBasico[2] >, 0,
            < ALSF_DatosQuadricBasico[3],
              ALSF_DatosQuadricBasico[4],
              ALSF_DatosQuadricBasico[5] >,
            ( -1-ALSF_FactorGrueso )*ALSF_VectorResultadoQuadric[0]
          }
//          #end
        #else
          // Probablemente sea mejor un sphere
          quadric           {
            < ALSF_DatosQuadricBasico[0],
              ALSF_DatosQuadricBasico[1],
              ALSF_DatosQuadricBasico[2] >, 0,
            < ALSF_DatosQuadricBasico[3],
              ALSF_DatosQuadricBasico[4],
              ALSF_DatosQuadricBasico[5] >,
            ( -1+ALSF_FactorGrueso )*ALSF_VectorResultadoQuadric[0]
            inverse
          }
        #end
        #if ( BanderaSegmento )
          ALSF_BoxTriplePunto( PuntoA, PuntoB, PuntoC )
        #end
        ALSF_BoxTriplePunto( PuntoB, PuntoE, PuntoC )
        ALSF_BoxTriplePunto( PuntoC, PuntoF, PuntoA )
        ALSF_BoxTriplePunto( PuntoA, PuntoD, PuntoB )
        ALSF_ImplementationQuadricBounded( PuntoA, PuntoB, PuntoC )
      }
    #else
      triangle          {
        PuntoA, PuntoB, PuntoC
      }
    #end    
  }
#end

// Normales deben ser unitarias
#macro ALSF_MultiQuadricGeneral
  ( VectorA, VectorB, VectorC, NormalA, NormalB, NormalC, Subdivision,
                        BanderaLaminar, BanderaSegmento, FactorGrueso )
  #declare ALSF_FactorGrueso    = FactorGrueso;
  #local BanderaProcesar        = true;
  #ifdef ( ALSF_QuadricFileHandle )
    #if ( ALSF_QuadricReadOnWriteOff )
      #local BanderaProcesar    = false;
      #if ( Subdivision > 1 )
        #local TotalTriangulos  = pow( 4, Subdivision-1 );
      #else
        #local TotalTriangulos  = 1;
      #end
      union             {
        #local C                  = 0;
        #while ( C < TotalTriangulos )
          ALSF_ImplementationQuadricFile()
          #local C                = C+1;
        #end
      }
    #end
  #end
  #if ( BanderaProcesar )
    #local UnitarioA      = NormalA/sqrt( vdot( NormalA, NormalA ) );
    #local UnitarioB      = NormalB/sqrt( vdot( NormalB, NormalB ) );
    #local UnitarioC      = NormalC/sqrt( vdot( NormalC, NormalC ) );
    object                {
      ALSF_ImplementationMultiQuadric
        ( VectorA, VectorB, VectorC, UnitarioA, UnitarioB, UnitarioC,
                  Subdivision, BanderaLaminar, BanderaSegmento )
      ALSF_ImplementationQuadricBounded( VectorA, VectorB, VectorC )
      clipped_by        { bounded_by }
    }
  #end
#end

#macro ALSF_MultiQuadric
  ( VectorA, VectorB, VectorC, NormalA, NormalB, NormalC,
                        Subdivision, FactorGrueso )
  ALSF_MultiQuadricGeneral
    ( VectorA, VectorB, VectorC, NormalA, NormalB, NormalC,
                        Subdivision, on, off, FactorGrueso )
#end

#macro ALSF_InicializarQuadricFile( MyFileName, BanderaLectura )
  #ifdef ( ALSF_QuadricFileHandle )
    #fclose ALSF_QuadricFileHandle
  #end
  #if ( BanderaLectura )
    #declare ALSF_QuadricReadOnWriteOff = on;
    #fopen ALSF_QuadricFileHandle MyFileName read
  #else
    #declare ALSF_QuadricReadOnWriteOff = off;
    #fopen ALSF_QuadricFileHandle MyFileName write
  #end
#end

#macro ALSF_FinalizarQuadricFile()
  #ifdef ( ALSF_QuadricFileHandle )
    #fclose ALSF_QuadricFileHandle
  #end
#end

#macro ALSF_ImplementationMultiTrianguloEsferico
  ( VectorA, VectorB, VectorC, NormalA, NormalB, NormalC,
        Subdivision, RadioEsfera, GruesoCascaron )
  #if ( Subdivision > 1 )
    #local VectorF                = < 0, 0, 0 >;
    #local VectorD                = < 0, 0, 0 >;
    #local VectorE                = < 0, 0, 0 >;
    #local UnitarioF              = < 0, 0, 0 >;
    #local UnitarioD              = < 0, 0, 0 >;
    #local UnitarioE              = < 0, 0, 0 >;
    ALSF_ImplementationPuntoCentralMulti
        ( VectorF, UnitarioF, VectorA, VectorB, NormalA, NormalB )
    ALSF_ImplementationPuntoCentralMulti
        ( VectorD, UnitarioD, VectorB, VectorC, NormalB, NormalC )
    ALSF_ImplementationPuntoCentralMulti
        ( VectorE, UnitarioE, VectorC, VectorA, NormalC, NormalA )
    union       {
      ALSF_ImplementationMultiTrianguloEsferico
        ( VectorA, VectorF, VectorE, NormalA, UnitarioF, UnitarioE,
                  Subdivision-1, RadioEsfera, GruesoCascaron )
      ALSF_ImplementationMultiTrianguloEsferico
        ( VectorF, VectorB, VectorD, UnitarioF, NormalB, UnitarioD,
                  Subdivision-1, RadioEsfera, GruesoCascaron )
      ALSF_ImplementationMultiTrianguloEsferico
        ( VectorE, VectorD, VectorC, UnitarioE, UnitarioD, NormalC,
                  Subdivision-1, RadioEsfera, GruesoCascaron )
      ALSF_ImplementationMultiTrianguloEsferico
        ( VectorF, VectorD, VectorE, UnitarioF, UnitarioD, UnitarioE,
                  Subdivision-1, RadioEsfera, GruesoCascaron )
    }
  #else
    ALSF_TrianguloEsfericoTriplePuntoLiso
       ( VectorA, VectorC, VectorB, RadioEsfera, GruesoCascaron )
  #end
#end

#macro ALSF_MultiTrianguloEsferico
  ( VectorA, VectorB, VectorC, NormalA, NormalB, NormalC,
        Subdivision, RadioEsfera, GruesoCascaron )
  #local UnitarioA      = NormalA/sqrt( vdot( NormalA, NormalA ) );
  #local UnitarioB      = NormalB/sqrt( vdot( NormalB, NormalB ) );
  #local UnitarioC      = NormalC/sqrt( vdot( NormalC, NormalC ) );
  object                {
    ALSF_ImplementationMultiTrianguloEsferico
      ( VectorA, VectorB, VectorC, UnitarioA, UnitarioB, UnitarioC,
                Subdivision, RadioEsfera, GruesoCascaron )
    ALSF_ImplementationQuadricBounded( VectorA, VectorB, VectorC )
    clipped_by  { bounded_by }
  }
#end

// La red se interpreta cono una rejilla
// Cada punto describe un rectangulo de dos elipsoides
// cuyo vertice superior izquierdo (de la matriz) es el punto.
// Los puntos inferiores se unirian con los superiores
// y los laterales derechos con los laterales izquierdos.
// Si todos los vertices se declaran visibles se supone
// que tiene estilo torus...
// Si todos los laterales derechos son invisibles entonces es estilo pipe...
// Si todos los laterales derecho e inferior son invisibles entonces es
// estilo laminar...
//
// El modo largo de definir la red es el siguiente :
// #declare MyRedBasica    = array [Filas][Columnas][4]
//      {{{VectorPosicion,Normal,
//                      <BanderaVisible,BanderaQuadric,Subdivision>,
//                      <Textura,RealConcavo,RealGrueso>}}}
//      VectorPosicion  : La posicion del punto
//      Normal          : La normal al punto
//      BanderaVisible  : El rectangulo aplicable visible o no
//      BanderaCubico   : Utiliza modo Quadric o esferico
//      Subdivision     : Grado de subdivision
//      Textura         : Indice de textura
//              utilice -1 o ALSF_NoTextura para no aplicar.
//      RealConcavo     : Valor real para concavidad (radio de esfera)
//              Su signo puede utilizarse para invertir el orden de
//              asignacion de puntos.
//      RealGrueso      : Valor de control para grueso laminar
//              cuidado al cambiar de modo...
//
// #macro ALSF_Red( MyRed, NombreArchivo, BanderaLectura, MyListaTexturas )
//      MyRed           : La red a construir
//              Ver ejemplo arriba
//      NombreArchivo   : Util para velocidad en el Render
//              aplica unicamente en el modo Quadric
//              Utilice "" para no utilizar archivo.
//      BanderaLectura  : "on" lee el archivo
//                        "off"  genera el archivo
//                        Aplica unicamente si NombreArchivo
//                        esta definido y solo para modo Quadric
//      MyListaTexturas : permite aplicar texturas de una lista
//                        En caso de no definir ninguna textura
//                        ( todos los parametros de textura en MyRed -1)
//                        Este parametro se ignora, y puede pasar un cero.
//

#declare ALSF_NoTextura         = -1;
#declare ALSF_UsarNormalCubica  = off;

#macro ALSF_Red( MyRed, NombreArchivo, BanderaLectura, MyListaTexturas )
  union                         {
    #declare ALSF_NormalCubica = ALSF_UsarNormalCubica;
    #if ( strcmp( NombreArchivo,"" ) )
      ALSF_InicializarQuadricFile( NombreArchivo, BanderaLectura )
    #end
    #local TotalFilas             = dimension_size( MyRed, 1 );
    #local TotalColumnas          = dimension_size( MyRed, 2 );
    #local TotalFilasMitad        = ( TotalFilas-1 )/2;
    #local TotalColumnasMitad     = ( TotalColumnas-1 )/2;
    #local C                      = 0;
    #while ( C < TotalFilas )
      #local CM1                  = C+1;
      #if ( CM1 = TotalFilas )
        #local CM1                = 0;
      #end
      #local D                    = 0;
      #while ( D < TotalColumnas )
        #if ( MyRed[C][D][2].x )  // BanderaVisible
          #local DM1              = D+1;
          #if ( DM1 = TotalColumnas )
            #local DM1            = 0;
          #end
          union                 {
            #if ( MyRed[C][D][2].y )  // BanderaQuadric
              #if ( MyRed[C][D][3].y >= 0 )
                #if ( ( ( TotalFilas-TotalFilasMitad )*
                      ( TotalColumnas-TotalColumnasMitad ) ) >= 0 )
                  object            {
                    ALSF_MultiQuadric(
                          MyRed[C][D][0],MyRed[CM1][D][0],MyRed[CM1][DM1][0],
                          MyRed[C][D][1],MyRed[CM1][D][1],MyRed[CM1][DM1][1],
                          MyRed[C][D][2].z,MyRed[C][D][3].z
                    )
                  }
                  object            {
                    ALSF_MultiQuadric(
                          MyRed[CM1][DM1][0],MyRed[C][DM1][0],MyRed[C][D][0],
                          MyRed[CM1][DM1][1],MyRed[C][DM1][1],MyRed[C][D][1],
                          MyRed[C][D][2].z,MyRed[C][D][3].z
                    )
                  }
                #else
                  object            {
                    ALSF_MultiQuadric(
                          MyRed[C][D][0],MyRed[CM1][D][0],MyRed[C][DM1][0],
                          MyRed[C][D][1],MyRed[CM1][D][1],MyRed[C][DM1][1],
                          MyRed[C][D][2].z,MyRed[C][D][3].z
                    )
                  }
                  object            {
                    ALSF_MultiQuadric(
                        MyRed[CM1][DM1][0],MyRed[C][DM1][0],MyRed[CM1][D][0],
                        MyRed[CM1][DM1][1],MyRed[C][DM1][1],MyRed[CM1][D][1],
                          MyRed[C][D][2].z,MyRed[C][D][3].z
                    )
                  }
                #end
              #else
                #if ( ( ( TotalFilas-TotalFilasMitad )*
                      ( TotalColumnas-TotalColumnasMitad ) ) >= 0 )
                  object            {
                    ALSF_MultiQuadric(
                          MyRed[C][D][0],MyRed[C][DM1][0],MyRed[CM1][DM1][0],
                          MyRed[C][D][1],MyRed[C][DM1][1],MyRed[CM1][DM1][1],
                          MyRed[C][D][2].z,MyRed[C][D][3].z
                    )
                  }
                  object            {
                    ALSF_MultiQuadric(
                          MyRed[CM1][DM1][0],MyRed[CM1][D][0],MyRed[C][D][0],
                          MyRed[CM1][DM1][1],MyRed[CM1][D][1],MyRed[C][D][1],
                          MyRed[C][D][2].z,MyRed[C][D][3].z
                    )
                  }
                #else
                  object            {
                    ALSF_MultiQuadric(
                          MyRed[C][D][0],MyRed[C][DM1][0],MyRed[CM1][D][0],
                          MyRed[C][D][1],MyRed[C][DM1][1],MyRed[CM1][D][1],
                          MyRed[C][D][2].z,MyRed[C][D][3].z
                    )
                  }
                  object            {
                    ALSF_MultiQuadric(
                        MyRed[CM1][DM1][0],MyRed[CM1][D][0],MyRed[C][DM1][0],
                        MyRed[CM1][DM1][1],MyRed[CM1][D][1],MyRed[C][DM1][1],
                          MyRed[C][D][2].z,MyRed[C][D][3].z
                    )
                  }
                #end
              #end
            #else
              #if ( MyRed[C][D][3].y >= 0 )
                #if ( ( ( TotalFilas-TotalFilasMitad )*
                      ( TotalColumnas-TotalColumnasMitad ) ) < 0 )
                  object            {
                    ALSF_MultiTrianguloEsferico(
                          MyRed[C][D][0],MyRed[CM1][D][0],MyRed[CM1][DM1][0],
                          MyRed[C][D][1],MyRed[CM1][D][1],MyRed[CM1][DM1][1],
                          MyRed[C][D][2].z,MyRed[C][D][3].y,MyRed[C][D][3].z
                    )
                  }
                  object            {
                    ALSF_MultiTrianguloEsferico(
                        MyRed[CM1][DM1][0],MyRed[C][DM1][0],MyRed[C][D][0],
                        MyRed[CM1][DM1][1],MyRed[C][DM1][1],MyRed[C][D][1],
                          MyRed[C][D][2].z,MyRed[C][D][3].y,MyRed[C][D][3].z
                    )
                  }
                #else
                  object            {
                    ALSF_MultiTrianguloEsferico(
                          MyRed[C][D][0],MyRed[CM1][D][0],MyRed[C][DM1][0],
                          MyRed[C][D][1],MyRed[CM1][D][1],MyRed[C][DM1][1],
                          MyRed[C][D][2].z,MyRed[C][D][3].y,MyRed[C][D][3].z
                    )
                  }
                  object            {
                    ALSF_MultiTrianguloEsferico(
                        MyRed[CM1][DM1][0],MyRed[C][DM1][0],MyRed[CM1][D][0],
                        MyRed[CM1][DM1][1],MyRed[C][DM1][1],MyRed[CM1][D][1],
                          MyRed[C][D][2].z,MyRed[C][D][3].y,MyRed[C][D][3].z
                    )
                  }
                #end
              #else
                #if ( ( ( TotalFilas-TotalFilasMitad )*
                      ( TotalColumnas-TotalColumnasMitad ) ) < 0 )
                  object            {
                    ALSF_MultiTrianguloEsferico(
                          MyRed[C][D][0],MyRed[C][DM1][0],MyRed[CM1][DM1][0],
                          MyRed[C][D][1],MyRed[C][DM1][1],MyRed[CM1][DM1][1],
                          MyRed[C][D][2].z,-MyRed[C][D][3].y,MyRed[C][D][3].z
                    )
                  }
                  object            {
                    ALSF_MultiTrianguloEsferico(
                        MyRed[CM1][DM1][0],MyRed[CM1][D][0],MyRed[C][D][0],
                        MyRed[CM1][DM1][1],MyRed[CM1][D][1],MyRed[C][D][1],
                          MyRed[C][D][2].z,-MyRed[C][D][3].y,MyRed[C][D][3].z
                    )
                  }
                #else
                  object            {
                    ALSF_MultiTrianguloEsferico(
                          MyRed[C][D][0],MyRed[CM1][D][0],MyRed[C][DM1][0],
                          MyRed[C][D][1],MyRed[CM1][D][1],MyRed[C][DM1][1],
                          MyRed[C][D][2].z,-MyRed[C][D][3].y,MyRed[C][D][3].z
                    )
                  }
                  object            {
                    ALSF_MultiTrianguloEsferico(
                        MyRed[CM1][DM1][0],MyRed[C][DM1][0],MyRed[CM1][D][0],
                        MyRed[CM1][DM1][1],MyRed[C][DM1][1],MyRed[CM1][D][1],
                          MyRed[C][D][2].z,-MyRed[C][D][3].y,MyRed[C][D][3].z
                    )
                  }
                #end
              #end
            #end
            #if ( MyRed[C][D][3].x >= 0 )
              texture           {
                MyListaTexturas[ MyRed[C][D][3].x ]
              }
            #end
          }
        #end
        #local D                  = D+1;
      #end
      #local C                    = C+1;
    #end
    #if ( off )
      ALSF_FinalizarQuadricFile()
    #end
  }
#end
