// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  29 abril 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// ALSF AbreLatasSinabreFacil
// El archivo dibuja un abrelatas sencillo.  Es compatible con POVRay 3.1.
//
// La macro principal tiene unicamente un parametro
// #macro ALSF_AbreLatas( AnguloSacaCorchos )       
//      AnguloSacaCorchos       : Angulo de rotacion para el saca corchos.
//              Un valor de cero para guardar.
//                       
// La siguiente versin de la macro, permite un mayor control de las caracteristicas.
// #macro ALSF_AbreLatasSinabreFacil( AnguloSacaCorchos,
//                GruesoFilo, AltoBase, LargoDelantero,
//                LargoPosterior, FrenteDelantero, FrentePosterior, GruesoBase,
//                AltoHoja, LargoSacaCorchos, DiametroAlambreSacaCorchos,
//                DiametroGiroSacaCorchos, VueltasSacaCorchos,
//                PasoSacaCorchos,
//                MaterialPrincipal, MaterialTornillo,
//                MaterialFilo, MaterialAbreBotellas, MaterialSacaCorchos ) 
//      AnguloSacaCorchos       : Angulo de rotacion para el saca corchos.
//              Un valor de cero para guardar.
//      GruesoFilo              : Grueso de la hoja cortante de la lata. 
//              Default es 0.7*L.
//      AltoBase                : Alto Y de la agarradera del abrelatas.
//              Default es 7.2*L.
//      LargoDelantero          : Referencia para el largo delantero (filo), a partir
//              del tornillo para el sacacorchos.  Default es 35.7*L.
//      LargoPosterior          : Referencia para el largo posterior (sacacorchos), a partir
//              del tornillo para el sacacorchos.  Default es 57.9*L.
//      FrenteDelantero         : Para el grueso Z delantero, el que corresponde al filo.
//              Default es 11.3*L.
//      FrentePosterior         : Para el grueso Z posterior (sacacorchos).  
//              Default es 11.0*L.  
//      GruesoBase              : Grueso principal de lamina metal.  Default es 1.43*L.     
//      AltoHoja                : Referencia para la dimensin Y del filo.
//              Default es 14.4*L.                             
//      LargoSacaCorchos        : Largo del sacacorchos.  Default es 46.5*L.
//      DiametroAlambreSacaCorchos              : Diametro del alambre sacacorchos.
//              Default es 1.8*L.
//      DiametroGiroSacaCorchos : Diametro de giro para el alambre sacacorchos,
//              sobre si mismo.  Default es 4.3*L.
//      VueltasSacaCorchos      : Total de vueltas enteras del alambre sacacorchos.
//              Default es 4.
//      PasoSacaCorchos         : Separacin entre vuelta y vuelta del alambre 
//              sacacorchos.  Default es 6.4*L. 
//      MaterialPrincipal       : Material principal para el abrelatas.
//              Default es ALSF_MaterialPrincipal.
//      MaterialTornillo        : Material para los tornillos.
//              Default es ALSF_MaterialTornillo.
//      MaterialFilo            : Material para el filo abrelatas.
//              Default es ALSF_MaterialFilo.
//      MaterialAbreBotellas    : Material para el filo abrebotellas.
//              Default es ALSF_MaterialAbreBotellas.
//      MaterialSacaCorchos     : Material para el alambre sacacorchos.
//              Default es ALSF_MaterialSacaCorchos.
//      
// El AbreLatas cerrado se puede encerrar en la region:
//      PuntoMinimo             = <-43,-13,-7>*L
//      PuntoMaximo             = < 58, 11, 7>*L
// El frente sobresale en direccion X- y el filo abrelatas hacia Y-.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.     
// #declare ALSF_DefaultMaterialPrincipal
//      Material principal para el abrelatas.
// #declare ALSF_DefaultMaterialTornillo
//      Material para los tornillos.  
// #declare ALSF_DefaultMaterialFilo
//      Material para el filo abrelatas.   
// #declare ALSF_DefaultMaterialAbreBotellas
//      Material para el filo abrebotellas. 
// #declare ALSF_DefaultMaterialSacaCorchos
//      Material para el alambre sacacorchos.  
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default)
// #declare ALSF_MaterialPrincipal                      = material { ... }
//      Material principal para el abrelatas.           
// #declare ALSF_MaterialTornillo                       = material { ... }
//      Material para los tornillos.  
// #declare ALSF_MaterialFilo                           = material { ... }
//      Material para el filo abrelatas.   
// #declare ALSF_MaterialAbreBotellas                   = material { ... }
//      Material para el filo abrebotellas. 
// #declare ALSF_MaterialSacaCorchos                    = material { ... }
//      Material para el alambre sacacorchos.  
// #declare ALSF_POV3_1                                 = off;
//      Valor on activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo simplemente
// #include "ALSF.inc"
// object        { ALSF_AbreLatas( 0.0 ) }
//
// Otro ejemplo con modificador
// #include "ALSF.inc"
// #declare ALSF_MaterialPrincipal        = material       { M_Water }
// object        {
//   ALSF_AbreLatas( 0.0 )
// }
//
// O bien con la macro detallada
// #include "ALSF.inc"
// object                       {
//   ALSF_AbreLatasSinabreFacil( 0.0, 0.0007, 0.0072, 0.0357,
//              0.0579, 0.0113, 0.0110, 0.00143, 0.0144, 0.0465, 
//              0.0018, 0.0043, 4, 0.0064,
//              ALSF_MaterialPrincipal, ALSF_MaterialTornillo,
//              ALSF_MaterialFilo, ALSF_MaterialAbreBotellas, ALSF_MaterialSacaCorchos )
// }
//
#include "colors.inc"

#declare OjoAbsoluto            = 256;
#declare VecesCentroAbsoluto    = 10;     
#declare L                      = 0.001;    
camera {
        location  <   0,  0, -( VecesCentroAbsoluto+1 )*OjoAbsoluto >*L
        direction z
        sky       y
        angle     38.74
//        look_at  <   0,  0, -VecesCentroAbsoluto*OjoAbsoluto >*L
}         
light_source    {
         < 500  , 500   , -3000 >*L
         White
}
background      {
         Gray50
}  
  
#include "ALSF.inc"   

#local   FactorAcercamiento     = 15;
 
object                          {
  ALSF_AbreLatas(0)    
  translate       -0.005*x
  translate       -( VecesCentroAbsoluto+1 )*( FactorAcercamiento-1 )
                        /( FactorAcercamiento )*OjoAbsoluto*L*z
}





