// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  29 abril 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// ALSF AbreLatasSinabreFacil
// El archivo dibuja un abrelatas sencillo.  Es compatible con POVRay 3.1.
//
// La macro principal tiene unicamente un parametro
// #macro ALSF_AbreLatas( AnguloSacaCorchos )       
//      AnguloSacaCorchos       : Angulo de rotacion para el saca corchos.
//              Un valor de cero para guardar.
//                       
// La siguiente versin de la macro, permite un mayor control de las caracteristicas.
// #macro ALSF_AbreLatasSinabreFacil( AnguloSacaCorchos,
//                GruesoFilo, AltoBase, LargoDelantero,
//                LargoPosterior, FrenteDelantero, FrentePosterior, GruesoBase,
//                AltoHoja, LargoSacaCorchos, DiametroAlambreSacaCorchos,
//                DiametroGiroSacaCorchos, VueltasSacaCorchos,
//                PasoSacaCorchos,
//                MaterialPrincipal, MaterialTornillo,
//                MaterialFilo, MaterialAbreBotellas, MaterialSacaCorchos ) 
//      AnguloSacaCorchos       : Angulo de rotacion para el saca corchos.
//              Un valor de cero para guardar.
//      GruesoFilo              : Grueso de la hoja cortante de la lata. 
//              Default es 0.7*L.
//      AltoBase                : Alto Y de la agarradera del abrelatas.
//              Default es 7.2*L.
//      LargoDelantero          : Referencia para el largo delantero (filo), a partir
//              del tornillo para el sacacorchos.  Default es 35.7*L.
//      LargoPosterior          : Referencia para el largo posterior (sacacorchos), a partir
//              del tornillo para el sacacorchos.  Default es 57.9*L.
//      FrenteDelantero         : Para el grueso Z delantero, el que corresponde al filo.
//              Default es 11.3*L.
//      FrentePosterior         : Para el grueso Z posterior (sacacorchos).  
//              Default es 11.0*L.  
//      GruesoBase              : Grueso principal de lamina metal.  Default es 1.43*L.     
//      AltoHoja                : Referencia para la dimensin Y del filo.
//              Default es 14.4*L.                             
//      LargoSacaCorchos        : Largo del sacacorchos.  Default es 46.5*L.
//      DiametroAlambreSacaCorchos              : Diametro del alambre sacacorchos.
//              Default es 1.8*L.
//      DiametroGiroSacaCorchos : Diametro de giro para el alambre sacacorchos,
//              sobre si mismo.  Default es 4.3*L.
//      VueltasSacaCorchos      : Total de vueltas enteras del alambre sacacorchos.
//              Default es 4.
//      PasoSacaCorchos         : Separacin entre vuelta y vuelta del alambre 
//              sacacorchos.  Default es 6.4*L. 
//      MaterialPrincipal       : Material principal para el abrelatas.
//              Default es ALSF_MaterialPrincipal.
//      MaterialTornillo        : Material para los tornillos.
//              Default es ALSF_MaterialTornillo.
//      MaterialFilo            : Material para el filo abrelatas.
//              Default es ALSF_MaterialFilo.
//      MaterialAbreBotellas    : Material para el filo abrebotellas.
//              Default es ALSF_MaterialAbreBotellas.
//      MaterialSacaCorchos     : Material para el alambre sacacorchos.
//              Default es ALSF_MaterialSacaCorchos.
//      
// El AbreLatas cerrado se puede encerrar en la region:
//      PuntoMinimo             = <-43,-13,-7>*L
//      PuntoMaximo             = < 58, 11, 7>*L
// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  29 abril 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// ALSF AbreLatasSinabreFacil
// El archivo dibuja un abrelatas sencillo.  Es compatible con POVRay 3.1.
//
// La macro principal tiene unicamente un parametro
// #macro ALSF_AbreLatas( AnguloSacaCorchos )       
//      AnguloSacaCorchos       : Angulo de rotacion para el saca corchos.
//              Un valor de cero para guardar.
//                       
// La siguiente versin de la macro, permite un mayor control de las caracteristicas.
// #macro ALSF_AbreLatasSinabreFacil( AnguloSacaCorchos,
//                GruesoFilo, AltoBase, LargoDelantero,
//                LargoPosterior, FrenteDelantero, FrentePosterior, GruesoBase,
//                AltoHoja, LargoSacaCorchos, DiametroAlambreSacaCorchos,
//                DiametroGiroSacaCorchos, VueltasSacaCorchos,
//                PasoSacaCorchos,
//                MaterialPrincipal, MaterialTornillo,
//                MaterialFilo, MaterialAbreBotellas, MaterialSacaCorchos ) 
//      AnguloSacaCorchos       : Angulo de rotacion para el saca corchos.
//              Un valor de cero para guardar.
//      GruesoFilo              : Grueso de la hoja cortante de la lata. 
//              Default es 0.7*L.
//      AltoBase                : Alto Y de la agarradera del abrelatas.
//              Default es 7.2*L.
//      LargoDelantero          : Referencia para el largo delantero (filo), a partir
//              del tornillo para el sacacorchos.  Default es 35.7*L.
//      LargoPosterior          : Referencia para el largo posterior (sacacorchos), a partir
//              del tornillo para el sacacorchos.  Default es 57.9*L.
//      FrenteDelantero         : Para el grueso Z delantero, el que corresponde al filo.
//              Default es 11.3*L.
//      FrentePosterior         : Para el grueso Z posterior (sacacorchos).  
//              Default es 11.0*L.  
//      GruesoBase              : Grueso principal de lamina metal.  Default es 1.43*L.     
//      AltoHoja                : Referencia para la dimensin Y del filo.
//              Default es 14.4*L.                             
//      LargoSacaCorchos        : Largo del sacacorchos.  Default es 46.5*L.
//      DiametroAlambreSacaCorchos              : Diametro del alambre sacacorchos.
//              Default es 1.8*L.
//      DiametroGiroSacaCorchos : Diametro de giro para el alambre sacacorchos,
//              sobre si mismo.  Default es 4.3*L.
//      VueltasSacaCorchos      : Total de vueltas enteras del alambre sacacorchos.
//              Default es 4.
//      PasoSacaCorchos         : Separacin entre vuelta y vuelta del alambre 
//              sacacorchos.  Default es 6.4*L. 
//      MaterialPrincipal       : Material principal para el abrelatas.
//              Default es ALSF_MaterialPrincipal.
//      MaterialTornillo        : Material para los tornillos.
//              Default es ALSF_MaterialTornillo.
//      MaterialFilo            : Material para el filo abrelatas.
//              Default es ALSF_MaterialFilo.
//      MaterialAbreBotellas    : Material para el filo abrebotellas.
//              Default es ALSF_MaterialAbreBotellas.
//      MaterialSacaCorchos     : Material para el alambre sacacorchos.
//              Default es ALSF_MaterialSacaCorchos.
//      
// El AbreLatas cerrado se puede encerrar en la region:
//      PuntoMinimo             = <-43,-13,-7>*L
//      PuntoMaximo             = < 58, 11, 7>*L
// El frente sobresale en direccion X- y el filo abrelatas hacia Y-.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.     
// #declare ALSF_DefaultMaterialPrincipal
//      Material principal para el abrelatas.
// #declare ALSF_DefaultMaterialTornillo
//      Material para los tornillos.  
// #declare ALSF_DefaultMaterialFilo
//      Material para el filo abrelatas.   
// #declare ALSF_DefaultMaterialAbreBotellas
//      Material para el filo abrebotellas. 
// #declare ALSF_DefaultMaterialSacaCorchos
//      Material para el alambre sacacorchos.  
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default)
// #declare ALSF_MaterialPrincipal                      = material { ... }
//      Material principal para el abrelatas.           
// #declare ALSF_MaterialTornillo                       = material { ... }
//      Material para los tornillos.  
// #declare ALSF_MaterialFilo                           = material { ... }
//      Material para el filo abrelatas.   
// #declare ALSF_MaterialAbreBotellas                   = material { ... }
//      Material para el filo abrebotellas. 
// #declare ALSF_MaterialSacaCorchos                    = material { ... }
//      Material para el alambre sacacorchos.  
// #declare ALSF_POV3_1                                 = off;
//      Valor on activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo simplemente
// #include "ALSF.inc"
// object        { ALSF_AbreLatas( 0.0 ) }
//
// Otro ejemplo con modificador
// #include "ALSF.inc"
// #declare ALSF_MaterialPrincipal        = material       { M_Water }
// object        {
//   ALSF_AbreLatas( 0.0 )
// }
//
// O bien con la macro detallada
// #include "ALSF.inc"
// object                       {
//   ALSF_AbreLatasSinabreFacil( 0.0, 0.0007, 0.0072, 0.0357,
//              0.0579, 0.0113, 0.0110, 0.00143, 0.0144, 0.0465, 
//              0.0018, 0.0043, 4, 0.0064,
//              ALSF_MaterialPrincipal, ALSF_MaterialTornillo,
//              ALSF_MaterialFilo, ALSF_MaterialAbreBotellas, ALSF_MaterialSacaCorchos )
// }
//
#include "colors.inc" 
#include "ALSF_AU1.inc"

#if ( version < 3.2 )
  #ifndef( ALSF_POV3_1 )
    #declare ALSF_POV3_1        = on;
  #end
#else
  #ifndef( ALSF_POV3_1 )
    #declare ALSF_POV3_1        = off;
  #end
#end

#declare ALSF_L                 = 0.001;
                                                   
#declare ALSF_DefaultMaterialPrincipal          =
  material                      {
    texture                     {
      pigment               {
        Silver*0.70+GreenCopper*0.30
      }
      normal                {
        bumps               
        turbulence          0.05
        scale               0.01
      }
      finish                {
        specular            0.2
        roughness           0.01
        metallic
      }
    }
    texture                             {   
      pigment                           {    
        agate    
        scale           0.002
        pigment_map                     {     
          [ 0.0 Silver ]
          [ 0.075 Clear ]
        }
      }
    }
  }


#ifndef ( ALSF_MaterialPrincipal )
  #declare ALSF_MaterialPrincipal       = ALSF_DefaultMaterialPrincipal
#end  // #ifndef ( ALSF_MaterialPrincipal )

#declare ALSF_DefaultMaterialTornillo   =
  material                              {
    texture                     {
      pigment               {
        Silver*0.60+GreenCopper*0.30
      }
      normal                {
        bumps
        turbulence          0.15
        scale               0.01
      }
      finish                {
        specular            0.2
        roughness           0.02
        metallic
      }
    }
  }

#ifndef ( ALSF_MaterialTornillo )
  #declare ALSF_MaterialTornillo        = ALSF_DefaultMaterialTornillo
#end  // #ifndef ( ALSF_MaterialTornillo )

#declare ALSF_DefaultMaterialFilo       = ALSF_DefaultMaterialPrincipal

#ifndef ( ALSF_MaterialFilo )
  #declare ALSF_MaterialFilo            = ALSF_DefaultMaterialFilo
#end  // #ifndef ( ALSF_MaterialFilo )

#declare ALSF_DefaultMaterialAbreBotellas = ALSF_DefaultMaterialPrincipal

#ifndef ( ALSF_MaterialAbreBotellas )
  #declare ALSF_MaterialAbreBotellas    = ALSF_DefaultMaterialAbreBotellas
#end  // #ifndef ( ALSF_MaterialFilo )

#declare ALSF_DefaultMaterialSacaCorchos  = ALSF_DefaultMaterialPrincipal

#ifndef ( ALSF_MaterialSacaCorchos )
  #declare ALSF_MaterialSacaCorchos     = ALSF_DefaultMaterialSacaCorchos
#end  // #ifndef ( ALSF_MaterialFilo )


#macro ALSF_AbreLatasSinabreFacil( AnguloSacaCorchos,
                GruesoFilo, AltoBase, LargoDelantero,
                LargoPosterior, FrenteDelantero, FrentePosterior, GruesoBase,
                AltoHoja, LargoSacaCorchos, DiametroAlambreSacaCorchos,
                DiametroGiroSacaCorchos, VueltasSacaCorchos,
                PasoSacaCorchos,
                MaterialPrincipal, MaterialTornillo,
                MaterialFilo, MaterialAbreBotellas, MaterialSacaCorchos )
  union                         {
    #local L                    = ALSF_L;
    #local GHF                  = <GruesoBase/2,0>;
    #local GHL                  = <0,GruesoBase/2>;
    difference                  {
      union                     {
        #local C                  = 0;
        #while ( C < 2 )
          difference              {
            prism                     {
              -AltoBase/2, AltoBase/2
              12,
              <-LargoDelantero,0>-GHF,
              <-0.975*LargoDelantero,FrenteDelantero/2>-GHF+GHL,
              <-0.90*LargoDelantero,FrenteDelantero/2>+GHF+GHL,
              <-0.70*LargoDelantero,GruesoFilo/2+GruesoBase/2>+GHL,
              <-0.25*LargoDelantero,GruesoFilo/2+GruesoBase/2>+GHL,
              <-0.15*LargoDelantero,DiametroAlambreSacaCorchos/2+GruesoBase/2>+GHL,
              <0,DiametroAlambreSacaCorchos/2+GruesoBase/2>+GHL,
              <+LargoPosterior/18,DiametroAlambreSacaCorchos/2+GruesoBase/2>-GHF+GHL,
              <+3*LargoPosterior/18,FrentePosterior/2>+GHL,
              <+17*LargoPosterior/18,0.8*FrentePosterior/2>+GHL+GHF,
              <+35*LargoPosterior/36,0.65*FrentePosterior/2>+GHF,
              <+LargoPosterior,0>+GHF
            }
            prism                     {
              -AltoBase, AltoBase
              13,
              <-LargoDelantero,0>+GHF,
              <-0.975*LargoDelantero,FrenteDelantero/2>+GHF-GHL,
              <-0.90*LargoDelantero,FrenteDelantero/2>-GHF-GHL,
              <-0.70*LargoDelantero,GruesoFilo/2+GruesoBase/2>-GHL,
              <-0.25*LargoDelantero,GruesoFilo/2+GruesoBase/2>-GHL,
              <-0.15*LargoDelantero,DiametroAlambreSacaCorchos/2+GruesoBase/2>-GHL,
              <0,DiametroAlambreSacaCorchos/2+GruesoBase/2>-GHL,
              <+LargoPosterior/18,DiametroAlambreSacaCorchos/2+GruesoBase/2>+GHF-GHL,
              <+3*LargoPosterior/18,FrentePosterior/2>-GHL,
              <+17*LargoPosterior/18,0.8*FrentePosterior/2>-GHL-GHF,
              <+35*LargoPosterior/36,0.65*FrentePosterior/2>-GHF,
              <+LargoPosterior,0>-GHF,
              -GHL
            } 
            box                         {  
              <-LargoDelantero+GruesoBase/2,-AltoBase,-GruesoBase/4>,
              <+LargoPosterior-GruesoBase/2,+AltoBase,+GruesoBase/4>
            }
            #if ( C = 1 )
              scale         <1,1,-1>
            #end
          }
        #local C                = C+1;
        #end
      }
      // Menos abertura delantera
      cylinder                  {
        -3*GHF, +3*GHF, 0.4*AltoBase
        translate               -AltoBase/2*y
        translate               -LargoDelantero*x
      }
    }
    // Seguros metalicos
    #local C                    = 0;
    #while ( C < 3 )
      union                       {
        difference                 {
          sphere                    {
            0, 1
          }
          sphere                    {
            -z, 0.75
          }
          plane                     {
            -z, 0
          }
          scale             <1,1,1/2>*0.25*AltoBase
          translate         -GruesoBase*z
          #if ( C = 0 )
            translate           -DiametroAlambreSacaCorchos/2*z
          #else  // #else ( C = 0 )
            translate           -GruesoFilo/2*z
          #end   // #else ( C = 0 )
        }
        difference                 {
          sphere                    {
            0, 1
          }
          plane                     {
            z, 0
          }
          scale             <1,1,1/2>*0.25*AltoBase
          translate         +GruesoBase*z
          #if ( C = 0 )
            translate           +DiametroAlambreSacaCorchos/2*z
          #else  // #else ( C = 0 )
            translate           +GruesoFilo/2*z
          #end   // #else ( C = 0 )
        }
        material                        {
          MaterialTornillo
        }
        #if ( C = 1 )
          translate             -0.25*LargoDelantero*x-AltoBase/2*x
        #end  // #if ( C = 1 )
        #if ( C = 2 )
          translate             -0.70*LargoDelantero*x+AltoBase/2*x
        #end  // #if ( C = 2 )
        #local C                        = C+1;
      }
    #end  // seguros metalicos
      
    // Filo Principal
    difference                  {
      prism                     {
        cubic_spline
        -GruesoFilo/2, GruesoFilo/2
        9,
        < -24.3,  -3.6 >,
        < -14.3,  -3.6 >,
        < -15.0, -10.0 >,
        < -28.2, -15.0 >,
        < -37.8, -13.6 >,
        < -42.9,  -7.1 >,
        < -24.3,  -3.6 >,
        < -14.3,  -3.6 >,
        < -15.0, -10.0 >
        rotate                  -90*x
        scale                   <ALSF_L,ALSF_L,1>
      }
      prism                     {
        -GruesoFilo, GruesoFilo,
        5,
        < -42.9,  -7.1 >,
        < -25.0,  -7.1 >,
        < -24.3,  -3.6 >,
        < -42.9,     0 >,
        < -42.9,  -7.1 >
        rotate                  -90*x
        scale                   <ALSF_L,ALSF_L,1>
      }
      translate                 +3.6*ALSF_L*y
      scale                     <LargoDelantero/(37*ALSF_L),(AltoHoja-AltoBase/2)/(15*ALSF_L),1>
      material                  {
        MaterialFilo
      }
      translate                 -AltoBase/2*y
    }
    // Filo Quita Tapas Botella
    difference                  {
      prism                     {
        cubic_spline
        -GruesoFilo/2, GruesoFilo/2
        9,
        < -13.0,   3.6 >,
        <  -7.8,   3.6 >,
        <  -7.8,   9.6 >,
        < -11.8,  12.9 >,
        < -17.8,  11.8 >,
        < -17.9,   8.0 >,
        < -13.0,   3.6 >,
        <  -7.8,   3.6 >,
        <  -7.8,   9.6 >
        rotate                  -90*x
        scale                   <ALSF_L,ALSF_L,1>
      }
      prism                     {
        cubic_spline
        -GruesoFilo, GruesoFilo,
        8,
        < -13.0,   3.6 >,
        < -17.9,   8.0 >,
        < -16.4,   9.0 >,
        < -12.8,   6.8 >,
        < -13.0,   3.6 >,
        < -15.0,   4.6 >,
        < -17.9,   8.0 >,
        < -16.4,   8.6 >
        rotate                  -90*x
        scale                   <ALSF_L,ALSF_L,1>
      }

      translate                 -3.6*ALSF_L*y
      scale                     <LargoDelantero/(37*ALSF_L),(AltoHoja-AltoBase/2)/(15*ALSF_L),1>
      material                  {
        MaterialAbreBotellas
      }
      translate                 +AltoBase/2*y
    }
    // SacaCorchos
    union                       {
      cylinder                  {
        0, ( LargoSacaCorchos-( VueltasSacaCorchos+1 )*PasoSacaCorchos )*x,
        DiametroAlambreSacaCorchos/2
      }
      #local Esc                = < PasoSacaCorchos,
                DiametroGiroSacaCorchos/2, DiametroGiroSacaCorchos/2>;
      #local PuntoA             = <0,-1,0>*Esc;
      #local PuntoB             = <0.25,0,+1>*Esc;
      #local PuntoC             = <0.50,1,0>*Esc;
      #local PuntoD             = <0.75,0,-1>*Esc;
      #local PuntoE             = <1,-1,0>*Esc;
      #local C                  = 0;
      cone                      {
        -DiametroGiroSacaCorchos/2*y
        -0.25*PasoSacaCorchos*x, DiametroAlambreSacaCorchos/2,
        +DiametroGiroSacaCorchos/2*z, 0
        translate               +LargoSacaCorchos*x
      }
      difference                {
        torus                   {
          3*DiametroAlambreSacaCorchos/2,
          DiametroAlambreSacaCorchos/2
          rotate                90*x
          translate     3*DiametroAlambreSacaCorchos/2*y
        }
        plane                   {
          -x, 0
        }
      }
      sphere                    {
        3*DiametroAlambreSacaCorchos*y,
        DiametroAlambreSacaCorchos/2
      }
      sphere                    {
        DiametroAlambreSacaCorchos*(y+2.0*x),
        DiametroAlambreSacaCorchos/2
      }
      cylinder                  {
        3*DiametroAlambreSacaCorchos*y,
        DiametroAlambreSacaCorchos*(y+2.0*x),
        DiametroAlambreSacaCorchos/2
      }
      union                     {
        ALSF_SweepTriplePunto( <0,0,0>,
             <0.1875*PasoSacaCorchos,-DiametroGiroSacaCorchos/8,-3*DiametroGiroSacaCorchos/4>,
             <0.375*PasoSacaCorchos,-DiametroGiroSacaCorchos/4,-DiametroGiroSacaCorchos/2>,
             DiametroAlambreSacaCorchos/2, true )
        ALSF_SweepTriplePunto(
             <0.375*PasoSacaCorchos,-DiametroGiroSacaCorchos/4,-DiametroGiroSacaCorchos/2>,
             <0.5625*PasoSacaCorchos,-3*DiametroGiroSacaCorchos/8,-3*DiametroGiroSacaCorchos/4>,
             <0.75*PasoSacaCorchos,-DiametroGiroSacaCorchos/2,0>,
             DiametroAlambreSacaCorchos/2, true )
        translate               ( LargoSacaCorchos
                -( VueltasSacaCorchos+1 )*PasoSacaCorchos )*x
      }
      #while ( C < VueltasSacaCorchos )
        union                   {
          ALSF_SweepTriplePunto( PuntoA, PuntoB, PuntoC,
              DiametroAlambreSacaCorchos/2, true )
          ALSF_SweepTriplePunto( PuntoC, PuntoD, PuntoE,
              DiametroAlambreSacaCorchos/2, true )
          translate            ( LargoSacaCorchos
                -( VueltasSacaCorchos+0.25 )*PasoSacaCorchos )*x
          translate             C*PasoSacaCorchos*x
        }
        #local C                = C+1;
      #end  // #while ( C < 4 )
      material                  {
        MaterialSacaCorchos
      }
      translate                 -3*DiametroAlambreSacaCorchos/2*y
      rotate                    AnguloSacaCorchos*z
    }
    material                    {
      MaterialPrincipal
    }
  }
#end  // #macro ALSF_AbreLatasSinabreFacil


#macro ALSF_AbreLatas( AnguloSacaCorchos )
  object                        {
    #local L                    = ALSF_L;
    #local GruesoFilo                   = 0.7*L;
    #local AltoBase                     = 7.2*L;
    #local LargoDelantero               = 35.7*L;
    #local LargoPosterior               = 57.9*L;
    #local FrenteDelantero              = 11.3*L;
    #local FrentePosterior              = 11.0*L;
    #local GruesoBase                   = 1.43*L;
    #local AltoHoja                     = 14.4*L;
    #local DiametroAlambreSacaCorchos   = 1.8*L;
    #local DiametroGiroSacaCorchos      = 4.3*L;
    #local PasoSacaCorchos              = 6.4*L;
    #local VueltasSacaCorchos           = 4;
    #local LargoSacaCorchos             = 46.5*L;
    ALSF_AbreLatasSinabreFacil( AnguloSacaCorchos,
                GruesoFilo, AltoBase, LargoDelantero,
                LargoPosterior, FrenteDelantero, FrentePosterior, GruesoBase,
                AltoHoja, LargoSacaCorchos, DiametroAlambreSacaCorchos,
                DiametroGiroSacaCorchos, VueltasSacaCorchos,
                PasoSacaCorchos,
                ALSF_MaterialPrincipal, ALSF_MaterialTornillo,
                ALSF_MaterialFilo, ALSF_MaterialAbreBotellas,
                ALSF_MaterialSacaCorchos )
  }
#end  // #macro ALSF_AbreLatas
