// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  7 octubre 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// EPCL EscurridorPlatosCubiertosLimpios
// El archivo dibuja un escurridor para platos y cubiertos de cocina.   
// Incluye una macro para modificar caracteristicas principales.
// Permite redefinir las texturas.
// Es compatible con POVRay 3.1.
//
// La macro default carece de parametros
// #macro EPCL_Escurridor()
// 
// Pueden controlarse mejor las caracteristicas con la siguiente macro:
// #macro EPCL_EscurridorPlatosCubiertosLimpios
//      ( Frente, Profundidad, ZonaCubiertos, AltoCubiertos,
//        GruesoBorde, TotalHuecosProfundidad, FraccionAire,
//        AltoBorde, AltoSoporte, GruesoDecorativo, RadioEsquina,
//        MaterialEscurridor )         
//      Frente                  = Frente total del articulo.  Default es 247*L.
//      Profundidad             = Profundidad total del articulo.  Default es 256*L.
//      ZonaCubiertos           = Referencia frontal para el espacio ocupado
//              por cubiertos, sin incluir bordes.  Default es 69*L.
//      AltoCubiertos           = Alto del recipiente para escurrir cubiertos.
//              Default es 34*L.
//      GruesoBorde             = Grueso del borde.  Default es 14*L.     
//      TotalHuecosProfundidad  = Total zonas vacias a lo profundo Z.  Default es 18.
//      FraccionAire            = Fraccion de espacio vacio en las laterales.  Default es 0.9.      
//      AltoBorde               = Alto del borde, sin incluir otros soportes.
//              Default es 7*L.                                                               
//      AltoSoporte             = Alto desde la zona baja del borde, incluye las patas.
//              Default es 43*L.
//      GruesoDecorativo        = Radio para curvatura estetica de los bordes.
//              Default es 2.5*L.
//      RadioEsquina            = Radio para la esquina de los bordes.
//              Default es 5.5*L.
//      MaterialEscurridor      = Material que se aplica al escurridor, sin
//              operaciones adicionales.  Default es EPCL_MaterialEscurridor.
//
// El aparato por defecto tiene las siguientes dimensiones:      
// Altura Y             = +57*L 
// Frente X             = 247*L  
// Profundidad Z        = 256*L
// El escurridor se dibuja centrado sobre el origen del plano XZ, con gravedad Y-.
// Llamamos frente, a los platos perpendiculares al observador.  Los
// platos se ubican a la izquierda respecto a un observador desde Z-.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare EPCL_DefaultMaterialEscurridor          
//      Material que se aplica a todo el objeto.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default) 
// #declare EPCL_MaterialEscurridor             = 
//              material { EPCL_DefaultMaterialEscurridor }          
//      Material que se aplica a todo el objeto.
// #declare JFSG_POV3_1                         = off;
//      Valor "on" activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//
// Para colocarlo simplemente
// #include "EPCL.inc"
// object        { EPCL_Escurridor() }
//
// Un ejemplo con la macro detallada:    
// #include "EPCL.inc" 
// object               {
//   EPCL_EscurridorPlatosCubiertosLimpios
//      ( 0.247, 0.256, 0.069, 0.034, 0.014, 18, 0.9,
//        0.007, 0.043, 0.0025, 0.0055, EPCL_MaterialEscurridor )
// }  
//
// O bien con modificadores:
// #include "EPCL.inc"                         
// #include "textures.inc"     
// #declare EPCL_MaterialEscurridor        =
//      material { texture { PinkAlabaster } }
// object        { EPCL_Escurridor() }
//
#include "colors.inc"

#declare OjoAbsoluto            = 256;
#declare VecesCentroAbsoluto    = 10;     
#declare L                      = 0.001;
camera {
        location  <   0,  0, -( VecesCentroAbsoluto+1 )*OjoAbsoluto >*L
        direction z
        sky       y
        angle     38.74
//        look_at  <   0,  0, -VecesCentroAbsoluto*OjoAbsoluto >*L
}         
light_source    {
         < 500  , 500   , -3000 >*L
         White
}
background      {
         Gray50
}    

#include "EPCL.inc"

#declare FactorAcercamiento     = 5;

object                  {
  EPCL_Escurridor()
  translate             -0.029*y
  translate       -( VecesCentroAbsoluto+1 )*( FactorAcercamiento-1 )
                        /( FactorAcercamiento )*OjoAbsoluto*L*z  
}





