// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  7 octubre 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// EPCL EscurridorPlatosCubiertosLimpios
// El archivo dibuja un escurridor para platos y cubiertos de cocina.   
// Incluye una macro para modificar caracteristicas principales.
// Permite redefinir las texturas.
// Es compatible con POVRay 3.1.
//
// La macro default carece de parametros
// #macro EPCL_Escurridor()
// 
// Pueden controlarse mejor las caracteristicas con la siguiente macro:
// #macro EPCL_EscurridorPlatosCubiertosLimpios
//      ( Frente, Profundidad, ZonaCubiertos, AltoCubiertos,
//        GruesoBorde, TotalHuecosProfundidad, FraccionAire,
//        AltoBorde, AltoSoporte, GruesoDecorativo, RadioEsquina,
//        MaterialEscurridor )         
//      Frente                  = Frente total del articulo.  Default es 247*L.
//      Profundidad             = Profundidad total del articulo.  Default es 256*L.
//      ZonaCubiertos           = Referencia frontal para el espacio ocupado
//              por cubiertos, sin incluir bordes.  Default es 69*L.
//      AltoCubiertos           = Alto del recipiente para escurrir cubiertos.
//              Default es 34*L.
//      GruesoBorde             = Grueso del borde.  Default es 14*L.     
//      TotalHuecosProfundidad  = Total zonas vacias a lo profundo Z.  Default es 18.
//      FraccionAire            = Fraccion de espacio vacio en las laterales.  Default es 0.9.      
//      AltoBorde               = Alto del borde, sin incluir otros soportes.
//              Default es 7*L.                                                               
//      AltoSoporte             = Alto desde la zona baja del borde, incluye las patas.
//              Default es 43*L.
//      GruesoDecorativo        = Radio para curvatura estetica de los bordes.
//              Default es 2.5*L.
//      RadioEsquina            = Radio para la esquina de los bordes.
//              Default es 5.5*L.
//      MaterialEscurridor      = Material que se aplica al escurridor, sin
//              operaciones adicionales.  Default es EPCL_MaterialEscurridor.
//
// El aparato por defecto tiene las siguientes dimensiones:      
// Altura Y             = +57*L 
// Frente X             = 247*L  
// Profundidad Z        = 256*L
// El escurridor se dibuja centrado sobre el origen del plano XZ, con gravedad Y-.
// Llamamos frente, a los platos perpendiculares al observador.  Los
// platos se ubican a la izquierda respecto a un observador desde Z-.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare EPCL_DefaultMaterialEscurridor          
//      Material que se aplica a todo el objeto.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default) 
// #declare EPCL_MaterialEscurridor             = 
//              material { EPCL_DefaultMaterialEscurridor }          
//      Material que se aplica a todo el objeto.
// #declare JFSG_POV3_1                         = off;
//      Valor "on" activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//
// Para colocarlo simplemente
// #include "EPCL.inc"
// object        { EPCL_Escurridor() }
//
// Un ejemplo con la macro detallada:    
// #include "EPCL.inc" 
// object               {
//   EPCL_EscurridorPlatosCubiertosLimpios
//      ( 0.247, 0.256, 0.069, 0.034, 0.014, 18, 0.9,
//        0.007, 0.043, 0.0025, 0.0055, EPCL_MaterialEscurridor )
// }  
//
// O bien con modificadores:
// #include "EPCL.inc"                         
// #include "textures.inc"     
// #declare EPCL_MaterialEscurridor        =
//      material { texture { PinkAlabaster } }
// object        { EPCL_Escurridor() }
//

#include "textures.inc"

#if ( version < 3.2 )
  #ifndef( MTAE_POV3_1 )
    #declare MTAE_POV3_1        = on;
  #end
#else
  #ifndef( MTAE_POV3_1 )
    #declare MTAE_POV3_1        = off;
  #end
#end
                      
#declare EPCL_L         = 0.001;

#declare EPCL_DefaultMaterialEscurridor  =
  material                              { 
    #if ( MTAE_POV3_1 )   
      texture { NBwinebottle }
    #else
      M_NB_Winebottle_Glass   
    #end  
  }

#ifndef ( EPCL_MaterialEscurridor )
  #declare EPCL_MaterialEscurridor      = EPCL_DefaultMaterialEscurridor
#end  // #ifndef ( EPCL_MaterialEscurridor )

#macro EPCL_EscurridorPlatosCubiertosLimpios
      ( Frente, Profundidad, ZonaCubiertos, AltoCubiertos,
        GruesoBorde, TotalHuecosProfundidad, FraccionAire,
        AltoBorde, AltoSoporte, GruesoDecorativo, RadioEsquina,
        MaterialEscurridor )
  union                                 {
    #local GruesoBordeDiferencia        =
                GruesoBorde-2*GruesoDecorativo;
    #local LargoMax                     = min( Frente, Profundidad );
    difference                          {
      union                             {
        box                             {
          < -Frente/2+GruesoBorde+ZonaCubiertos, 0,
            -Profundidad/2+GruesoBorde/2 >,
          < -Frente/2+2*GruesoBorde+ZonaCubiertos,
            AltoBorde-1.001*GruesoDecorativo,
            +Profundidad/2-GruesoBorde/2 >
        }
        union                           {
          box                           {
            < 0, -GruesoDecorativo, -Profundidad/2+2*GruesoBorde/3 >,
            < GruesoBordeDiferencia, GruesoDecorativo,
              +Profundidad/2-2*GruesoBorde/3 >
            translate   ( -Frente/2+GruesoBorde
                                +ZonaCubiertos+GruesoDecorativo )*x
          }
          cylinder                        {
            ( -Profundidad/2+GruesoBorde/3 )*z,
            ( +Profundidad/2-GruesoBorde/3 )*z,
            GruesoDecorativo
            translate   ( -Frente/2+GruesoBorde
                                +ZonaCubiertos+GruesoDecorativo )*x
          }
          cylinder                        {
            ( -Profundidad/2+GruesoBorde/3 )*z,
            ( +Profundidad/2-GruesoBorde/3 )*z,
            GruesoDecorativo
            translate   ( -Frente/2+2*GruesoBorde
                                +ZonaCubiertos-GruesoDecorativo )*x
          }
          translate                     ( AltoBorde-GruesoDecorativo )*y
        }
        #local C                        = 0;
        #while ( C < 8 )
          difference                    {
            union                       {
              box                       {
                < -LargoMax, 0, -GruesoBorde/2 >,
                < +GruesoBorde/2-RadioEsquina,
                   AltoBorde-1.001*GruesoDecorativo, +GruesoBorde/2 >
              }
              cylinder                  {
                0*y,
                ( AltoBorde-1.001*GruesoDecorativo )*y,
                RadioEsquina
                translate       <1,0,1>*( GruesoBorde/2-RadioEsquina )
              }
              union                     {
                box                             {
                  < -LargoMax, -GruesoDecorativo, +GruesoBorde/2-GruesoDecorativo >,
                  < GruesoBorde/2-RadioEsquina, GruesoDecorativo,
                    -GruesoBorde/2+GruesoDecorativo >
                }
                cylinder                        {
                  -LargoMax*x, ( +GruesoBorde/2-RadioEsquina )*x,
                  GruesoDecorativo
                  translate     +( GruesoBorde/2-GruesoDecorativo )*z
                }
                cylinder                        {
                  -LargoMax*x, ( +GruesoBorde/2-RadioEsquina )*x,
                  GruesoDecorativo
                  translate     -( GruesoBorde/2-GruesoDecorativo )*z
                }
                cylinder                  {
                  -GruesoDecorativo*y, GruesoDecorativo*y,
                  RadioEsquina-GruesoDecorativo
                  translate       <1,0,1>*( GruesoBorde/2-RadioEsquina )
                }
                torus                   {
                  RadioEsquina-GruesoDecorativo, GruesoDecorativo
                  translate       <1,0,1>*( GruesoBorde/2-RadioEsquina )
                }
                translate               +( AltoBorde-GruesoDecorativo )*y
              }
              #if ( div( C, 4 ) = 1 )
                matrix          <0,0,1,
                                 0,1,0,
                                 1,0,0,
                                 0,0,0>
              #end  // #if ( div( C, 4 ) = 1 )
              #if ( mod( C, 2) = 0 )
                translate         ( Frente/2-GruesoBorde/2 )*x
                                +( Profundidad/2-GruesoBorde/2 )*z
              #else  // #else ( mod( C, 2 ) = 0 )
                translate         ( Frente/2-GruesoBorde/2 )*z
                                +( Profundidad/2-GruesoBorde/2 )*x
              #end   // #else ( mod( C, 2 ) )
            }
            plane                       {
              x, 0
            }
            plane                       {
              z, 0
            }
            rotate                      90*C*y
          }
          #local C                      = C+1;
        #end  // #while ( C < 4 )
      }
      union                             {
        box                             {
          < -Frente/2+GruesoBorde+ZonaCubiertos+GruesoDecorativo,
            -GruesoDecorativo,
            -Profundidad/2+GruesoBorde >,
          < -Frente/2+2*GruesoBorde+ZonaCubiertos-GruesoDecorativo,
            AltoBorde-GruesoDecorativo,
            +Profundidad/2-GruesoBorde >
        }
        #local C                        = 0;
        #while ( C < 8 )
          difference                    {
            union                         {
              box                       {
                < -LargoMax, -GruesoDecorativo, -GruesoBordeDiferencia/2 >,
                < +GruesoBorde/2-RadioEsquina,
                   AltoBorde-GruesoDecorativo, +GruesoBordeDiferencia/2 >
              }
              cylinder                  {
                -GruesoDecorativo*y,
                ( AltoBorde-GruesoDecorativo )*y,
                ( GruesoBordeDiferencia-GruesoBorde )/2+RadioEsquina
                translate       <1,0,1>*( GruesoBorde/2-RadioEsquina )
              }
              #if ( div( C, 4 ) = 1 )
                matrix          <0,0,1,
                                 0,1,0,
                                 1,0,0,
                                 0,0,0>
              #end  // #if ( div( C, 4 ) = 1 )
              #if ( mod( C, 2) = 0 )
                translate         ( Frente/2-GruesoBorde/2 )*x
                                +( Profundidad/2-GruesoBorde/2 )*z
              #else  // #else ( mod( C, 2 ) = 0 )
                translate         ( Frente/2-GruesoBorde/2 )*z
                                +( Profundidad/2-GruesoBorde/2 )*x
              #end   // #else ( mod( C, 2 ) )
            }
            plane                       {
              x, -GruesoDecorativo
            }
            plane                       {
              z, -GruesoDecorativo
            }
            rotate                      90*C*y
          }
          #local C                      = C+1;
        #end  // #while ( C < 4 )
      }
    }
    // Soporte Platos
    union                               {
      #local ZonaPlatos                 = Frente-3*GruesoBorde-ZonaCubiertos;
      #local DiametroCilindroSoporte    = 13*GruesoBorde/14;
      #local ZonaPlatosInferior         = 59*ZonaPlatos/136;
      #local VacioPlatosInferior        = 23*ZonaPlatos/136;
      #local YPivote                    =
                ( VacioPlatosInferior+GruesoBorde/2+AltoBorde );
      #local XPivote                    =
         ( ZonaPlatos-ZonaPlatosInferior+GruesoBorde )/2;
      #local LPivote                    =
        sqrt( XPivote*XPivote+YPivote*YPivote );
      #local SitaPivote                 =
        degrees( atan2( YPivote, XPivote ) );
      difference                        {
        union                           {
          box                           {
            <-Frente/2+GruesoBorde,-AltoCubiertos,
              -Profundidad/2+GruesoBorde >,
            <-Frente/2+GruesoBorde+ZonaCubiertos, 0,
              +Profundidad/2-GruesoBorde >
          }
          cylinder                      {
            ( -Profundidad/2+GruesoBorde )*z,
            ( +Profundidad/2-GruesoBorde )*z,
            GruesoDecorativo
            translate                   ( -Frente/2+GruesoBorde )*x
          }
          cylinder                      {
            ( -Profundidad/2+GruesoBorde )*z,
            ( +Profundidad/2-GruesoBorde )*z,
            GruesoDecorativo
            translate              ( -Frente/2+GruesoBorde+ZonaCubiertos )*x
          }
          cylinder                      {
            ( -Frente/2+GruesoBorde )*x,
            ( -Frente/2+GruesoBorde+ZonaCubiertos )*x,
            GruesoDecorativo
            translate              ( -Profundidad/2+GruesoBorde )*z
          }
          cylinder                      {
            ( -Frente/2+GruesoBorde )*x,
            ( -Frente/2+GruesoBorde+ZonaCubiertos )*x,
            GruesoDecorativo
            translate              ( +Profundidad/2-GruesoBorde )*z
          }
          box                           {
            <-ZonaPlatosInferior/2,-VacioPlatosInferior-GruesoBorde,
              -Profundidad/2+GruesoBorde >,
            <+ZonaPlatosInferior/2,-VacioPlatosInferior,
              +Profundidad/2-GruesoBorde >
            translate   +( Frente/2-GruesoBorde-ZonaPlatos/2 )*x
          }
          cylinder                        {
            ( -Profundidad/2+GruesoBorde )*z,
            ( +Profundidad/2-GruesoBorde )*z,
            DiametroCilindroSoporte/2
            translate             AltoBorde*y
                  +( Frente/2-GruesoBorde )*x
          }
          box                           {
            <-LPivote, -DiametroCilindroSoporte/2,
              -Profundidad/2+GruesoBorde >,
            <0, DiametroCilindroSoporte/2,
              +Profundidad/2-GruesoBorde >
            rotate              SitaPivote*z
            translate             AltoBorde*y
                  +( Frente/2-GruesoBorde )*x
          }
          box                           {
            <-LPivote, -DiametroCilindroSoporte/2,
              -Profundidad/2+GruesoBorde >,
            <0, DiametroCilindroSoporte/2,
              +Profundidad/2-GruesoBorde >
            rotate              SitaPivote*z
            scale               <-1,1,1>
            translate             AltoBorde*y
                  +( Frente/2-GruesoBorde-ZonaPlatos )*x
          }
          cylinder                        {
            ( -Profundidad/2+GruesoBorde )*z,
            ( +Profundidad/2-GruesoBorde )*z,
            DiametroCilindroSoporte/2
            translate             AltoBorde*y
                +( Frente/2-GruesoBorde-ZonaPlatos )*x
          }
        }
        // Huecos
        #local RellenoHueco             =
                     ( 1-FraccionAire )*
                     ( Profundidad-2*GruesoBorde )/( TotalHuecosProfundidad+1 );
        #local VacioHueco               =
                     FraccionAire*
                     ( Profundidad-2*GruesoBorde )/TotalHuecosProfundidad;
        #local C                        = 0;
        #while ( C < TotalHuecosProfundidad )
          box                           {
            < -Frente/2, -1.5*AltoCubiertos,
              -Profundidad/2+GruesoBorde+RellenoHueco >,
            < +Frente/2, AltoCubiertos,
              -Profundidad/2+GruesoBorde+RellenoHueco+VacioHueco >
            translate   C*( VacioHueco+RellenoHueco )*z
          }

          #local C                      = C+1;
        #end  // #while ( C < TotalHuecosProfundidad )
        box                             {
          < -Frente/2+GruesoBorde+GruesoDecorativo,
            -AltoCubiertos+GruesoDecorativo,
            -Profundidad/2+GruesoBorde+GruesoDecorativo >,
          < -Frente/2+GruesoBorde+ZonaCubiertos-GruesoDecorativo,
            +GruesoDecorativo,
            +Profundidad/2-GruesoBorde-GruesoDecorativo >
        }
        // Huecos A lo profundo
        #local TotalHuecosFrente        =
                 div( FraccionAire*ZonaCubiertos, VacioHueco )+1;
        #local RellenoHuecoFrente       =
                     ( 1-FraccionAire )*
                     ( ZonaCubiertos-2*GruesoDecorativo )/
                     ( TotalHuecosFrente-1 );
        #local VacioHuecoFrente         =
                     FraccionAire*
                     ( ZonaCubiertos-2*GruesoDecorativo )/TotalHuecosFrente;

        #local C                        = 0;
        #while ( C < TotalHuecosFrente )
          box                           {
            < -Frente/2+GruesoBorde+GruesoDecorativo,
              -AltoCubiertos+GruesoDecorativo, -Profundidad/2 >,
            < -Frente/2+GruesoBorde+GruesoDecorativo+VacioHuecoFrente,
              2*GruesoDecorativo, Profundidad/2 >
            translate   C*( VacioHuecoFrente+RellenoHuecoFrente )*x
          }

          #local C                      = C+1;
        #end  // #while ( C < TotalHuecosProfundidad )

      }
      #local C                          = 0;
      #local TotalRellenosFrente        = TotalHuecosFrente-1;
      #while ( C < TotalRellenosFrente )
        box                           {
          < -Frente/2+GruesoBorde+GruesoDecorativo+VacioHuecoFrente,
              -AltoCubiertos, -Profundidad/2+GruesoBorde >,
          < -Frente/2+GruesoBorde+GruesoDecorativo+VacioHuecoFrente+
              RellenoHuecoFrente,
              -AltoCubiertos+GruesoDecorativo, Profundidad/2-GruesoBorde >
          translate   C*( VacioHuecoFrente+RellenoHuecoFrente )*x
        }

        #local C                      = C+1;
      #end  // #while ( C < TotalRellenosFrente )
    }
    // Patas
    union                               {
      box                               {
        <-Frente/2+GruesoBorde+ZonaCubiertos,0,
         -Profundidad/2+GruesoBorde >,
        <+Frente/2-GruesoBorde-ZonaPlatos+GruesoBorde,-GruesoBorde,
         -Profundidad/2+GruesoBorde+GruesoDecorativo >
      }
      box                               {
        <-Frente/2+GruesoBorde+ZonaCubiertos,0,
         +Profundidad/2-GruesoBorde >,
        <+Frente/2-GruesoBorde-ZonaPlatos+GruesoBorde,-GruesoBorde,
         +Profundidad/2-GruesoBorde-GruesoDecorativo >
      }
      cylinder                          {
        ( -Profundidad/2+GruesoBorde )*z,
        ( +Profundidad/2-GruesoBorde )*z,
        2*GruesoDecorativo
        translate       ( Frente/2-GruesoBorde-ZonaPlatos )*x
        translate       0.25*( ZonaPlatos-ZonaPlatosInferior )*x
        translate       ( AltoBorde-DiametroCilindroSoporte/2 )*y
        translate       -tan( radians( SitaPivote ) )*
                        0.25*( ZonaPlatos-ZonaPlatosInferior )*y
      }
      cylinder                          {
        ( -Profundidad/2+GruesoBorde )*z,
        ( +Profundidad/2-GruesoBorde )*z,
        2*GruesoDecorativo
        translate       ( Frente/2-GruesoBorde )*x
        translate       -0.25*( ZonaPlatos-ZonaPlatosInferior )*x
        translate       ( AltoBorde-DiametroCilindroSoporte/2 )*y
        translate       -tan( radians( SitaPivote ) )*
                        0.25*( ZonaPlatos-ZonaPlatosInferior )*y
      }
      cylinder                          {
        -AltoSoporte*y, (-VacioPlatosInferior-GruesoBorde
                        +GruesoDecorativo)*y, VacioHueco
        translate           ( +Frente/2-GruesoBorde-ZonaPlatos/2 )*x
                           +( -Profundidad/2+GruesoBorde )*z/2
      }
      cylinder                          {
        -AltoSoporte*y, (-VacioPlatosInferior-GruesoBorde
                        +GruesoDecorativo)*y, VacioHueco
        translate           ( +Frente/2-GruesoBorde-ZonaPlatos/2 )*x
                           -( -Profundidad/2+GruesoBorde )*z/2
      }
      difference                        {
        box                             {
          <+Frente/2-GruesoBorde-ZonaPlatos/2-ZonaPlatosInferior/2,
           -AltoSoporte, -Profundidad/2+GruesoBorde >,
          <+Frente/2-GruesoBorde-ZonaPlatos/2+ZonaPlatosInferior/2,
           -VacioPlatosInferior-GruesoBorde+GruesoDecorativo,
           +Profundidad/2-GruesoBorde >
        }
        box                             {
          <+Frente/2-GruesoBorde-ZonaPlatos/2
            -ZonaPlatosInferior/2+GruesoDecorativo,
           -AltoSoporte-GruesoDecorativo,
            -Profundidad/2+GruesoBorde+GruesoDecorativo >,
          <+Frente/2-GruesoBorde-ZonaPlatos/2
            +ZonaPlatosInferior/2-GruesoDecorativo,
           -VacioPlatosInferior-GruesoBorde+2*GruesoDecorativo,
            +Profundidad/2-GruesoBorde-GruesoDecorativo >
        }
        box                             {
          <+Frente/2-GruesoBorde-ZonaPlatos/2
            -0.8*ZonaPlatosInferior/2+GruesoDecorativo,
           -AltoSoporte-GruesoDecorativo,
            -Profundidad/2 >,
          <+Frente/2-GruesoBorde-ZonaPlatos/2
            +0.8*ZonaPlatosInferior/2-GruesoDecorativo,
           -VacioPlatosInferior-GruesoBorde+2*GruesoDecorativo,
            +Profundidad/2 >
        }
        box                             {
          <+Frente/2,-AltoSoporte-GruesoDecorativo,
           -0.9*( Profundidad/2-GruesoBorde ) >,
          <+Frente/2-2*GruesoBorde-ZonaPlatos,
            -VacioPlatosInferior-GruesoBorde,
           -0.05*( Profundidad/2-GruesoBorde ) >
        }
        box                             {
          <+Frente/2,-AltoSoporte-GruesoDecorativo,
           +0.9*( Profundidad/2-GruesoBorde ) >,
          <+Frente/2-2*GruesoBorde-ZonaPlatos,
            -VacioPlatosInferior-GruesoBorde,
           +0.05*( Profundidad/2-GruesoBorde ) >
        }
      }
      cylinder                          {
        -AltoSoporte*y, (-AltoCubiertos+GruesoDecorativo)*y,
         2*VacioHueco/3
        translate           ( -Frente/2+GruesoBorde+ZonaCubiertos/2 )*x
                           +( -Profundidad/2+GruesoBorde )*z/2
      }
      cylinder                          {
        -AltoSoporte*y, (-AltoCubiertos+GruesoDecorativo)*y,
         2*VacioHueco/3
        translate           ( -Frente/2+GruesoBorde+ZonaCubiertos/2 )*x
                           -( -Profundidad/2+GruesoBorde )*z/2
      }
      difference                        {
        box                             {
          <-Frente/2+GruesoBorde,-AltoSoporte,-Profundidad/2+GruesoBorde>,
          <-Frente/2+GruesoBorde+ZonaCubiertos,-AltoCubiertos,
           +Profundidad/2-GruesoBorde>
        }
        box                             {
          <-Frente/2+GruesoBorde+GruesoDecorativo,
            -AltoSoporte-GruesoDecorativo,-Profundidad/2>,
          <-Frente/2+GruesoBorde+ZonaCubiertos-GruesoDecorativo,0,
           +Profundidad/2>
        }
        box                             {
          <-Frente/2,-AltoSoporte-GruesoDecorativo,
           -0.9*( Profundidad/2-GruesoBorde ) >,
          <-Frente/2+2*GruesoBorde+ZonaCubiertos,
            -AltoCubiertos,
           -0.05*( Profundidad/2-GruesoBorde ) >
        }
        box                             {
          <-Frente/2,-AltoSoporte-GruesoDecorativo,
           +0.9*( Profundidad/2-GruesoBorde ) >,
          <-Frente/2+2*GruesoBorde+ZonaCubiertos,
            -AltoCubiertos,
           +0.05*( Profundidad/2-GruesoBorde ) >
        }
      }
    }       
    translate                   AltoSoporte*y
    material                            {
      MaterialEscurridor
    }  // texture
  }
#end  // #macro EPCL_EscurridorPlatosCubiertosLimpios

#macro EPCL_Escurridor()
  object                        {
    #local L                    = EPCL_L;
    #local Frente               = 247*L;
    #local Profundidad          = 256*L;
    #local ZonaCubiertos        = 69*L;
    #local GruesoBorde          = 14*L;
    #local AltoBorde            = 7*L;
    #local AltoCubiertos        = 34*L;
    #local AltoSoporte          = 43*L;
    #local GruesoDecorativo     = 2.5*L;
    #local RadioEsquina         = 5.5*L;
    #local FraccionAire         = 0.9;
    #local TotalHuecosProfundidad       = 18;
    EPCL_EscurridorPlatosCubiertosLimpios
      ( Frente, Profundidad, ZonaCubiertos, AltoCubiertos,
        GruesoBorde, TotalHuecosProfundidad, FraccionAire,
        AltoBorde, AltoSoporte, GruesoDecorativo, RadioEsquina,
        EPCL_MaterialEscurridor )
  }
#end  // #macro EPCL_Escurridor
