// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho... 12 marzo 2014
//
// NVFA NubeVolatilFractalAleatoria
// El archivo dibuja nubes 3D con volumen, poco flexibles.  Fueron disenadas,
// para evitar el uso de interior {}, cuando lo permitan los objetivos.                
// Simplemente son "fractales pintados y enrollados en el espacio". 
// Para evitar puntos negros deber elevar el valor de max_trace_level. 
// Ofrece diez modelos generados por combinacion de fractales y la funcion f_hetero_mf() 
// en "functions.inc", no es compatible con POVRay 3.1.  
//
// Considere que las nubes tienen un diametro aproximado de dos unidades PovRay.
// Usted puede elegir entre un limite sphere { 0, 1 } o box { -1, 1 }.
//
// Las macros generadoras son las siguientes.
//  
// #macro NVFA_Nube1( BoxSphere )                                        
// #macro NVFA_Nube2( BoxSphere )                                        
// #macro NVFA_Nube3( BoxSphere )                                        
// #macro NVFA_Nube4( BoxSphere )                                        
// #macro NVFA_Nube5( BoxSphere, VectorMovimiento )                                        
// #macro NVFA_Nube6( BoxSphere )                                        
// #macro NVFA_Nube7( BoxSphere )                                        
// #macro NVFA_Nube8( BoxSphere, NuevoThreshold, VectorMovimiento )                                        
// #macro NVFA_Nube9( BoxSphere )                                        
// #macro NVFA_Nube10( BoxSphere, NuevoThreshold )                                        
//      BoxSphere               : "on" utiliza box { -1, 1 } como limite,
//                                "off" utiliza sphere { 0, 1 } como limite.
//      NuevoThreshold          : Para modificar el valor theresfold de una isosurface, 
//              Recomendamos un valor de 0.99 para NVFA_Nube9() y de 1.2 para NVFA_Nube10().
//      VectorMovimiento        : Para desplazar el centro funcional de evaluacion.
//              En cumulos de nubes juntas, sirve para darle continuidad a los bloques.
//    
// La siguiente variable no deberia modificarse.
// #declare NVFA_DefaultTexturaNubeGeneral
//      Declara la textura por defecto de todas las nubes.
//                           
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default).
// Se trata de texturas, el numero indica la macro en que aplica. 
// Considere que al dibujar un fractal probablemente convenga elevar la variable ambient.
// #declare NVFA_TexturaNube1                  = NVFA_DefaultTexturaNubeGeneral
// #declare NVFA_TexturaNube2                  = NVFA_DefaultTexturaNubeGeneral
// #declare NVFA_TexturaNube3                  = NVFA_DefaultTexturaNubeGeneral
// #declare NVFA_TexturaNube4                  = NVFA_DefaultTexturaNubeGeneral
// #declare NVFA_TexturaNube5                  = NVFA_DefaultTexturaNubeGeneral
// #declare NVFA_TexturaNube6                  = NVFA_DefaultTexturaNubeGeneral
// #declare NVFA_TexturaNube7                  = NVFA_DefaultTexturaNubeGeneral
// #declare NVFA_TexturaNube8                  = NVFA_DefaultTexturaNubeGeneral
// #declare NVFA_TexturaNube9                  = NVFA_DefaultTexturaNubeGeneral
// #declare NVFA_TexturaNube10                 = NVFA_DefaultTexturaNubeGeneral
//
// Para colocarlo simplemente
// #include "NVFA.inc"    
// global_settings { max_trace_level 10 }
// object        { NVFA_Nube1( off ) }
//  
// Para usar los modificadores.
// #include "NVFA.inc"   
// global_settings { max_trace_level 10 }   
// #declare NVFA_TexturaNube1   = 
//      texture { pigment { White } finish { ambient 0.8 diffuse 0.2 } }
// object        { NVFA_Nube1( off ) }
// 

#include "colors.inc"

#declare OjoAbsoluto            = 256;
#declare VecesCentroAbsoluto    = 10;     
#declare L                      = 0.001;
camera {
        location  <   0,  0, -( VecesCentroAbsoluto+1 )*OjoAbsoluto >*L
        direction z
        sky       y
        angle     38.74
//        look_at  <   0,  0, -VecesCentroAbsoluto*OjoAbsoluto >*L
} 
 
global_settings         {  
  max_trace_level       10
}          
background              {  
  SkyBlue
}

light_source    {
         < 500  , 500   , -3000 >*L
         White
}             

#include "NVFA.inc"    

object          {               
  NVFA_Nube1(off)       
  translate     10*z-2.2*x+2.2*y
} 
   
object          {               
  NVFA_Nube2(off)       
  translate     10*z+2.2*y
} 
  
object          {               
  NVFA_Nube3(off)       
  translate     10*z+2.2*x+2.2*y
} 

object          {               
  NVFA_Nube4(off)       
  translate     10*z-3.3*x 
}

object          {               
  NVFA_Nube5(off,0)       
  translate     10*z-1.1*x 
}  

object          {               
  NVFA_Nube6(off)       
  translate     10*z+1.1*x 
}
 
object          { 
  NVFA_Nube7(off)
  translate     10*z+3.3*x
}  
  
object          {               
  NVFA_Nube8(off,0.99,0)       
  translate     10*z-2.2*x-2.2*y
} 


object          {               
  NVFA_Nube9(off)       
  translate     10*z-2.2*y
}   

object          {               
  NVFA_Nube10(off,1.2)       
  translate     10*z+2.2*x-2.2*y
} 


