// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho... 12 marzo 2014
//
// NVFA NubeVolatilFractalAleatoria
// El archivo dibuja nubes 3D con volumen, poco flexibles.  Fueron disenadas,
// para evitar el uso de interior {}, cuando lo permitan los objetivos.                
// Simplemente son "fractales pintados y enrollados en el espacio". 
// Para evitar puntos negros deber elevar el valor de max_trace_level. 
// Ofrece diez modelos generados por combinacion de fractales y la funcion f_hetero_mf() 
// en "functions.inc", no es compatible con POVRay 3.1.  
//
// Considere que las nubes tienen un diametro aproximado de dos unidades PovRay.
// Usted puede elegir entre un limite sphere { 0, 1 } o box { -1, 1 }.
//
// Las macros generadoras son las siguientes.
//  
// #macro NVFA_Nube1( BoxSphere )                                        
// #macro NVFA_Nube2( BoxSphere )                                        
// #macro NVFA_Nube3( BoxSphere )                                        
// #macro NVFA_Nube4( BoxSphere )                                        
// #macro NVFA_Nube5( BoxSphere, VectorMovimiento )                                        
// #macro NVFA_Nube6( BoxSphere )                                        
// #macro NVFA_Nube7( BoxSphere )                                        
// #macro NVFA_Nube8( BoxSphere, NuevoThreshold, VectorMovimiento )                                        
// #macro NVFA_Nube9( BoxSphere )                                        
// #macro NVFA_Nube10( BoxSphere, NuevoThreshold )                                        
//      BoxSphere               : "on" utiliza box { -1, 1 } como limite,
//                                "off" utiliza sphere { 0, 1 } como limite.
//      NuevoThreshold          : Para modificar el valor theresfold de una isosurface, 
//              Recomendamos un valor de 0.99 para NVFA_Nube9() y de 1.2 para NVFA_Nube10().
//      VectorMovimiento        : Para desplazar el centro funcional de evaluacion.
//              En cumulos de nubes juntas, sirve para darle continuidad a los bloques.
//    
// La siguiente variable no deberia modificarse.
// #declare NVFA_DefaultTexturaNubeGeneral
//      Declara la textura por defecto de todas las nubes.
//                           
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default).
// Se trata de texturas, el numero indica la macro en que aplica. 
// Considere que al dibujar un fractal probablemente convenga elevar la variable ambient.
// #declare NVFA_TexturaNube1                  = NVFA_DefaultTexturaNubeGeneral
// #declare NVFA_TexturaNube2                  = NVFA_DefaultTexturaNubeGeneral
// #declare NVFA_TexturaNube3                  = NVFA_DefaultTexturaNubeGeneral
// #declare NVFA_TexturaNube4                  = NVFA_DefaultTexturaNubeGeneral
// #declare NVFA_TexturaNube5                  = NVFA_DefaultTexturaNubeGeneral
// #declare NVFA_TexturaNube6                  = NVFA_DefaultTexturaNubeGeneral
// #declare NVFA_TexturaNube7                  = NVFA_DefaultTexturaNubeGeneral
// #declare NVFA_TexturaNube8                  = NVFA_DefaultTexturaNubeGeneral
// #declare NVFA_TexturaNube9                  = NVFA_DefaultTexturaNubeGeneral
// #declare NVFA_TexturaNube10                 = NVFA_DefaultTexturaNubeGeneral
//
// Para colocarlo simplemente
// #include "NVFA.inc"    
// global_settings { max_trace_level 10 }
// object        { NVFA_Nube1( off ) }
//  
// Para usar los modificadores.
// #include "NVFA.inc"   
// global_settings { max_trace_level 10 }   
// #declare NVFA_TexturaNube1   = 
//      texture { pigment { White } finish { ambient 0.8 diffuse 0.2 } }
// object        { NVFA_Nube1( off ) }
// 

#include "functions.inc" 
#include "colors.inc"              
                        
#declare NVFA_DefaultTexturaNubeGeneral         =
  texture                       {
      pigment { 
        granite
        pigment_map     {
          [ 0.1 Clear ]
          [0.5 color White transmit 0.5] 
        }
      }                         
      finish          { 
        ambient       0.9 
        diffuse       0.1
      }
  }
  
#ifndef ( NVFA_TexturaNube1 )   
  #declare NVFA_TexturaNube1            = NVFA_DefaultTexturaNubeGeneral
#end                          
 
#ifndef ( NVFA_TexturaNube2 )   
  #declare NVFA_TexturaNube2            = NVFA_DefaultTexturaNubeGeneral
#end                       
   
#ifndef ( NVFA_TexturaNube3 )   
  #declare NVFA_TexturaNube3            = NVFA_DefaultTexturaNubeGeneral
#end                          
                    
#ifndef ( NVFA_TexturaNube4 )   
  #declare NVFA_TexturaNube4            = NVFA_DefaultTexturaNubeGeneral
#end                          
                    
#ifndef ( NVFA_TexturaNube5 )   
  #declare NVFA_TexturaNube5            = NVFA_DefaultTexturaNubeGeneral
#end                          
                    
#ifndef ( NVFA_TexturaNube6 )   
  #declare NVFA_TexturaNube6            = NVFA_DefaultTexturaNubeGeneral
#end                          
                    
#ifndef ( NVFA_TexturaNube7 )   
  #declare NVFA_TexturaNube7            = NVFA_DefaultTexturaNubeGeneral
#end                          
                    
#ifndef ( NVFA_TexturaNube8 )   
  #declare NVFA_TexturaNube8            = NVFA_DefaultTexturaNubeGeneral
#end                          
                    
#ifndef ( NVFA_TexturaNube9 )   
  #declare NVFA_TexturaNube9            = NVFA_DefaultTexturaNubeGeneral
#end                          
                    
#ifndef ( NVFA_TexturaNube10 )   
  #declare NVFA_TexturaNube10           = NVFA_DefaultTexturaNubeGeneral
#end                          
                    
                    
 
                    
#declare NVFA_FuncionMandel     = function { pattern { mandel 25 } }                        
                         
#macro NVFA_Nube1( BoxSphere )                                        
  union                         {   
    isosurface                { 
      function { NVFA_FuncionMandel(x,y,z)+0.6*f_hetero_mf(x,y,z, 1.1, 2.05, 15, 0.26, 0.01, 1) }
      threshold               0.99         
      open                   
      #if ( BoxSphere )
        contained_by    { box    {-3, 3 } } 
      #else       
        contained_by    { sphere { 0, 3 } } 
      #end  
      texture                   {
        NVFA_TexturaNube1
      }
      scale         1/3  
    }
  } 
#end 
                                   
#declare NVFA_FuncionJulia1     = function { pattern { julia < 0.353, 0.288>, 30 interior 1,1 turbulence 0.1 omega 2 lambda 2 } }                                   
                                   
                                   
#macro NVFA_Nube2( BoxSphere )                                        
  union                         {   
    isosurface                { 
      function { NVFA_FuncionJulia1(x,y,z)/0.4+0.6*f_hetero_mf(x,y,z, 1.1, 2.05, 15, 0.26, 0.01, 1) }
      threshold               1         
      open                          
      #if ( BoxSphere )
        contained_by    { box    {-3, 3 } } 
      #else       
        contained_by    { sphere { 0, 3 } } 
      #end  
      texture                   {
        NVFA_TexturaNube2
      }
      scale         1/3  
    }
  } 
#end   

#declare NVFA_FuncionJulia2     = function { pattern { magnet 2 julia < 0.453, 0.188>, 30 interior 1,1 } }                                   
                                   
                                   
#macro NVFA_Nube3( BoxSphere )                                        
  union                         {   
    isosurface                { 
      function { NVFA_FuncionJulia2(z,y,x)/0.4+NVFA_FuncionJulia2(x,y,z)/0.4+0.3*f_hetero_mf(x,y,z, 1.1, 2.05, 15, 0.26, 0.01, 1)
        +0.1*f_hetero_mf(20*x,20*y,20*z, 1.1, 2.05, 15, 0.26, 0.01, 1) }
      threshold               1.9        
      open                          
      #if ( BoxSphere )
        contained_by    { box    {-3, 3 } } 
      #else       
        contained_by    { sphere { 0, 3 } } 
      #end  
      texture                   {
        NVFA_TexturaNube3
      }
      scale         1/3  
    }
  } 
#end         
 
 
#declare NVFA_FuncionMandel2     = function { pattern { magnet 1 mandel 25 } }                        
                         
#macro NVFA_Nube4( BoxSphere )                                        
  union                         {   
    isosurface                { 
      function { NVFA_FuncionMandel2(z,y,x)+NVFA_FuncionMandel2(x,y,z)+0.6*f_hetero_mf(x,y,z, 1.1, 2.05, 15, 0.26, 0.01, 1) }
      threshold               1.9         
      open                          
      #if ( BoxSphere )
        contained_by    { box    {-3, 3 } } 
      #else       
        contained_by    { sphere { 0, 3 } } 
      #end  
      texture                   {
        NVFA_TexturaNube4
      }
      scale         1/3  
    }
  } 
#end 
                                   
#declare NVFA_FuncionCrackle     = function { pattern { crackle } }                        
                         
#macro NVFA_Nube5( BoxSphere, VectorMovimiento )                                        
  union                         {               
    #local PuntoA               = VectorMovimiento*<1,1,1>; 
    #local Ax                   = PuntoA.x;  
    #local Ay                   = PuntoA.y;
    #local Az                   = PuntoA.z;
    isosurface                { 
      function { NVFA_FuncionCrackle(x-Ax,8*( y-Ay ),z-Az)+
                  0.5*f_hetero_mf(x-Ax,y-Ay,z-Az, 1.1, 6.05, 15, 0.26, 0.01, 1) }
      threshold               0.8        
      open                          
      #if ( BoxSphere )
        contained_by    { box    {-3, 3 } } 
      #else       
        contained_by    { sphere { 0, 3 } } 
      #end  
      texture                   {
        NVFA_TexturaNube5
      }
      scale         1/3  
    }
    isosurface                { 
      function { NVFA_FuncionCrackle(4*( x-Ax ),12*( y-Ay ),4*( z-Az ) )
                  +0.3*f_hetero_mf(x-Ax,y-Ay,z-Az, 1.1, 6.05, 15, 0.26, 0.01, 1) }
      threshold               0.80        
      open                          
      #if ( BoxSphere )
        contained_by    { box    {-3, 3 } } 
      #else       
        contained_by    { sphere { 0, 3 } } 
      #end  
      texture                   {
        NVFA_TexturaNube5
      }
      scale         1/3  
    }
  } 
#end 

#declare NVFA_FuncionMandel3     = function { pattern { mandel 25 exponent 3 } }                        
                         
#macro NVFA_Nube6( BoxSphere )                                        
  union                         {   
    isosurface                { 
      function { NVFA_FuncionMandel3(x,y,z)+NVFA_FuncionMandel3(y,z,x)+0.6*f_hetero_mf(x,y,z, 1.1, 2.05, 15, 0.26, 0.01, 1) }
      threshold               1.9         
      open                   
      #if ( BoxSphere )
        contained_by    { box    {-3, 3 } } 
      #else       
        contained_by    { sphere { 0, 3 } } 
      #end  
      texture                   {
        NVFA_TexturaNube6
      }
      scale         1/3  
    }
  } 
#end

#declare NVFA_FuncionJulia3     = function { pattern { julia < 0.453, 0.188>, 30 exponent 3 interior 1,1 } }                                   
                                   
                                   
#macro NVFA_Nube7( BoxSphere )                                        
  union                         {   
    isosurface                { 
      function { NVFA_FuncionJulia3(z,y,x)/0.4+NVFA_FuncionJulia2(x,y,z)/0.4+0.4*f_hetero_mf(x,y,z, 1.1, 2.05, 15, 0.26, 0.01, 1)
        +0.3*f_hetero_mf(20*x,20*y,20*z, 1.1, 2.05, 15, 0.26, 0.01, 1) }
      threshold               1.99        
      open                          
      #if ( BoxSphere )
        contained_by    { box    {-3, 3 } } 
      #else       
        contained_by    { sphere { 0, 3 } } 
      #end  
      texture                   {
        NVFA_TexturaNube7
      }
      scale         1/3  
    }
  } 
#end  

                                   
#macro NVFA_Nube8( BoxSphere, NuevoThreshold, VectorMovimiento )                                        
  union                         {   
    #local PuntoA               = VectorMovimiento*<1,1,1>; 
    #local Ax                   = PuntoA.x;  
    #local Ay                   = PuntoA.y;
    #local Az                   = PuntoA.z;
    isosurface                { 
      function { 0.5*f_hetero_mf(x-Ax,4*(y-Ay),z-Az, 1.1, 2.05, 15, 0.26, 0.01, 1)
        +0.2*f_hetero_mf(20*(x-Ax),20*(y-Ax),20*(z-Az), 1.1, 2.05, 15, 0.26, 0.01, 1) }
      threshold               NuevoThreshold        
      open                          
      #if ( BoxSphere )
        contained_by    { box    {-3, 3 } } 
      #else       
        contained_by    { sphere { 0, 3 } } 
      #end  
      texture                   {
        NVFA_TexturaNube8
      }
      scale         1/3  
    }
  } 
#end   

#declare NVFA_FuncionJulia4     = function { pattern { julia < -0.600, -0.400>, 30 exponent 4 interior 1,1 } }                                   
                                   
                                   
#macro NVFA_Nube9( BoxSphere )                                        
  union                         {   
    isosurface                { 
      function { NVFA_FuncionJulia4(x,y,z)/0.4+NVFA_FuncionJulia4(z,y,x)/0.4+0.5*f_hetero_mf(x,y,z, 1.1, 2.05, 15, 0.26, 0.01, 1)
        +0.2*f_hetero_mf(20*x,20*y,20*z, 1.1, 2.05, 15, 0.26, 0.01, 1) }
      threshold               1.9       
      open                          
      #if ( BoxSphere )
        contained_by    { box    {-3, 3 } } 
      #else       
        contained_by    { sphere { 0, 3 } } 
      #end  
      texture                   {
        NVFA_TexturaNube9
      }
      scale         1/3  
    }
  } 
#end         
 
#declare NVFA_FuncionMandel4     = function { pattern { magnet 2 mandel 25 interior 2, 0.1 exterior 2, 0.1 } }                        
                         
#macro NVFA_Nube10( BoxSphere, NuevoThreshold )                                        
  union                         {   
    isosurface                {                                        
      function { NVFA_FuncionMandel4(x,y,z)+NVFA_FuncionMandel4(y,z,x) }
      threshold               NuevoThreshold         
      open                   
      #if ( BoxSphere )
        contained_by    { box    {-3, 3 } } 
      #else       
        contained_by    { sphere { 0, 3 } } 
      #end  
      texture                   {
        NVFA_TexturaNube10
      }
      scale         1/3  
    }
  } 
#end


       
 
 
                                   

                                   
 