// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  20 enero 2015
//                
// MMCE MedallaMetalCongresoEucaristico
// El archivo dibuja una medallita que la Iglesia puso a la venta con
// motivo del Congreso Eucaristico 2015 en Costa Rica.
// Gracias a las herramientas POVRay resulta muy simple de hacer.
// Posee una macro detallada que permite adaptar facilmente otros modelos.
// Es compatible con POVRay 3.1.
//
// La macro por defecto carece de parametros
// #macro MMCE_Medalla()
//                       
// La siguiente version de la macro, permite mucho mayor control.
// #macro MMCE_MedallaMetalCongresoEucaristico
//              ( VisibleArgolla, BanderaTexturaRelieve, 
//                ImagenFrontal, ImagenPosteriorEspejo, 
//                TexturaPrincipal, TexturaRelieve, TexturaArgolla ) 
//      VisibleArgolla          : "on" dibuja el aro para sujetar.
//              "off" no lo dibuja.  Valor "on" por defecto.
//      BanderaTexturaRelieve   : "on" aplica TexturaRelieve por diferencia.
//              Desgasta el relieve por diferencia para pintar el superior.  
//              Esta pensado para una
//              imagen simple de unos tres niveles, incluyendo el cero.
//              "off" no aplica.  Valor "on" por defecto.  
//      ImagenFrontal           : Imagen hacia Z-.  Debe ser un GIF, con valor
//              gris desde cero exacto como water_level en un
//              height_field.  La zona cero exacto debe calzar con 
//              ImagenPosteriorReflejo.  Valor MMCE_GIFFrontal por defecto.
//      ImagenPosteriorReflejo  : Imagen hacia Z+, visto como en un espejo.
//              El efecto espejo produce que la zona cero exacto corresponda
//              en ambas imagenes.  Valor MMCE_GIFPosteriorEspejo por defecto.
//      TexturaPrincipal        : Textura principal a aplicar a la medalla.
//              Valor MMCE_TexturaPrincipal por defecto.
//      TexturaRelieve          : Textura opcional que se aplica por diferencia
//              a los relieves cercanos a uno en el height_field.
//              Se ignora cuando BanderaTexturaRelieve es "off". 
//              Valor MMCE_TexturaRelieve por defecto.    
//      TexturaArgolla          : Textura que se aplica a la argolla.
//              Valor MMCE_TexturaArgolla por defecto.
//
// La medalla sin su argolla se encuentra contenida en una esfera 
// en el origen de radio 0.5.
// Su diametro aproximado es ligeramente mayor a unos 0.04 unidades POVRay.
//       
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare MMCE_DefaultTexturaPrincipal          
//      Textura principal de la medalla.
// #declare MMCE_DefaultTexturaRelieve         
//      Textura por diferencia para el relieve decorado mayor.
// #declare MMCE_DefaultTexturaArgolla         
//      Textura que se aplica a la argolla.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default) 
// #declare MMCE_GIFFrontal                     = "MMCE_IM1.gif"; 
//      Imagen que se aplica al frente Z-. 
// #declare MMCE_GIFPosteriorEspejo             = "MMCE_IM2.gif";   
//      Imagen que se aplica en zona posterior Z+ vista como
//      reflejo en un espejo.  De esta forma se logra calzar
//      la zona cero exacto como water_level en un height_field.
// #declare MMCE_TexturaPrincipal               = texture { ... }         
//      Textura principal de la medalla.
// #declare MMCE_TexturaRelieve                 = texture { ... }
//      Textura por diferencia para el relieve decorado mayor.
// #declare MMCE_TexturaArgolla                 = texture { ... }
//      Textura que se aplica a la argolla.
// #declare JFSG_POV3_1                         = off;
//      Valor "on" activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo simplemente
// #include "MMCE.inc"
// object        { MMCE_Medalla() }
//
// O bien con la macro detallada
// #include "MMCE.inc"
// object                        {
//   MMCE_MedallaMetalCongresoEucaristico( on, on, 
//        MMCE_GIFFrontal, MMCE_GIFPosteriorEspejo,  
//        MMCE_TexturaPrincipal, MMCE_TexturaRelieve, MMCE_TexturaArgolla )
// }
//
// O bien con modificadores:
// #include "MMCE.inc"                         
// #include "textures.inc"     
// #declare MMCE_TexturaPrincipal        =
//   texture            { 
//     average
//     texture_map      {    
//       [ 0.5 MMCE_DefaultTexturaPrincipal ]
//       [ 0.5 Rust ] 
//     }  
//   }
// object                       {
//   MMCE_Medalla()
// }
// 

#include "colors.inc"

#declare OjoAbsoluto            = 256;
#declare VecesCentroAbsoluto    = 10;     
#declare L                      = 0.001;
camera {
        location  <   0,  0, -( VecesCentroAbsoluto+1 )*OjoAbsoluto >*L
        direction z
        sky       y
        angle     38.74
//        look_at  <   0,  0, -VecesCentroAbsoluto*OjoAbsoluto >*L
}         
light_source    {
         < 500  , 500   , -3000 >*L
         White
}
background      {
         Gray50
}    

#include "MMCE.inc"
  
#declare FactorAcercamiento             = 0.90;  
  
union                           { 
  object                        {   
    MMCE_Medalla()                              
    translate                   +0.55*x
  }
  object                        {   
    MMCE_Medalla()               
    rotate                      180*y               
    translate                   -0.55*x
  }
  translate       -( VecesCentroAbsoluto+1 )*( FactorAcercamiento-1 )
                        /( FactorAcercamiento )*OjoAbsoluto*L*z 
}