// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  2 setiembre 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// LMUT LavatorioManualUniTermico
// El archivo dibuja un lavatorio domestico corriente de una via,
// muy poco flexible. 
// Ofrece una macro para cambiar las texturas.   
// Es compatible con POVRay 3.1.
//
// La macro principal tiene un unico parametro
// #macro LMUT_Lavatorio( AnguloPerilla )
//      AnguloPerilla           : Angulo para rotar la perilla de agua.
//
// La siguiente versin de la macro, permite un mayor control de las caracteristicas.
// #macro LMUT_LavatorioManualUniTermico( AnguloPerilla, 
//          TexturaCeramica, TexturaMetalTubo, TexturaTornillo, 
//          TexturaDesague, TexturaInteriorTubo )    
//      AnguloPerilla           : Angulo para rotar la perilla de agua.
//      TexturaCeramica         : Textura principal del lavatorio.
//              Default es LMUT_TexturaCeramica.
//      TexturaMetalTubo        : Textura del tubo para agua.
//              Default es LMUT_TexturaMetalTubo.
//      TexturaTornillo         : Textura del tornillo superior del tubo.
//              Default es LMUT_TexturaTornillo.
//      TexturaDesague          : Textura del tubo del desague.
//              Default es LMUT_TexturaDesague.
//      TexturaInteriorTubo     : Textura para el interior del desague.
//              Default es LMUT_TexturaInteriorTubo.
//
// El aparato por defecto tiene las siguientes dimensiones:      
//      Alto                            = -128*L..49*L
//      Frente en X                     = -162*L..162*L
//      Profundidad en Z                = -252*L (desde el plano)
// La base ceramica del lavatorio, puede considerarse en el plano YZ, excepto
// por una prominencia ligera al fondo.  Frente Z-, Gravedad Y-.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare LMUT_DefaultTexturaCeramica          
//      Textura principal del lavatorio.
// #declare LMUT_DefaultTexturaMetalTubo         
//      Textura del tubo para agua.
// #declare LMUT_DefaultTexturaTornillo          
//      Textura del tornillo superior del tubo.
// #declare LMUT_DefaultTexturaDesague          
//      Textura para el tubo del desague.
// #declare LMUT_DefaultTexturaInteriorTubo     
//      Textura para el interior del desague.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default) 
// #declare LMUT_TexturaCeramica                = texture { ... }          
//      Textura principal del lavatorio.
// #declare LMUT_TexturaMetalTubo               = texture { ... }
//      Textura del tubo para agua.
// #declare LMUT_TexturaTornillo                = texture { ... }
//      Textura del tornillo superior del tubo.
// #declare LMUT_TexturaDesague                 = texture { ... }
//      Textura para el tubo del desague.
// #declare LMUT_TexturaInteriorTubo            = texture { ... }
//      Textura para el interior del desague.
// #declare LMUT_POV3_1                         = off;
//      Valor "on" activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo simplemente
// #include "LMUT.inc"
// object        { LMUT_Lavatorio(10) }
//
// Otro ejemplo con la macro detallada:
// #include "LMUT.inc"   
// object                       { 
//   LMUT_LavatorioManualUniTermico( 10, LMUT_TexturaCeramica, 
//              LMUT_TexturaMetalTubo, LMUT_TexturaTornillo, 
//              LMUT_TexturaDesague, LMUT_TexturaInteriorTubo )
// }                   
//
// O bien con modificadores:
// #include "LMUT.inc"                         
// #include "textures.inc"
// #declare LMUT_TexturaCeramica  = PinkAlabaster
// object                       {
//   LMUT_Lavatorio( 10 )
// }
//

#include "colors.inc"
       
#declare OjoAbsoluto            = 256;
#declare VecesCentroAbsoluto    = 10;     
#declare L                      = 0.001;
camera {
        location  <   0,  0, -( VecesCentroAbsoluto+1 )*OjoAbsoluto >*L
        direction z
        sky       y
        angle     38.74
//        look_at  <   0,  0, -VecesCentroAbsoluto*OjoAbsoluto >*L
}         
light_source    {
         < 500  , 500   , -3000 >*L
         White
}
light_source    {
         < 500  ,-500   , -3000 >*L
         White
}
background      {
         Gray50
}
    
#include "LMUT.inc"

#declare FactorAcercamiento    = 4;

object                  { 
  LMUT_Lavatorio(10)
  translate       -( VecesCentroAbsoluto+1 )
         *( FactorAcercamiento-1 )/( FactorAcercamiento )*OjoAbsoluto*L*z           
}