// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  2 setiembre 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// LMUT LavatorioManualUniTermico
// El archivo dibuja un lavatorio domestico corriente de una via,
// muy poco flexible. 
// Ofrece una macro para cambiar las texturas.   
// Es compatible con POVRay 3.1.
//
// La macro principal tiene un unico parametro
// #macro LMUT_Lavatorio( AnguloPerilla )
//      AnguloPerilla           : Angulo para rotar la perilla de agua.
//
// La siguiente versin de la macro, permite un mayor control de las caracteristicas.
// #macro LMUT_LavatorioManualUniTermico( AnguloPerilla, 
//          TexturaCeramica, TexturaMetalTubo, TexturaTornillo, 
//          TexturaDesague, TexturaInteriorTubo )    
//      AnguloPerilla           : Angulo para rotar la perilla de agua.
//      TexturaCeramica         : Textura principal del lavatorio.
//              Default es LMUT_TexturaCeramica.
//      TexturaMetalTubo        : Textura del tubo para agua.
//              Default es LMUT_TexturaMetalTubo.
//      TexturaTornillo         : Textura del tornillo superior del tubo.
//              Default es LMUT_TexturaTornillo.
//      TexturaDesague          : Textura del tubo del desague.
//              Default es LMUT_TexturaDesague.
//      TexturaInteriorTubo     : Textura para el interior del desague.
//              Default es LMUT_TexturaInteriorTubo.
//
// El aparato por defecto tiene las siguientes dimensiones:      
//      Alto                            = -128*L..49*L
//      Frente en X                     = -162*L..162*L
//      Profundidad en Z                = -252*L (desde el plano)
// La base ceramica del lavatorio, puede considerarse en el plano YZ, excepto
// por una prominencia ligera al fondo.  Frente Z-, Gravedad Y-.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare LMUT_DefaultTexturaCeramica          
//      Textura principal del lavatorio.
// #declare LMUT_DefaultTexturaMetalTubo         
//      Textura del tubo para agua.
// #declare LMUT_DefaultTexturaTornillo          
//      Textura del tornillo superior del tubo.
// #declare LMUT_DefaultTexturaDesague          
//      Textura para el tubo del desague.
// #declare LMUT_DefaultTexturaInteriorTubo     
//      Textura para el interior del desague.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default) 
// #declare LMUT_TexturaCeramica                = texture { ... }          
//      Textura principal del lavatorio.
// #declare LMUT_TexturaMetalTubo               = texture { ... }
//      Textura del tubo para agua.
// #declare LMUT_TexturaTornillo                = texture { ... }
//      Textura del tornillo superior del tubo.
// #declare LMUT_TexturaDesague                 = texture { ... }
//      Textura para el tubo del desague.
// #declare LMUT_TexturaInteriorTubo            = texture { ... }
//      Textura para el interior del desague.
// #declare LMUT_POV3_1                         = off;
//      Valor "on" activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo simplemente
// #include "LMUT.inc"
// object        { LMUT_Lavatorio(10) }
//
// Otro ejemplo con la macro detallada:
// #include "LMUT.inc"   
// object                       { 
//   LMUT_LavatorioManualUniTermico( 10, LMUT_TexturaCeramica, 
//              LMUT_TexturaMetalTubo, LMUT_TexturaTornillo, 
//              LMUT_TexturaDesague, LMUT_TexturaInteriorTubo )
// }                   
//
// O bien con modificadores:
// #include "LMUT.inc"                         
// #include "textures.inc"
// #declare LMUT_TexturaCeramica  = PinkAlabaster
// object                       {
//   LMUT_Lavatorio( 10 )
// }
//
  
#include "LMUT_AU1.inc"  
#include "LMUT_AU2.inc"   
#include "stones.inc"
#include "metals.inc"   
 
#declare LMUT_L                         = 0.001; 
   
#declare LMUT_DefaultTexturaCeramica    =
  texture                               {  
    T_Stone17
  }                 
  
#ifndef ( LMUT_TexturaCeramica )        
  #declare LMUT_TexturaCeramica         = LMUT_DefaultTexturaCeramica
#end  // #ifndef ( LMUT_TexturaCeramica )

#declare LMUT_DefaultTexturaMetalTubo   =
  texture                               {                             
    T_Chrome_2B
    normal      {    
      bumps
      scale     0.1
    }
  }  
  
#ifndef ( LMUT_TexturaMetalTubo )        
  #declare LMUT_TexturaMetalTubo        = LMUT_DefaultTexturaMetalTubo
#end  // #ifndef ( LMUT_TexturaMetalTubo )        

#declare LMUT_DefaultTexturaTornillo           =
  texture                               {                            
    T_Silver_2B
    normal      {    
      bumps
      scale     0.001
    }  
  } 
  
#ifndef ( LMUT_TexturaTornillo )        
  #declare LMUT_TexturaTornillo         = LMUT_DefaultTexturaTornillo
#end  // #ifndef ( LMUT_TexturaTornillo )

#declare LMUT_DefaultTexturaDesague     =
  texture                               {
    T_Silver_2B
    normal      {    
      bumps
      scale     0.1
    }  
  }  

#ifndef ( LMUT_TexturaDesague )        
  #declare LMUT_TexturaDesague          = LMUT_DefaultTexturaDesague
#end  // #ifndef ( LMUT_TexturaDesague )
       
#declare LMUT_DefaultTexturaInteriorTubo        =       
  texture                               {
    T_Brass_2B
    normal      {    
      bumps     10
      scale     0.01
    }  
  }               
  
#ifndef ( LMUT_TexturaInteriorTubo )
  #declare LMUT_TexturaInteriorTubo     = LMUT_DefaultTexturaInteriorTubo
#end  // #ifndef ( LMUT_TexturaInteriorTubo )  
     
       
#macro LMUT_LavatorioManualUniTermico( AnguloPerilla, 
          TexturaCeramica, TexturaMetalTubo, TexturaTornillo, 
          TexturaDesague, TexturaInteriorTubo )    
  union                                 {              
    #local L                            = LMUT_L; 
    #local Frente                       = 321*L;
    #local Alto                         = 100*L;
    #local Profundidad                  = 263*L;    
    #local TamanoTubo                   = 25*L;  
    #local RadioTornillo                = 0.3*TamanoTubo;  
    #local RadioDesague                 = 35*L;
    union                               {              
      #local PuntoA                     = <300,0,-150>*L;
      #local PuntoB                     = <300,0,-450>*L;
      #local PuntoC                     = <600,0,-150>*L;
       
      difference                        { 
      intersection                      {
        object                          {   
          LMUT_SuperiorLavatorio               
          scale                         <1,1,1> 
          translate                     -0.5*y
          scale                         <L,Alto,-L>
          translate                     -PuntoA
        }       
        object                          {  
          LMUT_FrontalLavatorio     
          scale                         <1,0.5,1>
          translate                     -0.5*y
          scale                         <L,Profundidad,-L>
          translate                     -PuntoB   
          rotate                        -90*x 
          translate                     -Profundidad*z
          
        }
        object                          { 
          LMUT_LateralLavatorio 
          scale                         <1,0.5,1>
          translate                     -0.5*y
          scale                         <L,Frente,-L>
          translate                     -PuntoC
          rotate                        -90*z   
          translate                     Frente/2*x
        } 
      }
      intersection                      {  
        object                          {   
          LMUT_VacioLavatorioSuperior               
          scale                         <1,1,1> 
          translate                     -0.5*y
          scale                         <L,Alto,-L>
          translate                     -PuntoA
        }       
        object                          {  
          LMUT_VacioLavatorioFrontal     
          scale                         <1,0.5,1>
          translate                     -0.5*y
          scale                         <L,Profundidad,-L>
          translate                     -PuntoB   
          rotate                        -90*x 
          translate                     -Profundidad*z
        }
        object                          { 
          LMUT_VacioLavatorioLateral 
          scale                         <1,0.5,1>
          translate                     -0.5*y
          scale                         <L,Frente,-L>
          translate                     -PuntoC
          rotate                        -90*z   
          translate                     Frente/2*x
        } 
      }       
        #local C                        = 0;
        #while ( C < 2 )                      
          cylinder                      {   
            0, +Profundidad*z, 0.050*Alto
            translate                   +0.10*Frente*x-0.25*Alto*y
            #if ( C = 0 )        
              scale                     <-1,1,1>
            #end  // #if ( C = 0 )
            translate                     -Profundidad*107/263*z          
          }
          #local C                      = C+1;
        #end  // #while ( C < 2 )
        superellipsoid                  {   
          <0.75,0.75>
          scale                 1.2*RadioDesague
          scale                         <1,0.2,1> 
          translate                       -0.75*Alto*y
          translate                     -Profundidad*107/263*z          
        }
        superellipsoid                  {   
          <0.75,0.75>
          scale                 1.1*RadioDesague
          scale                         <1,0.1,1> 
          translate                       -0.80*Alto*y
          translate                     -Profundidad*107/263*z          
        }  
        cylinder                        {   
          0, -Alto*y, 0.7*RadioDesague
          translate                     -Profundidad*107/263*z          
          texture                       {  
            TexturaInteriorTubo
          }          
        }
      }  // difference principal
      difference                        { 
        object                          {  
          LMUT_TuboCeramico           
          scale                         <2,-1,2>*L 
          translate                     -PuntoB.z*y
          translate                     -Profundidad*107/263*z
        }  
        cylinder                        {   
          0, -Alto*y, 0.7*RadioDesague
          translate                     -Profundidad*107/263*z          
          texture                       {  
            TexturaInteriorTubo
          }          
        }
        cylinder                        {   
          0,-Alto*0.9*y,Frente/2
        } 
      } 
      // Desague
      difference                        {   
        cylinder                        {
          0, -0.1*Alto*y, RadioDesague
        }
        cylinder                        {   
          0.05*Alto*y, -0.11*Alto*y, 0.66*RadioDesague
        }                                                
        translate                       -0.80*Alto*y
        translate                     -Profundidad*107/263*z
        texture                         {  
          TexturaDesague
        }
      }       
      texture                           {    
        TexturaCeramica
      }
    } 
    // Tubo sin perilla
    union                               {    
      difference                        {    
        object                          {   
          LMUT_TuboBlob
          scale                 1/2
          scale                 TamanoTubo  
          rotate                90*y  
          translate             -107*Profundidad/263*z
          translate             2.5*TamanoTubo*z
        }    
        cylinder                        {   
          0, 0.5*TamanoTubo*y, 0.5*TamanoTubo
          translate             -107*Profundidad/263*z  
          translate             -0.5*TamanoTubo*z
        }
        texture                         { 
          TexturaMetalTubo
        }
      } 
      // Perilla  
      union                             {   
        difference                      {
          sphere                            {
            0, RadioTornillo                          
            scale                       <0,0.05,0>                                
          }                                          
          #local C                      = 0;
          #while ( C < 4 )                   
            box                         {   
              <-0.1,-2,-2>*RadioTornillo,
              <+0.1, 2, 2>*RadioTornillo  
              rotate                    45*C
            }
            #local C                    = C+1;
          #end  // #while ( C < 4 )
          translate                     1.90*TamanoTubo*y
          texture                       {  
            TexturaTornillo
          }                           
        }
        difference                        { 
          union                           {    
            cone                          {   
              0, 0.375*TamanoTubo
              1.8*TamanoTubo*y, 0.75*TamanoTubo
            }    
            sphere                        { 
              0, 0.75*TamanoTubo
              scale                       <1,0.2,1>
              translate                   1.8*TamanoTubo*y              
            }
          }  
          sphere                                {   
            2*TamanoTubo*y, 1.1*RadioTornillo
          }
          #local C                        = 0;
          #while ( C < 5 )                     
            cylinder                      {  
              1.1*1.8*TamanoTubo*y+1.1*0.75*TamanoTubo*z,
              0.375*TamanoTubo*z,
              0.20*TamanoTubo
              rotate                      C*360/5*y
            }  
            #local C                      = C+1;
          #end  // #while ( C < 5 )
          cylinder                        {   
            0, 0.75*TamanoTubo*y, TamanoTubo
          } 
          texture                         {   
            TexturaMetalTubo
          }
        }
        rotate                          AnguloPerilla*y  
        translate             -107*Profundidad/263*z
        translate             2.5*TamanoTubo*z
      }  
    }
  }
#end  // #macro LMUT_LavatorioManualUniTermico

#macro LMUT_Lavatorio(AnguloPerilla)
  object                                { 
    LMUT_LavatorioManualUniTermico( AnguloPerilla, 
      LMUT_TexturaCeramica, LMUT_TexturaMetalTubo,
      LMUT_TexturaTornillo, LMUT_TexturaDesague,
      LMUT_TexturaInteriorTubo )
  }
#end  // #macro
