// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  16 setiembre 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// JFSG JoystickForSomeGames
// El archivo dibuja un joystick para juegos de computadora.   
// Se utilizo el programa Epspline.exe para la estructura principal. 
// No se dibujaron los cables o puede considerarlo inhalambrico si lo prefiere.
// Permite redefinir las texturas.
// Es compatible con POVRay 3.1.
//
// La macro carece de parametros
// #macro JFSG_JoystickForSomeGames()
//
// El aparato por defecto tiene las siguientes dimensiones:      
// Altura Y             = + 1*L..-45*L en Y
// Frente X             = 108*L  
// Profundidad Z        = -78*L (desde el plano)
// El joystick se dibuja de "espaldas" a un jugador que mire desde el eje Z-
// hacia el origen, con gravedad Y-.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare JFSG_DefaultTexturaPrincipal          
//      Textura principal del joystick.
// #declare JFSG_DefaultTexturaBotones         
//      Textura de los botones.
// #declare JFSG_DefaultTexturaBotonesLaterales          
//      Textura de los botones laterales.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default) 
// #declare JFSG_TexturaPrincipal               = texture { ... }          
//      Textura principal del joystick.
// #declare JFSG_TexturaBotones                 = texture { ... }
//      Textura de los botones.
// #declare JFSG_TexturaBotonesLaterales        = texture { ... }
//      Textura de los botones laterales.
// #declare JFSG_POV3_1                         = off;
//      Valor "on" activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo simplemente
// #include "JSFG.inc"
// object        { JFSG_JoystickForSomeGames() }
//
// O bien con modificadores:
// #include "JFSG.inc"                         
// #include "textures.inc"     
// #declare JFSG_TexturaPrincipal        =
//   texture            { 
//     average
//     texture_map      {    
//       [ 0.5 JFSG_DefaultTexturaPrincipal ]
//       [ 0.5 Rust ] 
//     }  
//   }
// object                       {
//   JFSG_JoystickForSomeGames()
// }
//
#include "colors.inc"

#declare OjoAbsoluto            = 256;
#declare VecesCentroAbsoluto    = 10;     
#declare L                      = 0.001;
camera {
        location  <   0,  0, -( VecesCentroAbsoluto+1 )*OjoAbsoluto >*L
        direction z
        sky       y
        angle     38.74
//        look_at  <   0,  0, -VecesCentroAbsoluto*OjoAbsoluto >*L
}         
light_source    {
         < 500  , 500   , -3000 >*L
         White
}
light_source    {
         <-500  ,-500   , -3000 >*L
         White
}
background      {
         Gray50
}    

#include "JFSG.inc"
  
#declare FactorAcercamiento             = 12;  
  
object                  {  
  JFSG_JoystickForSomeGames() 
  translate             +0.035*z    
  rotate          -90*x          
  translate       -( VecesCentroAbsoluto+1 )*( FactorAcercamiento-1 )
                        /( FactorAcercamiento )*OjoAbsoluto*L*z  
}