// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  16 setiembre 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// JFSG JoystickForSomeGames
// El archivo dibuja un joystick para juegos de computadora.   
// Se utilizo el programa Epspline.exe para la estructura principal. 
// No se dibujaron los cables o puede considerarlo inhalambrico si lo prefiere.
// Permite redefinir las texturas.
// Es compatible con POVRay 3.1.
//
// La macro carece de parametros
// #macro JFSG_JoystickForSomeGames()
//
// El aparato por defecto tiene las siguientes dimensiones:      
// Altura Y             = + 1*L..-45*L en Y
// Frente X             = 108*L  
// Profundidad Z        = -78*L (desde el plano)
// El joystick se dibuja de "espaldas" a un jugador que mire desde el eje Z-
// hacia el origen, con gravedad Y-.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare JFSG_DefaultTexturaPrincipal          
//      Textura principal del joystick.
// #declare JFSG_DefaultTexturaBotones         
//      Textura de los botones.
// #declare JFSG_DefaultTexturaBotonesLaterales          
//      Textura de los botones laterales.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default) 
// #declare JFSG_TexturaPrincipal               = texture { ... }          
//      Textura principal del joystick.
// #declare JFSG_TexturaBotones                 = texture { ... }
//      Textura de los botones.
// #declare JFSG_TexturaBotonesLaterales        = texture { ... }
//      Textura de los botones laterales.
// #declare JFSG_POV3_1                         = off;
//      Valor "on" activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//      En este archivo no cumple ninguna funcion.
//
// Para colocarlo simplemente
// #include "JSFG.inc"
// object        { JFSG_JoystickForSomeGames() }
//
// O bien con modificadores:
// #include "JFSG.inc"                         
// #include "textures.inc"     
// #declare JFSG_TexturaPrincipal        =
//   texture            { 
//     average
//     texture_map      {    
//       [ 0.5 JFSG_DefaultTexturaPrincipal ]
//       [ 0.5 Rust ] 
//     }  
//   }
// object                       {
//   JFSG_JoystickForSomeGames()
// }
//
  
#include "JFSG_AU1.inc"  
#include "stones.inc"
 
#declare JFSG_L                         = 0.001;  
 
#if ( version < 3.2 )
  #ifndef( JFSG_POV3_1 )
    #declare JFSG_POV3_1        = on;
  #end
#else
  #ifndef( JFSG_POV3_1 )
    #declare JFSG_POV3_1        = off;
  #end
#end
                      
 
#declare JFSG_DefaultTexturaPrincipal   = 
texture       {  
  T_Grnt16
}
texture         {  
  pigment       { color White transmit 0.5 }
}

#ifndef ( JFSG_TexturaPrincipal )        
  #declare JFSG_TexturaPrincipal        = JFSG_DefaultTexturaPrincipal
#end  // #ifndef ( JFSG_TexturaPrincipal )
 
#declare JFSG_DefaultTexturaBotones   = texture       {
  T_Stone41  
}

#ifndef ( JFSG_TexturaBotones )        
  #declare JFSG_TexturaBotones        = JFSG_DefaultTexturaBotones
#end  // #ifndef ( JFSG_TexturaPrincipal )
               
#declare JFSG_DefaultTexturaBotonesLaterales   = texture       { 
  T_Stone41
}          
texture                         {   
 pigment                {     
   color Black transmit 0.75 
 }
}

#ifndef ( JFSG_TexturaBotonesLaterales )        
  #declare JFSG_TexturaBotonesLaterales        = JFSG_DefaultTexturaBotonesLaterales
#end  // #ifndef ( JFSG_TexturaPrincipal )
               
               
#macro JFSG_JoystickForSomeGames()
  union                                 {              
    #local L                            = JFSG_L; 
    #local Frente                       = 440*L;
    #local Alto                         = 195*L;
    #local Profundidad                  = 320*L;  
    #local FrenteVerdadero              = 108*L;   
    #local AltoVerdadero                = Alto*FrenteVerdadero/Frente;
    #local ProfundidadVerdadero         = Profundidad*FrenteVerdadero/Frente;  
    #local Boton1                       = <0.200,0,-0.25>;
    #local Boton2                       = <0.200,0,-0.50>;
    #local Boton3                       = <0.125,0,-0.375>;
    #local Boton4                       = <0.275,0,-0.375>;
    #local BotonGrande                  = <-0.200,0,-0.375>;  
    #local BotonLateral1                = <0.250,-0.200,-0.050>;
    #local BotonLateral2                = <0.250,-0.400,-0.050>;
    #local UbicarBoton        = <FrenteVerdadero,AltoVerdadero,ProfundidadVerdadero>; 
    #local FactorRadioBoton             = 0.085;
    #local FactorRadioBotonExtra        = 0.10;   
    #local FactorRadioBotonGrande       = 0.185;
    #local FactorRadioBotonGrandeExtra  = 0.20;   
    #local FactorSuper                  = 1.1;
    union                               {              
      #local PuntoA                     = <300,0,-150>*L;
      #local PuntoB                     = <300,0,-450>*L;
      #local PuntoC                     = <600,0,-150>*L;
       
      #declare EstructuraBase           =
        intersection                      {
          object                          {   
            JFSG_JoystickSuperior               
            scale                         <1,1,1> 
            translate                     -0.5*y
            scale                         <L,Alto,-L>
            translate                     -PuntoA
          }       
          object                          {  
            JFSG_JoystickFrontal     
            scale                         <1,0.5,1>
            translate                     -0.5*y
            scale                         <L,Profundidad,-L>
            translate                     -PuntoB   
            rotate                        -90*x 
            translate                     -Profundidad*z
          
          }
          object                          { 
            JFSG_JoystickLateral 
            scale                         <1,0.5,1>
            translate                     -0.5*y
            scale                         <L,Frente,-L>
            translate                     -PuntoC
            rotate                        -90*z   
            translate                     Frente/2*x
          }  
          scale                 FrenteVerdadero/Frente
        }     
      union                     {  
        difference              {
          object                  {   
            EstructuraBase
          }    
          cylinder                      {    
            0, -y, 1
            scale               FactorRadioBotonExtra*AltoVerdadero
            translate               Boton1*UbicarBoton 
          }
          cylinder                      {    
            0, -y, 1
            scale               FactorRadioBotonExtra*AltoVerdadero
            translate               Boton2*UbicarBoton 
          }
          cylinder                      {    
            0, -y, 1
            scale               FactorRadioBotonExtra*AltoVerdadero
            translate               Boton3*UbicarBoton 
          }
          cylinder                      {    
            0, -y, 1
            scale               FactorRadioBotonExtra*AltoVerdadero
            translate               Boton4*UbicarBoton 
          }
          cylinder                      {    
            0, -y, 1
            scale               FactorRadioBotonGrandeExtra*AltoVerdadero
            translate               BotonGrande*UbicarBoton 
          }
          superellipsoid          {     
            <0.5,0.1>  
            rotate                90*z
            scale                 
              FactorSuper*<0.2*FrenteVerdadero,0.07*AltoVerdadero,0.2*ProfundidadVerdadero> 
            translate             BotonLateral1*UbicarBoton*<1,0,1>
            matrix              <1,0,0,
                                 0,1,0,
                                 0,0.3,1,0,0,0>
            translate             BotonLateral1*UbicarBoton*<0,1,0>
          }
          superellipsoid          {     
            <0.5,0.1>  
            rotate                90*z
            scale                 
              FactorSuper*<0.2*FrenteVerdadero,0.07*AltoVerdadero,0.2*ProfundidadVerdadero> 
            translate             BotonLateral1*UbicarBoton*<-1,0,1>
            matrix              <1,0,0,
                                 0,1,0,
                                 0,0.3,1,0,0,0>
            translate             BotonLateral1*UbicarBoton*<0,1,0>
          }
          superellipsoid          {     
            <0.5,0.1>  
            rotate                90*z
            scale                 
              FactorSuper*<0.2*FrenteVerdadero,0.07*AltoVerdadero,0.2*ProfundidadVerdadero> 
            translate             BotonLateral2*UbicarBoton*<1,0,1>
            matrix              <1,0,0,
                                 0,1,0,
                                 0,0.3,1,0,0,0>
            translate             BotonLateral2*UbicarBoton*<0,1,0>
          }
          superellipsoid          {     
            <0.5,0.1>  
            rotate                90*z
            scale                 
              FactorSuper*<0.2*FrenteVerdadero,0.07*AltoVerdadero,0.2*ProfundidadVerdadero> 
            translate             BotonLateral2*UbicarBoton*<-1,0,1>
            matrix              <1,0,0,
                                 0,1,0,
                                 0,0.3,1,0,0,0>
            translate             BotonLateral2*UbicarBoton*<0,1,0>
          }
          object                  {  
            EstructuraBase       
            scale               <1.1,1,1.1>
            translate -0.25*y*AltoVerdadero
          }                      
        }  
        difference              { 
          object                  {   
            EstructuraBase
            scale         <0.975,1,0.975>
          }                        
          cylinder                      {    
            0, -y, 1
            scale               FactorRadioBotonExtra*AltoVerdadero
            translate               Boton1*UbicarBoton 
          }
          cylinder                      {    
            0, -y, 1
            scale               FactorRadioBotonExtra*AltoVerdadero
            translate               Boton2*UbicarBoton 
          }
          cylinder                      {    
            0, -y, 1
            scale               FactorRadioBotonExtra*AltoVerdadero
            translate               Boton3*UbicarBoton 
          }
          cylinder                      {    
            0, -y, 1
            scale               FactorRadioBotonExtra*AltoVerdadero
            translate               Boton4*UbicarBoton 
          }
          cylinder                      {    
            0, -y, 1
            scale               FactorRadioBotonGrandeExtra*AltoVerdadero
            translate               BotonGrande*UbicarBoton 
          }
          superellipsoid          {     
            <0.5,0.1>  
            rotate                90*z
            scale                 
              FactorSuper*<0.2*FrenteVerdadero,0.07*AltoVerdadero,0.2*ProfundidadVerdadero> 
            translate             BotonLateral1*UbicarBoton*<1,0,1>
            matrix              <1,0,0,
                                 0,1,0,
                                 0,0.3,1,0,0,0>
            translate             BotonLateral1*UbicarBoton*<0,1,0>
          }
          superellipsoid          {     
            <0.5,0.1>  
            rotate                90*z
            scale                 
              FactorSuper*<0.2*FrenteVerdadero,0.07*AltoVerdadero,0.2*ProfundidadVerdadero> 
            translate             BotonLateral1*UbicarBoton*<-1,0,1>
            matrix              <1,0,0,
                                 0,1,0,
                                 0,0.3,1,0,0,0>
            translate             BotonLateral1*UbicarBoton*<0,1,0>
          }
          superellipsoid          {     
            <0.5,0.1>  
            rotate                90*z
            scale                 
              FactorSuper*<0.2*FrenteVerdadero,0.07*AltoVerdadero,0.2*ProfundidadVerdadero> 
            translate             BotonLateral2*UbicarBoton*<1,0,1>
            matrix              <1,0,0,
                                 0,1,0,
                                 0,0.3,1,0,0,0>
            translate             BotonLateral2*UbicarBoton*<0,1,0>
          }
          superellipsoid          {     
            <0.5,0.1>  
            rotate                90*z
            scale                 
              FactorSuper*<0.2*FrenteVerdadero,0.07*AltoVerdadero,0.2*ProfundidadVerdadero> 
            translate             BotonLateral2*UbicarBoton*<-1,0,1>
            matrix              <1,0,0,
                                 0,1,0,
                                 0,0.3,1,0,0,0>
            translate             BotonLateral2*UbicarBoton*<0,1,0>
          }
        }
        object                  {   
          EstructuraBase            
          scale                 0.90
          translate             -0.05*AltoVerdadero*(y+3.25*z)
        }
      }              
      texture                   {    
        JFSG_TexturaPrincipal
      }
    }  
    union                       {                 
      #local UnBotonRedondo     =
        union                   {  
          sphere                {  
            0, 1
            scale               <1,0.1,1>
          }  
          cylinder              {       
            0, -y, 1
          }         
          scale                 FactorRadioBoton*AltoVerdadero
        }
      #local UnBotonGrande      =  
        union                   {  
          cylinder              {       
            0, -y, 1
          } 
          intersection          {   
            cylinder            {  
              0, y, 1
            }    
            union               {    
            #local C            = 0;
              #while ( C < 4 )   
                difference       {       
                  cone              { 
                    0, 0.25
                    x, 1   
                    scale         <0,0.1,0>
                  }
                  cylinder              {   
                    0, x, 0.05
                    translate           0.1*y
                  }
                  rotate                C*90*y                 
                }
                #local C          = C+1;
              #end  // #while ( C < 4 )
            }
          }        
          scale                 FactorRadioBotonGrande*AltoVerdadero
        }  
      object                    {   
        UnBotonRedondo
        translate               Boton1*UbicarBoton 
      }
      object                    {   
        UnBotonRedondo
        translate               Boton2*UbicarBoton 
      }
      object                    {   
        UnBotonRedondo
        translate               Boton3*UbicarBoton 
      }
      object                    {   
        UnBotonRedondo
        translate               Boton4*UbicarBoton 
      }
      object                    {       
        UnBotonGrande
        translate               BotonGrande*UbicarBoton
      }   
      texture                   { 
        JFSG_TexturaBotones
      }
    }
    union                       {    
      intersection              { 
        union                   {  
          superellipsoid          {     
            <0.5,0.1>  
            rotate                90*z
            scale                 
              <0.2*FrenteVerdadero,0.07*AltoVerdadero,0.2*ProfundidadVerdadero> 
            translate             BotonLateral1*UbicarBoton*<1,0,1>
            matrix              <1,0,0,
                                 0,1,0,
                                 0,0.3,1,0,0,0>
            translate             BotonLateral1*UbicarBoton*<0,1,0>
          }
          superellipsoid          {     
            <0.5,0.1>  
            rotate                90*z
            scale                 
              <0.2*FrenteVerdadero,0.07*AltoVerdadero,0.2*ProfundidadVerdadero> 
            translate             BotonLateral1*UbicarBoton*<-1,0,1>
            matrix              <1,0,0,
                                 0,1,0,
                                 0,0.3,1,0,0,0>
            translate             BotonLateral1*UbicarBoton*<0,1,0>
          }
          superellipsoid          {     
            <0.5,0.1>  
            rotate                90*z
            scale                 
              <0.2*FrenteVerdadero,0.07*AltoVerdadero,0.2*ProfundidadVerdadero> 
            translate             BotonLateral2*UbicarBoton*<1,0,1>
            matrix              <1,0,0,
                                 0,1,0,
                                 0,0.3,1,0,0,0>
            translate             BotonLateral2*UbicarBoton*<0,1,0>
          }
          superellipsoid          {     
            <0.5,0.1>  
            rotate                90*z
            scale                 
              <0.2*FrenteVerdadero,0.07*AltoVerdadero,0.2*ProfundidadVerdadero> 
            translate             BotonLateral2*UbicarBoton*<-1,0,1>
            matrix              <1,0,0,
                                 0,1,0,
                                 0,0.3,1,0,0,0>
            translate             BotonLateral2*UbicarBoton*<0,1,0>
          }
        }
        object                  {    
          EstructuraBase
        }               
        translate               +0.01*ProfundidadVerdadero*z
      }
      texture                   { 
        JFSG_TexturaBotonesLaterales
      }
    }
  }  
#end  // #macro JFSG_JoystickForSomeGames               
   
