// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  26 marzo 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// TCFM TijerasCortantesFiloMetalico 
// El archivo dibuja unas tijersa sencillas.  Lamentablemente es muy
// poco flexible.  Es compatible con POVRay 3.1.
//
// La macro tiene unicamente un parametro
// #macro TCFM_Tijeras( FraccionApertura )
//      FraccionApertura        : Fraccin entre 0.0 para cerrado, y 1.0
//              para un angulo de apetura de 115 grados totales.
//
// La tijera cerrada se puede encerrar en la region:
//      PuntoMinimo             = <-53,-23,-3>*L
//      PuntoMaximo             = < 78, 22, 3>*L
// El frente sobresale en direccion X+.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.     
// #declare TCFM_CentroRotacion
//      Ubica como un vector de componente z nulo el centro de rotacion.
//      Se genera al llamar a la macro principal.
// #declare TPPR_DefaultTexturaPrincipalTijera
//      Textura principal del objeto.
// #declare TPPR_DefaultTexturaFiloTijera
//      Textura para la cara interior de la tijera.
// #declare TPPR_DefaultTexturaMangoTijera       
//      Textura para el mango de la tijera.
// #declare TPPR_DefaultTexturaOjoTijera   
//      Textura para los ojos de la tijera.
// #declare TPPR_DefaultTexturaTornillo    
//      Textura para el tornillo.
// #declare TPPR_DefaultTexturaDiferenciaMetalica 
//      Textura para aplicar por diferencia a algunas zonas de la tijera,
//      para dar un poco de variedad.
// #declare TCFM_DefaultTexturaMarca 
//      Textura a aplicar al nombre de marca.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default)
// #declare TCFM_StringMarca                            = "POVRay" 
//      Nombre de la marca de la tijera.
// #declare TCFM_FactorMarca                            = 1; 
//      Aplica un scale adicional al nombre de la marca.
// #declare TCFM_VectorMarca                            = <0,0,0>;
//      Aplica un translate final al nombre de marca.  Para corregir
//      defectos en la ubicacion del nombre en la cara Z-.
// #declare TCFM_VectorMarca2                           = <0,0,0>;    
//      Aplica un translate final al nombre de marca.  Para corregir
//      defectos en la ubicacion del nombre en la cara Z+.
// #declare TCFM_TexturaPrincipalTijera                 = texture { ... }
//      Textura principal del objeto.
// #declare TCFM_TexturaFiloTijera                      = texture { ... }
//      Textura para la cara interior de la tijera.
// #declare TCFM_TexturaMangoTijera                     = texture { ... }      
//      Textura para el mango de la tijera.
// #declare TCFM_TexturaOjoTijera                       = texture { ... } 
//      Textura para los ojos de la tijera.
// #declare TCFM_TexturaTornillo                        = texture { ... }   
//      Textura para el tornillo.                                   
// #declare TCFM_TexturaDiferenciaMetalica              = texture { ... }
//      Textura para aplicar por diferencia a algunas zonas de la tijera,
//      para dar un poco de variedad.
// #declare TCFM_TexturaMarca                           = texture { ... }
//      Textura a aplicar al nombre de marca.
// #declare TCFM_POV3_1                                 = off;
//      Valor on activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente.
//
// Para colocarlo simplemente
// #include "TCFM.inc"
// object        { TCFM_Tijeras( 0.0 ) }
//
// Otro ejemplo con modificador
// #include "TCFM.inc"
// #declare TCFM_TexturaPrincipalTijeras        = texture       {
//   average
//   texture_map        {
//     [ 0.5 TCFM_DefaultTexturaPrincipalTijeras ]
//     [ 0.5 Rust                                ]
//   }
// }
// object        {
//   TCFM_Tijeras( 0.0 )
// }
//

#include "colors.inc"

#declare EjeMejorado            = true;
#declare OjoAbsoluto            = 256;
#declare VecesCentroAbsoluto    = 10;     
#declare L                      = 0.001;
camera {
        location  <   0,  0, -( VecesCentroAbsoluto+1 )*OjoAbsoluto >*L
        direction z
        sky       y
        angle     38.74
//        look_at  <   0,  0, -VecesCentroAbsoluto*OjoAbsoluto >*L
}         
light_source    {
         < 500  , 500   , -3000 >*L
         White
}  
background      {
         Gray50
}    

#include "TCFM.inc"

#local   FactorAcercamiento     = 12;

object                          {
  TCFM_Tijeras( 0.5 )  
  translate             -0.015*x
  translate       -( VecesCentroAbsoluto+1 )*( FactorAcercamiento-1 )
                        /( FactorAcercamiento )*OjoAbsoluto*L*z
}





