// This file is licensed under the terms of the CC-LGPL.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho...  26 marzo 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// TCFM TijerasCortantesFiloMetalico 
// El archivo dibuja unas tijersa sencillas.  Lamentablemente es muy
// poco flexible.  Es compatible con POVRay 3.1.
//
// La macro tiene unicamente un parametro
// #macro TCFM_Tijeras( FraccionApertura )
//      FraccionApertura        : Fraccin entre 0.0 para cerrado, y 1.0
//              para un angulo de apetura de 115 grados totales.
//
// La tijera cerrada se puede encerrar en la region:
//      PuntoMinimo             = <-53,-23,-3>*L
//      PuntoMaximo             = < 78, 22, 3>*L
// El frente sobresale en direccion X+.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.     
// #declare TCFM_CentroRotacion
//      Ubica como un vector de componente z nulo el centro de rotacion.
//      Se genera al llamar a la macro principal.
// #declare TPPR_DefaultTexturaPrincipalTijera
//      Textura principal del objeto.
// #declare TPPR_DefaultTexturaFiloTijera
//      Textura para la cara interior de la tijera.
// #declare TPPR_DefaultTexturaMangoTijera       
//      Textura para el mango de la tijera.
// #declare TPPR_DefaultTexturaOjoTijera   
//      Textura para los ojos de la tijera.
// #declare TPPR_DefaultTexturaTornillo    
//      Textura para el tornillo.
// #declare TPPR_DefaultTexturaDiferenciaMetalica 
//      Textura para aplicar por diferencia a algunas zonas de la tijera,
//      para dar un poco de variedad.
// #declare TCFM_DefaultTexturaMarca 
//      Textura a aplicar al nombre de marca.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default)
// #declare TCFM_StringMarca                            = "POVRay" 
//      Nombre de la marca de la tijera.
// #declare TCFM_FactorMarca                            = 1; 
//      Aplica un scale adicional al nombre de la marca.
// #declare TCFM_VectorMarca                            = <0,0,0>;
//      Aplica un translate final al nombre de marca.  Para corregir
//      defectos en la ubicacion del nombre en la cara Z-.
// #declare TCFM_VectorMarca2                           = <0,0,0>;    
//      Aplica un translate final al nombre de marca.  Para corregir
//      defectos en la ubicacion del nombre en la cara Z+.
// #declare TCFM_TexturaPrincipalTijera                 = texture { ... }
//      Textura principal del objeto.
// #declare TCFM_TexturaFiloTijera                      = texture { ... }
//      Textura para la cara interior de la tijera.
// #declare TCFM_TexturaMangoTijera                     = texture { ... }      
//      Textura para el mango de la tijera.
// #declare TCFM_TexturaOjoTijera                       = texture { ... } 
//      Textura para los ojos de la tijera.
// #declare TCFM_TexturaTornillo                        = texture { ... }   
//      Textura para el tornillo.                                   
// #declare TCFM_TexturaDiferenciaMetalica              = texture { ... }
//      Textura para aplicar por diferencia a algunas zonas de la tijera,
//      para dar un poco de variedad.
// #declare TCFM_TexturaMarca                           = texture { ... }
//      Textura a aplicar al nombre de marca.
// #declare TCFM_POV3_1                                 = off;
//      Valor on activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente.
//
// Para colocarlo simplemente
// #include "TCFM.inc"
// object        { TCFM_Tijeras( 0.0 ) }
//
// Otro ejemplo con modificador
// #include "TCFM.inc"
// #declare TCFM_TexturaPrincipalTijeras        = texture       {
//   average
//   texture_map        {
//     [ 0.5 TCFM_DefaultTexturaPrincipalTijeras ]
//     [ 0.5 Rust                                ]
//   }
// }
// object        {
//   TCFM_Tijeras( 0.0 )
// }
//

#include "TCFM_AU1.inc"  
#include "metals.inc" 
#include "colors.inc"

#if ( version < 3.2 )
  #ifndef( TCFM_POV3_1 )
    #declare TCFM_POV3_1        = on;
  #end
#else
  #ifndef( TCFM_POV3_1 )
    #declare TCFM_POV3_1        = off;
  #end
#end

#declare TCFM_L                         = 0.001;

#declare TCFM_StringMarca               = "POVRay"
#declare TCFM_FactorMarca               = 1;
#declare TCFM_VectorMarca               = <0,0,0>; 
#declare TCFM_VectorMarca2              = <0,0,0>;   

#declare TCFM_DefaultTexturaPrincipalTijera             = 
texture                 {
  pigment               {
    Silver*0.80+GreenCopper*0.20
  }
  normal                {
    bumps
    turbulence          0.05
    scale               0.01
  }
  finish                {
    specular            1.0
    roughness           0.01
    metallic
  }
}  
  
#ifndef ( TCFM_TexturaPrincipalTijera )        
  #declare TCFM_TexturaPrincipalTijera  = TCFM_DefaultTexturaPrincipalTijera
#end  // #ifndef ( TCFM_TexturaPrincipalTijera )  
                                          
#declare TCFM_DefaultTexturaFiloTijera  =
texture                 { 
  pigment               {
    Silver*0.40+GreenCopper*0.20
  }
  normal                { 
    checker
    normal              {
    gradient x            
    triangle_wave
    scale               0.001 
    }
    normal                {
      bumps
      turbulence          0.05
      scale               0.01
    }     
  }
  finish                {
    specular            1.0
    roughness           0.01
    metallic
  }
}                                          
                                          
#ifndef ( TCFM_TexturaFiloTijera )  
  #declare TCFM_TexturaFiloTijera       = TCFM_DefaultTexturaFiloTijera
#end  // #ifndef ( TCFM_TexturaFiloTijera ) 

#declare TCFM_DefaultTexturaMangoTijera         = TCFM_DefaultTexturaPrincipalTijera   

#ifndef ( TCFM_TexturaMangoTijera )        
  #declare TCFM_TexturaMangoTijera      = TCFM_DefaultTexturaMangoTijera
#end  // #ifndef ( TCFM_TexturaMangoTijera ) 

#declare TCFM_DefaultTexturaOjoTijera           = TCFM_DefaultTexturaPrincipalTijera
  
#ifndef ( TCFM_TexturaOjoTijera )        
  #declare TCFM_TexturaOjoTijera                = TCFM_DefaultTexturaOjoTijera
#end  // #ifndef ( TCFM_TexturaOjoTijera )  

#declare TCFM_DefaultTexturaTornillo            =
texture                 { 
  pigment               {
    Silver*0.30+GreenCopper*0.30
  }
  normal                { 
    checker
    normal              {
    gradient x            
    triangle_wave
    scale               0.003 
    }
    normal                {
    gradient y            
    triangle_wave
    scale               0.003 
    }     
  }
  finish                {
    specular            1.0
    roughness           0.01
    metallic
  }
} 

#ifndef ( TCFM_TexturaTornillo )         
  #declare TCFM_TexturaTornillo                 = TCFM_DefaultTexturaTornillo
#end  // #ifndef ( TCFM_TexturaTornillo )

#declare TCFM_DefaultTexturaDiferenciaMetalica  =
texture                 {
  pigment               {
    Silver*0.90+GreenCopper*0.10
  }
  normal                {
    bumps
    turbulence          0.05
    scale               0.01
  }
  finish                {
    specular            1.0
    roughness           0.01
    metallic
  }
}        
                      
#ifndef ( TCFM_TexturaDiferenciaMetalica )        
  #declare TCFM_TexturaDiferenciaMetalica       =
                        TCFM_DefaultTexturaDiferenciaMetalica
#end  // #ifndef ( TCFM_TexturaDiferenciaMetalica )   

#declare TCFM_DefaultTexturaMarca               =
texture                 {    
  T_Silver_5E
} 

#ifndef ( TCFM_TexturaMarca )        
  #declare TCFM_TexturaMarca                    = TCFM_DefaultTexturaMarca
#end  // #ifndef ( TCFM_TexturaMarca )
   
#macro TCFM_Tijeras( FraccionApertura )
  union                                 {
    #local L                            = TCFM_L;
    #local AnguloMaximo                 = 115;
    #local TotalPuntosArregloBaseA      = 15;
    #local TotalPuntosArregloBaseB      = 14;
    #local TotalPuntosArregloOjoA       = 9;
    #local TotalPuntosArregloOjoB       = 11;
    #local GruesoTijera                 = 1.43*L;
    #local FS                           = 1.5*L;
    #local CizallaBaseA                 = 0.10;
    #local CizallaBaseB                 = 0.10;
    #local CizallaPuenteA               = 0.05;
    #local CizallaPuenteB               = 0.05;
    #local ArregloBaseA                 = array [TotalPuntosArregloBaseA]
             { <  52.5 ,   0    >*FS,
               <  30   ,   2.5  >*FS,
               <  10   ,   3.75 >*FS,
               <   8   ,   3.75 >*FS,
               <   7.5 ,   3.75 >*FS,
               <   0   ,   0    >*FS,
               <  -2.5 ,  -1.5  >*FS,
               <  -2.5 ,  -4.5  >*FS,
               <   7.5 ,  -4.0  >*FS,
               <  10   ,  -4.0  >*FS,
               <  15   ,  -4.0  >*FS,
               <  18   ,  -2.5  >*FS,
               <  35   ,  -2.4  >*FS,
               <  45   ,  -1.5  >*FS,
               <  52.5 ,   0    >*FS    }
    #local ArregloBaseB                 = array [TotalPuntosArregloBaseB]
             { <  52.5 ,  -1    >*FS,
               <  47.5 ,   0    >*FS,
               <  17.5 ,   1    >*FS,
               <  15   ,   3.5  >*FS,
               <   8.5 ,   3.5  >*FS,
               <   2   ,   3.75 >*FS,
               <  -2.5 ,   3.75 >*FS,
               <  -2.5 ,   1    >*FS,
               <   6   ,  -4.0  >*FS,
               <  15   ,  -4.25 >*FS,
               <  42.5 ,  -4.25 >*FS,
               <  47.5 ,  -3.5  >*FS,
               <  50   ,  -3.25 >*FS,
               <  52.5 ,  -1    >*FS    }
    #local ArregloOjoA                  = array [TotalPuntosArregloOjoA]
             { < -25   ,  -1    ,0>*FS,
               < -30   ,  -2.25 ,0>*FS,
               < -34   ,  -7.5  ,0>*FS,
               < -30   , -13.5  ,0>*FS,
               < -25   , -14.5  ,0>*FS,
               < -20   , -13.5  ,0>*FS,
               < -16.5 ,  -7.5  ,0>*FS,
               < -20   ,  -1.75 ,0>*FS,
               < -25   ,  -1    ,0>*FS    }
    #local ArregloOjoB                  = array [TotalPuntosArregloOjoB]
             { < -25   ,   1    ,0>*FS,
               < -30   ,   2    ,0>*FS,
               < -34   ,   7    ,0>*FS,
               < -30   ,  12    ,0>*FS,
               < -25   ,  13.5  ,0>*FS,
               < -20   ,  13.75 ,0>*FS,
               < -15   ,  12.5  ,0>*FS,
               < -11   ,   7.5  ,0>*FS,
               < -15   ,   2.5  ,0>*FS,
               < -20   ,   1    ,0>*FS,
               < -25   ,   1    ,0>*FS    }
    #local CentroRotacion               = <11.5,-0.5,0>*FS;
    #declare TCFM_CentroRotacion        = CentroRotacion;
    // Zona A
    union                               {
      // Filo sin tornillo
      difference                        {
        // Antes de aplicar filo
        difference                           {
          //  Forma principal Zona A
          prism                         {
            conic_sweep
            1.001, 1-CizallaBaseA,
            TotalPuntosArregloBaseA
            #local C                    = 0;
            #while ( C < TotalPuntosArregloBaseA )
              ArregloBaseA[C]
              #local C                  = C+1;
            #end  // #while ( C < TotalPuntosArregloBaseA )
            translate                   -y
            scale                       <1,-GruesoTijera/CizallaBaseA,1>
            rotate                      -90*x
          } //  prism Forma principal Zona A 
            
          box                           {   
            -10*FS*<2,1,0>, 10*FS*<6,1,1> 
            texture             { 
              TCFM_TexturaFiloTijera  
              scale                     <1,-1,1>
            }  
          } 
          
        }  // union Antes de aplicar filo  
    
        
        superellipsoid                  {
          <0.1,0.1>
          translate                     -z-y
          rotate                75.0*x
          rotate                -2.5*z
          scale                 17*FS

          translate             -5*FS*x-FS*y
          texture { TCFM_TexturaDiferenciaMetalica }
          translate               <  35   ,  -2.4  >*FS

        }
        cylinder                        {
          -0.1*GruesoTijera*z, 0.1*GruesoTijera*z, 1.75*FS
          translate                     CentroRotacion-GruesoTijera*z  
          texture       { TCFM_TexturaDiferenciaMetalica }
        }
        text                            {
          ttf   "timrom.ttf" TCFM_StringMarca 1, 0
          scale                 <TCFM_FactorMarca,TCFM_FactorMarca,1>
          scale < 1.5*FS, 1.5*FS, -0.5*GruesoTijera >
          translate             0.5*GruesoTijera*z/2
          rotate                90*z
          texture { TCFM_TexturaMarca }
          translate             CentroRotacion-3*FS*x-GruesoTijera*z-2.25*FS*y
                                +TCFM_VectorMarca
        }
      }  // difference  Filo sin tornillo
      // Tornillo
      cylinder                        {
        0, 0.1*GruesoTijera*z, 1.50*FS
        translate                     CentroRotacion-GruesoTijera*z
        texture { TCFM_TexturaTornillo }
      }
      
      // Ojo principal A
      union                             {
        #local C                        = 0;
        #while ( C < ( TotalPuntosArregloOjoA-1 ) )
          TCFM_SweepTriplePunto( ArregloOjoA[C], ArregloOjoA[C+1], ArregloOjoA[C+2],
                        FS, true )
          #local C                      = C+2;
        #end  // #while ( C < ( TotalPuntosArregloOjoA-1 ) )
        scale                   <1,1,2>
        matrix                  <1,0,0,
                                 0,1,0,
                                 -0.5,0,1,
                                 0,0,0>  
        texture  { TCFM_TexturaOjoTijera }                         
      }  // Ojo Principal A
      // Puente Ojo a Principal
      #local PuenteOjo          =
        difference                   {
          prism                 {
            conic_sweep
            1, 1-CizallaPuenteA,
            7,
            <-0.5,-0.25>*FS,
            <   6   ,  -4.0  >*FS,
            <0.0,-4.5>*FS,
            <-18.5,-3.5>*FS,
            <-22,-1>*FS,
            <-2,-1>*FS,
            <-0.5,-0.25>*FS
            translate                   -y
            scale                       <1,-1.5*GruesoTijera/CizallaPuenteA,1>
            rotate              -90*x
          }
          cylinder                      {
            0, 0.1*x, 0.50*FS
            scale               <1,1,0.1>
            rotate      -35*z
            translate                   -1.5*GruesoTijera*z-2*FS*x
          }
          texture               {  
            TCFM_TexturaMangoTijera
          }
        }
      object                    {
        PuenteOjo
        matrix                  <1,0,0,
                                 0,1,0,
                                 -0.5,0,1,
                                 0,0,0>
      }
      object                    {
        PuenteOjo
        scale                   <1,1,-1>
        matrix                  <1,0,0,
                                 0,1,0,
                                 0.5,0,1,
                                 0,0,0>
      }
      translate                         -CentroRotacion
      rotate                            0.5*AnguloMaximo*FraccionApertura*z
      translate                         CentroRotacion
    }  // union Zona A
    // Zona B
    union                               {
      // Filo sin tornillo
      difference                        {
        // Antes de aplicar filo
        difference                           {
          //  Forma principal Zona B
          prism                         {
            conic_sweep
            1.001, 1-CizallaBaseB,
            TotalPuntosArregloBaseB
            #local C                    = 0;
            #while ( C < TotalPuntosArregloBaseB )
              ArregloBaseB[C]
              #local C                  = C+1;
            #end  // #while ( C < TotalPuntosArregloBaseB )
            translate                   -y
            scale                       <1,GruesoTijera/CizallaBaseB,1>
            rotate                      -90*x
          } //  prism Forma principal Zona B
          box                           {   
            -10*FS*<2,1,0>, 10*FS*<6,1,1> 
            scale               <1,1,-1>    
            texture                     {  
              TCFM_TexturaFiloTijera   
            }
          } 
        }  // union Antes de aplicar filo
        superellipsoid                  {
          <0.1,0.1>
          translate                     z+y
          rotate                80*x
//          rotate                -2.5*z
          scale                 17*FS

          translate             -5*FS*x+1.5*FS*y
          texture { TCFM_TexturaDiferenciaMetalica }
          translate               <  35   ,  0.5 >*FS
        }
        cylinder                        {
          -0.1*GruesoTijera*z, 0.1*GruesoTijera*z, 1.50*FS
          translate                     CentroRotacion+GruesoTijera*z   
          texture       { TCFM_TexturaDiferenciaMetalica }
        }
        text                            {
          ttf   "timrom.ttf" TCFM_StringMarca 1, 0
          scale                 <TCFM_FactorMarca,TCFM_FactorMarca,1>
          scale <-1.5*FS, 1.5*FS, -0.5*GruesoTijera >
          translate             0.5*GruesoTijera*z/2
          rotate                90*z
          texture { TCFM_TexturaMarca }
          translate             CentroRotacion-3*FS*x+GruesoTijera*z+3.00*FS*y
                                +TCFM_VectorMarca2
        }
      }  // difference  Filo sin tornillo
      // Tornillo
      cylinder                        {
        0, 0.1*GruesoTijera*z, 1.25*FS
        translate                     CentroRotacion+GruesoTijera*z
        texture { TCFM_TexturaTornillo }
      }
      // Ojo principal B
      union                             {
        #local C                        = 0;
        #while ( C < ( TotalPuntosArregloOjoB-1 ) )
          TCFM_SweepTriplePunto( ArregloOjoB[C], ArregloOjoB[C+1], ArregloOjoB[C+2],
                        FS, true )
          #local C                      = C+2;
        #end  // #while ( C < ( TotalPuntosArregloOjoB-1 ) )
        scale                   <1,1,2>
        matrix                  <1,0,0,
                                 0,1,0,
                                 0.5,0,1,
                                 0,0,0>   
        texture        { TCFM_TexturaOjoTijera }                          
      }  // Ojo Principal B
      // Puente Ojo a Principal
      #local PuenteOjo          =
        difference                   {
          prism                 {
            conic_sweep
            1, 1-CizallaPuenteB,
            5,
            <-1,0>*FS,
            <5.5,3.75>*FS,
            <-13.5,4>*FS,
            <-17,1.25>*FS,
            <-1,0>*FS
            translate                   -y
            scale                       <1,1.5*GruesoTijera/CizallaPuenteB,1>
            rotate              -90*x
          }
          cylinder                      {
            0, 0.1*x, 0.50*FS
            scale               <1,1,0.1>
            rotate      35*z
            translate                   1.5*GruesoTijera*z-2*FS*x
          }
          texture { TCFM_TexturaMangoTijera }
        }
      object                    {
        PuenteOjo
        matrix                  <1,0,0,
                                 0,1,0,
                                 0.5,0,1,
                                 0,0,0>
      }
      object                    {
        PuenteOjo
        scale                   <1,1,-1>
        matrix                  <1,0,0,
                                 0,1,0,
                                 -0.5,0,1,
                                 0,0,0>
      }
      translate                         -CentroRotacion
      rotate                            -0.5*AnguloMaximo*FraccionApertura*z
      translate                         CentroRotacion
    }  // union Zona B 
    texture                             {   
      TCFM_TexturaPrincipalTijera
    }
  }  // union
#end  // #macro TCFM_TijerasCortantesFiloMetalico

