// This file is licensed under the terms of the CC-LGPL.
// NOTA: El juego "Nudos Iniciales", al que alude la presentacion de la maquina,
// fue programado por nosotros.  La imagen se sustituye facilmente.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho... 30 diciembre 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// MJEI MaquinaJuegosElectronicosImaginaria 
// El archivo dibuja un aparato de juegos electronicos tipo Parque de Diversiones
// y salon de video juegos, muy populares hace unas decadas.   
// Se puede cambiar las imagenes y otras caracteristicas.
// Es compatible con POVRay 3.1.
//
// La macro principal tiene dos parametros     
// #macro MJEI_MaquinaJuegos( GIFImagenPantalla, ArregloImagenes )
//      GIFImagenPantalla       : nombre para imagen GIF a desplegar en pantalla.
//              String null "" utiliza imagen por defecto.
//      ArregloImagenes         : array [7] de string.  Para decorar el aparato.
//              Utilice MJEI_DefaultArregloImagenes para imagenes por defecto.
//              El arreglo corresponde a imagenes GIF
//              { ImagenFrontal, ImagenTitulo, ImagenLateralDerecha,
//                ImagenLateralIzquierda, ImagenZonasLibres,
//                ImagenBaseBotones, ImagenBaseJoystick }
//              Por defecto { "MJEI_FRO.gif", "MJEI_TIT.gif", "MJEI_LAT.gif",
//                  "MJEI_LAT.gif", "MJEI_INT.gif", "MJEI_BOT.gif", "MJEI_JOY.gif" }
//              ImagenZonasLibres se aplica a la parte superior y varias
//              zonas no cubiertas con las anteriores.
//      
// La siguiente variante, permite mucho mayor control de las caracteristicas.
// #macro MJEI_MaquinaJuegosElectronicosImaginaria( 
//              GIFImagenPantalla, ArregloImagenes,
//              Frente, Altura, Profundidad,
//              LateralPantalla, AlturaBotones, AltoCartelSuperior, 
//              ProfundidadBotones, ProfundidadCartelSuperior, 
//              ProfundidadSalienteSuperior, GruesoMadera, AltoPalanca, DiametroBoton,   
//              TexturaMetal, TexturaPlastico,
//              TexturaVidrio, TexturaPosterior, TexturaEnvejecer )  
//      GIFImagenPantalla       : nombre para imagen GIF a desplegar en pantalla.
//              String null "" utiliza imagen por defecto.
//      ArregloImagenes         : array [7] de string.  Para decorar el aparato.
//              Utilice MJEI_DefaultArregloImagenes para imagenes por defecto.
//              El arreglo corresponde a imagenes GIF
//              { ImagenFrontal, ImagenTitulo, ImagenLateralDerecha,
//                ImagenLateralIzquierda, ImagenZonasLibres,
//                ImagenBaseBotones, ImagenBaseJoystick } 
//              Por defecto { "MJEI_FRO.gif", "MJEI_TIT.gif", "MJEI_LAT.gif",
//                  "MJEI_LAT.gif", "MJEI_INT.gif", "MJEI_BOT.gif", "MJEI_JOY.gif" }
//              ImagenZonasLibres se aplica a la parte superior y varias
//              zonas no cubiertas con las anteriores.
//      Frente                  : Frente X del aparato.  Valor por defecto 490*L. 
//      Altura                  : Altura total Y del aparato.  
//              Valor por defecto 1340*L.
//      Profundidad             : Profundidad Z del aparato sin liberador de monedas.
//              Valor por defecto 550*L.
//      LateralPantalla         : Tamano X de laterales de pantalla.
//              Valor por defecto 50*L.
//      AlturaBotones           : Altura sobre el piso de los botones.
//              Valor por defecto 800*L.
//      AltoCartelSuperior      : Tamano en Y del cartel para titulo.
//              Valor por defecto 120*L.
//      ProfundidadBotones      : Para ubicar en Z los botones.
//              Valor por defecto 179*L.
//      ProfundidadCartelSuperior               : Para ubicar en Z cartel superior.
//              Valor por defecto 100*L.
//      ProfundidadSalienteSuperior             : La zona superior en Z se
//              encuentra ligeramente retirada.  
//              Valor por defecto 25*L.
//      GruesoMadera            : Grueso basico de madera.  Valor por defecto 5*L. 
//      AltoPalanca             : Referencia alto del Joystick.  
//              Valor por defecto 50*L.        
//      DiametroBoton           : Diametro de botones.  Valor por defecto 20*L.
//      TexturaMetal            : Textura para aplicar al metal.
//              Valor por defecto MJEI_TexturaMetal.
//      TexturaPlastico         : Textura para aplicar al plastico.
//              Valor por defecto MJEI_TexturaPlastico.
//      TexturaVidrio           : Textura para el vidrio protector.
//              Valor por defecto MJEI_TexturaVidrio.
//      TexturaPosterior        : Textura para la zona posterior.
//              Valor por defecto MJEI_TexturaPosterior.
//      TexturaEnvejecer        : Textura adicional que se aplica a las
//              imagenes para envejecerlas.  La textura por defecto
//              es completamente transparente.
//              Valor por defecto MJEI_TexturaEnvejecer.
//
// Cuando cerrada la caja se encuentra contenida enteramente en:
// <-Frente/2,0,-1.06*Profundidad> ... <Frente/2,Altura,0>
//      Frente X                =  490*L
//      Altura Y                = 1340*L
//      Profundidad Z           =  583*L (incluye factor 1.06)   
// El frente del aparato mira hacia Z-, con gravedad Y-.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare D7OR_DefaultArregloImagenes         = array [7] 
//        { "MJEI_FRO.gif", "MJEI_TIT.gif", "MJEI_LAT.gif", "MJEI_LAT.gif", 
//          "MJEI_INT.gif", "MJEI_BOT.gif", "MJEI_JOY.gif" }
//      Arreglo de string para archivos de imagen, corresponden en orden a :
//      Frontal, Titulo, LateralDerecho, LateralIzquierdo, ZonasLibres,
//      BaseBoton, BaseJoystick.   
// #declare MJEI_DefaultTexturaMetal
//      Textura que se aplica a zonas metalizadas.
// #declare MJEI_DefaultTexturaPlastico
//      Textura que se aplica a botones y esfera del joystick.
// #declare MJEI_DefaultTexturaVidrio
//      Textura que se aplica al vidrio protector.
// #declare MJEI_DefaultTexturaPosterior
//      Textura que se aplica a zona posterior.
// #declare MJEI_DefaultTexturaEnvejecer
//      Textura que se aplica para envejecer las imagenes.
//      Se define por defecto transparente.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default)  
// #declare MJEI_TexturaMetal                   = texture { ... }
//      Textura que se aplica a zonas metalizadas.
// #declare MJEI_TexturaPlastico                = texture { ... }
//      Textura que se aplica a botones y esfera del joystick.
// #declare MJEI_TexturaVidrio                  = texture { ... }
//      Textura que se aplica al vidrio protector.
// #declare MJEI_TexturaPosterior               = texture { ... }
//      Textura que se aplica a zona posterior.
// #declare MJEI_TexturaEnvejecer               = texture { ... }
//      Textura que se aplica para envejecer las imagenes.
//      Se define por defecto transparente.
// #declare MJEI_POV3_1                         = off;
//      Valor "on" activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//
// Algunos ejemplos
// #include "MJEI.inc"                                  
// object        { MJEI_MaquinaJuegos( "", MJEI_DefaultArregloImagenes ) }
//            
// Cambiar las imagenes
// #include "MJEI.inc"                         
// #declare ArregloImagenes     = array [7]     =
//              { "CUSTOM1.gif", "CUSTOM2.gif", "CUSTOM3.gif", "CUSTOM4.gif",
//                "CUSTOM5.gif", "CUSTOM6.gif", "CUSTOM7.gif" }
// object        { MJEI_MaquinaJuegos( "CUSTOM0.gif", ArregloImagenes ) }
//                  
// O bien en version macro detallada:
// #include "MJEI.inc"
// object               {
//   MJEI_MaquinaJuegosElectronicosImaginaria( "", MJEI_DefaultArregloImagenes,   
//              0.490, 1.340, 0.550, 0.050, 0.800, 0.120, 
//              0.179, 0.100, 0.025, 0.005, 0.050, 0.020,
//              MJEI_TexturaMetal, MJEI_TexturaPlastico,
//              MJEI_TexturaVidrio, MJEI_TexturaPosterior, MJEI_TexturaEnvejecer )
// }       
//
// O bien con modificadores:
// #include "MJEI.inc"                         
// #include "textures.inc"    
// #declare MJEI_TexturaEnvejecer      =
//   texture                           {
//     pigment                         { 
//       bumps
//       pigment_map                   {
//         [ 0.50 Clear ]
//         [ 0.75 Green ]
//       }
//     } 
//   } 
// object        { MJEI_MaquinaJuegos( "", MJEI_DefaultArregloImagenes ) }
//

#include "colors.inc"

#declare EjeMejorado            = false;
#declare OjoAbsoluto            = 256;
#declare VecesCentroAbsoluto    = 10;     
#declare L                      = 0.001;
camera {
        location  <   0,  0, -( VecesCentroAbsoluto+1 )*OjoAbsoluto >*L
        direction z
        sky       y
        angle     38.74
//        look_at  <   0,  0, -VecesCentroAbsoluto*OjoAbsoluto >*L
}         
light_source    {
         < 500  , 500   , -3000 >*L
         White
}
light_source    {
         < -500  , 500   , -3000 >*L
         White
}

background      {
         Gray50
}
#include "MJEI.inc" 

object                          { 
  MJEI_MaquinaJuegos( "", MJEI_DefaultArregloImagenes )
  translate             -0.675*y+0.5*z
}  
              