// This file is licensed under the terms of the CC-LGPL.
// NOTA: El juego "Nudos Iniciales", al que alude la presentacion de la maquina,
// fue programado por nosotros.  La imagen se sustituye facilmente.
//
// Autor  : Rafael Angel Campos Vargas
// Correo : RofoelCompos@hotmail.com  
// Apdo. 964-1250 Escazu, San Jose, Costa Rica
// dedicado a Jesus y Maria...
//
// En este momento estoy creando un programa
// de animacion LibreN3D para FreeDOS con el compilador FreePascal
// falta mucho... 30 diciembre 2014
//                
// Mis dibujos estan en unidades L (Lisa)
// 1 L equivale a 0.055063 pulgadas 
// definido como 0.001 para POVRAY
//
// MJEI MaquinaJuegosElectronicosImaginaria 
// El archivo dibuja un aparato de juegos electronicos tipo Parque de Diversiones
// y salon de video juegos, muy populares hace unas decadas.   
// Se puede cambiar las imagenes y otras caracteristicas.
// Es compatible con POVRay 3.1.
//
// La macro principal tiene dos parametros     
// #macro MJEI_MaquinaJuegos( GIFImagenPantalla, ArregloImagenes )
//      GIFImagenPantalla       : nombre para imagen GIF a desplegar en pantalla.
//              String null "" utiliza imagen por defecto.
//      ArregloImagenes         : array [7] de string.  Para decorar el aparato.
//              Utilice MJEI_DefaultArregloImagenes para imagenes por defecto.
//              El arreglo corresponde a imagenes GIF
//              { ImagenFrontal, ImagenTitulo, ImagenLateralDerecha,
//                ImagenLateralIzquierda, ImagenZonasLibres,
//                ImagenBaseBotones, ImagenBaseJoystick }
//              Por defecto { "MJEI_FRO.gif", "MJEI_TIT.gif", "MJEI_LAT.gif",
//                  "MJEI_LAT.gif", "MJEI_INT.gif", "MJEI_BOT.gif", "MJEI_JOY.gif" }
//              ImagenZonasLibres se aplica a la parte superior y varias
//              zonas no cubiertas con las anteriores.
//      
// La siguiente variante, permite mucho mayor control de las caracteristicas.
// #macro MJEI_MaquinaJuegosElectronicosImaginaria( 
//              GIFImagenPantalla, ArregloImagenes,
//              Frente, Altura, Profundidad,
//              LateralPantalla, AlturaBotones, AltoCartelSuperior, 
//              ProfundidadBotones, ProfundidadCartelSuperior, 
//              ProfundidadSalienteSuperior, GruesoMadera, AltoPalanca, DiametroBoton,   
//              TexturaMetal, TexturaPlastico,
//              TexturaVidrio, TexturaPosterior, TexturaEnvejecer )  
//      GIFImagenPantalla       : nombre para imagen GIF a desplegar en pantalla.
//              String null "" utiliza imagen por defecto.
//      ArregloImagenes         : array [7] de string.  Para decorar el aparato.
//              Utilice MJEI_DefaultArregloImagenes para imagenes por defecto.
//              El arreglo corresponde a imagenes GIF
//              { ImagenFrontal, ImagenTitulo, ImagenLateralDerecha,
//                ImagenLateralIzquierda, ImagenZonasLibres,
//                ImagenBaseBotones, ImagenBaseJoystick } 
//              Por defecto { "MJEI_FRO.gif", "MJEI_TIT.gif", "MJEI_LAT.gif",
//                  "MJEI_LAT.gif", "MJEI_INT.gif", "MJEI_BOT.gif", "MJEI_JOY.gif" }
//              ImagenZonasLibres se aplica a la parte superior y varias
//              zonas no cubiertas con las anteriores.
//      Frente                  : Frente X del aparato.  Valor por defecto 490*L. 
//      Altura                  : Altura total Y del aparato.  
//              Valor por defecto 1340*L.
//      Profundidad             : Profundidad Z del aparato sin liberador de monedas.
//              Valor por defecto 550*L.
//      LateralPantalla         : Tamano X de laterales de pantalla.
//              Valor por defecto 50*L.
//      AlturaBotones           : Altura sobre el piso de los botones.
//              Valor por defecto 800*L.
//      AltoCartelSuperior      : Tamano en Y del cartel para titulo.
//              Valor por defecto 120*L.
//      ProfundidadBotones      : Para ubicar en Z los botones.
//              Valor por defecto 179*L.
//      ProfundidadCartelSuperior               : Para ubicar en Z cartel superior.
//              Valor por defecto 100*L.
//      ProfundidadSalienteSuperior             : La zona superior en Z se
//              encuentra ligeramente retirada.  
//              Valor por defecto 25*L.
//      GruesoMadera            : Grueso basico de madera.  Valor por defecto 5*L. 
//      AltoPalanca             : Referencia alto del Joystick.  
//              Valor por defecto 50*L.        
//      DiametroBoton           : Diametro de botones.  Valor por defecto 20*L.
//      TexturaMetal            : Textura para aplicar al metal.
//              Valor por defecto MJEI_TexturaMetal.
//      TexturaPlastico         : Textura para aplicar al plastico.
//              Valor por defecto MJEI_TexturaPlastico.
//      TexturaVidrio           : Textura para el vidrio protector.
//              Valor por defecto MJEI_TexturaVidrio.
//      TexturaPosterior        : Textura para la zona posterior.
//              Valor por defecto MJEI_TexturaPosterior.
//      TexturaEnvejecer        : Textura adicional que se aplica a las
//              imagenes para envejecerlas.  La textura por defecto
//              es completamente transparente.
//              Valor por defecto MJEI_TexturaEnvejecer.
//
// Cuando cerrada la caja se encuentra contenida enteramente en:
// <-Frente/2,0,-1.06*Profundidad> ... <Frente/2,Altura,0>
//      Frente X                =  490*L
//      Altura Y                = 1340*L
//      Profundidad Z           =  583*L (incluye factor 1.06)   
// El frente del aparato mira hacia Z-, con gravedad Y-.
//
// Estas son variables predefinidas o generadas en el
// interior de las macros que no deberian modificarse directamente.
// Si quiere cambiarlas, recurra a los modificadores.  
// #declare D7OR_DefaultArregloImagenes         = array [7] 
//        { "MJEI_FRO.gif", "MJEI_TIT.gif", "MJEI_LAT.gif", "MJEI_LAT.gif", 
//          "MJEI_INT.gif", "MJEI_BOT.gif", "MJEI_JOY.gif" }
//      Arreglo de string para archivos de imagen, corresponden en orden a :
//      Frontal, Titulo, LateralDerecho, LateralIzquierdo, ZonasLibres,
//      BaseBoton, BaseJoystick.   
// #declare MJEI_DefaultTexturaMetal
//      Textura que se aplica a zonas metalizadas.
// #declare MJEI_DefaultTexturaPlastico
//      Textura que se aplica a botones y esfera del joystick.
// #declare MJEI_DefaultTexturaVidrio
//      Textura que se aplica al vidrio protector.
// #declare MJEI_DefaultTexturaPosterior
//      Textura que se aplica a zona posterior.
// #declare MJEI_DefaultTexturaEnvejecer
//      Textura que se aplica para envejecer las imagenes.
//      Se define por defecto transparente.
//
// Los siguientes son los modificadores
// aplicables y redefinibles por el usuario (si se indica es default)  
// #declare MJEI_TexturaMetal                   = texture { ... }
//      Textura que se aplica a zonas metalizadas.
// #declare MJEI_TexturaPlastico                = texture { ... }
//      Textura que se aplica a botones y esfera del joystick.
// #declare MJEI_TexturaVidrio                  = texture { ... }
//      Textura que se aplica al vidrio protector.
// #declare MJEI_TexturaPosterior               = texture { ... }
//      Textura que se aplica a zona posterior.
// #declare MJEI_TexturaEnvejecer               = texture { ... }
//      Textura que se aplica para envejecer las imagenes.
//      Se define por defecto transparente.
// #declare MJEI_POV3_1                         = off;
//      Valor "on" activa modo de compatibilidad con POVRay 3.1.
//      En algunas versiones se activara automaticamente. 
//
// Algunos ejemplos
// #include "MJEI.inc"                                  
// object        { MJEI_MaquinaJuegos( "", MJEI_DefaultArregloImagenes ) }
//            
// Cambiar las imagenes
// #include "MJEI.inc"                         
// #declare ArregloImagenes     = array [7]     =
//              { "CUSTOM1.gif", "CUSTOM2.gif", "CUSTOM3.gif", "CUSTOM4.gif",
//                "CUSTOM5.gif", "CUSTOM6.gif", "CUSTOM7.gif" }
// object        { MJEI_MaquinaJuegos( "CUSTOM0.gif", ArregloImagenes ) }
//                  
// O bien en version macro detallada:
// #include "MJEI.inc"
// object               {
//   MJEI_MaquinaJuegosElectronicosImaginaria( "", MJEI_DefaultArregloImagenes,   
//              0.490, 1.340, 0.550, 0.050, 0.800, 0.120, 
//              0.179, 0.100, 0.025, 0.005, 0.050, 0.020,
//              MJEI_TexturaMetal, MJEI_TexturaPlastico,
//              MJEI_TexturaVidrio, MJEI_TexturaPosterior, MJEI_TexturaEnvejecer )
// }       
//
// O bien con modificadores:
// #include "MJEI.inc"                         
// #include "textures.inc"    
// #declare MJEI_TexturaEnvejecer      =
//   texture                           {
//     pigment                         { 
//       bumps
//       pigment_map                   {
//         [ 0.50 Clear ]
//         [ 0.75 Green ]
//       }
//     } 
//   } 
// object        { MJEI_MaquinaJuegos( "", MJEI_DefaultArregloImagenes ) }
//
                    
#include "colors.inc"                    
#include "textures.inc" 
#include "metals.inc"   
                      
#declare MJEI_L                         = 0.001;  

#if ( version < 3.2 )
  #ifndef( MJEI_POV3_1 )
    #declare MJEI_POV3_1        = on;
  #end
#else
  #ifndef( MJEI_POV3_1 )
    #declare MJEI_POV3_1        = off;
  #end
#end
   
#declare MJEI_DefaultArregloImagenes    = array [7]
        { "MJEI_FRO.gif", "MJEI_TIT.gif", 
          "MJEI_LAT.gif", "MJEI_LAT.gif", 
          "MJEI_INT.gif", "MJEI_BOT.gif", 
          "MJEI_JOY.gif" }   

#declare MJEI_IndiceTexturaFrontal              = 0;
#declare MJEI_IndiceTexturaTitulo               = 1;
#declare MJEI_IndiceTexturaLateralDerecha       = 2;
#declare MJEI_IndiceTexturaLateralIzquierda     = 3; 
#declare MJEI_IndiceTexturaLibre                = 4;  
#declare MJEI_IndiceTexturaBaseBotones          = 5;  
#declare MJEI_IndiceTexturaBaseJoystick         = 6;     
  
#declare MJEI_DefaultTexturaEnvejecer           =
  texture                               {
    pigment { Clear }
  }                                       

#ifndef ( MJEI_TexturaEnvejecer )
  #declare MJEI_TexturaEnvejecer                = MJEI_DefaultTexturaEnvejecer
#end 
  
#declare MJEI_DefaultTexturaVidrio              =
  texture                               {
    pigment                             {  
      Cyan transmit 0.925
    }  
  }
  
#ifndef ( MJEI_TexturaVidrio )        
  #declare MJEI_TexturaVidrio                   =
                MJEI_DefaultTexturaVidrio
#end  // #ifndef ( MJEI_TexturaVidrio )                    
 
#declare MJEI_DefaultTexturaMetal               =
  texture                               {  
    T_Chrome_2C   
    normal                      { bumps }
  }
  
#ifndef ( MJEI_TexturaMetal )        
  #declare MJEI_TexturaMetal                    =
                MJEI_DefaultTexturaMetal
#end  // #ifndef ( MJEI_TexturaMetal )                    
 
#declare MJEI_DefaultTexturaPlastico            =
  texture                               {  
    pigment { Red } 
    normal  { bumps scale 0.01 }
  }
  
#ifndef ( MJEI_TexturaPlastico )        
  #declare MJEI_TexturaPlastico                 =
                MJEI_DefaultTexturaPlastico
#end  // #ifndef ( MJEI_TexturaPlastico )                    
 
                                                                                  
#declare MJEI_DefaultTexturaPosterior           =
  texture                               {
    Cork 
  }     
  texture                               {   
    pigment                             {  
      Gray40      transmit        0.5
    }
  }
  
#ifndef ( MJEI_TexturaPosterior )        
  #declare MJEI_TexturaPosterior                =
                MJEI_DefaultTexturaPosterior
#end  // #ifndef ( MJEI_TexturaPosterior )                    
                      
#macro MJEI_MaquinaJuegosElectronicosImaginaria( GIFImagenPantalla, ArregloImagenes,
      Frente, Altura, Profundidad,
      LateralPantalla, AlturaBotones, AltoCartelSuperior, 
      ProfundidadBotones, ProfundidadCartelSuperior, ProfundidadSalienteSuperior,
      GruesoMadera, AltoPalanca, DiametroBoton,   
      TexturaMetal, TexturaPlastico,
      TexturaVidrio, TexturaPosterior, TexturaEnvejecer
    )  
  union                                 { 
    #local TexturaFrontal                       =
      texture                                   {   
        pigment                                 {  
          image_map                             { 
            gif   ArregloImagenes[ MJEI_IndiceTexturaFrontal ]  
          }                                  
          translate                             -0.5
          scale                                 2
        } 
      }     
      texture { TexturaEnvejecer }
    #local TexturaLateralDerecha                =
      texture                                   {   
        pigment                                 {  
          image_map                             { 
            gif   ArregloImagenes[ MJEI_IndiceTexturaLateralDerecha ]  
          }                                  
          translate                             -0.5
          scale                                 2
        } 
        rotate                                  -90*y
      }  
      texture { TexturaEnvejecer }
    #local TexturaLateralIzquierda              =
      texture                                   {   
        pigment                                 {  
          image_map                             { 
            gif   ArregloImagenes[ MJEI_IndiceTexturaLateralIzquierda ]  
          }                                  
          translate                             -0.5
          scale                                 2
        } 
        rotate                                  -90*y
      }  
      texture { TexturaEnvejecer }
    #local TexturaLibre                         =
      texture                                   {   
        pigment                                 {  
          image_map                             { 
            gif   ArregloImagenes[ MJEI_IndiceTexturaLibre ]  
          }                                  
          translate                             -0.5
          scale                                 2
        } 
        rotate                                  -90*y
      }  
      texture { TexturaEnvejecer }
    #local TexturaTitulo                        =
      texture                                   {   
        pigment                                 {  
          image_map                             { 
            gif   ArregloImagenes[ MJEI_IndiceTexturaTitulo ]  
          }                                  
          translate                             -0.5
          scale                                 2
        } 
      }  
      texture { TexturaEnvejecer }
    #local TexturaBaseBotones                   =
      texture                                   {   
        pigment                                 {  
          image_map                             { 
            gif   ArregloImagenes[ MJEI_IndiceTexturaBaseBotones ]  
          }                                  
          translate                             -0.5
          scale                                 2
        } 
        rotate                                  -90*x
      }  
      texture { TexturaEnvejecer }
    #local TexturaBaseJoystick                  =
      texture                                   {   
        pigment                                 {  
          image_map                             { 
            gif   ArregloImagenes[ MJEI_IndiceTexturaBaseJoystick ]  
          }                                  
          translate                             -0.5
          scale                                 2
        } 
        rotate                                  -90*x
      }  
      texture { TexturaEnvejecer }
        
    difference                          {
      prism                             {  
        -Frente/2, Frente/2,
        10,
        < 0, 0 >,
        < 0, -Profundidad >,     
        < AlturaBotones, -Profundidad >,
        < AlturaBotones, -Profundidad+ProfundidadBotones >, 
        < Altura-AltoCartelSuperior, -Profundidad+ProfundidadCartelSuperior >,
        < Altura-GruesoMadera, -Profundidad+ProfundidadCartelSuperior >,
        < Altura-GruesoMadera, -Profundidad+ProfundidadSalienteSuperior >,
        < Altura, -Profundidad+ProfundidadSalienteSuperior >,
        < Altura, 0 >,
        < 0, 0 >  
        rotate          90*z
      }   
      box                               {  
        -1,1
        texture                 {  
          TexturaLateralDerecha   
        }                      
        scale                   <GruesoMadera/2,Altura/2,Altura/2> 
        translate               +0.999*GruesoMadera/2*x+Frente/2*x
                                +Altura/2*y-Frente/2*z
      }
      box                               {  
        -1,1
        texture                 {  
          TexturaLateralIzquierda   
        }                      
        scale                   <GruesoMadera/2,Altura/2,Altura/2> 
        translate               -0.999*GruesoMadera/2*x-Frente/2*x
                                +Altura/2*y-Frente/2*z
      } 
      box                               {   
        -1, 1
        texture                 { 
          TexturaPosterior
        }
        scale                   <Altura/2,Altura/2,GruesoMadera/2> 
        translate               +0.999*GruesoMadera/2*z
                                +Altura/2*y
      }
      box                               {   
        -1, 1
        texture                 { 
          TexturaFrontal
        }
        scale                   <Frente/2,AlturaBotones/2,GruesoMadera/2> 
        translate               -0.999*GruesoMadera/2*z-Profundidad*z
                                +AlturaBotones/2*y
      }   
      box                               {   
        -1, 1
        texture                 { 
          TexturaTitulo
        }
        scale                   <Frente/2-2*GruesoMadera,
                                AltoCartelSuperior/2,Profundidad/2> 
        translate               ( -Profundidad/2-Profundidad
                                        +ProfundidadCartelSuperior+
                                  +AltoCartelSuperior/( Altura-AlturaBotones-GruesoMadera )*
                                   ( ProfundidadBotones-
                                     ProfundidadCartelSuperior ) )*z+
                                ( +Altura-AltoCartelSuperior/2-GruesoMadera )*y
      }
      box                       {  
        0, 1                                           
        translate               -0.5*x-0.5*z
        scale                   <Frente-2*LateralPantalla,
                                 Altura-AlturaBotones-LateralPantalla
                                 -GruesoMadera-AltoCartelSuperior,  
                                 Profundidad-2*GruesoMadera >
        translate               -0.5*Profundidad*z+GruesoMadera*y+
                                AlturaBotones*y+LateralPantalla*y                         
      }  
      box                       { 
        0, 1                                           
        translate               -0.5*x-1*z
        scale                   <Frente-2*GruesoMadera,
                                 Altura-2*GruesoMadera,  
                                 Profundidad-2*GruesoMadera-ProfundidadBotones >
        translate               -GruesoMadera/2*z+GruesoMadera*y/2                         
        texture                 {  
          pigment               { 
            granite
            pigment_map         {  
              [ 0 Black  ]
              [ 1 Gray05 ]
            } 
          }
        }
      }
      box                       {  
        -1,1
        scale                   <0.025*Frente/2,0.05*AlturaBotones/1.5,4*0.0125*Profundidad>
        translate               0.45*Frente*x-Profundidad*z+0.8*AlturaBotones*y
      }
      box                       { 
        -0.9, 0.9 
        scale                   <0.04*Frente,0.04*AlturaBotones,0.01*Profundidad>
        translate               0.25*Frente*x-Profundidad*z+0.50*AlturaBotones*y   
      }  
    }        
    
      box                               {   
        -1, 1
        texture                         {    
          TexturaVidrio
        }
        scale                   <Frente/2-2*GruesoMadera,
                                ( Altura-AlturaBotones-AltoCartelSuperior )/2,
                                Profundidad/100> 
        translate               ( -Profundidad+ProfundidadBotones )*z+
                                ( +Altura/2+AlturaBotones/2-AltoCartelSuperior/2 )*y
      }
    // Espejo    
    #local LargoPantalla        = min( Profundidad-ProfundidadBotones-2*GruesoMadera,
                                       Altura-AlturaBotones-LateralPantalla-GruesoMadera );
    #local LargoEspejo          = LargoPantalla*sqrt( 2 );   
    
    union                       { 
      
      light_source              {    
        AlturaBotones*y-LargoPantalla/2*z, White
        #if ( !MJEI_POV3_1 )
          parallel
          point_at -LargoPantalla/2*z

          projected_through       {
            box                   {
              -1, 1
              scale                   <Frente/2-2*GruesoMadera,LargoPantalla/2,
                                          GruesoMadera/2>*0.99
              translate               LargoPantalla*y/2
              rotate                  -90*x
              translate               ( AlturaBotones-1.1*GruesoMadera )*y
              translate               -GruesoMadera*z
            }
          }
        #end  // #if ( !MJEI_POV3_1 )
      } 
                              
      box                         {                                     
        -1, 1
        scale                   <Frente/2-2*GruesoMadera,LargoEspejo/2,GruesoMadera/100>
        translate               LargoEspejo*y/2
        rotate                  -45*x           
        translate               ( AlturaBotones+LateralPantalla )*y  
        translate               -GruesoMadera*z 
        material                  {    
          texture                 {   
            pigment               {   
              rgb 0.05 transmit 0.95
            }   
            finish                {
              #if ( MJEI_POV3_1 )
                reflection      0.95
              #else  // #else ( MJEI_POV3_1 )
                reflection      { 0.95 }
              #end   // #else ( MJEI_POV3_1 )
              ambient 0.025 diffuse 0.025  
            }
          }
        }
      }              
      superellipsoid            {  
        <0.1,0.1>
        material                {  
          texture               {    
            pigment             {   
              Black
            }
          }
          texture               {  
            pigment             {   
              image_map         {  
                #if ( strcmp( GIFImagenPantalla, "" ) = 0 )
                  gif "MJEI_DEF.gif"  
                #else  // #else ( strcmp( ImagenPantalla, "" ) ) 
                  gif GIFImagenPantalla 
                #end   // #else ( strcmp( ImagenPantalla, "" ) )       
                once
              }
              translate         -0.5
            }  
            scale             2*( Frente-1*LateralPantalla )/( Frente)
          }  
        }
        scale                   <Frente/2-2*GruesoMadera,LargoPantalla/2,
                                        GruesoMadera/2>
        translate               LargoPantalla*y/2 
        rotate                  -90*x
        translate               ( AlturaBotones-4*LateralPantalla )*y  
        translate               -GruesoMadera*z 
      }
      translate                 -0*Profundidad*z
    }      
    union                       {
      difference                  {   
        superellipsoid            {   
          <0.1,0.1>
          texture                 {  
            TexturaBaseJoystick     
          }                
          scale                   <0.15*Frente, GruesoMadera, 0.45*ProfundidadBotones > 
        }                          
        cylinder                  {   
          3*GruesoMadera*y, -3*GruesoMadera*y, 1.05*DiametroBoton/2
        } 
      }                           
      // Palanca 
      union                       {
        cylinder                  { 
          AltoPalanca*y, -3*GruesoMadera*y, DiametroBoton/2 
          texture                         {   
            TexturaMetal
          }
        }
        sphere                  { 
          AltoPalanca*y, DiametroBoton   
          texture                       {   
            TexturaPlastico
          } 
        } 
      }             
      torus                             {   
        1.05*DiametroBoton/2+0.2*DiametroBoton, 0.2*DiametroBoton
        texture                         {
          TexturaPlastico
        }       
        translate                       GruesoMadera*y
      }
      translate               ( -Profundidad+ProfundidadBotones/2 )*z 
      translate               AlturaBotones*y-0.3*Frente*x
    } 
    union                       {
      difference                  {   
        superellipsoid            {   
          <0.1,0.1>
          texture                 {  
            TexturaBaseBotones
          }        
          scale                   <0.25*Frente, GruesoMadera, 0.45*ProfundidadBotones > 
        }
        #local C                        = 0;
        #while ( C < 8 )                          
          cylinder                  {   
            3*GruesoMadera*y, -3*GruesoMadera*y, 1.05*DiametroBoton/2 
            translate           3*DiametroBoton*x/2
            rotate              90*C*y
            #if ( C < 4 )           
              translate         +0.125*Frente*x
            #else  // #else ( C < 4 )
              rotate            45*y
              translate         -0.125*Frente*x
            #end   // #else ( C < 4 ) 
          }   
          #local C                      = C+1;
        #end     
      }             
      #local C                          = 0;
      #while ( C < 8 )
        union                           {
          cylinder                          { 
            0.5*DiametroBoton*y,-0.5*DiametroBoton*y, 0.5*DiametroBoton
            texture                         { 
              TexturaPlastico
            }
          }
          torus                             {   
            1.05*DiametroBoton/2+0.2*DiametroBoton, 0.2*DiametroBoton
            texture                         {
              TexturaMetal
            }       
            translate                       GruesoMadera*y
          }
          translate           3*DiametroBoton*x/2
          rotate              90*C*y
          #if ( C < 4 )           
            translate         +0.125*Frente*x
          #else  // #else ( C < 4 )
            rotate            45*y
            translate         -0.125*Frente*x
          #end   // #else ( C < 4 )  
        }
        #local C                        = C+1;
      #end  // #while ( C < 8 )     
      translate               ( -Profundidad+ProfundidadBotones/2 )*z 
      translate               AlturaBotones*y+0.2*Frente*x
    }  
    // Monedero 
    difference                  {     
      superellipsoid            {   
        <0.2,0.2>
        scale                   <0.025*Frente,0.05*AlturaBotones,0.0125*Profundidad>
        translate               0.45*Frente*x-Profundidad*z+0.8*AlturaBotones*y
      }   
      box                       {  
        -1,1
        scale                   <0.025*Frente/4,0.05*AlturaBotones/2,2*0.0125*Profundidad>
        translate               0.45*Frente*x-Profundidad*z+0.8*AlturaBotones*y
      }
      texture                   {  
        TexturaMetal
      }
    }
    // Desatorado
    union                       { 
      cylinder                  {   
        -0.06*Profundidad*z, +0.06*Profundidad*z, 0.15*DiametroBoton
      } 
      cylinder                  {   
        -0.06*Profundidad*z, -0.05*Profundidad*z, 0.3*DiametroBoton
      } 
      torus                     {     
        0.35*DiametroBoton, 0.05*DiametroBoton 
        rotate          90*x
        texture                 {   
          TexturaPlastico
        }
      }
      translate               0.45*Frente*x-Profundidad*z+0.725*AlturaBotones*y
      texture                   { 
        TexturaMetal
      }
    }      
    // Salida desatorado
    union                       {   
      difference                {
        superellipsoid            {   
          <0.2,0.2>
        }
        box                             {  
          -0.8, 0.8
          scale                 <1,1,2>
        }     
      } 
       
      box                       {    
        -0.95, 0.95              
        scale           <1,1,0.1>
        translate       -0.95*y
        rotate          -30*x
        translate       +0.95*y+0*z
      }
      
      scale                   <0.04*Frente,0.04*AlturaBotones,0.01*Profundidad>
      translate               0.25*Frente*x-Profundidad*z+0.50*AlturaBotones*y
      texture                   {    
        TexturaMetal
      }
    }
    texture                     {  
      TexturaLibre
    }
  }
#end  // #macro MJEI_MaquinaJuegosElectronicosImaginaria

#macro MJEI_MaquinaJuegos( GIFImagenPantalla, ArregloImagenes )         
  object                                {       
    #local L                            = MJEI_L;
    #local Frente                       =  490*L;  
    #local LateralPantalla              =   50*L;
    #local Altura                       = 1340*L; 
    #local AlturaBotones                =  800*L;
    #local AltoCartelSuperior           =  120*L;
    #local Profundidad                  =  550*L;
    #local ProfundidadBotones           =  179*L;  
    #local ProfundidadCartelSuperior    =  100*L; 
    #local ProfundidadSalienteSuperior  =   25*L;
    #local GruesoMadera                 =    5*L;    
    #local AltoPalanca                  =   50*L;
    #local DiametroBoton                =   20*L;
    MJEI_MaquinaJuegosElectronicosImaginaria( GIFImagenPantalla, ArregloImagenes,   
      Frente, Altura, Profundidad,
      LateralPantalla, AlturaBotones, AltoCartelSuperior, 
      ProfundidadBotones, ProfundidadCartelSuperior, ProfundidadSalienteSuperior,
      GruesoMadera, AltoPalanca, DiametroBoton,
      MJEI_TexturaMetal, MJEI_TexturaPlastico,
      MJEI_TexturaVidrio, MJEI_TexturaPosterior, MJEI_TexturaEnvejecer
    )
  }
#end  // #macro MJEI_MaquinaJuegos()