{---------------------------------------}
UNIT Utils;

INTERFACE

USES Header;

{---------------------------------------}
FUNCTION FromKeyboard: boolean;
PROCEDURE AddToLocal (var LocalList: PLocalVar; p: PVarTable);
PROCEDURE DisposeAll (var LocalList: PLocalVar);
FUNCTION numeric(c: cell): boolean;
PROCEDURE PushFunc (var p: PFuncTable);
PROCEDURE CheckDeref (c: PCellList; var deref: boolean);
PROCEDURE GetFileID (d: string; var FileID: integer);
PROCEDURE NewFile (name: string; var ID: integer);
PROCEDURE CloseAll;
PROCEDURE Writeprompt;
PROCEDURE OpenAll;
PROCEDURE InitFiles;
PROCEDURE ReverseVarList (var p: PVarTable);
procedure FindVar (varname: string; var p: PVarTable);
procedure lookup (varname: string; var c: Cell);
Function InTable (funcname: string; var q: PFuncTable): boolean;
PROCEDURE Push (var stack: PCellList; NewNode: Cell);
PROCEDURE PushVar (var Stack: PVarTable;
                       varname: string;
                       value: cell;
                   var p: PVarTable);
PROCEDURE PopVar(var Stack: PVarTable; var value: cell);
PROCEDURE DisposeVar (var p: PVarTable);
PROCEDURE WriteError (s: string);
PROCEDURE Error (s: string);
PROCEDURE Expected (s: string);
FUNCTION Octal (n: integer): string;
PROCEDURE PutVarQueue (var p: PVarTable; name: string; value: cell);

{---------------------------------------}
IMPLEMENTATION

{---------------------------------------}
FUNCTION FromKeyboard: boolean;
begin
 FromKeyboard := InputFile = 0
end;

{---------------------------------------}
PROCEDURE AddToLocal (var LocalList: PLocalVar; p: PVarTable);
var q: PLocalVar;
begin
 new (q); q^.p := p; q^.next := nil;
 if LocalList = nil
    then LocalList := q
    else begin
          q^.next := LocalList;
          LocalList := q
         end
end;

{---------------------------------------}
procedure FindVar (varname: string; var p: PVarTable);
var found: boolean;
begin
 p := GlobalVar;
 found := false;
 while (p <> nil) and (not found) do begin
                                      found := p^.varname = varname;
                                      if not found then p := p^.next
                                     end;
 if not found then p := nil
end;

{---------------------------------------}
procedure lookup (varname: string; var c: Cell);
var p: PVarTable;
begin
 FindVar (varname, p);
 if p<>nil then c := p^.value
           else if copy(varname,1,6) = 'STREAM'
                   then begin
                         c.flag := _file;
                         c.descriptor := varname
                        end
                   else begin
                         c.flag := _null;
                         Error ('Undefined name ' + VarName)
                        end
end;

{---------------------------------------}
Function InTable (funcname: string; var q: PFuncTable): boolean;
var p: PFuncTable; found : boolean;
begin
 p := FuncTab; found := false;
 while (p <> nil) and (not found) do begin
                                      found := p^.FuncName = FuncName;
                                      if not found then p := p^.next
                                     end;
 if found then q := p else q := nil;
 InTable := found
end;


{---------------------------------------}
PROCEDURE Push (var stack: PCellList; NewNode: Cell);
var p: PCellList;
begin
 new(p);
 p^.data := NewNode;
 p^.next := nil;
 if stack = nil then stack := p
                else begin
                      p^.next := stack;
                      stack := p
                     end
end;

{---------------------------------------}
PROCEDURE PushVar (var Stack: PVarTable;
                       varname: string;
                       value: cell;
                   var p: PVarTable);
begin
 new(p);
 p^.varname := VarName;
 p^.value := value;
 p^.next := nil;
 if stack = nil then stack := p
                else begin
                      p^.next := stack;
                      stack := p
                     end
end;

{---------------------------------------}
PROCEDURE PopVar(var Stack: PVarTable; var value: cell);
begin
 if stack <> nil then begin
                       value := stack^.value;
                       stack := stack^.next
                      end
                 else begin
                       value.flag := _null;
                       error('Internal error: variable stack empty')
                      end
end;

{---------------------------------------}
PROCEDURE DisposeVar (var p: PVarTable);
var q: PVarTable;
begin
 q := GlobalVar;
 if q = p then GlobalVar := GlobalVar^.next
          else begin
                while (q <> nil) and (q^.next <> p) do q := q^.next;
                if q^.next = p then q^.next := q^.next^.next
               end;
 dispose(p)
end;

{---------------------------------------}
PROCEDURE DisposeAll (var LocalList: PLocalVar);
begin
 while LocalList <> nil
       do begin
           DisposeVar (LocalList^.p);
           LocalList := LocalList^.next
          end
end;

{---------------------------------------}
FUNCTION numeric(c: cell): boolean;
begin
 numeric := c.flag in [_int, _float, _ratio]
end;


{---------------------------------------}
PROCEDURE PushFunc (var p: PFuncTable);
var q: PFuncTable;
begin
 p^.next := nil;
 if InTable(p^.FuncName,q) then begin
                                 q^.FuncParam := p^.FuncParam;
                                 q^.FuncBody := p^.FuncBody
                                end
                 else begin
                       if FuncTab = nil then FuncTab := p
                                        else begin
                                              p^.next := FuncTab;
                                              FuncTab := p
                                             end
                      end
end;

{---------------------------------------}
PROCEDURE CheckDeref (c: PCellList; var deref: boolean);
begin
 deref := (c^.data.flag = _op) and (c^.data.opcode in [_comma,_at])
end;

{---------------------------------------}
PROCEDURE GetFileID (d: string; var FileID: integer);
var found: boolean;
begin
 FileID := 0; found := false;
 while (not found) and (FileID < MaxFiles)
       do begin
           found := Files[FileID].descriptor = d;
           if not found then inc(FileID)
          end;
 if not found then FileID := 0
end;


{---------------------------------------}
PROCEDURE GetFileIDFromName (d: string; var FileID: integer);
var found: boolean;
begin
 FileID := 0; found := false;
 while (not found) and (FileID < MaxFiles)
       do begin
           found := Files[FileID].name = d;
           if not found then inc(FileID)
          end;
 if not found then FileID := 0
end;


{---------------------------------------}
PROCEDURE NewFile (name: string; var ID: integer);
var q: string; i: integer;
begin
 GetFileIDFromName (name,i);
 if i <> 0 then begin
                 ID := i;
                 if files[i].IsOpen
                    then error ('File ' + name + 'is already open')
                end
            else begin
                  if FileId > MaxFiles
                     then error ('Too many open files')
                     else begin
                           FileId := FileId + 1;
                           ID := FileId;
                           str(ID,q);
                           if length(q) = 1 then q := '0' + q;
                           Files[ID].descriptor := 'STREAM' + q;
                           Files[ID].IsOpen := true;
                           Files[ID].name := name;
                          end
                 end;
end;

{---------------------------------------}
PROCEDURE CloseAll;
var OpenFiles: FILE OF boolean;
    FileDirs: FILE OF directions;
    FileIDs, FileNames: text;
    FileP: FILE OF integer;
    i: integer;
begin
 assign(OpenFiles, '.\temp\$openfil.dat'); rewrite (OpenFiles);
 assign(FileIDs, '.\temp\$fileIds.dat'); rewrite(FileIds);
 assign(FileDirs, '.\temp\$filedirs.dat'); rewrite(FileDIRs);
 assign(FileNames, '.\temp\$filename.dat'); rewrite (FileNames);
 assign(FileP, '.\temp\$filepos.dat'); rewrite (FileP);
 for i := 1 to MAXFILES
     do begin
         write (OpenFiles, files[i].IsOpen);
         writeln(FileIDs,  files[i].descriptor);
         if files[i].name <> '' then writeln(FileNames,  files[i].name)
                                else writeln(FileNames);
         write(FileDirs, files[i].dir);
         write(FileP, files[i].pos);
         if files[i].IsOpen then close (files[i].filevar)
        end;
 write(FileP, counter); write(FileP, InputFile); write (FileP, OutputFile);
 write (FileP, FileID);
 close (OpenFiles); close (FileIds); close (FileDIRs);close (FileNames);
 close (FileP)
end;

{---------------------------------------}
PROCEDURE Writeprompt;
begin
 Counter := Counter + 1;
 writeln; writeln; write ('[', Counter, ']> ')
end;

{---------------------------------------}
PROCEDURE OpenAll;
var OpenFiles: FILE OF boolean;
    FileDirs: FILE OF directions;
    FileIDs, FileNames: text;
    FileP: FILE OF integer;
    i,j: integer;
    cmdo: string;
begin
 assign(OpenFiles, '.\temp\$openfile.dat'); reset (OpenFiles);
 assign(FileIDs, '.\temp\$fileIds.dat'); reset (FileIds);
 assign(FileDirs, '.\temp\$filedirs.dat'); reset (FileDIRs);
 assign(FileNames, '.\temp\$filename.dat'); reset (FileNames);
 assign(FileP, '.\temp\$filepos.dat'); reset (FileP);
 for i := 1 to MAXFILES
     do begin
         read (OpenFiles, files[i].IsOpen);
         readln (FileIDs,  files[i].descriptor);
         readln (FileNames,  files[i].name);
         read (FileDirs, files[i].dir);
         read (FileP, files[i].pos);
         if files[i].IsOpen
            then begin
                  assign(files[i].filevar,files[i].name);
                  if files[i].dir = _output
                     then append (files[i].filevar)
                     else begin
                           reset (files[i].filevar);
                           for j := 1 to files[i].pos
                               do readln(files[i].filevar,cmdo)
                          end
                 end
        end;
 read (FileP, Counter);
 read (FileP, InputFile);
 read (FileP, OutputFile);
 read (FileP, FileID);
 close (OpenFiles); close (FileIds); close (FileDIRs);close (FileNames);
 close (FileP)
end;

{---------------------------------------}
{Initialize file table at the beginning of the session}
PROCEDURE InitFiles;
var i: integer;
begin
  for i:= -MAXFILES to MAXFILES do begin
                                   Files[i].name := '';
                                   Files[i].descriptor := '';
                                   Files[i].IsOpen := false;
                                   Files[i].dir := _undef;
                                   Files[i].pos := 0
                                  end
end;

{---------------------------------------}
PROCEDURE ReverseVarList (var p: PVarTable);
var cmdo,q: pvartable;
begin
 q := p;
 p := nil;
 while q <> nil do begin
                    PushVar(p,q^.varname,q^.value,cmdo);
                    q := q^.next
                   end
end;


{---------------------------------------}
PROCEDURE WriteError (s: string);
begin
   Writeln;
   Writeln('Error : ',s)
end;

{---------------------------------------}
PROCEDURE Error (s: string);
begin
 WriteError(s);
 exit_code := false
end;

{---------------------------------------}
PROCEDURE Expected (s: string);
begin
 Error (s + ' Expected')
end;

{---------------------------------------}
FUNCTION Octal (n: integer): string;
var s,q: string; r: byte;
begin
 s := '';
 while n <> 0 do begin
                  r := n mod 8;
                  str(r,q);
                  s := q + s;
                  n := n div 8
                 end;
 Octal := s
end;

{---------------------------------------}
PROCEDURE PutVarQueue (var p: PVarTable; name: string; value: cell);
var r,q: PVarTable;
begin
 new(q); q^.varname := name; q^.value := value; q^.next := nil;
 if p = nil then p := q
            else begin
                  r := p;
                  while r^.next <> nil do r := r^.next;
                  r^.next := q
                 end
end;

{---------------------------------------}

begin
end.


