// ͻ
//    TEST-PROGRAM FOR THE VESA GRAPHICS LIBRARY 1.4 FOR PACIFIC-C    
// Ķ
//           (C) Detlef Reimers, JUNE 1999, dreimers@aol.com          
// ͼ
#include <vesa.h>

#define abs(a)  ((a < 0) ? -a : a)

// Ŀ
//  Global variables.                                                 
// 
long x, y, z;
int  c;
byt  pal[256][3];

// Ŀ
//  Global strings.                                                   
// 
char * info[2] =
{
  "GREY PALETTE PICTURES",
  "MODE %d: %dx%d"
};

// Ŀ
//  Palette: Set up our own palette colors.                           
// 
void palette(void)
{
  int i;

  for (i = 3; i < 256; i++)
  {
    pal[i][0] = i;
    pal[i][1] = i;
    pal[i][2] = i;
  }
}

// Ŀ
//  SCREEN: Set up a screen with infos and a border.                  
// 
void screen(void)
{
  int k;

  k = hor - 141 - 8*(hor/1000) - 8*(ver/1000);

  setcol(1, 63, 63, 63);
  setcol(2, 0, 23, 35);
  
  rect ( 0, 0, hor - 1, ver - 1, 1);
  hline(20, 1, hor - 1, 1);
  frect( 1, 1, hor - 2, 19, 2);
  print( 5, 7, 1, 3, info[0]);
  print( k, 7, 1, 3, info[1], mode, hor, ver);

  clip(1, 21, hor - 2, ver - 2);
}

// Ŀ
//  NEW: Waits for a keypress and clears the drawing rectangle.       
// 
void new(void)
{
  waitkey();
  frect(1, 21, hor - 2, ver - 2, 0);
}

// Ŀ
//  DEMO: Shows some nice pictures with a special palette.            
// 
void demo(int m)
{
  int i, j, h, v;

  gmode(m);

  h = hor / 2;
  v = ver / 2 - 11;

  palette();
  setpal(*pal);
  screen();

  for (x = 4; x <= h; x++)
    rect(h-x-1, v-(ver-22)*x/hor+20, h+x-1, v+(ver-22)*x/hor+20, x%253+3);
  new();

  for (x = 0; x < hor; x++)
    line(x, 20, x, ver, x%253+3);
  new();

  for (y = 20; y < ver; y++)
    line(0, y, hor, y, y%253+3);
  new();

  for (x = 0; x <= h; x++)
  {
    for (y = 0; y < v; y ++)
    {
      z = (x + 1) * (h - x);
      c = abs(((z * z) / ((y + 1) * (v - y)) >> 9)%253)+3;
      plot(h - x, v - y + 20, c);
      plot(h + x, v - y + 20, c);
      plot(h + x, v + y + 20, c);
      plot(h - x, v + y + 20, c);
    }
  }
  new();
}

// Ŀ
//  Main: It runs the demo function at several resolutions.           
// 
void main(void)
{
  demo(257);
  demo(259);
  demo(261);

  tmode();
}

