// ͻ
//    TEST-PROGRAM FOR THE VESA GRAPHICS LIBRARY 1.4 FOR PACIFIC-C    
// Ķ
//           (C) Detlef Reimers, JUNE 1999, dreimers@aol.com          
// ͼ
#include <vesa.h>

// Ŀ
//  Global strings.                                                   
// 
char * info[2] =
{
  "COLOR SCREEN",
  "MODE %d: %dx%d"
};

// Ŀ
//  SCREEN: Set up a screen with infos and a border.                  
// 
void screen(void)
{
  int k;

  k = hor - 141 - 8*(hor/1000) - 8*(ver/1000);

  setcol(255, 0, 23, 35);
  
  rect ( 0, 0, hor - 1, ver - 1, lwhite);
  hline(20, 1, hor - 1, lwhite);
  frect( 1, 1, hor - 2, 19, 255);
  print( 5, 7, lwhite, 16, info[0]);
  print( k, 7, lwhite, 16, info[1], mode, hor, ver);

  clip(2, 21, hor - 2, ver - 2);
}

// Ŀ
//  Demo: It shows a screen tiling made of squares.                   
// 
void demo(int m)
{
  int i, j;

  gmode(m);
  screen();

  for (i = 1 ; i < hor; i += 16)
    for (j = 21 ; j < ver; j += 16)
      frect(i + 1, j + 1, i + 15, j + 15, (i + j) >> 4);

  waitkey();
}

// Ŀ
//  Main: It runs the demo function at several resolutions.           
// 
void main()
{
  demo(257);
  demo(259);
  demo(261);

  tmode();
}

