// ͻ
//    TEST-PROGRAM FOR THE VESA GRAPHICS LIBRARY 1.4 FOR PACIFIC-C    
// Ķ
//           (C) Detlef Reimers, JUNE 1999, dreimers@aol.com          
// ͼ
#include <vesa.h>

// Ŀ
//  Global variables.                                                 
// 
long width, height;
int  top, left, bottom, right;

int  num[4] = {0, 15, 34, 51};
int  A[51][4][2] =
{
  22, 21, 21, 19, 22, 16, 26, 16,               // Note-key
  26, 16, 28, 16, 30, 18, 30, 20,
  30, 20, 30, 23, 28, 25, 25, 25,
  25, 25, 22, 25, 20, 22, 20, 20,
  20, 20, 20, 18, 21, 17, 23, 14,
  23, 14, 25, 11, 26, 10, 27,  7,
  27,  7, 28,  4, 26,  1, 24,  2,
  24,  2, 22,  3, 20,  5, 21,  8,
  21,  8, 22, 11, 26, 23, 27, 26,
  27, 26, 28, 29, 26, 31, 24, 31,
  24, 31, 22, 31, 20, 30, 20, 28,
  20, 28, 20, 27, 21, 26, 22, 26,
  22, 26, 23, 26, 24, 27, 24, 28,
  24, 28, 24, 29, 23, 30, 22, 30,
  22, 30, 21, 30, 20, 29, 20, 28,

  31, 20, 31, 20, 17, 20, 17, 20,               // "A"
  17, 20, 17, 20, 14, 26, 14, 26,
  14, 26, 13, 28, 13, 28, 16, 29,
  16, 29, 16, 29, 16, 30, 16, 30,
  16, 30, 16, 30,  8, 30,  8, 30,
   8, 30,  8, 30,  8, 29,  8, 29,
   8, 29, 10, 28, 10, 28, 11, 26,
  11, 26, 11, 26, 23,  2, 23,  2,
  23,  2, 23,  2, 25,  2, 25,  2,
  25,  2, 25,  2, 37, 26, 37, 26,
  37, 26, 38, 28, 38, 28, 40, 29,
  40, 29, 40, 29, 40, 30, 40, 30,
  40, 30, 40, 30, 32, 30, 32, 30,
  32, 30, 32, 30, 32, 29, 32, 29,
  32, 29, 35, 28, 35, 28, 34, 26,
  34, 26, 34, 26, 31, 20, 31, 20,
  30, 18, 30, 18, 18, 18, 18, 18,
  18, 18, 18, 18, 24,  6, 24,  6,
  24,  6, 24,  6, 30, 18, 30, 18,

  16, 30, 16, 30, 16, 29, 16, 29,               // "B"
  16, 29, 18, 28, 18, 28, 18, 26,
  18, 26, 18, 26, 18,  6, 18,  6,
  18,  6, 18,  4, 18,  4, 16,  3,
  16,  3, 16,  3, 16,  2, 16,  2,
  16,  2, 16,  2, 26,  2, 26,  2,
  26,  2, 36,  2, 36, 14, 30, 16,
  30, 16, 36, 18, 36, 30, 26, 30,
  26, 30, 26, 30, 16, 30, 16, 30,
  22, 26, 22, 26, 22, 18, 22, 18,
  22, 18, 22, 18, 26, 18, 26, 18,
  26, 18, 31, 18, 31, 26, 26, 26,
  26, 26, 26, 26, 22, 26, 22, 26,
  22, 14, 22, 14, 22,  6, 22,  6,
  22,  6, 22,  6, 26,  6, 26,  6,
  26,  6, 31,  6, 31, 14, 26, 14,
  26, 14, 26, 14, 22, 14, 22, 14
};

// Ŀ
//  Global strings.                                                   
// 
char * info[2] =
{
  "DRAWING CHARACTERS WITH BEZIER",
  "MODE %d: %dx%d"
};

// Ŀ
//  SCREEN: Set up a screen with infos and a border.                  
// 
void screen(void)
{
  int k;

  top    = 21;
  left   = 1;
  right  = hor - 2;
  bottom = ver - 2;
  width  = right  - left;
  height = bottom - top;
  k      = hor - 141 - 8*(hor/1000) - 8*(ver/1000);

  setcol(blue, 0,   23, 35);

  rect ( 0, 0, hor - 1, ver - 1, lwhite);
  hline(20, 1, hor - 1, lwhite);
  frect( 1, 1, hor - 2, 19, blue);
  print( 5, 7, lwhite , 16, info[0]);
  print( k, 7, lwhite , 16, info[1], mode, hor, ver);
}

// Ŀ
//  GRID: Draw a grid with a scale.                                   
// 
void grid(int col1, int col2, int col3)
{
  int i;
  long x, y;

  for (i = 1; i < 32; i++)
  {
    y = i * height / 32 + top;
    hline(y, left, right, col1);
  }

  for (i = 1; i < 48; i++)
  {
    x = i * width / 48 + left;
    vline(x, top, bottom, col1);
  }

  for (i = 4; i < 32; i+ = 4)
  {
    y = i * height / 32 + top;
    hline(y, left, right, col2);
    y = y -4;
    print(6, y, col3, 0, "%d", i);
  }

  for (i = 4; i < 48; i+ = 4)
  {
    x = i * width / 48 + left;
    vline(x, top, bottom, col2);
    x = x - 3;
    if (i > 10)
      x = x - 4;
    print(x, 26, col3, 0, "%d", i);
  }
}

// Ŀ
//  POINTS: This draws the bezier points.                             
// 
void points(int col1, int col2)
{
  fcircle(bez[1][0], bez[1][1], 2, col2);
  fcircle(bez[2][0], bez[2][1], 2, col2);

  fcircle(bez[0][0], bez[0][1], 2, col1);
  fcircle(bez[3][0], bez[3][1], 2, col1);
}

// Ŀ
//  HANDLES: This draws the bezier handles.                           
// 
void handles(int col)
{
  line(bez[0][0], bez[0][1], bez[1][0], bez[1][1], col);
  line(bez[2][0], bez[2][1], bez[3][0], bez[3][1], col);
}

// Ŀ
//  DEMO: This draws the grid and thw whole characters "A" and "B".   
// 
void demo(int mode)
{
  int i, j, k;

  gmode(mode);
  setcol(blue, 0, 23, 35);

  for (i = 0; i < 3; i++)
  {
    clear(black);
    screen();
    grid(21, 24, 28);

    for (j = num[i]; j < num[i + 1]; j++)
    {
      for (k = 0; k < 4; k++)
      {
        bez[k][0] = left + A[j][k][0] * width  / 48;
        bez[k][1] = top  + A[j][k][1] * height / 32;
      }
      handles(red);
      bezier(5, lgreen);
      points(44, 32);
    }
    waitkey();
  }
}

// Ŀ
//  Main: It runs the demo function in several resolutions.           
// 
void main(void)
{
  demo(257);
  demo(259);
  demo(261);

  tmode();
}

