; ͻ
;              VESA GRAPHICS LIBRARY 1.4 FOR PACIFIC-C                
; Ķ
;          (C) Detlef Reimers, JUNE 1999, dreimers@aol.com            
; ͼ
        .386
        .psect  text,global

; Ŀ
;   Global functions.                                                 
; 
        .globl  _printf
        .globl  _sprintf
        .globl  _vsprintf
        .globl  adivl
        .globl  amull

        .globl  _bye
        .globl  _key
        .globl  _waitkey
        .globl  _gmode
        .globl  _tmode
        .globl  _clip
        .globl  _noclip
        .globl  _clear
	.globl	_pmode
	.globl	_setpix
	.globl	_plot
        .globl  _line
        .globl  _bezier
        .globl  _moveto
        .globl  _lineto
        .globl  _curveto
        .globl  _hline
        .globl  _vline
        .globl  _rect
        .globl  _frect
        .globl  _circle
        .globl  _fcircle
        .globl  _ellipse
        .globl  _setcol
        .globl  _getfont
        .globl  _outstr
        .globl  _print
        .globl  _setpal
        .globl  _retrace

; Ŀ
;   Global variables.                                                 
; 
        .globl  _mode
        .globl  _hor
        .globl  _ver
        .globl  _xmin
        .globl  _ymin
        .globl  _xmax
        .globl  _ymax
        .globl  _bez
        .globl  _xcur
        .globl  _ycur
        .globl  _font

; Ŀ
;   Go back to text mode and quit the program:                        
;                                                                     
;   void bye(void)                                                    
; 
_bye:
        call    _tmode          ;   back to text mode
        mov     ah,#4ch         ;   and
        int     #21h            ;   return to DOS

        ret

; Ŀ
;   Wait until key is pressed. Quit program if ESC was pressed.       
;                                                                     
;   int waitkey(void)                                                 
; 
_key:
        mov     ah,#1
        int     #16h
        jz      2f
        mov     ah,#0
        int     #16h
        cmp     al,#27
        brne    1f
        call    _bye
1:
        mov     ax,#1
        jmp     3f
2:
        mov     ax,#0
3:
        ret

; Ŀ
;   Wait until key is pressed. Quit program if ESC was pressed.       
;                                                                     
;   int waitkey(void)                                                 
; 
_waitkey:
        mov     ax,#0
        int     #16h
        cmp     al,#27
        brne    1f
        call    _bye
1:
        cmp     al,#0
        brne    2f
        ror     ax,#8
2:
        and     ax,#255
        ret

; Ŀ
;   Get VESA informations (internal function, called from gmode):     
;                                                                     
;                dx                                                   
;                                                                    
;   void vinf(int m)                                                  
; 
_vinf:
        push    bp
        mov     bp,sp

        mov     ax,#4f01h       ; call VESA function
        mov     cx,dx           ; copy the graph mode
        mov     di,#buff        ; get buffer offset
        mov     bx,#seg(buff)   ; get buffer segment
        mov     es,bx           ; save in segment register
        int     #10h
        mov     ecx,es:12[di]   ; load far pointer for bank switching
        mov     switch,ecx      ; save pointer

        leave
        ret

; Ŀ
;   Get back to text mode:                                            
;                                                                     
;   void tmode(void)                                                  
; 
_tmode:
        mov     ax,#03h         ; call DOS function to go
        int     #10h            ;   back to text mode
        push    #35
        push    #23
        mov     al,#0
        mov     dx,#1
        call    _setcol         ;   set my special blue

        ret

; Ŀ
;   Set the VESA graphics mode.                                       
;                                                                     
;                 dx                                                  
;                                                                    
;   void gmode(int m)                                                 
; 
_gmode:
        push    bp
        mov     bp,sp

	mov	cs:pix,#88h,byte
	mov	_mode,dx
        call    _vinf           ; get VESA info for
        mov     di,#0           ; start with first mode in
        mov     cx,_mode        ;   the mode list at the end
        br      2f
1:
        cmp     cx,vesa[di]
        je      3f
        add     di,#8           ;   and go through all of them
2:
        cmp     di,#len
        jl      1b
        br      4f              ; mode is not supported
3:
        mov     bx,vesa+6[di]   ; read in the values for
        mov     banks,bx        ;   this mode
        mov     cx,vesa+4[di]
        mov     _ver,cx
        mov     ax,vesa+2[di]
        mov     _hor,ax

        mov     ax,#4f02h       ; call the VESA function
        mov     bx,_mode        ;   to set up the mode
        int     #10h
        cmp     ah,#0           ; look if it's avaliable
        je      5f              ; mode is supported
4:
        call    _tmode          ; go back to text mode
        push    _mode,word      ; otherwise:
        push    #txt            ;   print a message that the
        call    _printf         ;   mode is not supported
        call    _waitkey        ;   wait for keypress
        call    _bye            ;   go back to DOS
5:
        call    _getfont        ; get 8x8 ROM font
        call    _noclip         ; deactivate clipping

        mov     sp,bp
        pop     bp
        ret

; Ŀ
;   Set cliprect and active clipping:                                 
;                                                                     
;                dx      ax    4[bp]  6[bp]                           
;                                                                 
;  void clip(int x1, int y1, int x2, int y2)                          
; 
_clip:
        push    bp
        mov     bp,sp

        mov     _xmin,dx        ; xmin
        mov     _ymin,ax        ; ymin
        mov     cx,4[bp]
        mov     _xmax,cx        ; xmax
        mov     cx,6[bp]
        mov     _ymax,cx        ; ymax
	mov	clp,#1,word	; enable clipping

        leave
        ret     #4

; Ŀ
;   Set cliprect to whole screen and deactivate clipping:             
;                                                                     
;  void cliprect(void)                                                
; 
_noclip:
        push    bp
        mov     bp,sp

        mov     _xmin,#0,word   ; xmin
        mov     _ymin,#0,word   ; ymin
        mov     ax,_hor
        mov     _xmax,ax        ; xmax
        mov     ax,_ver
        mov     _ymax,ax        ; ymax
	mov	clp,#0,word	; disable clipping

        leave
        ret

; Ŀ
;   Clear the entire screen with a color:                             
;                                                                     
;                 dx                                                  
;                                                                    
;   void clear(int c)                                                 
; 
_clear:
        push    bp
        mov     bp,sp
        sub     sp,#4

        mov     -1[bp],dl       ; color
        mov     -2[bp],dl       ; color
        mov     -3[bp],dl       ; color
        mov     -4[bp],dl       ; color
        mov     ax,#0a000h      ; VGA video ram
        mov     es,ax           ; into segment
        mov     cx,banks        ; change it for smaller gran size
1:                              ;   (at the end of this file)
        push    cx
        mov     dl,cl
        dec     dl              ; we go backwards
        xor     bx,bx           ; needed for switching
        callf   [switch]        ; switch video banks
        mov     cx,#16384       ; the size of the window / 2
        mov     eax,-4[bp]
        mov     di,#0
        repz    stosd           ; and draw four pixels

        pop     cx
        dec     cx
        jnz     1b
        mov     sp,bp
        pop     bp
        ret

; Ŀ
;   Set the pixel mode to 0..3: copy, and, or, xor		       
;                                                                     
; 		   dx						       
; 		    						       
;   void pmode(int m)						       
; 
_pmode:
	push	bp
        mov     bp,sp

	cmp	dx,#1
        je      1f
	cmp	dx,#2
	je	2f
	cmp	dx,#3
	je	3f
	mov	al,#88h
	jmp	4f
1:
	mov	al,#20h
	jmp	4f
2:
	mov	al,#08h
	jmp	4f
3:
	mov	al,#30h
	jmp	4f
4:
	mov	cs:pix,al
        leave
	ret

; Ŀ
;   Plot a single pixel with color and pixel mode:		       
;                                                                     
;   void setpix(void)                                                 
; 
_setpix:
	.byte	26h
pix:	.byte	0h
        .byte   04h
        ret

; Ŀ
;   Plot a single pixel with color:                                   
;                                                                     
;                dx     ax   4[bp]                                    
;                                                                  
;   void plot(int x, int y, int c)                                    
; 
_plot:
        push    bp
        mov     bp,sp
;	 push	 ax

	cmp	clp,#0,word	; check if clipping is active
        je      1f              ; no, go ahead

        cmp     dx,_xmin        ; we have to check all coordinates
        jl      3f              ; against the clipping limits
        cmp     dx,_xmax        ; If a point is not inside
        jg      3f              ; the cliprect, nothing is drawn
        cmp     ax,_ymin
        jl      3f
        cmp     ax,_ymax
        jg      3f
1:
        mov     bx,dx           ; get x
        mov     cx,ax           ; get y
        xor     dx,dx           ; clear dx
        mov     ax,#0A000h      ; start of VGA video
        mov     es,ax           ; set segment to this
        mov     ax,_hor

        mul     cx
        add     ax,bx           ; y * scanline + x
        adc     dl,#0           ; this will ensure that the code
        mov     si,ax           ;   also works just after switches
        cmp     dl,wind         ; do we have to switch the bank?
        je      2f              ;   no, do nothing

        xor     bx,bx           ; needed for switching
        mov     wind,dl         ; save curent window
        callf   [switch]        ; switch video banks
2:
	mov	al,4[bp],byte	; get color value
	call	_setpix
3:
;	 pop	 ax
        mov     sp,bp
        pop     bp
        ret     #2

; Ŀ
;   Draw a line (Bresenham algorithm):                                
;                                                                     
;                 dx      ax    4[bp]  6[bp]  8[bp]                   
;                                                                
;  void line(int x1, int y1, int x2, int y2, int c)                   
; 
_line:
        push    bp
        mov     bp,sp
        sub     sp,#22

        mov     cx,4[bp]        ; x2
        sub     cx,dx           ; dx = x2 - x1
        mov     -16[bp],cx      ; dx
        mov     -20[bp],ax      ; y1
        or      cx,cx
        mov     ax,cx
        brnl    1f
        neg     ax              ; ax = ((dx < 0) ? -dx : dx) << 1
1:
        add     ax,ax
        mov     -8[bp],ax
        cmp     -16[bp],#0,word ; dx < 0 ?
        brl     2f              ; if yes
        mov     ax,#1           ; else
        jmp     3f
2:
        mov     ax,#-1
3:
        mov     -12[bp],ax
        mov     cx,6[bp]
        sub     cx,-20[bp]
        mov     -18[bp],cx      ; dy = y2-y1
        or      cx,cx
        mov     ax,cx
        brnl    4f
        neg     ax              ; ay = ((dy < 0) ? -dy : dy) << 1
4:
        add     ax,ax
        mov     -10[bp],ax
        cmp     -18[bp],#0,word
        brl     5f
        mov     ax,#1
        jmp     6f              ; sy = ((dy < 0) ? -1 : 1)
5:
        mov     ax,#-1
6:
        mov     -14[bp],ax
        mov     -4[bp],dx       ; x = x1
        mov     cx,-20[bp]
        mov     -6[bp],cx       ; y = y1
        mov     -22[bp],dx      ; x1
        mov     cx,-8[bp]
        cmp     cx,-10[bp]      ; if (ax > ay)
        brle    10f
        mov     bx,cx
        sar     bx,#1
        mov     cx,-10[bp]
        sub     cx,bx
        mov     -2[bp],cx       ; d = ay - (ax >> 1)
        jmp     9f              ; while(x != x2)
7:
        push    8[bp]
        mov     ax,-6[bp]
        mov     dx,-4[bp]
        call    _plot           ; plot(x, y, c)
        cmp     -2[bp],#0,word  ; if (d >= 0)
        brl     8f
        mov     cx,-14[bp]
        add     -6[bp],cx       ; y += sy
        mov     cx,-8[bp]
        sub     -2[bp],cx       ; d = - ax
8:
        mov     cx,-12[bp]
        add     -4[bp],cx       ; x += sx
        mov     cx,-10[bp]
        add     -2[bp],cx       ; d += ax
9:
        mov     cx,-4[bp]
        cmp     cx,4[bp]
        brne    7b
        jmp     14f             ; else
10:
        mov     bx,-10[bp]
        sar     bx,#1
        mov     cx,-8[bp]
        sub     cx,bx
        mov     -2[bp],cx       ; d = ax - (ay >> 1)
        jmp     13f             ; while ( y != y2)
11:
        push    8[bp]
        mov     ax,-6[bp]
        mov     dx,-4[bp]
        call    _plot           ; plot(x, y, c)
        cmp     -2[bp],#0,word  ; if ( d >= 0)
        brl     12f
        mov     cx,-12[bp]
        add     -4[bp],cx       ; x += sx
        mov     cx,-10[bp]
        sub     -2[bp],cx       ; d -= ay
12:
        mov     cx,-14[bp]
        add     -6[bp],cx       ; y += sy
        mov     cx,-8[bp]
        add     -2[bp],cx       ; d += ax
13:
        mov     cx,-6[bp]
        cmp     cx,6[bp]
        brne    11b
14:
        mov     sp,bp
        pop     bp
        ret     #6

; Ŀ
;   Draw a bezier curve with 2^n line segments from 4 control points: 
;                                                                     
;                  dx      ax                                         
;                                                                   
;   void bezier(int n, int col)                                       
; 
_bezier:
        push    bp
        mov     bp,sp
        sub     sp,#62
        push    di
        push    si

        mov     -6[bp],dx
        mov     cx,dx
        add     cx,dx
        mov     -8[bp],cx
        add     cx,dx
        mov     -10[bp],cx
        mov     cl,dl
        mov     bx,#1
        sal     bx,cl
        mov     dx,bx
        mov     -2[bp],#0,word
        mov     -60[bp],ax
        mov     -62[bp],dx
        jmp     8f
1:
        mov     bx,-2[bp]
        add     bx,bx
        mov     ax,_bez[bx]
        cwd
        mov     di,-2[bp]
        sal     di,#2
        mov     -58[bp][di],ax
        mov     -56[bp][di],dx
        mov     cx,-10[bp]
        mov     ch,#0
        mov     di,-2[bp]
        sal     di,#2
        mov     ax,-58[bp][di]
        mov     dx,-56[bp][di]
        jcxz    3f
2:
        add     ax,ax
        adc     dx,dx
        loop    2b
3:
        mov     di,-2[bp]
        sal     di,#2
        mov     -58[bp][di],ax
        mov     -56[bp][di],dx
        mov     di,-2[bp]
        sal     di,#2
        mov     -42[bp][di],#0,word
        mov     -40[bp][di],#0,word
        mov     di,-2[bp]
        sal     di,#2
        mov     -50[bp][di],#0,word
        mov     -48[bp][di],#0,word
        mov     bx,-2[bp]
        add     bx,bx
        mov     di,-2[bp]
        add     di,di
        mov     ax,_bez+4[di]
        sub     ax,_bez[bx]
        cwd
        mov     di,-2[bp]
        sal     di,#2
        mov     -34[bp][di],ax
        mov     -32[bp][di],dx
        mov     di,-2[bp]
        sal     di,#2
        mov     si,-2[bp]
        sal     si,#2
        lea     cx,-34[bp]
        mov     bx,-2[bp]
        sal     bx,#2
        add     bx,cx
        mov     ax,[bx]
        mov     cx,2[bx]
        add     ax,-34[bp][si]
        adc     cx,-32[bp][si]
        add     ax,-34[bp][di]
        adc     cx,-32[bp][di]
        mov     di,-2[bp]
        sal     di,#2
        mov     -34[bp][di],ax
        mov     -32[bp][di],cx
        mov     bx,-2[bp]
        add     bx,bx
        mov     ax,_bez+8[bx]
        mov     bx,-2[bp]
        add     bx,bx
        sub     ax,_bez+4[bx]
        cwd
        mov     di,-2[bp]
        sal     di,#2
        mov     -26[bp][di],ax
        mov     -24[bp][di],dx
        mov     di,-2[bp]
        sal     di,#2
        mov     si,-2[bp]
        sal     si,#2
        lea     cx,-26[bp]
        mov     bx,-2[bp]
        sal     bx,#2
        add     bx,cx
        push    2[bx]
        push    [bx]
        lea     cx,-26[bp]
        mov     bx,-2[bp]
        sal     bx,#2
        add     bx,cx
        mov     ax,[bx]
        mov     dx,2[bx]
        pop     cx
        add     ax,cx
        pop     cx
        adc     dx,cx
        add     ax,-26[bp][si]
        adc     dx,-24[bp][si]
        sub     ax,-34[bp][di]
        sbb     dx,-32[bp][di]
        mov     di,-2[bp]
        sal     di,#2
        mov     -26[bp][di],ax
        mov     -24[bp][di],dx
        mov     bx,-2[bp]
        add     bx,bx
        mov     di,-2[bp]
        add     di,di
        mov     ax,_bez+12[di]
        sub     ax,_bez[bx]
        cwd
        mov     di,-2[bp]
        sal     di,#2
        mov     -18[bp][di],ax
        mov     -16[bp][di],dx
        mov     di,-2[bp]
        sal     di,#2
        mov     si,-2[bp]
        sal     si,#2
        lea     cx,-18[bp]
        mov     bx,-2[bp]
        sal     bx,#2
        add     bx,cx
        mov     ax,[bx]
        mov     cx,2[bx]
        sub     ax,-26[bp][si]
        sbb     cx,-24[bp][si]
        sub     ax,-34[bp][di]
        sbb     cx,-32[bp][di]
        mov     di,-2[bp]
        sal     di,#2
        mov     -18[bp][di],ax
        mov     -16[bp][di],cx
        mov     cx,-6[bp]
        mov     ch,#0
        mov     di,-2[bp]
        sal     di,#2
        mov     ax,-26[bp][di]
        mov     dx,-24[bp][di]
        jcxz    5f
4:
        add     ax,ax
        adc     dx,dx
        loop    4b
5:
        mov     di,-2[bp]
        sal     di,#2
        mov     -26[bp][di],ax
        mov     -24[bp][di],dx
        mov     di,-2[bp]
        sal     di,#2
        mov     si,-2[bp]
        sal     si,#2
        mov     cx,-8[bp]
        mov     ch,#0
        lea     ax,-34[bp]
        mov     bx,-2[bp]
        sal     bx,#2
        add     bx,ax
        mov     ax,[bx]
        mov     dx,2[bx]
        jcxz    7f
6:
        add     ax,ax
        adc     dx,dx
        loop    6b
7:
        add     ax,-18[bp][si]
        adc     dx,-16[bp][si]
        add     ax,-26[bp][di]
        adc     dx,-24[bp][di]
        mov     di,-2[bp]
        sal     di,#2
        mov     -34[bp][di],ax
        mov     -32[bp][di],dx
        mov     di,-2[bp]
        sal     di,#2
        lea     cx,-18[bp]
        mov     bx,-2[bp]
        sal     bx,#2
        add     bx,cx
        mov     ax,[bx]
        mov     cx,2[bx]
        add     ax,ax
        adc     cx,cx
        add     ax,-18[bp][di]
        adc     cx,-16[bp][di]
        add     ax,ax
        adc     cx,cx
        mov     di,-2[bp]
        sal     di,#2
        mov     -18[bp][di],ax
        mov     -16[bp][di],cx
        mov     di,-2[bp]
        sal     di,#2
        lea     cx,-26[bp]
        mov     bx,-2[bp]
        sal     bx,#2
        add     bx,cx
        mov     ax,[bx]
        mov     cx,2[bx]
        add     ax,ax
        adc     cx,cx
        add     ax,-18[bp][di]
        adc     cx,-16[bp][di]
        mov     di,-2[bp]
        sal     di,#2
        mov     -26[bp][di],ax
        mov     -24[bp][di],cx
        inc     -2[bp],word
8:
        cmp     -2[bp],#2,word
        brl     1b
        mov     ax,_bez+2
        mov     dx,_bez
        call    _moveto
        mov     -4[bp],#1,word
        jmp     16f
9:
        mov     -2[bp],#0,word
        jmp     11f
10:
        mov     di,-2[bp]
        sal     di,#2
        mov     si,-2[bp]
        sal     si,#2
        lea     cx,-34[bp]
        mov     bx,-2[bp]
        sal     bx,#2
        add     bx,cx
        mov     ax,[bx]
        mov     cx,2[bx]
        add     ax,-58[bp][si]
        adc     cx,-56[bp][si]
        add     ax,-42[bp][di]
        adc     cx,-40[bp][di]
        mov     di,-2[bp]
        sal     di,#2
        mov     -58[bp][di],ax
        mov     -56[bp][di],cx
        mov     di,-2[bp]
        sal     di,#2
        mov     si,-2[bp]
        sal     si,#2
        lea     cx,-26[bp]
        mov     bx,-2[bp]
        sal     bx,#2
        add     bx,cx
        mov     ax,[bx]
        mov     cx,2[bx]
        add     ax,-42[bp][si]
        adc     cx,-40[bp][si]
        add     ax,-50[bp][di]
        adc     cx,-48[bp][di]
        mov     di,-2[bp]
        sal     di,#2
        mov     -42[bp][di],ax
        mov     -40[bp][di],cx
        mov     di,-2[bp]
        sal     di,#2
        mov     ax,-50[bp][di]
        mov     cx,-48[bp][di]
        mov     di,-2[bp]
        sal     di,#2
        add     ax,-18[bp][di]
        adc     cx,-16[bp][di]
        mov     di,-2[bp]
        sal     di,#2
        mov     -50[bp][di],ax
        mov     -48[bp][di],cx
        inc     -2[bp],word
11:
        cmp     -2[bp],#2,word
        brl     10b
        push    -60[bp]
        mov     cx,-10[bp]
        mov     ch,#0
        mov     ax,-54[bp]
        mov     dx,-52[bp]
        jcxz    13f
12:
        sar     dx,#1
        rcr     ax,#1
        loop    12b
13:
        mov     cx,-10[bp]
        mov     ch,#0
        mov     di,-58[bp]
        mov     dx,-56[bp]
        jcxz    15f
14:
        sar     dx,#1
        rcr     di,#1
        loop    14b
15:
        mov     dx,di
        call    _lineto
        inc     -4[bp],word
16:
        mov     cx,-4[bp]
        cmp     cx,-62[bp]
        brle    9b

        pop     si
        pop     di
        leave
        ret

; Ŀ
;   Set current point to (x,y):                                       
;                                                                     
;                 dx     ax                                           
;                                                                   
;  void moveto(int x, int y)                                          
; 
_moveto:
        mov     _xcur,dx        ; simply store the point
        mov     _ycur,ax
        ret

; Ŀ
;   Draw a line form current point to (x,y):                          
;                                                                     
;                 dx     ax   4[bp]                                   
;                                                                  
;  void lineto(int x, int y, int c)                                   
; 
_lineto:
        push    bp
        mov     bp,sp
        sub     sp,#4

        mov     -2[bp],dx       ; save x
        mov     -4[bp],ax       ; save y
        push    4[bp],word      ; c
        push    ax              ; y2 = y
        push    dx              ; x2 = x
        mov     ax,_ycur        ; y1 = ycur
        mov     dx,_xcur        ; x1 = xcur
        call    _line           ; draw line
        mov     bx,-2[bp],word
        mov     _xcur,bx        ; xcur = x2
        mov     bx,-4[bp],word
        mov     _ycur,bx        ; ycur = y2

        mov     sp,bp
        pop     bp
        ret     #2

; Ŀ
;   Draw a bezier curve with 2^n line segments from the current point 
;   and 3 control points:                                             
;                   dx      ax                                        
;                                                                   
;   void curveto(int n, int col)                                      
; 
_curveto:
        push    bp
        mov     bp,sp
        push    cx
        push    cx

        mov     cx,_xcur
        mov     _bez,cx
        mov     cx,_ycur
        mov     _bez+2,cx
        mov     -2[bp],ax
        mov     -4[bp],dx
        call    _bezier
        mov     ax,_bez+14
        mov     dx,_bez+12
        call    _moveto

        leave
        ret

; Ŀ
;   Draw a horizontal line:                                           
;                                                                     
;                  dx      ax    4[bp]  6[bp]                         
;                                                                 
;   void hline (int y, int x1, int x2, int c)                         
; 
_hline:
        push    bp
        mov     bp,sp
        sub     sp,#4
        push    ax

        mov     -2[bp],dx       ; save y
        mov     -4[bp],ax       ; save x1
        cmp     ax,4[bp]        ; if x1 < x2
        jle     1f              ;   go ahead
        mov     bx,4[bp]        ; else
        mov     4[bp],ax        ;   swap x1 and x2
        mov     ax,bx           ; x1 = min(x1, x2)
        mov     -4[bp],bx       ; save x1
1:
	cmp	clp,#0,word	; check if clipping is active
        je      3f              ; no, go ahead

        mov     bx,_ymin
        mov     cx,_ymax
        cmp     dx,bx           ; y < ymin?
        jl      6f              ;  yes, don't draw
        cmp     dx,cx           ; y > ymax?
        jg      6f              ;  yes, don't draw

        mov     bx,_xmin
        mov     cx,_xmax

        cmp     4[bp],bx        ; x2 < xmin?
        jl      6f              ;  no, go next

        cmp     ax,cx           ; x1 > xmax?
        jg      6f              ;  no, go next

        cmp     ax,bx           ; x1 < xmin?
        jg      2f              ;  no, go next
        mov     ax,bx           ;  yes, set x1 = xmin
        mov     -4[bp],ax       ;  and store it
2:
        cmp     4[bp],cx        ; x2 > xmax?
        jl      3f              ;  no, go next
        mov     4[bp],cx        ;  yes, set x2 = xmax
3:
        mov     di,4[bp]        ; n = x2
        sub     di,ax           ; n = x2 - x1
        inc     di              ; n = n + 1 (if x1 = x2)

        mov     cx,#0A000h      ; start of VGA video
        mov     es,cx           ; set segment to this

        xor     dx,dx           ; clear dx
        mov     ax,_hor         ; hor
        mul     -2[bp],word     ; y * scanline
        add     ax,-4[bp],word  ; y * scanline + x
4:
        adc     dl,#0           ; add with carry (1 at bank limit)
        mov     si,ax

        cmp     dl,wind         ; do we have to switch the bank?
        je      5f              ;   no, do nothing

        xor     bx,bx           ; needed for switching
        mov     wind,dl         ; save curent window
        callf   [switch]        ; switch video banks
5:
        mov     al,6[bp],byte   ; get color value
	call	_setpix
	mov	ax,si		; get old position
        add     ax,#1           ; next point
        dec     di              ; n = n - 1
        jnz     4b
6:
        pop     ax
        mov     sp,bp
        pop     bp
        ret     #4

; Ŀ
;   Draw a vertical line:                                             
;                                                                     
;                  dx      ax    4[bp]  6[bp]                         
;                                                                 
;   void vline (int x, int y1, int y2, int c)                         
; 
_vline:
        push    bp
        mov     bp,sp
        sub     sp,#4
        push    ax

        mov     -2[bp],dx       ; x
        mov     -4[bp],ax       ; y1
        cmp     ax,4[bp]        ; if y1 < y2
        jle     1f              ;   go ahead
        mov     bx,4[bp]        ; else
        mov     4[bp],ax        ;   swap y1 and y2
        mov     ax,bx           ; y1 = min(y1, y2)
        mov     -4[bp],bx       ; save y1
1:
	cmp	clp,#0,word	; check if clipping is active
        je      3f              ; no, go ahead

        mov     bx,_xmin
        mov     cx,_xmax
        cmp     dx,bx           ; x < xmin?
        jl      6f              ;  yes, don't draw
        cmp     dx,cx           ; x > xmax?
        jg      6f              ;  yes, don't draw

        mov     bx,_ymin
        mov     cx,_ymax
        cmp     4[bp],bx        ; y2 < ymin?
        jle     6f              ;  no, go next
        cmp     ax,cx           ; y1 > ymax?
        jge     6f              ;  no, go next

        cmp     ax,bx           ; y1 < xmin?
        jg      2f              ;  no, go next
        mov     ax,bx           ;  yes, set y1 = ymin
        mov     -4[bp],ax       ;  and store it
2:
        cmp     4[bp],cx        ; y2 > ymax?
        jl      3f              ;  no, go next
        mov     4[bp],cx        ;  yes, set y2 = ymax
3:
        mov     di,4[bp]        ; n = y2
        sub     di,ax           ; n = y2 - y1
        inc     di              ; n = n + 1 (if y1 = y2)

        mov     cx,#0A000h      ; start of VGA video
        mov     es,cx           ; set segment to this

        xor     dx,dx           ; clear dx
        mov     ax,_hor         ; hor
        mul     -4[bp],word     ; y * scanline
        add     ax,-2[bp],word  ; y * scanline + x

4:      adc     dl,#0           ; add with carry (1 at bank limit)
        mov     si,ax

        cmp     dl,wind         ; do we have to switch the bank?
        je      5f              ;   no, do nothing

        xor     bx,bx           ; needed for switching
        mov     wind,dl         ; save current window
        callf   [switch]        ; switch video banks
5:
        mov     al,6[bp],byte   ; get color value
        call    _setpix
        mov     ax,si           ; get old position
        add     ax,_hor         ; next line
        dec     di              ; n = n - 1
        jnz     4b
6:
        pop     ax
        mov     sp,bp
        pop     bp
        ret     #4

; Ŀ
;   Draw a rectangle:                                                 
;                                                                     
;                 dx      ax    4[bp]  6[bp]   8[bp]                  
;                                                                
;   void rect(int x1, int y1, int x2, int y2, int c)                  
; 
_rect:
        push    bp
        mov     bp,sp
        push    cx
        push    cx

        mov     -2[bp],ax       ; y1
        mov     -4[bp],dx       ; x1

        push    8[bp]           ; c
        push    4[bp]           ; x2
        mov     ax,dx           ; x1
        mov     dx,-2[bp]       ; y1
        call    _hline

        push    8[bp]           ; c
        push    4[bp]           ; x2
        mov     dx,6[bp]        ; y2
        call    _hline

        push    8[bp]           ; c
        push    6[bp]           ; y2
        mov     ax,-2[bp]       ; y1
        mov     dx,-4[bp]       ; x1
        call    _vline

        push    8[bp]           ; c
        push    6[bp]           ; y2
        mov     dx,4[bp]        ; x2
        call    _vline

        mov     sp,bp
        pop     bp
        ret     #6

; Ŀ
;   Draw a filled rectangle:                                          
;                                                                     
;                  dx      ax    4[bp]  6[bp]   8[bp]                 
;                                                                
;   void frect(int x1, int y1, int x2, int y2, int c)                 
; 
_frect:
        push    bp
        mov     bp,sp
        sub     sp,#6

        mov     -2[bp],ax       ; y
        mov     -4[bp],ax       ; y1
        mov     -6[bp],dx       ; x1
        jmp     2f
1:
        push    8[bp]           ; c
        push    4[bp]           ; x2
        mov     ax,-6[bp]       ; x1
        mov     dx,-2[bp]       ; y
        call    _hline
        inc     -2[bp],word
2:
        mov     cx,-2[bp]
        cmp     cx,6[bp]
        brle    1b

        mov     sp,bp
        pop     bp
        ret     #6

; Ŀ
;   Draw a circle:                                                    
;                                                                     
;                    dx      ax   4[bp]  6[bp]                        
;                                                                 
;   void circle (int xm, int ym, int r, int c)                        
; 
_circle:
	push	bp
	mov	bp,sp
	sub	sp,#10

	mov	-2[bp],#0,word
	mov	cx,4[bp]
	mov	-4[bp],cx
	mov	cx,#2
	sub	cx,4[bp]
	sub	cx,4[bp]
	mov	-6[bp],cx
	mov	-8[bp],ax
	mov	-10[bp],dx
	jmp	3f
1:
	add	ax,-4[bp]
	mov	dx,-10[bp]
	add	dx,-2[bp]
	call	_plot

	push	6[bp]
	mov	ax,-8[bp]
	sub	ax,-4[bp]
	mov	dx,-10[bp]
	add	dx,-2[bp]
	call	_plot

	push	6[bp]
	mov	ax,-8[bp]
	add	ax,-4[bp]
	mov	dx,-10[bp]
	sub	dx,-2[bp]
	call	_plot

	push	6[bp]
	mov	ax,-8[bp]
	sub	ax,-4[bp]
	mov	dx,-10[bp]
	sub	dx,-2[bp]
	call	_plot

	mov	cx,-6[bp]
	add	cx,-4[bp]
	brle	2f
	dec	-4[bp],word
	mov	cx,-4[bp]
	add	cx,cx
	sub	cx,#1
	sub	-6[bp],cx
2:
	mov	cx,-2[bp]
	cmp	cx,-6[bp]
	brle	3f
	inc	-2[bp],word
	mov	cx,-2[bp]
	add	cx,cx
	inc	cx
	add	-6[bp],cx
3:
	cmp	-4[bp],#0,word
	push	6[bp]
	mov	ax,-8[bp]
	brnl	1b
	mov	dx,-10[bp]
	add	dx,4[bp]
	call	_plot

	push	6[bp]
	mov	ax,-8[bp]
	mov	dx,-10[bp]
	sub	dx,4[bp]
	call	_plot

	push	6[bp]
	mov	ax,-8[bp]
	sub	ax,4[bp]
	mov	dx,-10[bp]
	call	_plot

	push	6[bp]
	mov	ax,-8[bp]
	add	ax,4[bp]
	mov	dx,-10[bp]
	call	_plot

	leave
	ret	#4

; Ŀ
;   Draw a filled circle:                                             
;                                                                     
;                    dx      ax    4[bp]  6[bp]                       
;                                                                 
;   void fcircle (int x, int y1, int y2, int c)                       
; 
_fcircle:
	push	bp
	mov	bp,sp
	sub	sp,#12

	mov	-2[bp],#0,word
	mov	cx,4[bp]
	mov	-4[bp],cx
	mov	-8[bp],#0,word
	mov	cx,#2
	sub	cx,4[bp]
	sub	cx,4[bp]
	mov	-6[bp],cx
	mov	-10[bp],ax
	mov	-12[bp],dx
	jmp	4f
1:
	add	cx,-2[bp]
	push	cx
	mov	ax,-12[bp]
	sub	ax,-2[bp]
	mov	dx,-10[bp]
	sub	dx,-4[bp]
	call	_hline

	push	6[bp]
	mov	cx,-12[bp]
	add	cx,-2[bp]
	push	cx
	mov	ax,-12[bp]
	sub	ax,-2[bp]
	mov	dx,-10[bp]
	add	dx,-4[bp]
	call	_hline

	mov	cx,-6[bp]
	add	cx,-4[bp]
	brle	2f
	dec	-4[bp],word
	mov	cx,-4[bp]
	add	cx,cx
	sub	cx,#1
	sub	-6[bp],cx
	jmp	3f
2:
	push	6[bp]
	mov	cx,-12[bp]
	add	cx,-2[bp]
	push	cx
	mov	ax,-12[bp]
	sub	ax,-2[bp]
	mov	dx,-10[bp]
	sub	dx,-4[bp]
	call	_hline

	push	6[bp]
	mov	cx,-12[bp]
	add	cx,-2[bp]
	push	cx
	mov	ax,-12[bp]
	sub	ax,-2[bp]
	mov	dx,-10[bp]
	add	dx,-4[bp]
	call	_hline
3:
	mov	cx,-2[bp]
	cmp	cx,-6[bp]
	brle	4f
	inc	-2[bp],word
	mov	cx,-2[bp]
	add	cx,cx
	inc	cx
	add	-6[bp],cx
4:
	cmp	-4[bp],#0,word
	push	6[bp]
	mov	cx,-12[bp]
	brnl	1b
	add	cx,-2[bp]
	push	cx
	mov	ax,-12[bp]
	sub	ax,-2[bp]
	mov	dx,-10[bp]
	call	_hline

	leave
	ret	#4

; Ŀ
;   Draw an ellipse:                                                  
;                                                                     
;                    dx      ax    4[bp]   6[bp]  8[bp]               
;                                                                
;   void ellipse(int xm, int ym, int rx, int ry, int c)               
; 
_ellipse:
        enter   18,0
        mov     -6[bp],#0,word
        mov     -16[bp],ax      ; ym
        mov     -18[bp],dx      ; xm
        mov     cx,4[bp]        ; rx
        cmp     cx,6[bp]        ; ry
        brle    3f
        mov     ax,cx
        cwd

        push    dx
        push    ax
        mov     ax,6[bp]
        mov     dx,ax
        xor     ax,ax
        call    adivl

        mov     -14[bp],ax
        mov     -12[bp],dx
        mov     cx,4[bp]
        mov     -2[bp],cx
        mov     cx,4[bp]
        mov     -4[bp],cx
1:
        cmp     -2[bp],#0,word
        brnl    2f
        dec     -4[bp],word
        mov     cx,-4[bp]
        add     cx,cx
        add     -2[bp],cx
2:
        push    -12[bp]
        push    -14[bp]
        mov     ax,-4[bp]
        cwd
        call    amull
        mov     ax,dx
        mov     -10[bp],ax

        push    -12[bp]
        push    -14[bp]
        mov     ax,-6[bp]
        cwd
        call    amull
        mov     ax,dx
        mov     -8[bp],ax

        push    8[bp]           ; c
        mov     ax,-16[bp]
        sub     ax,-10[bp]      ; ym - yp
        mov     dx,-18[bp]
        add     dx,-6[bp]       ; xm + x
        call    _plot

        push    8[bp]           ; c
	mov	ax,-16[bp]
	sub	ax,-10[bp]	; ym - yp, same as last
        mov     dx,-18[bp]
        sub     dx,-6[bp]       ; xm - x
        call    _plot

        push    8[bp]           ; c
        mov     ax,-16[bp]
        add     ax,-10[bp]      ; ym + yp
        mov     dx,-18[bp]
        add     dx,-6[bp]       ; xm + x
        call    _plot

        push    8[bp]           ; c
	mov	ax,-16[bp]
	add	ax,-10[bp]	; ym + yp, same as last
        mov     dx,-18[bp]
        sub     dx,-6[bp]       ; xm - x
        call    _plot

        push    8[bp]           ; c
        mov     ax,-16[bp]
        sub     ax,-8[bp]       ; ym - xp
        mov     dx,-18[bp]
        add     dx,-4[bp]       ; xm + y
        call    _plot

        push    8[bp]           ; c
	mov	ax,-16[bp]
	sub	ax,-8[bp]	; ym - xp, same as last
        mov     dx,-18[bp]
        sub     dx,-4[bp]       ; xm - y
        call    _plot

        push    8[bp]           ; c
        mov     ax,-16[bp]
        add     ax,-8[bp]       ; ym + xp
        mov     dx,-18[bp]
        add     dx,-4[bp]       ; xm + y
        call    _plot

        push    8[bp]           ; c
	mov	ax,-16[bp]
	add	ax,-8[bp]	; ym + xp, same as last
        mov     dx,-18[bp]
        sub     dx,-4[bp]       ; xm - y
        call    _plot

        mov     cx,-6[bp]
        add     cx,cx
        inc     cx
        sub     -2[bp],cx
	inc	-6[bp],word
        mov     cx,-4[bp]
        cmp     cx,-6[bp]
        brnl    1b
        jmp     6f
3:
        mov     ax,6[bp]
        cwd
        push    dx
        push    ax
        mov     ax,4[bp]
        mov     dx,ax
        xor     ax,ax
        call    adivl

        mov     -14[bp],ax
        mov     -12[bp],dx
        mov     cx,6[bp]
        mov     -2[bp],cx
        mov     cx,6[bp]
        mov     -4[bp],cx
4:
	cmp	-2[bp],#0,word
        brnl    5f
	dec	-4[bp],word
        mov     cx,-4[bp]
        add     cx,cx
        add     -2[bp],cx
5:
        push    -12[bp]
        push    -14[bp]
        mov     ax,-4[bp]
        cwd
        call    amull
        mov     ax,dx
        mov     -10[bp],ax

        push    -12[bp]
        push    -14[bp]
        mov     ax,-6[bp]
        cwd
        call    amull
        mov     ax,dx
        mov     -8[bp],ax

        push    8[bp]           ; c
        mov     ax,-16[bp]
        sub     ax,-4[bp]       ; ym - y
        mov     dx,-18[bp]
        add     dx,-8[bp]       ; xm + xp
        call    _plot

        push    8[bp]           ; c
	mov	ax,-16[bp]
	sub	ax,-4[bp]	; ym - y, same as last
        mov     dx,-18[bp]
        sub     dx,-8[bp]       ; xm - xp
        call    _plot

        push    8[bp]           ; c
        mov     ax,-16[bp]
        add     ax,-4[bp]       ; ym + y
        mov     dx,-18[bp]
        add     dx,-8[bp]       ; xm + xp
        call    _plot

        push    8[bp]           ; c
	mov	ax,-16[bp]
	add	ax,-4[bp]	; ym + y, same as last
        mov     dx,-18[bp]
        sub     dx,-8[bp]       ; xm - xp
        call    _plot

        push    8[bp]           ; c
        mov     ax,-16[bp]
        sub     ax,-6[bp]       ; ym - x
        mov     dx,-18[bp]
        add     dx,-10[bp]      ; xm + yp
        call    _plot

        push    8[bp]           ; c
	mov	ax,-16[bp]
	sub	ax,-6[bp]	; ym - x, same as last
        mov     dx,-18[bp]
        sub     dx,-10[bp]      ; xm - yp
        call    _plot

        push    8[bp]           ; c
        mov     ax,-16[bp]
        add     ax,-6[bp]       ; ym + x
        mov     dx,-18[bp]
        add     dx,-10[bp]      ; xm + yp
        call    _plot

        push    8[bp]           ; c
	mov	ax,-16[bp]
	add	ax,-6[bp]	; ym + x, same as last
        mov     dx,-18[bp]
        sub     dx,-10[bp]      ; xm - yp
        call    _plot

        mov     cx,-6[bp]
        add     cx,cx
        inc     cx
        sub     -2[bp],cx
        inc     -6[bp],word
        mov     cx,-4[bp]
        cmp     cx,-6[bp]
        brnl    4b
6:
        mov     sp,bp
        pop     bp
        ret     #6


; Ŀ
;   Set a single palette color:                                       
;                                                                     
;                 dx     ax  4[bp]  6[bp]                             
;                                                                 
;  void setcol(int c, byt r, byt g, byt b)                            
; 
_setcol:
        push    bp
        mov     bp,sp
        sub     sp,#4

        mov     -2[bp],dx       ; save c
        mov     -4[bp],ax       ; save red
        mov     dx,#3c8h
        mov     ax,-2[bp],word  ; c
        out     [dx],al
        inc     dx
        mov     al,-4[bp],byte  ; red
        out     [dx],al
        mov     al,4[bp],byte   ; green
        out     [dx],al
        mov     al,6[bp],byte   ; blue
        out     [dx],al

        mov     sp,bp
        pop     bp
        ret     #4

; Ŀ
;   Set a new palette:                                                
;                                                                     
;                    dx                                               
;                                                                    
;  void setpal(byt *pal)                                              
; 
_setpal:
        push    bp
        mov     bp,sp

        xor     bx,bx
        mov     ax,ds
        mov     es,ax
        mov     cx,#256
        mov     ax,#1012h
        int     #10h

        mov     sp,bp
        pop     bp
        ret

; Ŀ
;   Get the 8*8 ROM-font:                                             
;                                                                     
;      es:bp                                                          
; 	    							       
;   void far * getfont(void)                                          
; 
_getfont:
        push    bp

        mov     ax,#1130h       ; call DOS font function
        mov     bh,#3           ; 8*8 ROM font
        int     #10h
        mov     _font,bp,word   ; get offset  Ŀ build a far
        mov     _font+2,es,word ; get segment  pointer

        pop     bp
        ret

; Ŀ
;   Draw a character at (x, y) with/without shadow:                   
;                                                                     
;                  dx     ax   4[bp]    6[bp]   8[bp]                 
;                                                                
;   void outstr(int x, int y, int c1, int c2, byt *cp)                
; 
_outstr:
        push    bp
        mov     bp,sp
        sub     sp,#12

	mov	-10[bp],ax	; y
        mov     -12[bp],dx      ; x
        jmp     7f
1:
        mov     -2[bp],#0,word
        jmp     6f
2:
        mov     bx,8[bp]        ; *cp neu
        mov     cl,[bx]
        mov     ch,#0
        sal     cx,#3
        add     cx,-2[bp]
        les     bx,_font
        add     bx,cx
        mov     al,es:[bx]
	cbw
        mov     -6[bp],ax
        mov     -8[bp],#128,word
        mov     -4[bp],#0,word
        jmp     5f
3:
        mov     cx,-6[bp]
        test    cx,-8[bp]
        bre     4f

        cmp     6[bp],#0,word   ; check for shadow
        je      8f              ; no, so skip this

        push    6[bp]           ; c2 = shadow
        mov     ax,-10[bp]
        add     ax,-2[bp]
        add     ax,#1
        mov     dx,-12[bp]
        add     dx,-4[bp]
        add     dx,#1
        call    _plot
8:
        push    4[bp]           ; c1 = color
        mov     ax,-10[bp]
        add     ax,-2[bp]
        mov     dx,-12[bp]
        add     dx,-4[bp]
        call    _plot
4:
        sar     -8[bp],#1,word
        inc     -4[bp],word
5:
        cmp     -4[bp],#8,word
        brl     3b
        inc     -2[bp],word
6:
        cmp     -2[bp],#8,word
        brl     2b
        add     -12[bp],#8,word
	inc	8[bp],word
7:
        mov     bx,8[bp]
        cmp     [bx],#0,byte
        brne    1b

	leave
	ret	#6

; Ŀ
;   Draw a string with or without shadow and variable arguments:      
;                                                                     
;                 dx     ax   4[bp]    6[bp]     8[bp]                
;                                                                
;   void print(int x, int y, int c1, int c2, char *str, ...)          
; 
_print:
        push    bp
        mov     bp,sp
        sub     sp,#264

        lea     cx,10[bp]       ; *str
        mov     -2[bp],cx
        mov     -262[bp],ax     ; y
        mov     -264[bp],dx     ; x
        lea     cx,-2[bp]
        push    cx
        mov     ax,8[bp]        ; str address
        lea     dx,-257[bp]
        call    _vsprintf
        lea     cx,-257[bp]
        mov     -260[bp],cx
        jmp     2f
1:
        push    -260[bp]        ; *cp
        push    6[bp]           ; c2 = no shadow
        push    4[bp]           ; c1 = color c
        mov     ax,-262[bp]     ; y
        mov     dx,-264[bp]     ; x
        call    _outstr
	inc	-260[bp],word	; *cp++
        add     -264[bp],#8,word
2:
        mov     bx,-260[bp]
        cmp     [bx],#0,byte
        brne    1b

        leave
        ret

; Ŀ
;   Wait for vertical retrace:                                        
;                                                                     
;   void retrace(void)                                                
; 
_retrace:
        mov     dx,#3dah
1:
        in      al,[dx]
        test    al,#8           ; sync while CTR is off
        jnz     1b              ; bit set
2:
        in      al,[dx]
        test    al,#8           ; sync while CTR is on
        jz      2b              ; bit not set

        ret

; Ŀ
;   The data section: VESA-Definitions and special variables.         
; 
        .psect  data,global

vesa:   .word   100h,  640,  400,  4    ; You may have to change this. !!!
        .word   101h,  640,  480,  5    ;  The last number in each line
        .word   103h,  800,  600,  8    ;  is the number of banks for
        .word   105h, 1024,  768, 12    ;  that mode:  n = hor*ver/gran
        .word   124h, 1152,  864, 16    ;  If gran is less then 64 k,
        .word   107h, 1280, 1024, 20    ;  change the number accordingly

len:    .word   $-vesa          ; length of modes record

txt:    .byte   "Mode %xh is not avaliable",10,0

switch: .dword  0               ; Far address for bank switches
banks:  .word   0               ; number of banks
wind:   .word   0               ; the curent window to video RAM
clp:	.word	0		; clipping flag

; 
_mode:  .word   0               ; our graphics mode
_hor:   .word   0               ; horizontal resolution
_ver:   .word   0               ; vertical resolution
_xmin:  .word   0               ; cliprect left
_ymin:  .word   0               ; cliprect top
_xmax:  .word   0               ; cliprect right
_ymax:  .word   0               ; cliprect bottom
_xcur:  .word   0               ; curent x coordinate
_ycur:  .word   0               ; curent y coordinate
_font:  .dword  0               ; the ROM font (far pointer)

; Ŀ
;   The bss section: We need a buffer, to which the VESA information  
;                    will copied.                                     
; 
        .psect  bss,global

        .align  2
buff:   .blkb   30
_bez:   .blkb   16
        .end

; 

