@echo off
cls

echo.
echo"     ͻ
echo"      **********  COMPILE, LINK AND CREATE THE VESA-LIBRARY  ********* 
echo"     Ķ
echo"      This batch file will create the VESA library "86--dsv.lib" from  
echo"      the source file "vesalib.as".                                    
echo"     ͼ
echo.
echo.

:delete
rem ----------------------------------------------------------------------
rem  First we delete the old library file from its directory.
rem ----------------------------------------------------------------------
echo"                  Looking for old library and deleting it.
echo.
if exist ..\..\lib\86--dsv.lib del ..\..\lib\86--dsv.lib > nul

:compile
rem ----------------------------------------------------------------------
rem  Now we compile the source files to object files.
rem ----------------------------------------------------------------------
echo"                         Compiling "vesalib.as".
echo.

pacc -q -2 -x -c -eerr.txt vesalib.as
if errorlevel 1 goto error1

rem ----------------------------------------------------------------------
rem  Now we can create the VESA-library file.
rem ----------------------------------------------------------------------
echo"                 Creating the VESA library "86---dsv.lib".
echo.

libr r ..\..\lib\86--dsv.lib vesalib.obj
if errorlevel 1 goto error2

echo.
echo"                 Ŀ
echo"                          Vesa-library created!        
echo"                     It's now in the LIB directory.    
echo"                 
echo.
goto quit

:error1
rem ----------------------------------------------------------------------
rem  An error occured during compilation.
rem ----------------------------------------------------------------------
echo"                   An error occured during compilation
echo.

q err.txt vesalib.as
goto quit

:error2
rem ----------------------------------------------------------------------
rem  An error occured while producing the library.
rem ----------------------------------------------------------------------
echo"              An error occured while running the librarian
echo.

:quit
rem ----------------------------------------------------------------------
rem  At the end we clean up everything.
rem ----------------------------------------------------------------------
if exist   *.obj del   *.obj > nul
if exist err.txt del err.txt > nul
