/* Software License Agreement
 * 
 *     Copyright(C) 1994-2020 David Lindauer, (LADSoft)
 * 
 *     This file is part of the Orange C Compiler package.
 * 
 *     The Orange C Compiler package is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 * 
 *     The Orange C Compiler package is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with Orange C.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *     As a special exception, if other files instantiate templates or
 *     use macros or inline functions from this file, or you compile
 *     this file and link it with other works to produce a work based
 *     on this file, this file does not by itself cause the resulting
 *     work to be covered by the GNU General Public License. However
 *     the source code for this file must still be made available in
 *     accordance with section (3) of the GNU General Public License.
 *     
 *     This exception does not invalidate any other reasons why a work
 *     based on this file might be covered by the GNU General Public
 *     License.
 * 
 *     contact information:
 *         email: TouchStone222@runbox.com <David Lindauer>
 * 
 */

#include <limits.h>
#include <stddef.h>
#include <ctype.h>
#include <locale.h>
#include <string.h>
#include "_locale.h"
#include "llp.h"

void __ctype_init(void);

extern ABBREVIATED_CTYPE_DATA C_ctype_data ;
extern ABBREVIATED_TIME_DATA C_time_data ;
extern NUMERIC_DATA C_numeric_data ;
extern void *__locale_data[LC_LAST+1] ;

static char C_qualified_name[] = "C";
static char C_unqualified_name[] = "C";

static ABBREVIATED_COLLATE_DATA C_collate_data= {
	&C_qualified_name,
	{
	0x00, 0x00, 0x01, 0x00, 0x25, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x67, 0x68, 0x00, 0x00, 0x0D, 0x0E, 0x0B, 0x00, 
	0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 
	0x09, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x10, 0x12, 0x14, 0x16, 0x18, 0x1A, 0x1C, 
	0x1E, 0x20, 0x22, 0x24, 0x26, 0x28, 0x2A, 0x2C, 
	0x2E, 0x30, 0x32, 0x34, 0x36, 0x38, 0x3A, 0x3C, 
	0x3E, 0x40, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x0F, 0x11, 0x13, 0x15, 0x17, 0x19, 0x1B, 
	0x1D, 0x1F, 0x21, 0x23, 0x25, 0x27, 0x29, 0x2B, 
	0x2D, 0x2F, 0x31, 0x33, 0x35, 0x37, 0x39, 0x3B, 
	0x3D, 0x3F, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x4E, 0x64, 0x4F, 0x46, 0x49, 0x45, 0x47, 0x4D, 
	0x52, 0x53, 0x51, 0x57, 0x56, 0x55, 0x4A, 0x48, 
	0x50, 0x4B, 0x4C, 0x5D, 0x5E, 0x5C, 0x63, 0x62, 
	0x66, 0x5F, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x44, 0x54, 0x5B, 0x61, 0x58, 0x59, 0x43, 0x5A, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	
	}
};
MONETARY_DATA C_monetary_data= {
	&C_qualified_name,
	"",
	"",
	"",
	"",
	"",
	"",
	"",
    CHAR_MAX,CHAR_MAX,CHAR_MAX,CHAR_MAX,
    CHAR_MAX,CHAR_MAX,CHAR_MAX,CHAR_MAX,
    CHAR_MAX,CHAR_MAX,CHAR_MAX,CHAR_MAX,
    CHAR_MAX,CHAR_MAX
};
static MESSAGE_DATA C_message_data = {
	&C_qualified_name,
	"y",
	"n",
};
static USERDEF_DATA C_userdef_data = {
    &C_qualified_name, 0
};
LOCALE_HEADER _C_locale_data = {
	&C_unqualified_name,
    &C_qualified_name,
    { &C_collate_data },
	{ &C_ctype_data },
	&C_monetary_data,
	&C_numeric_data,
	{ &C_time_data },
	&C_message_data,
	&C_userdef_data
};

static void *__init_locale_data[LC_LAST+1] = {
    0,
	&C_collate_data,
	&C_ctype_data,
	&C_monetary_data,
	&C_numeric_data,
	&C_time_data,
	&C_message_data,
	&C_userdef_data
} ;

#pragma startup __locale_reinit 230
void __locale_reinit()
{
	memcpy(__locale_data, __init_locale_data, sizeof(__locale_data));
	__ctype_init();
}

