#include <io.h>
#include <sys/types.h>
#include <errno.h>
ssize_t pread(int fd, void *buf, size_t nbyte, off_t offset)
{
  int save_errno;
  size_t result;
  off_t old_offset = lseek(fd, 0, SEEK_CUR);
  if (old_offset == (off_t)-1) return -1;
  if (lseek(fd, offset, SEEK_SET) == (off_t)-1) return -1;
  result = read(fd, buf, nbyte);
  save_errno = errno;
  if (lseek(fd, old_offset, SEEK_SET) == (off_t)-1) {
    if (result == -1) errno = save_errno;
    return -1;
  }
  errno = save_errno;
  return result;
}
